/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.text.AttributedCharacterIterator;
import java.util.Map;
import java.util.Set;

class MultiACI
implements AttributedCharacterIterator {
    int start;
    int limit;
    AttributedCharacterIterator[] iters;
    int currentIter = -1;
    int currentIterStart = -1;
    int currentIterLimit = -1;

    MultiACI(int n, int n2, AttributedCharacterIterator[] attributedCharacterIteratorArray) {
        this.start = n;
        this.limit = n2;
        this.iters = attributedCharacterIteratorArray;
        int n3 = 0;
        int n4 = 0;
        while (n4 < attributedCharacterIteratorArray.length) {
            n3 += this.iterLength(n4);
            ++n4;
        }
        if (n3 != n2 - n) {
            throw new IllegalArgumentException("start: " + n + " limit: " + n2 + " != count: " + n3);
        }
    }

    private int iterLength(int n) {
        return this.iters[n].getEndIndex() - this.iters[n].getBeginIndex();
    }

    public char first() {
        this.currentIter = 0;
        this.currentIterStart = this.start;
        this.currentIterLimit = this.start + this.iterLength(this.currentIter);
        return this.iters[this.currentIter].first();
    }

    public char last() {
        this.currentIter = this.iters.length - 1;
        this.currentIterStart = this.limit - this.iterLength(this.currentIter);
        this.currentIterLimit = this.limit;
        return this.iters[this.currentIter].last();
    }

    public char current() {
        return this.iters[this.currentIter].current();
    }

    public char next() {
        char c = this.iters[this.currentIter].next();
        if (c == '\uffff' && this.currentIter < this.iters.length - 1) {
            ++this.currentIter;
            this.currentIterStart = this.currentIterLimit;
            this.currentIterLimit += this.iterLength(this.currentIter);
            return this.iters[this.currentIter].first();
        }
        return c;
    }

    public char previous() {
        char c = this.iters[this.currentIter].previous();
        if (c == '\uffff' && this.currentIter > 0) {
            --this.currentIter;
            this.currentIterLimit = this.currentIterStart;
            this.currentIterStart = this.currentIterLimit - this.iterLength(this.currentIter);
            return this.iters[this.currentIter].last();
        }
        return c;
    }

    public char setIndex(int n) {
        if (n < this.start || n > this.limit) {
            throw new IllegalArgumentException("Invalid index: " + n + " (" + this.start + ", " + this.limit + ")");
        }
        this.currentIter = 0;
        this.currentIterStart = 0;
        do {
            AttributedCharacterIterator attributedCharacterIterator = this.iters[this.currentIter];
            int n2 = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
            this.currentIterLimit = this.currentIterStart + n2;
            if (n < this.currentIterLimit) {
                return attributedCharacterIterator.setIndex(attributedCharacterIterator.getBeginIndex() + n - this.currentIterStart);
            }
            this.currentIterStart = this.currentIterLimit;
            ++this.currentIter;
        } while (this.currentIter < this.iters.length);
        this.currentIter = this.iters.length - 1;
        this.currentIterLimit = this.limit;
        this.currentIterStart = this.limit - this.iterLength(this.currentIter);
        return this.iters[this.currentIter].setIndex(this.iters[this.currentIter].getEndIndex());
    }

    public int getBeginIndex() {
        return this.start;
    }

    public int getEndIndex() {
        return this.limit;
    }

    public int getIndex() {
        return this.currentIterStart + this.iters[this.currentIter].getIndex() - this.iters[this.currentIter].getBeginIndex();
    }

    public Object clone() {
        try {
            MultiACI multiACI = (MultiACI)super.clone();
            int n = 0;
            while (n < this.iters.length) {
                AttributedCharacterIterator attributedCharacterIterator = (AttributedCharacterIterator)this.iters[n].clone();
                if (attributedCharacterIterator == null) {
                    return null;
                }
                multiACI.iters[n] = attributedCharacterIterator;
                ++n;
            }
            return multiACI;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int getRunStart() {
        int n = this.currentIterStart + this.iters[this.currentIter].getRunStart() - this.iters[this.currentIter].getBeginIndex();
        return n;
    }

    public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
        int n = this.currentIterStart + this.iters[this.currentIter].getRunStart(attribute) - this.iters[this.currentIter].getBeginIndex();
        return n;
    }

    public int getRunStart(Set set) {
        int n = this.currentIterStart + this.iters[this.currentIter].getRunStart(set) - this.iters[this.currentIter].getBeginIndex();
        return n;
    }

    public int getRunLimit() {
        int n = this.currentIterStart + this.iters[this.currentIter].getRunLimit() - this.iters[this.currentIter].getBeginIndex();
        return n;
    }

    public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
        int n = this.currentIterStart + this.iters[this.currentIter].getRunLimit(attribute) - this.iters[this.currentIter].getBeginIndex();
        return n;
    }

    public int getRunLimit(Set set) {
        int n = this.currentIterStart + this.iters[this.currentIter].getRunLimit(set) - this.iters[this.currentIter].getBeginIndex();
        return n;
    }

    public Map getAttributes() {
        return this.iters[this.currentIter].getAttributes();
    }

    public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
        return this.iters[this.currentIter].getAttribute(attribute);
    }

    public Set getAllAttributeKeys() {
        Set set = this.iters[0].getAllAttributeKeys();
        int n = 1;
        while (n < this.iters.length) {
            set.addAll(this.iters[n].getAllAttributeKeys());
            ++n;
        }
        return set;
    }
}

