/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalTheme;
import sun.awt.AppContext;

public class MetalLookAndFeel
extends BasicLookAndFeel {
    private static MetalTheme currentTheme;
    private static boolean isOnlyOneContext;
    private static AppContext cachedAppContext;
    static final String deleteNextCellAction = "delete-next-cell";

    public String getName() {
        return "Metal";
    }

    public String getID() {
        return "Metal";
    }

    public String getDescription() {
        return "The Java(tm) Look and Feel";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        String string = "javax.swing.plaf.metal.";
        Object[] objectArray = new Object[]{"ButtonUI", string + "MetalButtonUI", "CheckBoxUI", string + "MetalCheckBoxUI", "RadioButtonUI", string + "MetalRadioButtonUI", "ToggleButtonUI", string + "MetalToggleButtonUI", "ProgressBarUI", string + "MetalProgressBarUI", "ScrollBarUI", string + "MetalScrollBarUI", "ScrollPaneUI", string + "MetalScrollPaneUI", "SplitPaneUI", string + "MetalSplitPaneUI", "SliderUI", string + "MetalSliderUI", "SeparatorUI", string + "MetalSeparatorUI", "PopupMenuSeparatorUI", string + "MetalPopupMenuSeparatorUI", "TabbedPaneUI", string + "MetalTabbedPaneUI", "TextFieldUI", string + "MetalTextFieldUI", "TreeUI", string + "MetalTreeUI", "LabelUI", string + "MetalLabelUI", "ToolBarUI", string + "MetalToolBarUI", "ToolTipUI", string + "MetalToolTipUI", "ComboBoxUI", string + "MetalComboBoxUI", "InternalFrameUI", string + "MetalInternalFrameUI", "DesktopIconUI", string + "MetalDesktopIconUI", "FileChooserUI", string + "MetalFileChooserUI"};
        uIDefaults.putDefaults(objectArray);
    }

    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
        Object[] objectArray = new Object[]{"desktop", MetalLookAndFeel.getDesktopColor(), "activeCaption", MetalLookAndFeel.getWindowTitleBackground(), "activeCaptionText", MetalLookAndFeel.getWindowTitleForeground(), "activeCaptionBorder", MetalLookAndFeel.getPrimaryControlShadow(), "inactiveCaption", MetalLookAndFeel.getWindowTitleInactiveBackground(), "inactiveCaptionText", MetalLookAndFeel.getWindowTitleInactiveForeground(), "inactiveCaptionBorder", MetalLookAndFeel.getControlShadow(), "window", MetalLookAndFeel.getWindowBackground(), "windowBorder", MetalLookAndFeel.getControl(), "windowText", MetalLookAndFeel.getUserTextColor(), "menu", MetalLookAndFeel.getMenuBackground(), "menuText", MetalLookAndFeel.getMenuForeground(), "text", MetalLookAndFeel.getWindowBackground(), "textText", MetalLookAndFeel.getUserTextColor(), "textHighlight", MetalLookAndFeel.getTextHighlightColor(), "textHighlightText", MetalLookAndFeel.getHighlightedTextColor(), "textInactiveText", MetalLookAndFeel.getInactiveSystemTextColor(), "control", MetalLookAndFeel.getControl(), "controlText", MetalLookAndFeel.getControlTextColor(), "controlHighlight", MetalLookAndFeel.getControlHighlight(), "controlLtHighlight", MetalLookAndFeel.getControlHighlight(), "controlShadow", MetalLookAndFeel.getControlShadow(), "controlDkShadow", MetalLookAndFeel.getControlDarkShadow(), "scrollbar", MetalLookAndFeel.getControl(), "info", MetalLookAndFeel.getPrimaryControl(), "infoText", MetalLookAndFeel.getPrimaryControlInfo()};
        int n = 0;
        while (n < objectArray.length) {
            uIDefaults.put((String)objectArray[n], objectArray[n + 1]);
            n += 2;
        }
    }

    private void loadResourceBundle(UIDefaults uIDefaults) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("javax.swing.plaf.metal.resources.metal");
        Enumeration enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            uIDefaults.put(string, resourceBundle.getObject(string));
        }
    }

    private void copyFont(UIDefaults uIDefaults, String string, final String string2) {
        final String string3 = uIDefaults.getString(string);
        if (string3 != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        String string = System.getProperty(string2);
                        if (string == null || "".equals(string)) {
                            System.setProperty(string2, string3);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        this.loadResourceBundle(uIDefaults);
        this.copyFont(uIDefaults, "Font.menuFont", "swing.plaf.metal.controlFont");
        this.copyFont(uIDefaults, "Font.systemFont", "swing.plaf.metal.systemFont");
        this.copyFont(uIDefaults, "Font.userFont", "swing.plaf.metal.userFont");
        this.copyFont(uIDefaults, "Font.smallFont", "swing.plaf.metal.smallFont");
        UIDefaults.ProxyLazyValue proxyLazyValue = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders", "getTextFieldBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue2 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders", "getTextBorder");
        UIDefaults.LazyInputMap lazyInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "DELETE", deleteNextCellAction, "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "alt ENTER", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap lazyInputMap2 = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "BACK_SPACE", "delete-previous", "DELETE", deleteNextCellAction, "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation", "alt ENTER", "toggle-componentOrientation"});
        UIDefaults.ProxyLazyValue proxyLazyValue3 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders$ScrollPaneBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue4 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders", "getButtonBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue5 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders", "getToggleButtonBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue6 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{uIDefaults.getColor("controlShadow")});
        UIDefaults.ProxyLazyValue proxyLazyValue7 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders", "getDesktopIconBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue8 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders$MenuBarBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue9 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders$PopupMenuBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue10 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders$MenuItemBorder");
        String string = new String("-");
        UIDefaults.ProxyLazyValue proxyLazyValue11 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders$ToolBarBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue12 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{MetalLookAndFeel.getControlDarkShadow(), new Integer(1)});
        UIDefaults.ProxyLazyValue proxyLazyValue13 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{MetalLookAndFeel.getPrimaryControlDarkShadow()});
        UIDefaults.ProxyLazyValue proxyLazyValue14 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{MetalLookAndFeel.getFocusColor()});
        InsetsUIResource insetsUIResource = new InsetsUIResource(4, 2, 0, 6);
        InsetsUIResource insetsUIResource2 = new InsetsUIResource(0, 0, 0, 0);
        Object[] objectArray = new Object[]{new Integer(16)};
        Object[] objectArray2 = new Object[]{"TextField.border", proxyLazyValue, "TextField.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getUserTextFont"), "TextField.caretForeground", MetalLookAndFeel.getUserTextColor(), "PasswordField.border", proxyLazyValue2, "PasswordField.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getUserTextFont"), "PasswordField.caretForeground", MetalLookAndFeel.getUserTextColor(), "TextArea.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getUserTextFont"), "TextArea.caretForeground", MetalLookAndFeel.getUserTextColor(), "TextPane.selectionBackground", uIDefaults.get("textHighlight"), "TextPane.selectionForeground", uIDefaults.get("textHighlightText"), "TextPane.background", uIDefaults.get("window"), "TextPane.foreground", uIDefaults.get("textText"), "TextPane.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getUserTextFont"), "TextPane.caretForeground", MetalLookAndFeel.getUserTextColor(), "EditorPane.selectionBackground", uIDefaults.get("textHighlight"), "EditorPane.selectionForeground", uIDefaults.get("textHighlightText"), "EditorPane.background", uIDefaults.get("window"), "EditorPane.foreground", uIDefaults.get("textText"), "EditorPane.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getUserTextFont"), "EditorPane.caretForeground", MetalLookAndFeel.getUserTextColor(), "TextField.focusInputMap", lazyInputMap, "PasswordField.focusInputMap", lazyInputMap, "TextArea.focusInputMap", lazyInputMap2, "TextPane.focusInputMap", lazyInputMap2, "EditorPane.focusInputMap", lazyInputMap2, "Button.background", MetalLookAndFeel.getControl(), "Button.foreground", MetalLookAndFeel.getControlTextColor(), "Button.disabledText", MetalLookAndFeel.getInactiveControlTextColor(), "Button.select", MetalLookAndFeel.getControlShadow(), "Button.border", proxyLazyValue4, "Button.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getControlTextFont"), "Button.focus", MetalLookAndFeel.getFocusColor(), "CheckBox.background", MetalLookAndFeel.getControl(), "CheckBox.foreground", MetalLookAndFeel.getControlTextColor(), "CheckBox.disabledText", MetalLookAndFeel.getInactiveControlTextColor(), "Checkbox.select", MetalLookAndFeel.getControlShadow(), "CheckBox.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getControlTextFont"), "CheckBox.focus", MetalLookAndFeel.getFocusColor(), "CheckBox.icon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getCheckBoxIcon"), "CheckBox.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "RadioButton.background", MetalLookAndFeel.getControl(), "RadioButton.foreground", MetalLookAndFeel.getControlTextColor(), "RadioButton.disabledText", MetalLookAndFeel.getInactiveControlTextColor(), "RadioButton.select", MetalLookAndFeel.getControlShadow(), "RadioButton.icon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getRadioButtonIcon"), "RadioButton.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getControlTextFont"), "RadioButton.focus", MetalLookAndFeel.getFocusColor(), "RadioButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "ToggleButton.background", MetalLookAndFeel.getControl(), "ToggleButton.foreground", MetalLookAndFeel.getControlTextColor(), "ToggleButton.select", MetalLookAndFeel.getControlShadow(), "ToggleButton.text", MetalLookAndFeel.getControl(), "ToggleButton.disabledText", MetalLookAndFeel.getInactiveControlTextColor(), "ToggleButton.disabledSelectedText", MetalLookAndFeel.getControlDarkShadow(), "ToggleButton.disabledBackground", MetalLookAndFeel.getControl(), "ToggleButton.disabledSelectedBackground", MetalLookAndFeel.getControlShadow(), "ToggleButton.focus", MetalLookAndFeel.getFocusColor(), "ToggleButton.border", proxyLazyValue5, "ToggleButton.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getControlTextFont"), "ToggleButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "FileView.directoryIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeFolderIcon"), "FileView.fileIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeLeafIcon"), "FileView.computerIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeComputerIcon"), "FileView.hardDriveIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeHardDriveIcon"), "FileView.floppyDriveIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeFloppyDriveIcon"), "FileChooser.detailsViewIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserDetailViewIcon"), "FileChooser.homeFolderIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserHomeFolderIcon"), "FileChooser.listViewIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserListViewIcon"), "FileChooser.newFolderIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserNewFolderIcon"), "FileChooser.upFolderIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserUpFolderIcon"), "FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection"}), "ToolTip.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getSystemTextFont"), "ToolTip.border", proxyLazyValue13, "ToolTip.background", uIDefaults.get("info"), "ToolTip.foreground", uIDefaults.get("infoText"), "Slider.border", null, "Slider.foreground", MetalLookAndFeel.getPrimaryControlShadow(), "Slider.background", MetalLookAndFeel.getControl(), "Slider.focus", MetalLookAndFeel.getFocusColor(), "Slider.focusInsets", insetsUIResource2, "Slider.trackWidth", new Integer(7), "Slider.majorTickLength", new Integer(6), "Slider.horizontalThumbIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getHorizontalSliderThumbIcon"), "Slider.verticalThumbIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getVerticalSliderThumbIcon"), "Slider.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "rightUnitIncrement", "KP_RIGHT", "rightUnitIncrement", "DOWN", "downUnitIncrement", "KP_DOWN", "downUnitIncrement", "PAGE_DOWN", "downBlockIncrement", "ctrl PAGE_DOWN", "downBlockIncrement", "LEFT", "leftUnitIncrement", "KP_LEFT", "leftUnitIncrement", "UP", "upUnitIncrement", "KP_UP", "upUnitIncrement", "PAGE_UP", "upBlockIncrement", "ctrl PAGE_UP", "upBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "ProgressBar.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getControlTextFont"), "ProgressBar.foreground", MetalLookAndFeel.getPrimaryControlShadow(), "ProgressBar.background", MetalLookAndFeel.getControl(), "ProgressBar.foregroundHighlight", MetalLookAndFeel.getPrimaryControlShadow(), "ProgressBar.backgroundHighlight", MetalLookAndFeel.getControl(), "ProgressBar.selectionForeground", MetalLookAndFeel.getControl(), "ProgressBar.selectionBackground", MetalLookAndFeel.getPrimaryControlDarkShadow(), "ProgressBar.border", proxyLazyValue12, "ProgressBar.cellSpacing", new Integer(0), "ProgressBar.cellLength", new Integer(1), "ComboBox.background", uIDefaults.get("control"), "ComboBox.foreground", uIDefaults.get("controlText"), "ComboBox.selectionBackground", MetalLookAndFeel.getPrimaryControlShadow(), "ComboBox.selectionForeground", MetalLookAndFeel.getControlTextColor(), "ComboBox.listBackground", MetalLookAndFeel.getControl(), "ComboBox.listForeground", MetalLookAndFeel.getControlTextColor(), "ComboBox.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getControlTextFont"), "ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "alt DOWN", "togglePopup", "alt KP_DOWN", "togglePopup", "alt UP", "togglePopup", "alt KP_UP", "togglePopup", "UP", "selectPrevious", "KP_UP", "selectPrevious"}), "InternalFrame.icon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getInternalFrameDefaultMenuIcon"), "InternalFrame.border", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders$InternalFrameBorder"), "InternalFrame.optionDialogBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders$OptionDialogBorder"), "InternalFrame.paletteBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders$PaletteBorder"), "InternalFrame.paletteTitleHeight", new Integer(11), "InternalFrame.paletteCloseIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory$PaletteCloseIcon"), "InternalFrame.closeIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getInternalFrameCloseIcon", objectArray), "InternalFrame.maximizeIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getInternalFrameMaximizeIcon", objectArray), "InternalFrame.iconifyIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getInternalFrameMinimizeIcon", objectArray), "InternalFrame.minimizeIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getInternalFrameAltMaximizeIcon", objectArray), "InternalFrame.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getWindowTitleFont"), "InternalFrame.windowBindings", new Object[]{"shift ESCAPE", "showSystemMenu", "ctrl SPACE", "showSystemMenu", "ESCAPE", "hideSystemMenu"}, "DesktopIcon.border", proxyLazyValue7, "DesktopIcon.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getControlTextFont"), "DesktopIcon.foreground", MetalLookAndFeel.getControlTextColor(), "DesktopIcon.background", MetalLookAndFeel.getControl(), "Desktop.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl F5", "restore", "ctrl F4", "close", "ctrl F7", "move", "ctrl F8", "resize", "RIGHT", "right", "KP_RIGHT", "right", "LEFT", "left", "KP_LEFT", "left", "UP", "up", "KP_UP", "up", "DOWN", "down", "KP_DOWN", "down", "ESCAPE", "escape", "ctrl F9", "minimize", "ctrl F10", "maximize", "ctrl F6", "selectNextFrame", "ctrl TAB", "selectNextFrame", "ctrl alt F6", "selectNextFrame", "shift ctrl alt F6", "selectPreviousFrame"}), "TitledBorder.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getControlTextFont"), "TitledBorder.titleColor", MetalLookAndFeel.getSystemTextColor(), "TitledBorder.border", proxyLazyValue6, "Label.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getControlTextFont"), "Label.background", uIDefaults.get("control"), "Label.foreground", MetalLookAndFeel.getSystemTextColor(), "Label.disabledForeground", MetalLookAndFeel.getInactiveSystemTextColor(), "List.focusCellHighlightBorder", proxyLazyValue14, "List.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "HOME", "selectFirstRow", "shift HOME", "selectFirstRowExtendSelection", "END", "selectLastRow", "shift END", "selectLastRowExtendSelection", "PAGE_UP", "scrollUp", "shift PAGE_UP", "scrollUpExtendSelection", "PAGE_DOWN", "scrollDown", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "SPACE", "selectCurrent"}), "ScrollBar.background", MetalLookAndFeel.getControl(), "ScrollBar.highlight", MetalLookAndFeel.getControlHighlight(), "ScrollBar.shadow", MetalLookAndFeel.getControlShadow(), "ScrollBar.darkShadow", MetalLookAndFeel.getControlDarkShadow(), "ScrollBar.thumb", MetalLookAndFeel.getPrimaryControlShadow(), "ScrollBar.thumbShadow", MetalLookAndFeel.getPrimaryControlDarkShadow(), "ScrollBar.thumbHighlight", MetalLookAndFeel.getPrimaryControl(), "ScrollBar.width", new Integer(17), "ScrollBar.allowsAbsolutePositioning", Boolean.TRUE, "ScrollBar.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "negativeUnitIncrement", "KP_RIGHT", "negativeUnitIncrement", "DOWN", "positiveUnitIncrement", "KP_DOWN", "positiveUnitIncrement", "PAGE_DOWN", "positiveBlockIncrement", "LEFT", "positiveUnitIncrement", "KP_LEFT", "positiveUnitIncrement", "UP", "negativeUnitIncrement", "KP_UP", "negativeUnitIncrement", "PAGE_UP", "negativeBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "ScrollPane.border", proxyLazyValue3, "ScrollPane.background", uIDefaults.get("control"), "ScrollPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "unitScrollRight", "KP_RIGHT", "unitScrollRight", "DOWN", "unitScrollDown", "KP_DOWN", "unitScrollDown", "LEFT", "unitScrollLeft", "KP_LEFT", "unitScrollLeft", "UP", "unitScrollUp", "KP_UP", "unitScrollUp", "PAGE_UP", "scrollUp", "PAGE_DOWN", "scrollDown", "ctrl PAGE_UP", "scrollLeft", "ctrl PAGE_DOWN", "scrollRight", "ctrl HOME", "scrollHome", "ctrl END", "scrollEnd"}), "TabbedPane.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getControlTextFont"), "TabbedPane.tabAreaBackground", MetalLookAndFeel.getControl(), "TabbedPane.background", MetalLookAndFeel.getControlShadow(), "TabbedPane.foreground", MetalLookAndFeel.getControlTextColor(), "TabbedPane.highlight", MetalLookAndFeel.getControl(), "TabbedPane.lightHighlight", MetalLookAndFeel.getControlHighlight(), "TabbedPane.darkShadow", MetalLookAndFeel.getControlDarkShadow(), "TabbedPane.focus", MetalLookAndFeel.getPrimaryControlDarkShadow(), "TabbedPane.selected", MetalLookAndFeel.getControl(), "TabbedPane.selectHighlight", MetalLookAndFeel.getControlHighlight(), "TabbedPane.tabAreaInsets", insetsUIResource, "TabbedPane.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "navigateRight", "KP_RIGHT", "navigateRight", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "ctrl DOWN", "requestFocusForVisibleComponent", "ctrl KP_DOWN", "requestFocusForVisibleComponent"}), "TabbedPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl PAGE_DOWN", "navigatePageDown", "ctrl PAGE_UP", "navigatePageUp", "ctrl UP", "requestFocus", "ctrl KP_UP", "requestFocus"}), "Table.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getUserTextFont"), "Table.focusCellHighlightBorder", proxyLazyValue14, "Table.focusCellBackground", uIDefaults.get("window"), "Table.scrollPaneBorder", proxyLazyValue3, "Table.gridColor", MetalLookAndFeel.getControlShadow(), "Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "PAGE_UP", "scrollUpChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "HOME", "selectFirstColumn", "END", "selectLastColumn", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift HOME", "selectFirstColumnExtendSelection", "shift END", "selectLastColumnExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "ctrl HOME", "selectFirstRow", "ctrl END", "selectLastRow", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "ENTER", "selectNextRowCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "ESCAPE", "cancel", "F2", "startEditing"}), "TableHeader.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getUserTextFont"), "TableHeader.cellBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders$TableHeaderBorder"), "MenuBar.border", proxyLazyValue8, "MenuBar.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getMenuTextFont"), "MenuBar.foreground", MetalLookAndFeel.getMenuForeground(), "MenuBar.background", MetalLookAndFeel.getMenuBackground(), "MenuBar.windowBindings", new Object[]{"F10", "takeFocus"}, "Menu.border", proxyLazyValue10, "Menu.borderPainted", Boolean.TRUE, "Menu.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getMenuTextFont"), "Menu.foreground", MetalLookAndFeel.getMenuForeground(), "Menu.background", MetalLookAndFeel.getMenuBackground(), "Menu.selectionForeground", MetalLookAndFeel.getMenuSelectedForeground(), "Menu.selectionBackground", MetalLookAndFeel.getMenuSelectedBackground(), "Menu.disabledForeground", MetalLookAndFeel.getMenuDisabledForeground(), "Menu.acceleratorFont", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getSubTextFont"), "Menu.acceleratorForeground", MetalLookAndFeel.getAcceleratorForeground(), "Menu.acceleratorSelectionForeground", MetalLookAndFeel.getAcceleratorSelectedForeground(), "Menu.checkIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getMenuItemCheckIcon"), "Menu.arrowIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getMenuArrowIcon"), "Menu.selectedWindowInputMapBindings", new Object[]{"ESCAPE", "cancel", "DOWN", "selectNext", "KP_DOWN", "selectNext", "UP", "selectPrevious", "KP_UP", "selectPrevious", "LEFT", "selectParent", "KP_LEFT", "selectParent", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "ENTER", "return", "SPACE", "return"}, "MenuItem.border", proxyLazyValue10, "MenuItem.borderPainted", Boolean.TRUE, "MenuItem.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getMenuTextFont"), "MenuItem.foreground", MetalLookAndFeel.getMenuForeground(), "MenuItem.background", MetalLookAndFeel.getMenuBackground(), "MenuItem.selectionForeground", MetalLookAndFeel.getMenuSelectedForeground(), "MenuItem.selectionBackground", MetalLookAndFeel.getMenuSelectedBackground(), "MenuItem.disabledForeground", MetalLookAndFeel.getMenuDisabledForeground(), "MenuItem.acceleratorFont", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getSubTextFont"), "MenuItem.acceleratorForeground", MetalLookAndFeel.getAcceleratorForeground(), "MenuItem.acceleratorSelectionForeground", MetalLookAndFeel.getAcceleratorSelectedForeground(), "MenuItem.acceleratorDelimiter", string, "MenuItem.checkIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getMenuItemCheckIcon"), "MenuItem.arrowIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getMenuItemArrowIcon"), "OptionPane.windowBindings", new Object[]{"ESCAPE", "close"}, "Separator.background", MetalLookAndFeel.getSeparatorBackground(), "Separator.foreground", MetalLookAndFeel.getSeparatorForeground(), "PopupMenu.background", MetalLookAndFeel.getMenuBackground(), "PopupMenu.border", proxyLazyValue9, "CheckBoxMenuItem.border", proxyLazyValue10, "CheckBoxMenuItem.borderPainted", Boolean.TRUE, "CheckBoxMenuItem.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getMenuTextFont"), "CheckBoxMenuItem.foreground", MetalLookAndFeel.getMenuForeground(), "CheckBoxMenuItem.background", MetalLookAndFeel.getMenuBackground(), "CheckBoxMenuItem.selectionForeground", MetalLookAndFeel.getMenuSelectedForeground(), "CheckBoxMenuItem.selectionBackground", MetalLookAndFeel.getMenuSelectedBackground(), "CheckBoxMenuItem.disabledForeground", MetalLookAndFeel.getMenuDisabledForeground(), "CheckBoxMenuItem.acceleratorFont", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getSubTextFont"), "CheckBoxMenuItem.acceleratorForeground", MetalLookAndFeel.getAcceleratorForeground(), "CheckBoxMenuItem.acceleratorSelectionForeground", MetalLookAndFeel.getAcceleratorSelectedForeground(), "CheckBoxMenuItem.checkIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getCheckBoxMenuItemIcon"), "CheckBoxMenuItem.arrowIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getMenuItemArrowIcon"), "RadioButtonMenuItem.border", proxyLazyValue10, "RadioButtonMenuItem.borderPainted", Boolean.TRUE, "RadioButtonMenuItem.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getMenuTextFont"), "RadioButtonMenuItem.foreground", MetalLookAndFeel.getMenuForeground(), "RadioButtonMenuItem.background", MetalLookAndFeel.getMenuBackground(), "RadioButtonMenuItem.selectionForeground", MetalLookAndFeel.getMenuSelectedForeground(), "RadioButtonMenuItem.selectionBackground", MetalLookAndFeel.getMenuSelectedBackground(), "RadioButtonMenuItem.disabledForeground", MetalLookAndFeel.getMenuDisabledForeground(), "RadioButtonMenuItem.acceleratorFont", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getSubTextFont"), "RadioButtonMenuItem.acceleratorForeground", MetalLookAndFeel.getAcceleratorForeground(), "RadioButtonMenuItem.acceleratorSelectionForeground", MetalLookAndFeel.getAcceleratorSelectedForeground(), "RadioButtonMenuItem.checkIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getRadioButtonMenuItemIcon"), "RadioButtonMenuItem.arrowIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getMenuItemArrowIcon"), "SplitPane.dividerSize", new Integer(10), "SplitPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "negativeIncrement", "DOWN", "positiveIncrement", "LEFT", "negativeIncrement", "RIGHT", "positiveIncrement", "KP_UP", "negativeIncrement", "KP_DOWN", "positiveIncrement", "KP_LEFT", "negativeIncrement", "KP_RIGHT", "positiveIncrement", "HOME", "selectMin", "END", "selectMax", "F8", "startResize", "F6", "toggleFocus"}), "Tree.background", MetalLookAndFeel.getWindowBackground(), "Tree.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getSystemTextFont"), "Tree.textForeground", uIDefaults.get("textText"), "Tree.textBackground", MetalLookAndFeel.getWindowBackground(), "Tree.selectionForeground", uIDefaults.get("textHighlightText"), "Tree.selectionBackground", uIDefaults.get("textHighlight"), "Tree.selectionBorderColor", MetalLookAndFeel.getFocusColor(), "Tree.openIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeFolderIcon"), "Tree.closedIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeFolderIcon"), "Tree.leafIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeLeafIcon"), "Tree.expandedIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeControlIcon", new Object[]{new Boolean(false)}), "Tree.collapsedIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeControlIcon", new Object[]{new Boolean(true)}), "Tree.line", MetalLookAndFeel.getPrimaryControl(), "Tree.hash", MetalLookAndFeel.getPrimaryControl(), "Tree.rowHeight", new Integer(0), "Tree.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "selectPrevious", "KP_UP", "selectPrevious", "shift UP", "selectPreviousExtendSelection", "shift KP_UP", "selectPreviousExtendSelection", "DOWN", "selectNext", "KP_DOWN", "selectNext", "shift DOWN", "selectNextExtendSelection", "shift KP_DOWN", "selectNextExtendSelection", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "LEFT", "selectParent", "KP_LEFT", "selectParent", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "HOME", "selectFirst", "shift HOME", "selectFirstExtendSelection", "END", "selectLast", "shift END", "selectLastExtendSelection", "ENTER", "toggle", "F2", "startEditing", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "ctrl SPACE", "toggleSelectionPreserveAnchor", "shift SPACE", "extendSelection", "ctrl HOME", "selectFirstChangeLead", "ctrl END", "selectLastChangeLead", "ctrl UP", "selectPreviousChangeLead", "ctrl KP_UP", "selectPreviousChangeLead", "ctrl DOWN", "selectNextChangeLead", "ctrl KP_DOWN", "selectNextChangeLead", "ctrl PAGE_DOWN", "scrollDownChangeLead", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl LEFT", "scrollLeft", "ctrl KP_LEFT", "scrollLeft", "ctrl RIGHT", "scrollRight", "ctrl KP_RIGHT", "scrollRight", "SPACE", "toggleSelectionPreserveAnchor"}), "Tree.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancel"}), "ToolBar.border", proxyLazyValue11, "ToolBar.background", MetalLookAndFeel.getMenuBackground(), "ToolBar.foreground", MetalLookAndFeel.getMenuForeground(), "ToolBar.font", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalLookAndFeel", "getMenuTextFont"), "ToolBar.dockingBackground", MetalLookAndFeel.getMenuBackground(), "ToolBar.floatingBackground", MetalLookAndFeel.getMenuBackground(), "ToolBar.dockingForeground", MetalLookAndFeel.getPrimaryControlDarkShadow(), "ToolBar.floatingForeground", MetalLookAndFeel.getPrimaryControl(), "ToolBar.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "RIGHT", "navigateRight", "KP_RIGHT", "navigateRight"}), "RootPane.defaultButtonWindowKeyBindings", new Object[]{"ENTER", "press", "released ENTER", "release", "ctrl ENTER", "press", "ctrl released ENTER", "release"}};
        uIDefaults.putDefaults(objectArray2);
    }

    protected void createDefaultTheme() {
        if (MetalLookAndFeel.getCurrentTheme() == null) {
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
        }
    }

    public UIDefaults getDefaults() {
        this.createDefaultTheme();
        UIDefaults uIDefaults = super.getDefaults();
        currentTheme.addCustomEntriesToTable(uIDefaults);
        return uIDefaults;
    }

    public static void setCurrentTheme(MetalTheme metalTheme) {
        if (metalTheme == null) {
            throw new NullPointerException("Can't have null theme");
        }
        currentTheme = metalTheme;
        cachedAppContext = AppContext.getAppContext();
        cachedAppContext.put("currentMetalTheme", metalTheme);
    }

    private static MetalTheme getCurrentTheme() {
        AppContext appContext = AppContext.getAppContext();
        if (cachedAppContext != appContext) {
            currentTheme = (MetalTheme)appContext.get("currentMetalTheme");
            cachedAppContext = appContext;
            if (currentTheme == null) {
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                currentTheme = (MetalTheme)appContext.get("currentMetalTheme");
            }
        }
        return currentTheme;
    }

    public static FontUIResource getControlTextFont() {
        return MetalLookAndFeel.getCurrentTheme().getControlTextFont();
    }

    public static FontUIResource getSystemTextFont() {
        return MetalLookAndFeel.getCurrentTheme().getSystemTextFont();
    }

    public static FontUIResource getUserTextFont() {
        return MetalLookAndFeel.getCurrentTheme().getUserTextFont();
    }

    public static FontUIResource getMenuTextFont() {
        return MetalLookAndFeel.getCurrentTheme().getMenuTextFont();
    }

    public static FontUIResource getWindowTitleFont() {
        return MetalLookAndFeel.getCurrentTheme().getWindowTitleFont();
    }

    public static FontUIResource getSubTextFont() {
        return MetalLookAndFeel.getCurrentTheme().getSubTextFont();
    }

    public static ColorUIResource getDesktopColor() {
        return MetalLookAndFeel.getCurrentTheme().getDesktopColor();
    }

    public static ColorUIResource getFocusColor() {
        return MetalLookAndFeel.getCurrentTheme().getFocusColor();
    }

    public static ColorUIResource getWhite() {
        return MetalLookAndFeel.getCurrentTheme().getWhite();
    }

    public static ColorUIResource getBlack() {
        return MetalLookAndFeel.getCurrentTheme().getBlack();
    }

    public static ColorUIResource getControl() {
        return MetalLookAndFeel.getCurrentTheme().getControl();
    }

    public static ColorUIResource getControlShadow() {
        return MetalLookAndFeel.getCurrentTheme().getControlShadow();
    }

    public static ColorUIResource getControlDarkShadow() {
        return MetalLookAndFeel.getCurrentTheme().getControlDarkShadow();
    }

    public static ColorUIResource getControlInfo() {
        return MetalLookAndFeel.getCurrentTheme().getControlInfo();
    }

    public static ColorUIResource getControlHighlight() {
        return MetalLookAndFeel.getCurrentTheme().getControlHighlight();
    }

    public static ColorUIResource getControlDisabled() {
        return MetalLookAndFeel.getCurrentTheme().getControlDisabled();
    }

    public static ColorUIResource getPrimaryControl() {
        return MetalLookAndFeel.getCurrentTheme().getPrimaryControl();
    }

    public static ColorUIResource getPrimaryControlShadow() {
        return MetalLookAndFeel.getCurrentTheme().getPrimaryControlShadow();
    }

    public static ColorUIResource getPrimaryControlDarkShadow() {
        return MetalLookAndFeel.getCurrentTheme().getPrimaryControlDarkShadow();
    }

    public static ColorUIResource getPrimaryControlInfo() {
        return MetalLookAndFeel.getCurrentTheme().getPrimaryControlInfo();
    }

    public static ColorUIResource getPrimaryControlHighlight() {
        return MetalLookAndFeel.getCurrentTheme().getPrimaryControlHighlight();
    }

    public static ColorUIResource getSystemTextColor() {
        return MetalLookAndFeel.getCurrentTheme().getSystemTextColor();
    }

    public static ColorUIResource getControlTextColor() {
        return MetalLookAndFeel.getCurrentTheme().getControlTextColor();
    }

    public static ColorUIResource getInactiveControlTextColor() {
        return MetalLookAndFeel.getCurrentTheme().getInactiveControlTextColor();
    }

    public static ColorUIResource getInactiveSystemTextColor() {
        return MetalLookAndFeel.getCurrentTheme().getInactiveSystemTextColor();
    }

    public static ColorUIResource getUserTextColor() {
        return MetalLookAndFeel.getCurrentTheme().getUserTextColor();
    }

    public static ColorUIResource getTextHighlightColor() {
        return MetalLookAndFeel.getCurrentTheme().getTextHighlightColor();
    }

    public static ColorUIResource getHighlightedTextColor() {
        return MetalLookAndFeel.getCurrentTheme().getHighlightedTextColor();
    }

    public static ColorUIResource getWindowBackground() {
        return MetalLookAndFeel.getCurrentTheme().getWindowBackground();
    }

    public static ColorUIResource getWindowTitleBackground() {
        return MetalLookAndFeel.getCurrentTheme().getWindowTitleBackground();
    }

    public static ColorUIResource getWindowTitleForeground() {
        return MetalLookAndFeel.getCurrentTheme().getWindowTitleForeground();
    }

    public static ColorUIResource getWindowTitleInactiveBackground() {
        return MetalLookAndFeel.getCurrentTheme().getWindowTitleInactiveBackground();
    }

    public static ColorUIResource getWindowTitleInactiveForeground() {
        return MetalLookAndFeel.getCurrentTheme().getWindowTitleInactiveForeground();
    }

    public static ColorUIResource getMenuBackground() {
        return MetalLookAndFeel.getCurrentTheme().getMenuBackground();
    }

    public static ColorUIResource getMenuForeground() {
        return MetalLookAndFeel.getCurrentTheme().getMenuForeground();
    }

    public static ColorUIResource getMenuSelectedBackground() {
        return MetalLookAndFeel.getCurrentTheme().getMenuSelectedBackground();
    }

    public static ColorUIResource getMenuSelectedForeground() {
        return MetalLookAndFeel.getCurrentTheme().getMenuSelectedForeground();
    }

    public static ColorUIResource getMenuDisabledForeground() {
        return MetalLookAndFeel.getCurrentTheme().getMenuDisabledForeground();
    }

    public static ColorUIResource getSeparatorBackground() {
        return MetalLookAndFeel.getCurrentTheme().getSeparatorBackground();
    }

    public static ColorUIResource getSeparatorForeground() {
        return MetalLookAndFeel.getCurrentTheme().getSeparatorForeground();
    }

    public static ColorUIResource getAcceleratorForeground() {
        return MetalLookAndFeel.getCurrentTheme().getAcceleratorForeground();
    }

    public static ColorUIResource getAcceleratorSelectedForeground() {
        return MetalLookAndFeel.getCurrentTheme().getAcceleratorSelectedForeground();
    }

    static {
        isOnlyOneContext = true;
        cachedAppContext = AppContext.getAppContext();
    }
}

