/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;

public class MetalRadioButtonUI
extends BasicRadioButtonUI {
    private static final MetalRadioButtonUI metalRadioButtonUI = new MetalRadioButtonUI();
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;
    private boolean defaults_initialized = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return metalRadioButtonUI;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            this.focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
            this.selectColor = UIManager.getColor(this.getPropertyPrefix() + "select");
            this.disabledTextColor = UIManager.getColor(this.getPropertyPrefix() + "disabledText");
            this.defaults_initialized = true;
        }
        abstractButton.setOpaque(true);
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaults_initialized = false;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Dimension dimension = jComponent.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = new Rectangle(dimension);
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Icon icon = abstractButton.getIcon();
        Object var14_14 = null;
        Object var15_15 = null;
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), icon != null ? icon : this.getDefaultIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, this.getDefaultTextIconGap(abstractButton));
        if (jComponent.isOpaque()) {
            graphics.setColor(abstractButton.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (icon != null) {
            if (!buttonModel.isEnabled()) {
                icon = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = abstractButton.getPressedIcon();
                if (icon == null) {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (buttonModel.isSelected()) {
                if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                    icon = abstractButton.getRolloverSelectedIcon();
                    if (icon == null) {
                        icon = abstractButton.getSelectedIcon();
                    }
                } else {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                icon = abstractButton.getRolloverIcon();
            }
            if (icon == null) {
                icon = abstractButton.getIcon();
            }
            icon.paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
        } else {
            this.getDefaultIcon().paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
        }
        if (string != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, rectangle3);
            } else if (buttonModel.isEnabled()) {
                graphics.setColor(abstractButton.getForeground());
                BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle3.x, rectangle3.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(abstractButton.getBackground().darker());
                BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle3.x, rectangle3.y + fontMetrics.getAscent());
            }
            if (abstractButton.hasFocus() && abstractButton.isFocusPainted() && rectangle3.width > 0 && rectangle3.height > 0) {
                this.paintFocus(graphics, rectangle3, dimension);
            }
        }
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle, Dimension dimension) {
        graphics.setColor(this.getFocusColor());
        graphics.drawRect(rectangle.x, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
    }
}

