/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class DefaultTableCellRenderer
extends JLabel
implements TableCellRenderer,
Serializable {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private Color unselectedForeground;
    private Color unselectedBackground;

    public DefaultTableCellRenderer() {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.unselectedForeground = color;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.unselectedBackground = color;
    }

    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            super.setForeground(jTable.getSelectionForeground());
            super.setBackground(jTable.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
        }
        this.setFont(jTable.getFont());
        if (bl2) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (jTable.isCellEditable(n, n2)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setValue(object);
        return this;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    protected void setValue(Object object) {
        this.setText(object == null ? "" : object.toString());
    }

    public static class UIResource
    extends DefaultTableCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

