/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Vector;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;

public class DefaultHighlighter
extends LayeredHighlighter {
    private Vector highlights = new Vector();
    private JTextComponent component;
    private boolean drawsLayeredHighlights = true;
    public static LayeredHighlighter.LayerPainter DefaultPainter = new DefaultHighlightPainter(null);

    public void paint(Graphics graphics) {
        int n = this.highlights.size();
        int n2 = 0;
        while (n2 < n) {
            HighlightInfo highlightInfo = (HighlightInfo)this.highlights.elementAt(n2);
            if (!(highlightInfo instanceof LayeredHighlightInfo)) {
                Rectangle rectangle = this.component.getBounds();
                Insets insets = this.component.getInsets();
                rectangle.x = insets.left;
                rectangle.y = insets.top;
                rectangle.width -= insets.left + insets.right;
                rectangle.height -= insets.top + insets.bottom;
                while (n2 < n) {
                    highlightInfo = (HighlightInfo)this.highlights.elementAt(n2);
                    if (!(highlightInfo instanceof LayeredHighlightInfo)) {
                        Highlighter.HighlightPainter highlightPainter = highlightInfo.getPainter();
                        highlightPainter.paint(graphics, highlightInfo.getStartOffset(), highlightInfo.getEndOffset(), rectangle, this.component);
                    }
                    ++n2;
                }
            }
            ++n2;
        }
    }

    public void install(JTextComponent jTextComponent) {
        this.component = jTextComponent;
        this.removeAllHighlights();
    }

    public void deinstall(JTextComponent jTextComponent) {
        this.component = null;
    }

    public Object addHighlight(int n, int n2, Highlighter.HighlightPainter highlightPainter) throws BadLocationException {
        Document document = this.component.getDocument();
        TextUI textUI = this.component.getUI();
        HighlightInfo highlightInfo = this.getDrawsLayeredHighlights() && highlightPainter instanceof LayeredHighlighter.LayerPainter ? new LayeredHighlightInfo() : new HighlightInfo();
        highlightInfo.painter = highlightPainter;
        highlightInfo.p0 = document.createPosition(n);
        highlightInfo.p1 = document.createPosition(n2);
        this.highlights.addElement(highlightInfo);
        textUI.damageRange(this.component, n, n2);
        return highlightInfo;
    }

    public void removeHighlight(Object object) {
        if (object instanceof LayeredHighlightInfo) {
            LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)object;
            if (layeredHighlightInfo.width > 0 && layeredHighlightInfo.height > 0) {
                this.component.repaint(layeredHighlightInfo.x, layeredHighlightInfo.y, layeredHighlightInfo.width, layeredHighlightInfo.height);
            }
        } else {
            TextUI textUI = this.component.getUI();
            HighlightInfo highlightInfo = (HighlightInfo)object;
            textUI.damageRange(this.component, highlightInfo.p0.getOffset(), highlightInfo.p1.getOffset());
        }
        this.highlights.removeElement(object);
    }

    public void removeAllHighlights() {
        int n;
        TextUI textUI = this.component.getUI();
        if (this.getDrawsLayeredHighlights()) {
            int n2 = this.highlights.size();
            if (n2 != 0) {
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                while (n7 < n2) {
                    LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)this.highlights.elementAt(n7);
                    n3 = Math.min(n3, layeredHighlightInfo.x);
                    n4 = Math.min(n4, layeredHighlightInfo.y);
                    n5 = Math.max(n5, layeredHighlightInfo.x + layeredHighlightInfo.width);
                    n6 = Math.max(n6, layeredHighlightInfo.y + layeredHighlightInfo.height);
                    ++n7;
                }
                if (n3 != n5 && n4 != n6) {
                    this.component.repaint(n3, n4, n5 - n3, n6 - n4);
                }
                this.highlights.removeAllElements();
            }
        } else if (textUI != null && (n = this.highlights.size()) != 0) {
            int n8 = Integer.MAX_VALUE;
            int n9 = 0;
            int n10 = 0;
            while (n10 < n) {
                HighlightInfo highlightInfo = (HighlightInfo)this.highlights.elementAt(n10);
                n8 = Math.min(n8, highlightInfo.p0.getOffset());
                n9 = Math.max(n9, highlightInfo.p1.getOffset());
                ++n10;
            }
            textUI.damageRange(this.component, n8, n9);
            this.highlights.removeAllElements();
        }
    }

    public void changeHighlight(Object object, int n, int n2) throws BadLocationException {
        Document document = this.component.getDocument();
        TextUI textUI = this.component.getUI();
        if (object instanceof LayeredHighlightInfo) {
            LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)object;
            if (layeredHighlightInfo.width > 0 && layeredHighlightInfo.height > 0) {
                this.component.repaint(layeredHighlightInfo.x, layeredHighlightInfo.y, layeredHighlightInfo.width, layeredHighlightInfo.height);
            }
            layeredHighlightInfo.height = 0;
            layeredHighlightInfo.width = 0;
            layeredHighlightInfo.p0 = document.createPosition(n);
            layeredHighlightInfo.p1 = document.createPosition(n2);
            textUI.damageRange(this.component, Math.min(n, n2), Math.max(n, n2));
        } else {
            HighlightInfo highlightInfo = (HighlightInfo)object;
            int n3 = highlightInfo.p0.getOffset();
            int n4 = highlightInfo.p1.getOffset();
            if (n == n3) {
                textUI.damageRange(this.component, Math.min(n4, n2), Math.max(n4, n2));
            } else if (n2 == n4) {
                textUI.damageRange(this.component, Math.min(n, n3), Math.max(n, n3));
            } else {
                textUI.damageRange(this.component, n3, n4);
                textUI.damageRange(this.component, n, n2);
            }
            highlightInfo.p0 = document.createPosition(n);
            highlightInfo.p1 = document.createPosition(n2);
        }
    }

    public Highlighter.Highlight[] getHighlights() {
        Object[] objectArray = new Highlighter.Highlight[this.highlights.size()];
        this.highlights.copyInto(objectArray);
        return objectArray;
    }

    public void paintLayeredHighlights(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
        int n3 = this.highlights.size() - 1;
        while (n3 >= 0) {
            Object object = this.highlights.elementAt(n3);
            if (object instanceof LayeredHighlightInfo) {
                LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)object;
                int n4 = layeredHighlightInfo.getStartOffset();
                int n5 = layeredHighlightInfo.getEndOffset();
                if (n < n4 && n2 > n4 || n >= n4 && n < n5) {
                    layeredHighlightInfo.paintLayeredHighlights(graphics, n, n2, shape, jTextComponent, view);
                }
            }
            --n3;
        }
    }

    public void setDrawsLayeredHighlights(boolean bl) {
        this.drawsLayeredHighlights = bl;
    }

    public boolean getDrawsLayeredHighlights() {
        return this.drawsLayeredHighlights;
    }

    class LayeredHighlightInfo
    extends HighlightInfo {
        int x;
        int y;
        int width;
        int height;

        LayeredHighlightInfo() {
        }

        void union(Shape shape) {
            if (shape == null) {
                return;
            }
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            if (this.width == 0 || this.height == 0) {
                this.x = rectangle.x;
                this.y = rectangle.y;
                this.width = rectangle.width;
                this.height = rectangle.height;
            } else {
                this.width = Math.max(this.x + this.width, rectangle.x + rectangle.width);
                this.height = Math.max(this.y + this.height, rectangle.y + rectangle.height);
                this.x = Math.min(this.x, rectangle.x);
                this.width -= this.x;
                this.y = Math.min(this.y, rectangle.y);
                this.height -= this.y;
            }
        }

        void paintLayeredHighlights(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            int n3 = this.getStartOffset();
            int n4 = this.getEndOffset();
            n = Math.max(n3, n);
            n2 = Math.min(n4, n2);
            this.union(((LayeredHighlighter.LayerPainter)this.painter).paintLayer(graphics, n, n2, shape, jTextComponent, view));
        }
    }

    class HighlightInfo
    implements Highlighter.Highlight {
        Position p0;
        Position p1;
        Highlighter.HighlightPainter painter;

        HighlightInfo() {
        }

        public int getStartOffset() {
            return this.p0.getOffset();
        }

        public int getEndOffset() {
            return this.p1.getOffset();
        }

        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }
    }

    public static class DefaultHighlightPainter
    extends LayeredHighlighter.LayerPainter {
        private Color color;

        public DefaultHighlightPainter(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            Rectangle rectangle = shape.getBounds();
            try {
                TextUI textUI = jTextComponent.getUI();
                Rectangle rectangle2 = textUI.modelToView(jTextComponent, n, Position.Bias.Forward);
                Rectangle rectangle3 = textUI.modelToView(jTextComponent, n2, Position.Bias.Backward);
                Color color = this.getColor();
                if (color == null) {
                    graphics.setColor(jTextComponent.getSelectionColor());
                } else {
                    graphics.setColor(color);
                }
                if (rectangle2.y == rectangle3.y) {
                    Rectangle rectangle4 = rectangle2.union(rectangle3);
                    graphics.fillRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                } else {
                    int n3 = rectangle.x + rectangle.width - rectangle2.x;
                    graphics.fillRect(rectangle2.x, rectangle2.y, n3, rectangle2.height);
                    if (rectangle2.y + rectangle2.height != rectangle3.y) {
                        graphics.fillRect(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle3.y - (rectangle2.y + rectangle2.height));
                    }
                    graphics.fillRect(rectangle.x, rectangle3.y, rectangle3.x - rectangle.x, rectangle3.height);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            Color color = this.getColor();
            if (color == null) {
                graphics.setColor(jTextComponent.getSelectionColor());
            } else {
                graphics.setColor(color);
            }
            if (n == view.getStartOffset() && n2 == view.getEndOffset()) {
                Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                return rectangle;
            }
            try {
                Shape shape2 = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
                ((Graphics2D)graphics).fill(shape2);
                return shape2;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
    }
}

