/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.Transferable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import sun.io.CharacterEncoding;
import sun.security.action.GetPropertyAction;

public abstract class DataTransferer {
    private static final Map knownEncodings;
    private static String defaultEncoding;
    private static DataFlavorComparator defaultComparator;

    public static String getTextCharset(DataFlavor dataFlavor) {
        if (!"text".equals(dataFlavor.getPrimaryType())) {
            return null;
        }
        String string = dataFlavor.getParameter("charset");
        if (string != null) {
            return string;
        }
        return DataTransferer.getDefaultTextCharset();
    }

    public static String getDefaultTextCharset() {
        if (defaultEncoding != null) {
            return defaultEncoding;
        }
        GetPropertyAction getPropertyAction = new GetPropertyAction("file.encoding");
        String string = (String)AccessController.doPrivileged(getPropertyAction);
        if (string != null) {
            defaultEncoding = DataTransferer.isEncodingSupported(string) ? string : "ISO8859_1";
            return defaultEncoding;
        }
        return "ISO8859_1";
    }

    public static boolean isEncodingSupported(String string) {
        Boolean bl;
        if (string == null) {
            return false;
        }
        String string2 = CharacterEncoding.aliasName(string);
        if (string2 == null) {
            string2 = string;
        }
        if ((bl = (Boolean)knownEncodings.get(string2)) == null) {
            try {
                new String("abc".getBytes(string2), string2);
                bl = Boolean.TRUE;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bl = Boolean.FALSE;
            }
            knownEncodings.put(string2, bl);
        }
        return bl == Boolean.TRUE;
    }

    public Map getFormatsForTransferable(Transferable transferable, FlavorMap flavorMap) {
        return this.getFormatsForFlavors(transferable.getTransferDataFlavors(), flavorMap);
    }

    public Map getFormatsForFlavor(DataFlavor dataFlavor, FlavorMap flavorMap) {
        return this.getFormatsForFlavors(new DataFlavor[]{dataFlavor}, flavorMap);
    }

    public abstract Map getFormatsForFlavors(DataFlavor[] var1, FlavorMap var2);

    public long[] getFormatsForTransferableAsArray(Transferable transferable, FlavorMap flavorMap) {
        return this.keysToLongArray(this.getFormatsForTransferable(transferable, flavorMap));
    }

    public long[] getFormatsForFlavorAsArray(DataFlavor dataFlavor, FlavorMap flavorMap) {
        return this.keysToLongArray(this.getFormatsForFlavor(dataFlavor, flavorMap));
    }

    public long[] getFormatsForFlavorsAsArray(DataFlavor[] dataFlavorArray, FlavorMap flavorMap) {
        return this.keysToLongArray(this.getFormatsForFlavors(dataFlavorArray, flavorMap));
    }

    public abstract Map getFlavorsForFormats(long[] var1, FlavorMap var2);

    public Map getFlavorsForFormat(long l, FlavorMap flavorMap) {
        return this.getFlavorsForFormats(new long[]{l}, flavorMap);
    }

    public DataFlavor[] getFlavorsForFormatsAsArray(long[] lArray, FlavorMap flavorMap) {
        return this.keysToDataFlavorArray(this.getFlavorsForFormats(lArray, flavorMap));
    }

    public DataFlavor[] getFlavorsForFormatAsArray(long l, FlavorMap flavorMap) {
        return this.keysToDataFlavorArray(this.getFlavorsForFormat(l, flavorMap));
    }

    public long[] keysToLongArray(Map map) {
        Set set = map.keySet();
        long[] lArray = new long[set.size()];
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            lArray[n] = (Long)iterator.next();
            ++n;
        }
        return lArray;
    }

    public DataFlavor[] keysToDataFlavorArray(Map map) {
        return this.setToSortedDataFlavorArray(map.keySet(), map);
    }

    protected abstract String getEncoding(DataFlavor var1, long var2, String var4);

    public byte[] translateTransferable(Transferable transferable, DataFlavor dataFlavor, long l) throws IOException {
        return this.translateTransferable(transferable, dataFlavor, l, null);
    }

    protected abstract byte[] translateTransferable(Transferable var1, DataFlavor var2, long var3, String var5) throws IOException;

    public Object translateBytes(byte[] byArray, DataFlavor dataFlavor, long l) throws IOException {
        return this.translateBytesOrStream(null, byArray, dataFlavor, l);
    }

    public Object translateStream(InputStream inputStream, DataFlavor dataFlavor, long l) throws IOException {
        return this.translateBytesOrStream(inputStream, null, dataFlavor, l);
    }

    protected abstract Object translateBytesOrStream(InputStream var1, byte[] var2, DataFlavor var3, long var4) throws IOException;

    protected byte[] inputStreamToByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        byte[] byArray = new byte[64];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public DataFlavor[] setToSortedDataFlavorArray(Set set) {
        Object[] objectArray = new DataFlavor[set.size()];
        set.toArray(objectArray);
        Arrays.sort(objectArray, defaultComparator);
        return objectArray;
    }

    public DataFlavor[] setToSortedDataFlavorArray(Set set, Map map) {
        Object[] objectArray = new DataFlavor[set.size()];
        set.toArray(objectArray);
        DataFlavorComparator dataFlavorComparator = new DataFlavorComparator(map, false);
        Arrays.sort(objectArray, dataFlavorComparator);
        return objectArray;
    }

    static {
        HashMap hashMap = new HashMap(11);
        hashMap.put("ASCII", Boolean.TRUE);
        hashMap.put("ISO8859_1", Boolean.TRUE);
        hashMap.put("UTF8", Boolean.TRUE);
        hashMap.put("UnicodeBigUnmarked", Boolean.TRUE);
        hashMap.put("UnicodeLittleUnmarked", Boolean.TRUE);
        hashMap.put("UTF16", Boolean.TRUE);
        knownEncodings = Collections.synchronizedMap(hashMap);
        defaultComparator = new DataFlavorComparator(false);
    }

    public static class DataFlavorComparator
    implements Comparator {
        public static final boolean FORWARD_ORDER = true;
        public static final boolean REVERSE_ORDER = false;
        protected final Map flavorToFormatMap;
        private final boolean order;
        private static final Map primaryTypes;
        private static final Map subtypes;
        private static final Map charsets;
        private static String defaultEncoding;
        private static final Long UNKNOWN_TYPE;
        private static final Long DEFAULT_CHARSET_INDEX;
        private static final Long OTHER_CHARSET_INDEX;
        private static final Long WORST_CHARSET_INDEX;
        private static final Long UNSUPPORTED_CHARSET_INDEX;
        private static final String UNSUPPORTED_CHARSET = "UNSUPPORTED";
        private static final Long REMOTE_CLASS_INDEX;
        private static final Long SERIALIZABLE_CLASS_INDEX;
        private static final Long INPUT_STREAM_CLASS_INDEX;
        private static final Long OTHER_CLASS_INDEX;
        static /* synthetic */ Class class$java$rmi$Remote;
        static /* synthetic */ Class class$java$io$Serializable;
        static /* synthetic */ Class class$java$io$InputStream;

        DataFlavorComparator() {
            this(true);
        }

        DataFlavorComparator(boolean bl) {
            this.order = bl;
            this.flavorToFormatMap = Collections.EMPTY_MAP;
        }

        DataFlavorComparator(Map map) {
            this(map, true);
        }

        DataFlavorComparator(Map map, boolean bl) {
            this.order = bl;
            HashMap hashMap = new HashMap(map.size());
            hashMap.putAll(map);
            this.flavorToFormatMap = Collections.unmodifiableMap(hashMap);
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            DataFlavor dataFlavor = null;
            DataFlavor dataFlavor2 = null;
            if (this.order) {
                dataFlavor = (DataFlavor)object;
                dataFlavor2 = (DataFlavor)object2;
            } else {
                dataFlavor = (DataFlavor)object2;
                dataFlavor2 = (DataFlavor)object;
            }
            n = this.comparePrimaryTypes(dataFlavor.getPrimaryType(), dataFlavor2.getPrimaryType());
            if (n != 0) {
                return n;
            }
            n = this.compareSubtypes(dataFlavor.getSubType(), dataFlavor2.getSubType());
            if (n != 0) {
                return n;
            }
            if ("text".equals(dataFlavor.getPrimaryType()) && (n = this.compareCharsets(DataTransferer.getTextCharset(dataFlavor), DataTransferer.getTextCharset(dataFlavor2))) != 0) {
                return n;
            }
            n = this.compareRepresentationClasses(dataFlavor.getRepresentationClass(), dataFlavor2.getRepresentationClass());
            if (n != 0) {
                return n;
            }
            return this.compareByNativeFormats(dataFlavor, dataFlavor2);
        }

        protected int comparePrimaryTypes(String string, String string2) {
            return DataFlavorComparator.compareIndices(primaryTypes, string, string2, UNKNOWN_TYPE);
        }

        protected int compareSubtypes(String string, String string2) {
            return DataFlavorComparator.compareIndices(subtypes, string, string2, UNKNOWN_TYPE);
        }

        protected int compareCharsets(String string, String string2) {
            int n = DataFlavorComparator.compareIndices(charsets, string = DataFlavorComparator.getEncoding(string), string2 = DataFlavorComparator.getEncoding(string2), OTHER_CHARSET_INDEX);
            if (n == 0) {
                return string2.compareTo(string);
            }
            return n;
        }

        protected static String getEncoding(String string) {
            String string2;
            String string3 = null;
            if (string == null) {
                return null;
            }
            string3 = DataTransferer.isEncodingSupported(string) ? ((string2 = CharacterEncoding.aliasName(string)) != null ? string2 : string) : UNSUPPORTED_CHARSET;
            return string3;
        }

        protected static int compareIndices(Map map, Object object, Object object2, Long l) {
            Long l2 = (Long)map.get(object);
            Long l3 = (Long)map.get(object2);
            if (l2 == null) {
                l2 = l;
            }
            if (l3 == null) {
                l3 = l;
            }
            return l2.compareTo(l3);
        }

        protected int compareRepresentationClasses(Class clazz, Class clazz2) {
            Long l = DataFlavorComparator.getRepresentationClassIndex(clazz);
            Long l2 = DataFlavorComparator.getRepresentationClassIndex(clazz2);
            return l.compareTo(l2);
        }

        protected static Long getRepresentationClassIndex(Class clazz) {
            if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = DataFlavorComparator.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz)) {
                return REMOTE_CLASS_INDEX;
            }
            if ((class$java$io$Serializable == null ? (class$java$io$Serializable = DataFlavorComparator.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz)) {
                return SERIALIZABLE_CLASS_INDEX;
            }
            if ((class$java$io$InputStream == null ? (class$java$io$InputStream = DataFlavorComparator.class$("java.io.InputStream")) : class$java$io$InputStream).isAssignableFrom(clazz)) {
                return INPUT_STREAM_CLASS_INDEX;
            }
            return OTHER_CLASS_INDEX;
        }

        protected int compareByNativeFormats(DataFlavor dataFlavor, DataFlavor dataFlavor2) {
            return DataFlavorComparator.compareIndices(this.flavorToFormatMap, dataFlavor, dataFlavor2, new Long(Long.MIN_VALUE));
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        static {
            UNKNOWN_TYPE = new Long(Long.MAX_VALUE);
            DEFAULT_CHARSET_INDEX = new Long(2L);
            OTHER_CHARSET_INDEX = new Long(1L);
            WORST_CHARSET_INDEX = new Long(0L);
            UNSUPPORTED_CHARSET_INDEX = new Long(Long.MIN_VALUE);
            REMOTE_CLASS_INDEX = new Long(3L);
            SERIALIZABLE_CLASS_INDEX = new Long(2L);
            INPUT_STREAM_CLASS_INDEX = new Long(1L);
            OTHER_CLASS_INDEX = new Long(0L);
            HashMap hashMap = new HashMap(2);
            hashMap.put("text", new Long(0L));
            hashMap.put("application", new Long(1L));
            primaryTypes = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(17);
            hashMap.put("plain", new Long(0L));
            hashMap.put("calendar", new Long(1L));
            hashMap.put("css", new Long(2L));
            hashMap.put("directory", new Long(3L));
            hashMap.put("rfc822-headers", new Long(4L));
            hashMap.put("tab-separated-values", new Long(5L));
            hashMap.put("uri-list", new Long(6L));
            hashMap.put("richtext", new Long(7L));
            hashMap.put("enriched", new Long(8L));
            hashMap.put("rtf", new Long(9L));
            hashMap.put("html", new Long(10L));
            hashMap.put("xml", new Long(11L));
            hashMap.put("sgml", new Long(12L));
            hashMap.put("x-java-file-list", new Long(13L));
            hashMap.put("x-java-serialized-object", new Long(14L));
            hashMap.put("x-java-jvm-local-objectref", new Long(15L));
            hashMap.put("x-java-remote-object", new Long(16L));
            subtypes = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(6);
            hashMap.put("UnicodeLittleUnmarked", new Long(3L));
            hashMap.put("UnicodeBigUnmarked", new Long(4L));
            hashMap.put("UTF8", new Long(5L));
            hashMap.put("UTF16", new Long(6L));
            hashMap.put("ASCII", WORST_CHARSET_INDEX);
            String string = DataTransferer.getDefaultTextCharset();
            defaultEncoding = CharacterEncoding.aliasName(string);
            if (defaultEncoding == null) {
                defaultEncoding = string;
            }
            if (hashMap.get(defaultEncoding) == null) {
                hashMap.put(defaultEncoding, DEFAULT_CHARSET_INDEX);
            }
            hashMap.put(UNSUPPORTED_CHARSET, UNSUPPORTED_CHARSET_INDEX);
            charsets = Collections.unmodifiableMap(hashMap);
        }
    }
}

