/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import com.ibm.jvm.io.LocalizedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import sun.awt.DebugHelperImpl;

final class DebugSettings {
    static final String PREFIX = "awtdebug";
    static final String PROP_FILE = "properties";
    private static final String[] DEFAULT_PROPS = new String[]{"awtdebug.assert=true", "awtdebug.trace=false", "awtdebug.on=true", "awtdebug.ctrace=false"};
    private static DebugSettings instance = null;
    private Properties props = new Properties();

    static DebugSettings getInstance() {
        if (instance == null) {
            instance = new DebugSettings();
        }
        return instance;
    }

    private DebugSettings() {
        new PrivilegedAction(){

            public Object run() {
                DebugSettings.this.loadProperties();
                return null;
            }
        }.run();
    }

    private synchronized void loadProperties() {
        this.loadDefaultProperties();
        this.loadFileProperties();
        this.loadSystemProperties();
        this.println(this);
    }

    public String toString() {
        Enumeration enumeration = this.props.propertyNames();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.println("------------------");
        printStream.println("AWT Debug Settings");
        printStream.println("------------------");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.props.getProperty(string, "");
            printStream.println(string + "=" + string2);
        }
        printStream.println("------------------");
        return new String(byteArrayOutputStream.toByteArray());
    }

    private void loadDefaultProperties() {
        try {
            int n = 0;
            while (n < DEFAULT_PROPS.length) {
                StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(DEFAULT_PROPS[n]);
                this.props.load(stringBufferInputStream);
                stringBufferInputStream.close();
                ++n;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadFileProperties() {
        String string = System.getProperty("awtdebug.properties", "");
        if (string.equals("")) {
            string = System.getProperty("user.home", "") + File.separator + PREFIX + "." + PROP_FILE;
        }
        File file = new File(string);
        try {
            this.println("Reading debug settings from '" + file.getCanonicalPath() + "'...");
            FileInputStream fileInputStream = new FileInputStream(file);
            this.props.load(LocalizedInputStream.localize(fileInputStream));
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.println("Did not find settings file.");
        }
        catch (IOException iOException) {
            this.println("Problem reading settings, IOException: " + iOException.getMessage());
        }
    }

    private void loadSystemProperties() {
        Properties properties = System.getProperties();
        Enumeration enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string, "");
            if (!string.startsWith(PREFIX)) continue;
            this.props.setProperty(string, string2);
        }
    }

    public synchronized boolean getBoolean(String string, boolean bl) {
        String string2 = this.getString(string, String.valueOf(bl));
        return string2.equalsIgnoreCase("true");
    }

    public synchronized int getInt(String string, int n) {
        String string2 = this.getString(string, String.valueOf(n));
        return Integer.parseInt(string2);
    }

    public synchronized String getString(String string, String string2) {
        String string3 = "awtdebug." + string;
        String string4 = this.props.getProperty(string3, string2);
        return string4;
    }

    public synchronized Enumeration getPropertyNames() {
        Vector vector = new Vector();
        Enumeration enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            string = string.substring(PREFIX.length() + 1);
            vector.addElement(string);
        }
        return vector.elements();
    }

    private void println(Object object) {
        DebugHelperImpl.printlnImpl(object.toString());
    }
}

