/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import sun.awt.font.NativeFontWrapper;

public class FontDesignMetrics2D {
    private Font font;
    private FontRenderContext frc;
    private float ascent;
    private float descent;
    private float leading;
    private float maxAdvance;
    private double[] matrix;

    public FontDesignMetrics2D(Font font, FontRenderContext fontRenderContext, float f, float f2, float f3, float f4) {
        this.font = font;
        this.frc = fontRenderContext;
        this.ascent = f;
        this.descent = f2;
        this.leading = f3;
        this.maxAdvance = f4;
        float f5 = font.getSize2D();
        AffineTransform affineTransform = fontRenderContext.getTransform();
        affineTransform.scale(f5, f5);
        this.matrix = new double[4];
        this.matrix[0] = affineTransform.getScaleX();
        this.matrix[1] = 0.0;
        this.matrix[2] = 0.0;
        this.matrix[3] = affineTransform.getScaleY();
    }

    public float getAdvance(char c) {
        return NativeFontWrapper.getAdvance(this.font, c, this.matrix, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics());
    }

    public float getAdvance(String string) {
        if (string.length() > 0) {
            int n = string.length();
            float f = 0.0f;
            int n2 = 0;
            while (n2 < n) {
                f += this.getAdvance(string.charAt(n2));
                ++n2;
            }
            return f;
        }
        return 0.0f;
    }

    public float getAdvance(char[] cArray, int n, int n2) {
        return this.getAdvance(new String(cArray, n, n2));
    }

    public float getMaxAdvance() {
        return this.maxAdvance;
    }

    public float getAscent() {
        return this.ascent;
    }

    public float getDescent() {
        return this.descent;
    }

    public float getLeading() {
        return this.leading;
    }

    public float getAscent(char c) {
        return this.ascent;
    }

    public float getDescent(char c) {
        return this.descent;
    }

    public float getLeading(char c) {
        return this.leading;
    }

    public float getHeight(char c) {
        return this.leading;
    }

    public float getHeight() {
        return this.leading;
    }
}

