/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.geom;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import sun.awt.geom.ChainEnd;
import sun.awt.geom.Curve;
import sun.awt.geom.CurveLink;
import sun.awt.geom.Edge;

public abstract class AreaOp {
    public static final int CTAG_LEFT = 0;
    public static final int CTAG_RIGHT = 1;
    public static final int ETAG_IGNORE = 0;
    public static final int ETAG_ENTER = 1;
    public static final int ETAG_EXIT = -1;
    public static final int RSTAG_INSIDE = 1;
    public static final int RSTAG_OUTSIDE = -1;
    private static Comparator YXTopComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            double d;
            Curve curve = ((Edge)object).getCurve();
            Curve curve2 = ((Edge)object2).getCurve();
            double d2 = curve.getYTop();
            if (d2 == (d = curve2.getYTop()) && (d2 = curve.getXTop()) == (d = curve2.getXTop())) {
                return 0;
            }
            if (d2 < d) {
                return -1;
            }
            return 1;
        }
    };
    private static CurveLink[] EmptyLinkList = new CurveLink[2];
    private static ChainEnd[] EmptyChainList = new ChainEnd[2];

    protected AreaOp() {
    }

    public abstract void newRow();

    public abstract int classify(Edge var1);

    public abstract int getState();

    public Vector calculate(Vector vector, Vector vector2) {
        Vector vector3 = new Vector();
        AreaOp.addEdges(vector3, vector, 0);
        AreaOp.addEdges(vector3, vector2, 1);
        vector3 = this.pruneEdges(vector3);
        return vector3;
    }

    private static void addEdges(Vector vector, Vector vector2, int n) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Curve curve = (Curve)enumeration.nextElement();
            if (curve.getOrder() <= 0) continue;
            vector.add(new Edge(curve, n));
        }
    }

    private Vector pruneEdges(Vector vector) {
        int n = vector.size();
        if (n < 2) {
            return vector;
        }
        Object[] objectArray = (Edge[])vector.toArray(new Edge[n]);
        Arrays.sort(objectArray, YXTopComparator);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double[] dArray = new double[2];
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        while (n2 < n) {
            int n6;
            Object object;
            double d = dArray[0];
            n4 = n5 = n3 - 1;
            while (n4 >= n2) {
                object = objectArray[n4];
                if (((Edge)object).getCurve().getYBot() > d) {
                    if (n5 > n4) {
                        objectArray[n5] = object;
                    }
                    --n5;
                }
                --n4;
            }
            n2 = n5 + 1;
            if (n2 >= n3) {
                if (n3 >= n) break;
                d = ((Edge)objectArray[n3]).getCurve().getYTop();
                if (d > dArray[0]) {
                    AreaOp.finalizeSubCurves(vector2, vector3);
                }
                dArray[0] = d;
            }
            while (n3 < n) {
                object = objectArray[n3];
                if (((Edge)object).getCurve().getYTop() > d) break;
                ++n3;
            }
            dArray[1] = ((Edge)objectArray[n2]).getCurve().getYBot();
            if (n3 < n && dArray[1] > (d = ((Edge)objectArray[n3]).getCurve().getYTop())) {
                dArray[1] = d;
            }
            int n7 = 1;
            n4 = n2;
            while (n4 < n3) {
                object = objectArray[n4];
                ((Edge)object).setEquivalence(0);
                n5 = n4;
                while (n5 > n2) {
                    Object object2 = objectArray[n5 - 1];
                    int n8 = ((Edge)object).compareTo((Edge)object2, dArray);
                    if (dArray[1] <= dArray[0]) {
                        throw new InternalError("backstepping to " + dArray[1] + " from " + dArray[0]);
                    }
                    if (n8 >= 0) {
                        if (n8 != 0) break;
                        int n9 = ((Edge)object2).getEquivalence();
                        if (n9 == 0) {
                            n9 = n7++;
                            ((Edge)object2).setEquivalence(n9);
                        }
                        ((Edge)object).setEquivalence(n9);
                        break;
                    }
                    objectArray[n5] = object2;
                    --n5;
                }
                objectArray[n5] = object;
                ++n4;
            }
            this.newRow();
            double d2 = dArray[0];
            double d3 = dArray[1];
            n4 = n2;
            while (n4 < n3) {
                object = objectArray[n4];
                int n10 = ((Edge)object).getEquivalence();
                if (n10 != 0) {
                    int n11 = this.getState();
                    n6 = n11 == 1 ? -1 : 1;
                    Object object3 = null;
                    Object object4 = object;
                    double d4 = d3;
                    do {
                        this.classify((Edge)object);
                        if (object3 == null && ((Edge)object).isActiveFor(d2, n6)) {
                            object3 = object;
                        }
                        if (!((d = ((Edge)object).getCurve().getYBot()) > d4)) continue;
                        object4 = object;
                        d4 = d;
                    } while (++n4 < n3 && ((Edge)(object = objectArray[n4])).getEquivalence() == n10);
                    --n4;
                    if (this.getState() == n11) {
                        n6 = 0;
                    } else {
                        object = object3 != null ? object3 : object4;
                    }
                } else {
                    n6 = this.classify((Edge)object);
                }
                if (n6 != 0) {
                    ((Edge)object).record(d3, n6);
                    vector4.add(new CurveLink(((Edge)object).getCurve(), d2, d3, n6));
                }
                ++n4;
            }
            if (this.getState() != -1) {
                System.out.println("Still inside at end of active edge list!");
                System.out.println("num curves = " + (n3 - n2));
                System.out.println("num links = " + vector4.size());
                System.out.println("y top = " + dArray[0]);
                if (n3 < n) {
                    System.out.println("y top of next curve = " + ((Edge)objectArray[n3]).getCurve().getYTop());
                } else {
                    System.out.println("no more curves");
                }
                n4 = n2;
                while (n4 < n3) {
                    object = objectArray[n4];
                    System.out.println(object);
                    n6 = ((Edge)object).getEquivalence();
                    if (n6 != 0) {
                        System.out.println("  was equal to " + n6 + "...");
                    }
                    ++n4;
                }
            }
            AreaOp.resolveLinks(vector2, vector3, vector4);
            vector4.clear();
            dArray[0] = d3;
        }
        AreaOp.finalizeSubCurves(vector2, vector3);
        Vector vector5 = new Vector();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            CurveLink curveLink = (CurveLink)enumeration.nextElement();
            vector5.add(curveLink.getMoveto());
            CurveLink curveLink2 = curveLink;
            while ((curveLink2 = curveLink2.getNext()) != null) {
                if (curveLink.absorb(curveLink2)) continue;
                vector5.add(curveLink.getSubCurve());
                curveLink = curveLink2;
            }
            vector5.add(curveLink.getSubCurve());
        }
        return vector5;
    }

    public static void finalizeSubCurves(Vector vector, Vector vector2) {
        int n = vector2.size();
        if (n == 0) {
            return;
        }
        if ((n & 1) != 0) {
            throw new InternalError("Odd number of chains!");
        }
        Object[] objectArray = new ChainEnd[n];
        vector2.toArray(objectArray);
        int n2 = 1;
        while (n2 < n) {
            Object object = objectArray[n2 - 1];
            Object object2 = objectArray[n2];
            CurveLink curveLink = ((ChainEnd)object).linkTo((ChainEnd)object2);
            if (curveLink != null) {
                vector.add(curveLink);
            }
            n2 += 2;
        }
        vector2.clear();
    }

    public static void resolveLinks(Vector vector, Vector vector2, Vector vector3) {
        Object[] objectArray;
        Object[] objectArray2;
        int n = vector3.size();
        if (n == 0) {
            objectArray2 = EmptyLinkList;
        } else {
            if ((n & 1) != 0) {
                throw new InternalError("Odd number of new curves!");
            }
            objectArray2 = new CurveLink[n + 2];
            vector3.toArray(objectArray2);
        }
        int n2 = vector2.size();
        if (n2 == 0) {
            objectArray = EmptyChainList;
        } else {
            if ((n2 & 1) != 0) {
                throw new InternalError("Odd number of chains!");
            }
            objectArray = new ChainEnd[n2 + 2];
            vector2.toArray(objectArray);
        }
        int n3 = 0;
        int n4 = 0;
        vector2.clear();
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        Object object3 = objectArray2[0];
        Object object4 = objectArray2[1];
        while (object != null || object3 != null) {
            boolean bl;
            boolean bl2 = object3 == null;
            boolean bl3 = bl = object == null;
            if (!bl2 && !bl) {
                bl2 = !(n3 & true) && ((ChainEnd)object).getX() == ((ChainEnd)object2).getX();
                boolean bl4 = bl = !(n4 & true) && ((CurveLink)object3).getX() == ((CurveLink)object4).getX();
                if (!bl2 && !bl) {
                    double d = ((ChainEnd)object).getX();
                    double d2 = ((CurveLink)object3).getX();
                    bl2 = object2 != null && d < d2 && AreaOp.obstructs(((ChainEnd)object2).getX(), d2, n3);
                    boolean bl5 = bl = object4 != null && d2 < d && AreaOp.obstructs(((CurveLink)object4).getX(), d, n4);
                }
            }
            if (bl2) {
                CurveLink curveLink = ((ChainEnd)object).linkTo((ChainEnd)object2);
                if (curveLink != null) {
                    vector.add(curveLink);
                }
                object = objectArray[n3 += 2];
                object2 = objectArray[n3 + 1];
            }
            if (bl) {
                ChainEnd chainEnd = new ChainEnd((CurveLink)object3, null);
                ChainEnd chainEnd2 = new ChainEnd((CurveLink)object4, chainEnd);
                chainEnd.setOtherEnd(chainEnd2);
                vector2.add(chainEnd);
                vector2.add(chainEnd2);
                object3 = objectArray2[n4 += 2];
                object4 = objectArray2[n4 + 1];
            }
            if (bl2 || bl) continue;
            ((ChainEnd)object).addLink((CurveLink)object3);
            vector2.add(object);
            object = object2;
            object2 = objectArray[++n3 + 1];
            object3 = object4;
            object4 = objectArray2[++n4 + 1];
        }
        if ((vector2.size() & 1) != 0) {
            System.out.println("Odd number of chains!");
        }
    }

    public static boolean obstructs(double d, double d2, int n) {
        return (n & 1) == 0 ? d <= d2 : d < d2;
    }

    public static class EOWindOp
    extends AreaOp {
        private boolean inside;

        public void newRow() {
            this.inside = false;
        }

        public int classify(Edge edge) {
            boolean bl;
            this.inside = bl = !this.inside;
            return bl ? 1 : -1;
        }

        public int getState() {
            return this.inside ? 1 : -1;
        }
    }

    public static class NZWindOp
    extends AreaOp {
        private int count;

        public void newRow() {
            this.count = 0;
        }

        public int classify(Edge edge) {
            int n = this.count;
            int n2 = n == 0 ? 1 : 0;
            this.count = n += edge.getCurve().getDirection();
            return n == 0 ? -1 : n2;
        }

        public int getState() {
            return this.count == 0 ? -1 : 1;
        }
    }

    public static class XorOp
    extends CAGOp {
        public boolean newClassification(boolean bl, boolean bl2) {
            return bl != bl2;
        }
    }

    public static class IntOp
    extends CAGOp {
        public boolean newClassification(boolean bl, boolean bl2) {
            return bl && bl2;
        }
    }

    public static class SubOp
    extends CAGOp {
        public boolean newClassification(boolean bl, boolean bl2) {
            return bl && !bl2;
        }
    }

    public static class AddOp
    extends CAGOp {
        public boolean newClassification(boolean bl, boolean bl2) {
            return bl || bl2;
        }
    }

    public static abstract class CAGOp
    extends AreaOp {
        boolean inLeft;
        boolean inRight;
        boolean inResult;

        public void newRow() {
            this.inLeft = false;
            this.inRight = false;
            this.inResult = false;
        }

        public int classify(Edge edge) {
            if (edge.getCurveTag() == 0) {
                this.inLeft = !this.inLeft;
            } else {
                this.inRight = !this.inRight;
            }
            boolean bl = this.newClassification(this.inLeft, this.inRight);
            if (this.inResult == bl) {
                return 0;
            }
            this.inResult = bl;
            return bl ? 1 : -1;
        }

        public int getState() {
            return this.inResult ? 1 : -1;
        }

        public abstract boolean newClassification(boolean var1, boolean var2);
    }
}

