/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import sun.awt.windows.WClipboard;
import sun.awt.windows.WDataTransferer;

final class FullyRenderedTransferable
implements Transferable {
    private final HashMap flavorsToData = new HashMap();
    private final DataFlavor[] flavors;
    private static DataFlavor plainTextStringFlavor;

    public FullyRenderedTransferable() {
        WClipboard.openClipboard(null);
        try {
            Object object;
            Object object2;
            Object object3;
            long[] lArray = this.getClipboardFormats();
            boolean bl = false;
            int n = 0;
            while (n < lArray.length) {
                if (lArray[n] == 13L || lArray[n] == 1L && !bl) {
                    try {
                        object3 = this.getClipboardBytes(lArray[n]);
                        if (object3 != null) {
                            object2 = WDataTransferer.getInstance().translateBytes((byte[])object3, plainTextStringFlavor, lArray[n]);
                            object = new DataFactory(lArray[n], (byte[])object3);
                            this.flavorsToData.put(DataFlavor.stringFlavor, object);
                            this.flavorsToData.put(DataFlavor.plainTextFlavor, object);
                            if (lArray[n] == 13L) {
                                bl = true;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        this.flavorsToData.put(DataFlavor.stringFlavor, iOException);
                        this.flavorsToData.put(DataFlavor.plainTextFlavor, iOException);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                ++n;
            }
            object3 = WDataTransferer.getInstance().getFlavorsForFormats(lArray, WClipboard.flavorMap);
            object2 = object3.keySet().iterator();
            while (object2.hasNext()) {
                object = (DataFlavor)object2.next();
                if (this.flavorsToData.containsKey(object)) continue;
                long l = (Long)object3.get(object);
                try {
                    byte[] byArray = this.getClipboardBytes(l);
                    DataFactory dataFactory = new DataFactory(l, byArray);
                    this.flavorsToData.put(object, dataFactory);
                }
                catch (IOException iOException) {
                    this.flavorsToData.put(object, iOException);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            this.flavors = WDataTransferer.getInstance().setToSortedDataFlavorArray(this.flavorsToData.keySet(), (Map)object3);
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            WClipboard.closeClipboard();
            throw throwable;
        }
        WClipboard.closeClipboard();
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.flavorsToData.containsKey(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        Object object = this.flavorsToData.get(dataFlavor);
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        if (object instanceof DataFactory) {
            DataFactory dataFactory = (DataFactory)object;
            if (DataFlavor.stringFlavor.equals(dataFlavor) || DataFlavor.plainTextFlavor.equals(dataFlavor)) {
                object = dataFactory.getTransferData(plainTextStringFlavor);
                if (DataFlavor.plainTextFlavor.equals(dataFlavor) && object instanceof String) {
                    object = new StringReader((String)object);
                }
            } else {
                object = dataFactory.getTransferData(dataFlavor);
            }
        }
        return object;
    }

    private native long[] getClipboardFormats();

    private native byte[] getClipboardBytes(long var1) throws IOException;

    static {
        try {
            plainTextStringFlavor = new DataFlavor("text/plain;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    static class DataFactory {
        final long format;
        final byte[] data;

        DataFactory(long l, byte[] byArray) {
            this.format = l;
            this.data = byArray;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws IOException {
            return WDataTransferer.getInstance().translateBytes(this.data, dataFlavor, this.format);
        }
    }
}

