/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.peer.DialogPeer;
import sun.awt.im.InputMethodManager;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;

class WDialogPeer
extends WWindowPeer
implements DialogPeer {
    static final Color defaultBackground = SystemColor.control;
    boolean needDefaultBackground;
    static boolean NT4;
    boolean setDefaultColourCalled = false;

    WDialogPeer(Dialog dialog) {
        super(dialog);
        InputMethodManager inputMethodManager = InputMethodManager.getInstance();
        String string = inputMethodManager.getTriggerMenuString();
        if (string != null) {
            this.pSetIMMOption(string);
        }
    }

    native void createEx(WComponentPeer var1);

    native void showModal();

    native void endModal();

    public void create(WComponentPeer wComponentPeer) {
        NT4 = true;
        this.createEx(wComponentPeer);
        if (this.setDefaultColourCalled) {
            SystemColor systemColor = NT4 ? SystemColor.control : SystemColor.window;
            ((Dialog)this.target).setBackground(systemColor);
        }
    }

    void initialize() {
        Dialog dialog = (Dialog)this.target;
        if (this.needDefaultBackground) {
            dialog.setBackground(defaultBackground);
        }
        super.initialize();
        if (dialog.getTitle() != null) {
            this.setTitle(dialog.getTitle());
        }
        this.setResizable(dialog.isResizable());
    }

    public void show() {
        Dialog dialog = (Dialog)this.target;
        if (dialog.isModal()) {
            this.showModal();
            WToolkit.getWToolkit().notifyModalityChange(1300);
        } else {
            super.show();
        }
    }

    public void hide() {
        if (((Dialog)this.target).isModal()) {
            WToolkit.getWToolkit().notifyModalityChange(1301);
            this.endModal();
        } else {
            super.hide();
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(WWindowPeer.getSysMinWidth(), WWindowPeer.getSysMinHeight());
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.reshapeFrame(n, n2, n3, n4);
    }

    private void setDefaultColor(boolean bl) {
        this.setDefaultColourCalled = true;
        NT4 = bl;
        this.needDefaultBackground = true;
    }

    native void pSetIMMOption(String var1);

    void notifyIMMOptionChange() {
        InputMethodManager.getInstance().notifyChangeRequest((Component)this.target);
    }
}

