/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.geom.AffineTransform;
import sun.awt.windows.TextRenderingGDI;
import sun.awt.windows.WGraphics;
import sun.awt.windows.WPrintControl;
import sun.awt.windows.WPrintGraphicsWrapper;
import sun.awt.windows.WPrintJob;
import sun.java2d.loops.GraphicsPrimitiveMgr;
import sun.java2d.loops.GraphicsPrimitives;
import sun.java2d.loops.ImageData;
import sun.java2d.loops.RasterOutputManager;

class WPrintGraphics
extends WGraphics
implements PrintGraphics {
    static final String newDevID = "WPrintGraphics";
    private WPrintJob job;
    private int pageNum;
    private boolean hasPageNum;
    boolean drawingText = false;
    boolean drawingScaledImage = false;
    WPrintGraphicsWrapper wrapper;

    WPrintGraphics(WPrintControl wPrintControl, WPrintJob wPrintJob) {
        super(wPrintControl, wPrintJob);
        this.job = wPrintJob;
        this.setColor(Color.black);
        this.setBackground(Color.white);
    }

    WPrintGraphics(long l) {
        super(l);
        this.setForPrinting(true);
        this.setColor(Color.black);
        this.setBackground(Color.white);
    }

    public PrintJob getPrintJob() {
        return this.job;
    }

    public Object clone() {
        WPrintGraphics wPrintGraphics = (WPrintGraphics)super.clone();
        wPrintGraphics.hasPageNum = false;
        wPrintGraphics.pageNum = 0;
        return wPrintGraphics;
    }

    Graphics create(int n) {
        WPrintGraphics wPrintGraphics = (WPrintGraphics)this.create();
        wPrintGraphics.hasPageNum = true;
        wPrintGraphics.pageNum = n;
        return wPrintGraphics;
    }

    public final String getDevID() {
        return newDevID;
    }

    protected void disposeImpl() {
        if (this.hasPageNum && this.job != null) {
            this.job.flushPage(this.pageNum);
        }
        super.disposeImpl();
    }

    public ImageData lock(int n, int n2, int n3, int n4, int n5) {
        ImageData imageData = super.lock(n, n2, n3, n4, n5);
        if (imageData != null) {
            imageData.setResRatio(1.0);
            imageData.setScaleFactorX(1.0);
            imageData.setScaleFactorY(1.0);
            if (this.drawingText) {
                imageData.setOriginX((int)this.transform.getTranslateX());
                imageData.setOriginY((int)this.transform.getTranslateY());
                imageData.setResRatio(this.wrapper.getRatio());
                imageData.setType(0);
            } else if (this.drawingScaledImage) {
                imageData.setScaleFactorX(this.wrapper.getScaleFactorX());
                imageData.setScaleFactorY(this.wrapper.getScaleFactorY());
            }
        }
        return imageData;
    }

    void preScale(double d, double d2) {
        this.transform.preConcatenate(AffineTransform.getScaleInstance(d, d2));
        this.invalidateTransform();
    }

    static {
        RasterOutputManager rasterOutputManager = RasterOutputManager.getManager();
        GraphicsPrimitiveMgr.register((GraphicsPrimitives)new TextRenderingGDI(), newDevID);
    }
}

