/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.Properties;
import sun.awt.windows.WPathGraphics;
import sun.java2d.PeekGraphics;
import sun.java2d.PeekMetrics;
import sun.java2d.RasterPrinterJob;

public class WPrinterJob
extends RasterPrinterJob {
    protected static final int POLYFILL_ALTERNATE = 1;
    protected static final int POLYFILL_WINDING = 2;
    private static final int MAX_WCOLOR = 255;
    private static final String FORCE_PIPE_PROP = "sun.java2d.print.pipeline";
    private static final String FORCE_RASTER = "raster";
    private static final String FORCE_PDL = "pdl";
    private static final String SHAPE_TEXT_PROP = "sun.java2d.print.shapetext";
    private static boolean forcePDL = false;
    private static boolean forceRaster = false;
    static boolean shapeTextProp = false;
    private boolean driverDoesMultipleCopies = true;
    private boolean driverDoesCollation = true;
    private boolean userRequestedCollation = false;
    private long mPrintDC;
    private long mPrintHDevMode;
    private long mPrintHDevNames;
    private int mPrintPaperSize;
    private int mPrintXRes;
    private int mPrintYRes;
    private int mPrintPhysX;
    private int mPrintPhysY;
    private int mPrintWidth;
    private int mPrintHeight;
    private int mPageWidth;
    private int mPageHeight;
    private Color mLastColor;
    private Color mLastTextColor;
    private Font mLastFont;
    private int mLastRotation;

    protected void finalize() {
        this.deleteDC();
    }

    public PageFormat pageDialog(PageFormat pageFormat) {
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        boolean bl = this.pageSetup(pageFormat2, null);
        return bl ? pageFormat2 : pageFormat;
    }

    public boolean printDialog() {
        return this.jobSetup(this.getPageable(), this.checkAllowedToPrintToFile());
    }

    private native void getDefaultPage(PageFormat var1);

    public PageFormat defaultPage(PageFormat pageFormat) {
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        this.getDefaultPage(pageFormat2);
        return pageFormat2;
    }

    protected native void validatePaper(Paper var1, Paper var2);

    protected Graphics2D createPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n) {
        WPathGraphics wPathGraphics;
        PeekMetrics peekMetrics = peekGraphics.getMetrics();
        if (!forcePDL && (forceRaster || peekMetrics.hasNonSolidColors() || peekMetrics.hasCompositing())) {
            wPathGraphics = null;
        } else {
            BufferedImage bufferedImage = new BufferedImage(8, 8, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            wPathGraphics = new WPathGraphics(graphics2D, printerJob, printable, pageFormat, n);
        }
        return wPathGraphics;
    }

    protected double getXRes() {
        return this.mPrintXRes;
    }

    protected double getYRes() {
        return this.mPrintYRes;
    }

    protected double getPhysicalPrintableX(Paper paper) {
        return this.mPrintPhysX;
    }

    protected double getPhysicalPrintableY(Paper paper) {
        return this.mPrintPhysY;
    }

    protected double getPhysicalPrintableWidth(Paper paper) {
        return this.mPrintWidth;
    }

    protected double getPhysicalPrintableHeight(Paper paper) {
        return this.mPrintHeight;
    }

    protected double getPhysicalPageWidth(Paper paper) {
        return this.mPageWidth;
    }

    protected double getPhysicalPageHeight(Paper paper) {
        return this.mPageHeight;
    }

    protected boolean isCollated() {
        return this.userRequestedCollation;
    }

    public int getCollatedCopies() {
        if (this.driverDoesCollation || !this.isCollated()) {
            return 1;
        }
        return this.getCopies();
    }

    public int getNoncollatedCopies() {
        if (this.driverDoesMultipleCopies || this.isCollated()) {
            return 1;
        }
        return this.getCopies();
    }

    protected long getPrintDC() {
        return this.mPrintDC;
    }

    protected void beginPath() {
        this.beginPath(this.mPrintDC);
    }

    protected void endPath() {
        this.endPath(this.mPrintDC);
    }

    protected void closeFigure() {
        this.closeFigure(this.mPrintDC);
    }

    protected void fillPath() {
        this.fillPath(this.mPrintDC);
    }

    protected void moveTo(float f, float f2) {
        this.moveTo(this.mPrintDC, f, f2);
    }

    protected void lineTo(float f, float f2) {
        this.lineTo(this.mPrintDC, f, f2);
    }

    protected void polyBezierTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.polyBezierTo(this.mPrintDC, f, f2, f3, f4, f5, f6);
    }

    protected void setPolyFillMode(int n) {
        this.setPolyFillMode(this.mPrintDC, n);
    }

    protected void selectSolidBrush(Color color) {
        if (!color.equals(this.mLastColor)) {
            this.mLastColor = color;
            float[] fArray = color.getColorComponents(null);
            this.selectSolidBrush(this.mPrintDC, (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
        }
    }

    protected int getPenX() {
        return this.getPenX(this.mPrintDC);
    }

    protected int getPenY() {
        return this.getPenY(this.mPrintDC);
    }

    protected void selectClipPath() {
        this.selectClipPath(this.mPrintDC);
    }

    protected boolean setFont(Font font, int n) {
        boolean bl = true;
        if (!font.equals(this.mLastFont) || n != this.mLastRotation) {
            int n2 = font.getStyle();
            bl = this.setFont(this.mPrintDC, font.getFontName(), font.getSize2D(), (n2 & 1) != 0, (n2 & 2) != 0, n);
            if (bl) {
                this.mLastFont = font;
                this.mLastRotation = n;
            }
        }
        return bl;
    }

    protected void setTextColor(Color color) {
        if (!color.equals(this.mLastTextColor)) {
            this.mLastTextColor = color;
            float[] fArray = color.getColorComponents(null);
            this.setTextColor(this.mPrintDC, (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
        }
    }

    protected void textOut(String string, float f, float f2, Font font) {
        this.textOut(this.mPrintDC, string, f, f2, font);
    }

    protected void drawImage3ByteBGR(byte[] byArray, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.drawImage3ByteBGR(this.mPrintDC, byArray, f, f2, f3, f4, f5, f6, f7, f8);
    }

    protected void startPage(PageFormat pageFormat, Printable printable, int n) {
        this.invalidateCachedState();
        this.deviceStartPage(pageFormat, printable, n);
    }

    protected void endPage(PageFormat pageFormat, Printable printable, int n) {
        this.deviceEndPage(pageFormat, printable, n);
    }

    private void invalidateCachedState() {
        this.mLastColor = null;
        this.mLastTextColor = null;
        this.mLastFont = null;
    }

    public native boolean pageSetup(PageFormat var1, Printable var2);

    private native boolean jobSetup(Pageable var1, boolean var2);

    protected native void initPrinter();

    private native void _startDoc();

    protected void startDoc() {
        this._startDoc();
    }

    protected native void endDoc();

    protected native void abortDoc();

    protected native void deleteDC();

    protected native void deviceStartPage(PageFormat var1, Printable var2, int var3);

    protected native void deviceEndPage(PageFormat var1, Printable var2, int var3);

    protected native void printBand(byte[] var1, int var2, int var3, int var4, int var5);

    protected native void beginPath(long var1);

    protected native void endPath(long var1);

    protected native void closeFigure(long var1);

    protected native void fillPath(long var1);

    protected native void moveTo(long var1, float var3, float var4);

    protected native void lineTo(long var1, float var3, float var4);

    protected native void polyBezierTo(long var1, float var3, float var4, float var5, float var6, float var7, float var8);

    protected native void setPolyFillMode(long var1, int var3);

    protected native void selectSolidBrush(long var1, int var3, int var4, int var5);

    protected native int getPenX(long var1);

    protected native int getPenY(long var1);

    protected native void selectClipPath(long var1);

    protected native boolean setLogicalFont(Font var1, int var2);

    protected native boolean setFont(long var1, String var3, float var4, boolean var5, boolean var6, int var7);

    protected native void setTextColor(long var1, int var3, int var4, int var5);

    protected native void textOut(long var1, String var3, float var4, float var5, Font var6);

    protected native void drawImage3ByteBGR(long var1, byte[] var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11);

    static {
        Toolkit.getDefaultToolkit();
        forcePDL = false;
        forceRaster = false;
        shapeTextProp = false;
        Properties properties = System.getProperties();
        if (properties != null) {
            String string;
            String string2 = properties.getProperty(FORCE_PIPE_PROP);
            if (string2 != null) {
                if (string2.equalsIgnoreCase(FORCE_PDL)) {
                    forcePDL = true;
                } else if (string2.equalsIgnoreCase(FORCE_RASTER)) {
                    forceRaster = true;
                }
            }
            if ((string = properties.getProperty(SHAPE_TEXT_PROP)) != null) {
                shapeTextProp = true;
            }
        }
    }
}

