/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import sun.net.ProgressData;
import sun.net.ProgressEntry;
import sun.net.www.HeaderParser;
import sun.net.www.MessageHeader;
import sun.net.www.http.HttpClient;
import sun.net.www.http.PosterOutputStream;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.BasicAuthentication;
import sun.net.www.protocol.http.DigestAuthentication;
import sun.net.www.protocol.http.EmptyInputStream;
import sun.net.www.protocol.http.Handler;
import sun.net.www.protocol.http.HttpAuthenticator;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    static final String version;
    public static final String userAgent;
    static final int defaultmaxRedirects = 20;
    static final int maxRedirects;
    static final String httpVersion = "HTTP/1.1";
    static final String acceptString = "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
    private static final String[] EXCLUDE_HEADERS;
    protected HttpClient http;
    protected Handler handler;
    protected PrintStream ps = null;
    private static HttpAuthenticator defaultAuth;
    private MessageHeader requests = new MessageHeader();
    protected ProgressEntry pe;
    private MessageHeader responses = new MessageHeader();
    private InputStream inputStream = null;
    private PosterOutputStream poster = null;
    private boolean setRequests = false;
    private boolean failedOnce = false;
    private Exception rememberedException = null;

    private static PasswordAuthentication privilegedRequestPasswordAuthentication(final InetAddress inetAddress, final int n, final String string, final String string2, final String string3) {
        return (PasswordAuthentication)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Authenticator.requestPasswordAuthentication(inetAddress, n, string, string2, string3);
            }
        });
    }

    private void checkMessageHeader(String string, String string2) {
        int n = 10;
        int n2 = string.indexOf(n);
        if (n2 != -1) {
            throw new IllegalArgumentException("Illegal character(s) in message header field: " + string);
        }
        n2 = string2.indexOf(n);
        while (n2 != -1) {
            char c;
            if (++n2 < string2.length() && ((c = string2.charAt(n2)) == ' ' || c == '\t')) {
                n2 = string2.indexOf(n, n2);
                continue;
            }
            throw new IllegalArgumentException("Illegal character(s) in message header value: " + string2);
        }
    }

    private void writeRequests() throws IOException {
        if (!this.setRequests) {
            Object object;
            Cloneable cloneable;
            long l;
            AuthenticationInfo authenticationInfo;
            if (!this.failedOnce) {
                this.requests.prepend(this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
            }
            this.requests.setIfNotSet("User-Agent", userAgent);
            int n = this.url.getPort();
            String string = this.url.getHost();
            if (n != -1 && n != 80) {
                string = string + ":" + String.valueOf(n);
            }
            this.requests.setIfNotSet("Host", string);
            this.requests.setIfNotSet("Accept", acceptString);
            if (!this.failedOnce && this.http.getHttpKeepAliveSet()) {
                if (this.http.usingProxy && !this.method.equals("POST") && !this.method.equals("PUT")) {
                    this.requests.setIfNotSet("Proxy-Connection", "keep-alive");
                } else if (!this.http.usingProxy) {
                    this.requests.setIfNotSet("Connection", "keep-alive");
                }
            } else {
                this.requests.set("Connection", "close");
            }
            if (this.http.usingProxy && (authenticationInfo = AuthenticationInfo.getProxyAuth(this.http.getProxyHostUsed(), this.http.getProxyPortUsed())) != null && authenticationInfo.supportsPreemptiveAuthorization()) {
                this.requests.setIfNotSet(authenticationInfo.getHeaderName(), authenticationInfo.getHeaderValue());
            }
            if ((l = this.getIfModifiedSince()) != 0L) {
                cloneable = new Date(l);
                object = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'");
                ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("GMT"));
                this.requests.setIfNotSet("If-Modified-Since", ((DateFormat)object).format((Date)cloneable));
            }
            if ((cloneable = AuthenticationInfo.getServerAuth(this.url)) != null && ((AuthenticationInfo)cloneable).supportsPreemptiveAuthorization()) {
                this.requests.setIfNotSet(((AuthenticationInfo)cloneable).getHeaderName(), ((AuthenticationInfo)cloneable).getHeaderValue());
            }
            if (this.poster != null) {
                object = this.poster;
                synchronized (object) {
                    this.poster.close();
                    if (!this.method.equals("PUT")) {
                        String string2 = "application/x-www-form-urlencoded";
                        this.requests.setIfNotSet("Content-type", string2);
                    }
                    this.requests.set("Content-length", String.valueOf(this.poster.size()));
                }
            }
            this.setRequests = true;
        }
        this.http.writeRequests(this.requests, this.poster);
        if (this.ps.checkError()) {
            this.disconnect();
            if (this.failedOnce) {
                throw new IOException("Error writing to server");
            }
            this.failedOnce = true;
            this.http = this.getNewClient(this.url);
            this.ps = (PrintStream)this.http.getOutputStream();
            this.connected = true;
            this.responses = new MessageHeader();
            this.setRequests = false;
            this.writeRequests();
        }
    }

    protected HttpClient getNewClient(URL uRL) throws IOException {
        return new HttpClient(uRL, null, -1);
    }

    protected HttpClient getProxiedClient(URL uRL, String string, int n) throws IOException {
        return new HttpClient(uRL, string, n);
    }

    protected HttpURLConnection(URL uRL, Handler handler) throws IOException {
        super(uRL);
        this.handler = handler;
    }

    public HttpURLConnection(URL uRL, String string, int n) throws IOException {
        this(uRL, new Handler(string, n));
    }

    public static void setDefaultAuthenticator(HttpAuthenticator httpAuthenticator) {
        defaultAuth = httpAuthenticator;
    }

    public static InputStream openConnectionCheckRedirects(URLConnection uRLConnection) throws IOException {
        boolean bl;
        int n = 0;
        InputStream inputStream = null;
        do {
            HttpURLConnection httpURLConnection;
            int n2;
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(false);
            }
            inputStream = uRLConnection.getInputStream();
            bl = false;
            if (!(uRLConnection instanceof HttpURLConnection) || (n2 = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode()) < 300 || n2 > 305 || n2 == 304) continue;
            URL uRL = httpURLConnection.getURL();
            String string = httpURLConnection.getHeaderField("Location");
            URL uRL2 = null;
            if (string != null) {
                uRL2 = new URL(uRL, string);
            }
            httpURLConnection.disconnect();
            if (uRL2 == null || !uRL.getProtocol().equals(uRL2.getProtocol()) || uRL.getPort() != uRL2.getPort() || !HttpURLConnection.hostsEqual(uRL, uRL2) || n >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            bl = true;
            uRLConnection = uRL2.openConnection();
            ++n;
        } while (bl);
        return inputStream;
    }

    private static boolean hostsEqual(URL uRL, URL uRL2) {
        final String string = uRL.getHost();
        final String string2 = uRL2.getHost();
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        final boolean[] blArray = new boolean[]{false};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    InetAddress inetAddress2 = InetAddress.getByName(string2);
                    blArray[0] = inetAddress.equals(inetAddress2);
                }
                catch (UnknownHostException unknownHostException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return null;
            }
        });
        return blArray[0];
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.http = "http".equals(this.url.getProtocol()) && !this.failedOnce ? HttpClient.New(this.url) : new HttpClient(this.url, this.handler.proxy, this.handler.proxyPort);
        this.ps = (PrintStream)this.http.getOutputStream();
        this.connected = true;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        try {
            if (!this.doOutput) {
                throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
            }
            if (this.method.equals("GET")) {
                this.setRequestMethod("POST");
            }
            if (!"POST".equals(this.method) && !"PUT".equals(this.method) && "http".equals(this.url.getProtocol())) {
                throw new ProtocolException("HTTP method " + this.method + " doesn't support output");
            }
            if (this.inputStream != null) {
                throw new ProtocolException("Cannot write output after reading input.");
            }
            this.connect();
            this.ps = (PrintStream)this.http.getOutputStream();
            if (this.poster == null) {
                this.poster = new PosterOutputStream();
            }
            return this.poster;
        }
        catch (RuntimeException runtimeException) {
            this.disconnect();
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Cannot read from URLConnection if doInput=false (call setDoInput(true))");
        }
        if (this.inputStream != null && !this.connected && this.rememberedException != null) {
            if (this.rememberedException instanceof RuntimeException) {
                throw (RuntimeException)this.rememberedException;
            }
            throw (IOException)this.rememberedException;
        }
        if (this.inputStream != null) {
            return this.inputStream;
        }
        int n = 0;
        AuthenticationInfo authenticationInfo = null;
        AuthenticationInfo authenticationInfo2 = null;
        try {
            do {
                String string;
                this.pe = new ProgressEntry(this.url.getFile(), null);
                ProgressData.pdata.register(this.pe);
                this.connect();
                this.ps = (PrintStream)this.http.getOutputStream();
                this.writeRequests();
                this.http.parseHTTP(this.responses, this.pe);
                this.inputStream = this.http.getInputStream();
                int n2 = this.getResponseCode();
                if (n2 == 407) {
                    if (authenticationInfo2 != null) {
                        authenticationInfo2.removeFromCache();
                    }
                    if ((authenticationInfo2 = this.getHttpProxyAuthentication()) != null) {
                        this.disconnect();
                        ++n;
                        continue;
                    }
                }
                if (n2 == 401) {
                    if (authenticationInfo != null) {
                        authenticationInfo.removeFromCache();
                    }
                    if ((authenticationInfo = this.getServerAuthentication()) != null) {
                        this.disconnect();
                        ++n;
                        continue;
                    }
                }
                if (n2 == 200 || n2 >= 300 && n2 <= 305) {
                    if (authenticationInfo2 != null) {
                        authenticationInfo2.addToCache();
                    }
                    if (authenticationInfo != null) {
                        if (!(authenticationInfo instanceof DigestAuthentication) && authenticationInfo instanceof BasicAuthentication) {
                            BasicAuthentication basicAuthentication;
                            String string2 = null;
                            try {
                                string2 = new URL(this.url, "./").getPath();
                            }
                            catch (MalformedURLException malformedURLException) {
                                System.err.println("Exception : " + malformedURLException);
                                malformedURLException.printStackTrace();
                            }
                            string = authenticationInfo.path;
                            if (string.startsWith(string2) && string2.length() < string.length()) {
                                basicAuthentication = (BasicAuthentication)authenticationInfo.clone();
                                authenticationInfo.removeFromCache();
                                basicAuthentication.path = string2;
                                authenticationInfo = basicAuthentication;
                            } else {
                                basicAuthentication = (BasicAuthentication)authenticationInfo.clone();
                                basicAuthentication.path = basicAuthentication.getRootPath(string2);
                                authenticationInfo.removeFromCache();
                                authenticationInfo = basicAuthentication;
                            }
                        }
                        authenticationInfo.addToCache();
                    }
                }
                if (this.followRedirect()) {
                    ++n;
                    continue;
                }
                int n3 = -1;
                try {
                    n3 = Integer.parseInt(this.responses.findValue("content-length"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.method.equals("HEAD") || this.method.equals("TRACE") || n3 == 0) {
                    this.disconnect();
                    this.inputStream = new EmptyInputStream();
                    return this.inputStream;
                }
                string = this.url.getFile();
                if (!(n2 < 400 || string == null || string.endsWith(".html") || string.endsWith(".htm") || string.endsWith("/") || string.endsWith(".txt"))) {
                    throw new FileNotFoundException(this.url.toString());
                }
                return this.inputStream;
            } while (n < maxRedirects);
            throw new ProtocolException("Server redirected too many times (" + n + ")");
        }
        catch (RuntimeException runtimeException) {
            this.disconnect();
            this.rememberedException = runtimeException;
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.disconnect();
            this.rememberedException = iOException;
            throw iOException;
        }
    }

    private AuthenticationInfo getHttpProxyAuthentication() {
        AuthenticationInfo authenticationInfo = null;
        String string = this.getHeaderField("Proxy-authenticate");
        String string2 = this.http.getProxyHostUsed();
        int n = this.http.getProxyPortUsed();
        if (string2 != null && string != null) {
            Object object;
            Serializable serializable;
            String string3;
            char c;
            HeaderParser headerParser = new HeaderParser(string);
            String string4 = headerParser.findValue("realm");
            authenticationInfo = AuthenticationInfo.getProxyAuth(string2, n, string4, c = "basic".equalsIgnoreCase(string3 = headerParser.findKey(0)) ? (char)'B' : ("digest".equalsIgnoreCase(string3) ? (char)'D' : '\u0000'));
            if (authenticationInfo == null && c == 'B') {
                serializable = null;
                try {
                    serializable = InetAddress.getByName(string2);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                object = HttpURLConnection.privilegedRequestPasswordAuthentication(serializable, n, "http", string4, string3);
                if (object != null) {
                    authenticationInfo = new BasicAuthentication(true, string2, n, string4, (PasswordAuthentication)object);
                }
            }
            if (authenticationInfo == null && defaultAuth != null && defaultAuth.schemeSupported(string3)) {
                try {
                    serializable = new URL("http", string2, n, "/");
                    object = defaultAuth.authString((URL)serializable, string3, string4);
                    if (object != null) {
                        authenticationInfo = new BasicAuthentication(true, string2, n, string4, (String)object);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (authenticationInfo != null && !authenticationInfo.setHeaders(this, headerParser)) {
                authenticationInfo = null;
            }
        }
        return authenticationInfo;
    }

    private AuthenticationInfo getServerAuthentication() {
        AuthenticationInfo authenticationInfo = null;
        String string = this.getHeaderField("WWW-Authenticate");
        if (string != null) {
            Object object;
            int n;
            HeaderParser headerParser = new HeaderParser(string);
            String string2 = headerParser.findValue("realm");
            String string3 = headerParser.findKey(0);
            char c = "basic".equalsIgnoreCase(string3) ? (char)'B' : ("digest".equalsIgnoreCase(string3) ? (char)'D' : '\u0000');
            authenticationInfo = AuthenticationInfo.getServerAuth(this.url, string2, c);
            InetAddress inetAddress = null;
            if (authenticationInfo == null) {
                try {
                    inetAddress = InetAddress.getByName(this.url.getHost());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if ((n = this.url.getPort()) == -1) {
                if (this.url.getProtocol().toLowerCase().equals("http")) {
                    n = 80;
                } else if (this.url.getProtocol().toLowerCase().equals("https")) {
                    n = 443;
                }
            }
            if (authenticationInfo == null && c == 'B' && (object = HttpURLConnection.privilegedRequestPasswordAuthentication(inetAddress, this.url.getPort(), this.url.getProtocol(), string2, string3)) != null) {
                authenticationInfo = new BasicAuthentication(false, this.url, string2, (PasswordAuthentication)object);
            }
            if (authenticationInfo == null && c == 'D' && (object = HttpURLConnection.privilegedRequestPasswordAuthentication(inetAddress, this.url.getPort(), this.url.getProtocol(), string2, string3)) != null) {
                authenticationInfo = new DigestAuthentication(this.url, string2, string3, (PasswordAuthentication)object);
            }
            if (authenticationInfo == null && defaultAuth != null && defaultAuth.schemeSupported(string3) && (object = defaultAuth.authString(this.url, string3, string2)) != null) {
                authenticationInfo = new BasicAuthentication(false, this.url, string2, (String)object);
            }
            if (authenticationInfo != null && !authenticationInfo.setHeaders(this, headerParser)) {
                authenticationInfo = null;
            }
        }
        return authenticationInfo;
    }

    private boolean followRedirect() throws IOException {
        if (!this.getInstanceFollowRedirects()) {
            return false;
        }
        int n = this.getResponseCode();
        if (n < 300 || n > 305 || n == 304) {
            return false;
        }
        String string = this.getHeaderField("Location");
        if (string == null) {
            return false;
        }
        this.disconnect();
        this.responses = new MessageHeader();
        if (n == 305) {
            URL uRL = new URL(string);
            this.http = this.getProxiedClient(this.url, uRL.getHost(), uRL.getPort());
            this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
            this.connected = true;
        } else {
            this.url = new URL(this.url, string);
            if (this.method.equals("POST") && !Boolean.getBoolean("http.strictPostRedirect")) {
                this.requests = new MessageHeader();
                this.setRequests = false;
                this.setRequestMethod("GET");
                this.poster = null;
                this.connect();
            } else {
                this.connect();
                this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
                this.requests.set("Host", this.url.getHost() + (this.url.getPort() == -1 || this.url.getPort() == 80 ? "" : ":" + String.valueOf(this.url.getPort())));
            }
        }
        return true;
    }

    public void disconnect() {
        this.responseCode = -1;
        if (this.pe != null) {
            ProgressData.pdata.unregister(this.pe);
        }
        if (this.http != null) {
            this.http.closeServer();
            this.http = null;
            this.connected = false;
        }
    }

    public boolean usingProxy() {
        if (this.http != null) {
            return this.http.usingProxy;
        }
        return false;
    }

    public String getHeaderField(String string) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.findValue(string);
    }

    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.getValue(n);
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.getKey(n);
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        this.checkMessageHeader(string, string2);
        this.requests.set(string, string2);
    }

    void setAuthenticationProperty(String string, String string2) {
        this.checkMessageHeader(string, string2);
        this.requests.set(string, string2);
    }

    public String getRequestProperty(String string) {
        if (string != null) {
            int n = 0;
            while (n < EXCLUDE_HEADERS.length) {
                if (string.equalsIgnoreCase(EXCLUDE_HEADERS[n])) {
                    return null;
                }
                ++n;
            }
        }
        return this.requests.findValue(string);
    }

    public void finalize() {
    }

    String getMethod() {
        return this.method;
    }

    static {
        maxRedirects = (Integer)AccessController.doPrivileged(new GetIntegerAction("http.maxRedirects", 20));
        version = (String)AccessController.doPrivileged(new GetPropertyAction("java.version"));
        userAgent = (String)AccessController.doPrivileged(new GetPropertyAction("http.agent", "Java" + version));
        EXCLUDE_HEADERS = new String[]{"Proxy-Authorization", "Authorization"};
    }
}

