/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.LogStream;
import java.rmi.server.RMIFailureHandler;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UID;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Vector;
import java.util.WeakHashMap;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCAckHandler;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.RMIThreadAction;
import sun.rmi.transport.StreamRemoteCall;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.proxy.HttpReceiveSocket;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPConnection;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class TCPTransport
extends Transport
implements Runnable {
    static int logLevel = LogStream.parseLevel(TCPTransport.getLogLevel());
    static String disableThreadPooling = (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.tcp.noConnectionPool"));
    private static int threadNum = 0;
    private static ThreadLocal threadConnectionHandler = new ThreadLocal();
    private TCPEndpoint endpoint;
    private ServerSocket server = null;
    private Hashtable channelTable = new Hashtable();
    private Vector pool = new Vector();
    private static int startThreadNum = 0;
    static RMISocketFactory defaultSocketFactory = RMISocketFactory.getDefaultSocketFactory();
    private static final int connectionReadTimeout = (Integer)AccessController.doPrivileged(new GetIntegerAction("sun.rmi.transport.tcp.readTimeout", 0x6DDD00));
    private transient long acceptFailureTime = 0L;
    private transient int acceptFailureCount;

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.tcp.logLevel"));
    }

    TCPTransport(TCPEndpoint tCPEndpoint) {
        if (logLevel >= 10) {
            LogStream.log("tcp").println("TCPTransport.<init>: Version = 2, ep = " + tCPEndpoint);
        }
        this.endpoint = tCPEndpoint;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shedConnectionCaches() {
        int n;
        TCPChannel[] tCPChannelArray;
        Hashtable hashtable = this.channelTable;
        synchronized (hashtable) {
            tCPChannelArray = new TCPChannel[this.channelTable.size()];
            Enumeration enumeration = this.channelTable.elements();
            n = 0;
            while (enumeration.hasMoreElements()) {
                tCPChannelArray[n] = (TCPChannel)enumeration.nextElement();
                ++n;
            }
        }
        while (--n >= 0) {
            tCPChannelArray[n].shedCache();
        }
    }

    public Channel getChannel(Endpoint endpoint) {
        Channel channel = null;
        if (endpoint instanceof TCPEndpoint) {
            Hashtable hashtable = this.channelTable;
            synchronized (hashtable) {
                channel = (Channel)this.channelTable.get(endpoint);
                if (channel == null) {
                    channel = new TCPChannel(this, (TCPEndpoint)endpoint);
                    this.channelTable.put(endpoint, channel);
                }
            }
        }
        return channel;
    }

    public void free(Endpoint endpoint) {
        if (endpoint instanceof TCPEndpoint) {
            Hashtable hashtable = this.channelTable;
            synchronized (hashtable) {
                TCPChannel tCPChannel = (TCPChannel)this.channelTable.remove(endpoint);
                if (tCPChannel != null) {
                    tCPChannel.shedCache();
                }
            }
        }
    }

    public Endpoint thisEndpoint() {
        return this.endpoint;
    }

    public void exportObject(Target target) throws RemoteException {
        this.listen();
        target.setExportedEndpoint(this.endpoint);
        super.exportObject(target);
    }

    protected void checkAcceptPermission(AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        ConnectionHandler connectionHandler = (ConnectionHandler)threadConnectionHandler.get();
        if (connectionHandler == null) {
            throw new Error("checkAcceptPermission not in ConnectionHandler thread");
        }
        connectionHandler.checkAcceptPermission(securityManager, accessControlContext);
    }

    private synchronized void listen() throws RemoteException {
        int n = this.endpoint.getPort();
        if (this.server == null) {
            if (logLevel >= 10) {
                LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").listen: " + "create socket, port = " + n);
            }
            try {
                this.server = this.endpoint.newServerSocket();
                this.newListener();
            }
            catch (BindException bindException) {
                throw new ExportException("Port already in use: " + n, bindException);
            }
            catch (IOException iOException) {
                throw new ExportException("Listen failed on port: " + n, iOException);
            }
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(n);
            }
        }
    }

    private void newListener() {
        Thread thread = (Thread)AccessController.doPrivileged(new RMIThreadAction(this, "TCP Accept-" + ++threadNum, true));
        thread.start();
    }

    private synchronized boolean continueAfterAcceptFailure(Throwable throwable) {
        boolean bl;
        RMIFailureHandler rMIFailureHandler = RMISocketFactory.getFailureHandler();
        if (rMIFailureHandler != null) {
            bl = throwable instanceof Exception ? rMIFailureHandler.failure((Exception)throwable) : rMIFailureHandler.failure(new InvocationTargetException(throwable));
        } else {
            long l = System.currentTimeMillis();
            if (this.acceptFailureTime == 0L || l - this.acceptFailureTime > 5000L) {
                this.acceptFailureTime = l;
                this.acceptFailureCount = 0;
            } else {
                ++this.acceptFailureCount;
                if (this.acceptFailureCount >= 10) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        if (logLevel >= 10) {
            LogStream.log("tcp").println("TCPTransport.run: listening on port " + this.endpoint.getPort());
        }
        ServerSocket serverSocket;
        while ((serverSocket = this.server) != null) {
            Exception exception2;
            OutOfMemoryError outOfMemoryError2;
            Object var8_14;
            Throwable throwable = null;
            try {
                block31: {
                    String string;
                    Socket socket = serverSocket.accept();
                    InetAddress inetAddress = socket.getInetAddress();
                    String string2 = string = inetAddress != null ? inetAddress.getHostAddress() : "0.0.0.0";
                    if (disableThreadPooling != null) {
                        Thread thread = (Thread)AccessController.doPrivileged(new RMIThreadAction(new ConnectionHandler(socket, string), "TCP Connection(" + ++threadNum + ")-" + string, true, true));
                        thread.start();
                        break block31;
                    }
                    this.handleConnection(socket, string);
                }
                var8_14 = null;
                if (throwable == null) continue;
            }
            catch (Throwable throwable2) {
                var8_14 = null;
                if (throwable == null) throw throwable2;
                if (!(throwable instanceof SecurityException)) {
                    try {
                        TCPEndpoint.shedConnectionCaches();
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                if (throwable instanceof IOException || throwable instanceof OutOfMemoryError || throwable instanceof NoClassDefFoundError || throwable instanceof MissingResourceException || throwable instanceof SecurityException) {
                    if (this.continueAfterAcceptFailure(throwable)) throw throwable2;
                    return;
                }
                if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
                throw (RuntimeException)throwable;
            }
            if (!(throwable instanceof SecurityException)) {
                try {
                    TCPEndpoint.shedConnectionCaches();
                }
                catch (OutOfMemoryError outOfMemoryError2) {
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (throwable instanceof IOException || throwable instanceof OutOfMemoryError || throwable instanceof NoClassDefFoundError || throwable instanceof MissingResourceException || throwable instanceof SecurityException) {
                if (this.continueAfterAcceptFailure(throwable)) continue;
                return;
            }
            if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
            throw (RuntimeException)throwable;
            {
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    var8_14 = null;
                    if (iOException2 == null) continue;
                    if (!(iOException2 instanceof SecurityException)) {
                        try {
                            TCPEndpoint.shedConnectionCaches();
                        }
                        catch (OutOfMemoryError outOfMemoryError2) {
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    if (iOException2 instanceof IOException || iOException2 instanceof OutOfMemoryError || iOException2 instanceof NoClassDefFoundError || iOException2 instanceof MissingResourceException || iOException2 instanceof SecurityException) {
                        if (this.continueAfterAcceptFailure(iOException2)) continue;
                        return;
                    }
                    if (!(iOException2 instanceof RuntimeException)) throw (Error)((Object)iOException2);
                    throw (RuntimeException)((Object)iOException2);
                }
                catch (RuntimeException runtimeException) {
                    RuntimeException runtimeException2 = runtimeException;
                    var8_14 = null;
                    if (runtimeException2 == null) continue;
                    if (!(runtimeException2 instanceof SecurityException)) {
                        try {
                            TCPEndpoint.shedConnectionCaches();
                        }
                        catch (OutOfMemoryError outOfMemoryError2) {
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    if (runtimeException2 instanceof IOException || runtimeException2 instanceof OutOfMemoryError || runtimeException2 instanceof NoClassDefFoundError || runtimeException2 instanceof MissingResourceException || runtimeException2 instanceof SecurityException) {
                        if (this.continueAfterAcceptFailure(runtimeException2)) continue;
                        return;
                    }
                    if (!(runtimeException2 instanceof RuntimeException)) throw (Error)((Object)runtimeException2);
                    throw runtimeException2;
                }
                catch (Error error) {
                    Error error2 = error;
                    var8_14 = null;
                    if (error2 == null) continue;
                    if (!(error2 instanceof SecurityException)) {
                        try {
                            TCPEndpoint.shedConnectionCaches();
                        }
                        catch (OutOfMemoryError outOfMemoryError2) {
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    if (error2 instanceof IOException || error2 instanceof OutOfMemoryError || error2 instanceof NoClassDefFoundError || error2 instanceof MissingResourceException || error2 instanceof SecurityException) {
                        if (!this.continueAfterAcceptFailure(error2)) return;
                        continue;
                    }
                    if (!(error2 instanceof RuntimeException)) throw error2;
                    throw (RuntimeException)((Object)error2);
                }
            }
            break;
        }
        return;
    }

    private static void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleMessages(Connection var1_1, boolean var2_2) {
        block20: {
            block21: {
                try {
                    try {
                        var3_3 = new DataInputStream(var1_1.getInputStream());
                        block14: do {
                            if ((var4_5 = var3_3.read()) == -1) {
                                if (TCPTransport.logLevel >= 10) {
                                    LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").handleMessages: connection closed");
                                }
                                break block20;
                            }
                            if (TCPTransport.logLevel >= 10) {
                                LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").handleMessages: op = " + var4_5);
                            }
                            switch (var4_5) {
                                case 80: {
                                    var5_7 = new StreamRemoteCall(var1_1);
                                    if (this.serviceCall(var5_7)) continue block14;
                                    var8_9 = null;
                                    break block21;
                                }
                                case 82: {
                                    var6_8 = new DataOutputStream(var1_1.getOutputStream());
                                    var6_8.writeByte(83);
                                    var1_1.releaseOutputStream();
                                    break;
                                }
                                case 84: {
                                    DGCAckHandler.received(UID.read(var3_3));
                                    break;
                                }
                                default: {
                                    throw new IOException("unknown transport op " + var4_5);
                                }
                            }
                        } while (var2_2);
                        break block20;
                    }
                    catch (IOException var3_4) {
                        if (TCPTransport.logLevel >= 10) {
                            var4_6 = LogStream.log("tcp");
                            var4_6.println("TCPTransport(" + this.endpoint.getPort() + ").handleMessages: exception: ");
                            var3_4.printStackTrace(var4_6);
                        }
                        var8_11 = null;
                        try {
                            var1_1.close();
                            return;
                        }
                        catch (IOException var9_15) {
                            return;
                        }
                    }
                }
                catch (Throwable var7_17) {
                    var8_12 = null;
                    ** try [egrp 2[TRYBLOCK] [2 : 339->348)] { 
lbl46:
                    // 1 sources

                    var1_1.close();
                    throw var7_17;
lbl48:
                    // 1 sources

                    catch (IOException var9_16) {
                        // empty catch block
                    }
                    throw var7_17;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 339->348)] { 
lbl53:
            // 1 sources

            var1_1.close();
            return;
lbl55:
            // 1 sources

            catch (IOException var9_13) {
                // empty catch block
            }
            return;
        }
        var8_10 = null;
        try {}
        catch (IOException var9_14) {}
        var1_1.close();
        return;
    }

    public static String getClientHost() throws ServerNotActiveException {
        ConnectionHandler connectionHandler = (ConnectionHandler)threadConnectionHandler.get();
        if (connectionHandler != null) {
            return connectionHandler.getClientHost();
        }
        throw new ServerNotActiveException("not in a remote call");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    ConnectionHandler getHandler() {
        ConnectionHandler connectionHandler = null;
        Vector vector = this.pool;
        // MONITORENTER : vector
        if (this.pool.size() > 0) {
            connectionHandler = (ConnectionHandler)this.pool.lastElement();
            this.pool.removeElementAt(this.pool.size() - 1);
        }
        // MONITOREXIT : vector
        if (connectionHandler != null) {
            if (logLevel < 10) return connectionHandler;
            LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").run: reusing a connection thread from pool");
            return connectionHandler;
        }
        if (logLevel >= 10) {
            LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").run: creating a new connection thread");
        }
        connectionHandler = new ConnectionHandler();
        Thread thread = (Thread)AccessController.doPrivileged(new RMIThreadAction(connectionHandler, String.valueOf(++startThreadNum), true, true));
        thread.start();
        Thread thread2 = thread;
        // MONITORENTER : thread2
        while (!connectionHandler.threadStarted) {
            try {
                thread.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        // MONITOREXIT : thread2
        return connectionHandler;
    }

    void handleConnection(Socket socket, String string) {
        ConnectionHandler connectionHandler;
        ConnectionHandler connectionHandler2 = connectionHandler = this.getHandler();
        synchronized (connectionHandler2) {
            connectionHandler.initThread(socket, string);
            connectionHandler.notify();
        }
    }

    static /* synthetic */ ThreadLocal access$200() {
        return threadConnectionHandler;
    }

    static /* synthetic */ int access$300() {
        return connectionReadTimeout;
    }

    static /* synthetic */ void access$400(Socket socket) {
        TCPTransport.closeSocket(socket);
    }

    static /* synthetic */ TCPEndpoint access$500(TCPTransport tCPTransport) {
        return tCPTransport.endpoint;
    }

    static /* synthetic */ Hashtable access$600(TCPTransport tCPTransport) {
        return tCPTransport.channelTable;
    }

    static /* synthetic */ Vector access$700(TCPTransport tCPTransport) {
        return tCPTransport.pool;
    }

    private class ConnectionHandler
    implements Runnable {
        private static final int POST = 1347375956;
        private AccessControlContext okContext;
        private WeakHashMap authCache;
        private SecurityManager cacheSecurityManager = null;
        private Socket socket;
        private String remoteHost;
        private boolean threadStarted = false;
        String name;

        ConnectionHandler(Socket socket, String string) {
            this.socket = socket;
            this.remoteHost = string;
        }

        ConnectionHandler() {
        }

        void initThread(Socket socket, String string) {
            this.socket = socket;
            this.remoteHost = string;
            this.name = "TCP Connection(" + ++threadNum + ")-" + string;
        }

        String getClientHost() {
            return this.remoteHost;
        }

        void checkAcceptPermission(SecurityManager securityManager, AccessControlContext accessControlContext) {
            if (securityManager != this.cacheSecurityManager) {
                this.okContext = null;
                this.authCache = new WeakHashMap();
                this.cacheSecurityManager = securityManager;
            }
            if (accessControlContext.equals(this.okContext) || this.authCache.containsKey(accessControlContext)) {
                return;
            }
            InetAddress inetAddress = this.socket.getInetAddress();
            String string = inetAddress != null ? inetAddress.getHostAddress() : "*";
            securityManager.checkAccept(string, this.socket.getPort());
            this.authCache.put(accessControlContext, new SoftReference(accessControlContext));
            this.okContext = accessControlContext;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void handleRequest() {
            block35: {
                block34: {
                    TCPTransport.access$200().set(this);
                    try {
                        this.socket.setTcpNoDelay(true);
                    }
                    catch (Exception var1_1) {
                        // empty catch block
                    }
                    try {
                        if (TCPTransport.access$300() > 0) {
                            this.socket.setSoTimeout(TCPTransport.access$300());
                        }
                    }
                    catch (Exception var1_2) {
                        // empty catch block
                    }
                    try {
                        try {
                            var1_3 = this.socket.getInputStream();
                            var2_5 = var1_3.markSupported() != false ? var1_3 : new BufferedInputStream(var1_3);
                            var2_5.mark(4);
                            var3_7 = new DataInputStream(var2_5);
                            var4_8 = var3_7.readInt();
                            if (var4_8 == 1347375956) {
                                if (TCPTransport.logLevel >= 10) {
                                    LogStream.log("tcp").println("TCPTransport.run: decoding HTTP-wrapped call");
                                }
                                var2_5.reset();
                                try {
                                    this.socket = new HttpReceiveSocket(this.socket, var2_5, null);
                                    this.remoteHost = "0.0.0.0";
                                    var1_3 = this.socket.getInputStream();
                                    var2_5 = new BufferedInputStream(var1_3);
                                    var3_7 = new DataInputStream(var2_5);
                                    var4_8 = var3_7.readInt();
                                }
                                catch (IOException var5_9) {
                                    throw new RemoteException("Error HTTP-unwrapping call", var5_9);
                                }
                            }
                            var5_10 = var3_7.readShort();
                            if (var4_8 != 1246907721 || var5_10 != 2) {
                                TCPTransport.access$400(this.socket);
                                var20_11 = null;
                                break block34;
                            }
                            var6_19 = this.socket.getOutputStream();
                            var7_20 = new BufferedOutputStream(var6_19);
                            var8_21 = new DataOutputStream(var7_20);
                            var9_22 = this.socket.getPort();
                            if (TCPTransport.logLevel >= 10) {
                                LogStream.log("tcp").println("TCPTransport.run: accepted socket from [" + this.remoteHost + ":" + var9_22 + "]");
                            }
                            var13_23 = var3_7.readByte();
                            switch (var13_23) {
                                case 76: {
                                    var10_24 = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), TCPTransport.access$500(TCPTransport.this).getClientSocketFactory(), TCPTransport.access$500(TCPTransport.this).getServerSocketFactory());
                                    var11_27 = new TCPChannel(TCPTransport.this, var10_24);
                                    var12_30 = new TCPConnection(var11_27, this.socket, var2_5, var7_20);
                                    TCPTransport.this.handleMessages(var12_30, false);
                                    ** break;
                                }
                                case 75: {
                                    var8_21.writeByte(78);
                                    if (TCPTransport.logLevel >= 20) {
                                        LogStream.log("tcp").println("TCPTransport(" + TCPTransport.access$500(TCPTransport.this).getPort() + ").run: " + "suggesting " + this.remoteHost + ":" + var9_22);
                                    }
                                    var8_21.writeUTF(this.remoteHost);
                                    var8_21.writeInt(var9_22);
                                    var8_21.flush();
                                    var14_32 = var3_7.readUTF();
                                    var15_33 = var3_7.readInt();
                                    if (TCPTransport.logLevel >= 20) {
                                        LogStream.log("tcp").println("TCPTransport(" + TCPTransport.access$500(TCPTransport.this).getPort() + ").run: " + "client using " + var14_32 + ":" + var15_33);
                                    }
                                    var10_25 = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), TCPTransport.access$500(TCPTransport.this).getClientSocketFactory(), TCPTransport.access$500(TCPTransport.this).getServerSocketFactory());
                                    var11_28 = new TCPChannel(TCPTransport.this, var10_25);
                                    var12_31 = new TCPConnection(var11_28, this.socket, var2_5, var7_20);
                                    TCPTransport.this.handleMessages(var12_31, true);
                                    ** break;
                                }
                                case 77: {
                                    if (TCPTransport.logLevel >= 20) {
                                        LogStream.log("tcp").println("TCPTransport(" + TCPTransport.access$500(TCPTransport.this).getPort() + ").run: " + "accepting multiplex protocol");
                                    }
                                    var8_21.writeByte(78);
                                    if (TCPTransport.logLevel >= 20) {
                                        LogStream.log("tcp").println("TCPTransport(" + TCPTransport.access$500(TCPTransport.this).getPort() + ").run: " + "suggesting " + this.remoteHost + ":" + var9_22);
                                    }
                                    var8_21.writeUTF(this.remoteHost);
                                    var8_21.writeInt(var9_22);
                                    var8_21.flush();
                                    var10_26 = new TCPEndpoint(var3_7.readUTF(), var3_7.readInt(), TCPTransport.access$500(TCPTransport.this).getClientSocketFactory(), TCPTransport.access$500(TCPTransport.this).getServerSocketFactory());
                                    if (TCPTransport.logLevel >= 20) {
                                        LogStream.log("tcp").println("TCPTransport(" + TCPTransport.access$500(TCPTransport.this).getPort() + ").run: " + "client using " + var10_26.getHost() + ":" + var10_26.getPort());
                                    }
                                    var17_34 = TCPTransport.access$600(TCPTransport.this);
                                    synchronized (var17_34) {
                                        var11_29 = (TCPChannel)TCPTransport.this.getChannel(var10_26);
                                        var16_35 = new ConnectionMultiplexer(var11_29, var2_5, var6_19, false);
                                        var11_29.useMultiplexer(var16_35);
                                    }
                                    var16_35.run();
                                    ** break;
                                }
                            }
                            var8_21.writeByte(79);
                            var8_21.flush();
                            break block35;
                        }
                        catch (IOException var1_4) {
                            if (TCPTransport.logLevel >= 10) {
                                var2_6 = LogStream.log("tcp");
                                var2_6.println("TCPTransport.run: terminated with exception:");
                                var1_4.printStackTrace(var2_6);
                            }
                            var20_13 = null;
                            TCPTransport.access$400(this.socket);
                            if (TCPTransport.disableThreadPooling != null) return;
                            this.socket = null;
                            TCPTransport.access$200().set(null);
                            var21_17 = TCPTransport.access$700(TCPTransport.this);
                            synchronized (var21_17) {
                                TCPTransport.access$700(TCPTransport.this).addElement(this);
                                return;
                            }
                        }
                    }
                    catch (Throwable var19_36) {
                        var20_14 = null;
                        TCPTransport.access$400(this.socket);
                        if (TCPTransport.disableThreadPooling != null) throw var19_36;
                        this.socket = null;
                        TCPTransport.access$200().set(null);
                        var21_18 = TCPTransport.access$700(TCPTransport.this);
                        synchronized (var21_18) {
                            TCPTransport.access$700(TCPTransport.this).addElement(this);
                            throw var19_36;
                        }
                    }
                }
                TCPTransport.access$400(this.socket);
                if (TCPTransport.disableThreadPooling != null) return;
                this.socket = null;
                TCPTransport.access$200().set(null);
                var21_15 = TCPTransport.access$700(TCPTransport.this);
                synchronized (var21_15) {
                    TCPTransport.access$700(TCPTransport.this).addElement(this);
                    return;
                }
            }
            var20_12 = null;
            TCPTransport.access$400(this.socket);
            if (TCPTransport.disableThreadPooling != null) return;
            this.socket = null;
            TCPTransport.access$200().set(null);
            var21_16 = TCPTransport.access$700(TCPTransport.this);
            synchronized (var21_16) {
                TCPTransport.access$700(TCPTransport.this).addElement(this);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Thread thread;
            if (disableThreadPooling != null) {
                this.handleRequest();
                return;
            }
            Thread thread2 = thread = Thread.currentThread();
            synchronized (thread2) {
                this.threadStarted = true;
                thread.notify();
            }
            while (true) {
                ConnectionHandler connectionHandler = this;
                synchronized (connectionHandler) {
                    while (this.socket == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    thread.setName(this.name);
                }
                this.handleRequest();
            }
        }
    }
}

