/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.HostAddresses;
import com.ibm.security.krb5.KDCOptions;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.krb5.internal.Ticket;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;

public class KDCReqBody {
    private KDCOptions a;
    private PrincipalName b;
    private Realm c;
    private PrincipalName d;
    private KerberosTime e;
    private KerberosTime f;
    private KerberosTime g;
    private int h;
    private int[] i;
    private HostAddresses j;
    private EncryptedData k;
    private Ticket[] l;

    public KDCReqBody(KDCOptions kDCOptions, PrincipalName principalName, Realm realm, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int n2, int[] nArray, HostAddresses hostAddresses, EncryptedData encryptedData, Ticket[] ticketArray) throws IOException {
        this.a = kDCOptions;
        this.b = principalName;
        this.c = realm;
        this.d = principalName2;
        this.e = kerberosTime;
        this.f = kerberosTime2;
        this.g = kerberosTime3;
        this.h = n2;
        if (nArray != null) {
            this.i = (int[])nArray.clone();
        }
        this.j = hostAddresses;
        this.k = encryptedData;
        this.l = ticketArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KDCReqBody(DerValue derValue, int n2) throws Asn1Exception, RealmException, KrbException, IOException {
        this.j = null;
        this.k = null;
        this.l = null;
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.a = KDCOptions.parse(derValue.getData(), (byte)0, false);
        this.b = PrincipalName.parse(derValue.getData(), (byte)1, true);
        if (n2 != 10 && this.b != null) {
            throw new Asn1Exception(906);
        }
        this.c = Realm.parse(derValue.getData(), (byte)2, false);
        this.d = PrincipalName.parse(derValue.getData(), (byte)3, true);
        this.e = KerberosTime.parse(derValue.getData(), (byte)4, true);
        this.f = KerberosTime.parse(derValue.getData(), (byte)5, false);
        this.g = KerberosTime.parse(derValue.getData(), (byte)6, true);
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 7) {
            throw new Asn1Exception(906);
        }
        this.h = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        Vector<Integer> vector = new Vector<Integer>();
        if ((derValue2.getTag() & 0x1F) != 8) throw new Asn1Exception(906);
        DerValue derValue3 = derValue2.getData().getDerValue();
        if (derValue3.getTag() != 48) throw new Asn1Exception(906);
        while (derValue3.getData().available() > 0) {
            vector.addElement(new Integer(derValue3.getData().getBigInteger().intValue()));
        }
        this.i = new int[vector.size()];
        int n3 = 0;
        while (n3 < vector.size()) {
            this.i[n3] = (Integer)vector.elementAt(n3);
            ++n3;
        }
        if (derValue.getData().available() > 0) {
            this.j = HostAddresses.parse(derValue.getData(), (byte)9, true);
        }
        if (derValue.getData().available() > 0) {
            this.k = EncryptedData.parse(derValue.getData(), (byte)10, true);
        }
        if (derValue.getData().available() > 0) {
            Vector<Ticket> vector2 = new Vector<Ticket>();
            derValue2 = derValue.getData().getDerValue();
            if ((derValue2.getTag() & 0x1F) != 11) throw new Asn1Exception(906);
            derValue3 = derValue2.getData().getDerValue();
            if (derValue3.getTag() != 48) throw new Asn1Exception(906);
            while (derValue3.getData().available() > 0) {
                vector2.addElement(new Ticket(derValue3.getData().getDerValue()));
            }
            if (vector2.size() > 0) {
                this.l = new Ticket[vector2.size()];
                vector2.copyInto(this.l);
            }
        }
        if (derValue.getData().available() <= 0) return;
        throw new Asn1Exception(906);
    }

    public byte[] asn1Encode(int n2) throws Asn1Exception, IOException {
        Vector<DerValue> vector = new Vector<DerValue>();
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), this.a.asn1Encode()));
        if (n2 == 10 && this.b != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.b.asn1Encode()));
        }
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.c.asn1Encode()));
        if (this.d != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)3), this.d.asn1Encode()));
        }
        if (this.e != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.e.asn1Encode()));
        }
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)5), this.f.asn1Encode()));
        if (this.g != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)6), this.g.asn1Encode()));
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(this.h);
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)7), derOutputStream.toByteArray()));
        derOutputStream = new DerOutputStream();
        int n3 = 0;
        while (n3 < this.i.length) {
            derOutputStream.putInteger(BigInteger.valueOf(this.i[n3]));
            ++n3;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)8), derOutputStream2.toByteArray()));
        if (this.j != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)9), this.j.asn1Encode()));
        }
        if (this.k != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)10), this.k.asn1Encode()));
        }
        if (this.l != null && this.l.length > 0) {
            derOutputStream = new DerOutputStream();
            int n4 = 0;
            while (n4 < this.l.length) {
                derOutputStream.write(this.l[n4].asn1Encode());
                ++n4;
            }
            DerOutputStream derOutputStream3 = new DerOutputStream();
            derOutputStream3.write((byte)48, derOutputStream);
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)11), derOutputStream3.toByteArray()));
        }
        Object[] objectArray = new DerValue[vector.size()];
        vector.copyInto(objectArray);
        derOutputStream = new DerOutputStream();
        derOutputStream.putSequence((DerValue[])objectArray);
        return derOutputStream.toByteArray();
    }

    public Ticket[] getAdditionalTickets() {
        return this.l;
    }

    public EncryptedData getEncryptedAuthzData() {
        return this.k;
    }

    public PrincipalName getClient() {
        return this.b;
    }

    public PrincipalName getServer() {
        return this.d;
    }

    public Realm getRealm() {
        return this.c;
    }

    public int getNonce() {
        return this.h;
    }

    public KDCOptions getOptions() {
        return this.a;
    }

    public KerberosTime getStartTime() {
        return this.e;
    }

    public KerberosTime getEndTime() {
        return this.f;
    }

    public KerberosTime getRenewableTillTime() {
        return this.g;
    }

    public int[] getEtypes() {
        return this.i;
    }

    public HostAddresses getAddresses() {
        return this.j;
    }
}

