/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPublicKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.Date;

public final class RSAPublicKey
extends X509Key
implements PKCS11RSAPublicKey,
Serializable {
    private PKCS11Object object = null;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private Integer keyType = PKCS11Object.RSA;
    private byte[] ID = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private byte[] subject = null;
    private Boolean isEncrypt = null;
    private Boolean isVerify = null;
    private Boolean isVerifyRecover = null;
    private Boolean isWrap = null;
    private BigInteger modulus = null;
    private Integer modulusBits = null;
    private BigInteger publicExponent = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.RSAPublicKey";

    RSAPublicKey(PKCS11Object pKCS11Object, byte[] byArray, byte[] byArray2, String string, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4) throws InvalidKeyException {
        this.object = pKCS11Object;
        if (byArray != null) {
            this.ID = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.ID, 0, byArray.length);
        } else {
            this.ID = (byte[])this.getValue(this.object, 258);
        }
        if (byArray2 != null) {
            this.subject = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.subject, 0, byArray2.length);
        } else {
            this.subject = (byte[])this.getValue(this.object, 257);
        }
        this.label = string != null ? new String(string) : (String)this.getValue(this.object, 3);
        this.isToken = bl != null ? new Boolean(bl) : (Boolean)this.getValue(this.object, 1);
        this.isVerify = bl2 != null ? new Boolean(bl2) : (Boolean)this.getValue(this.object, 266);
        this.isEncrypt = bl3 != null ? new Boolean(bl3) : (Boolean)this.getValue(this.object, 260);
        this.isWrap = bl4 != null ? new Boolean(bl4) : (Boolean)this.getValue(this.object, 262);
        this.isPrivate = (Boolean)this.getValue(this.object, 2);
        this.isModifiable = (Boolean)this.getValue(this.object, 368);
        this.startDate = (Date)this.getValue(this.object, 272);
        this.endDate = (Date)this.getValue(this.object, 273);
        this.isDerive = (Boolean)this.getValue(this.object, 268);
        this.isLocal = (Boolean)this.getValue(this.object, 355);
        this.isVerifyRecover = (Boolean)this.getValue(this.object, 267);
    }

    RSAPublicKey(PKCS11Object pKCS11Object, byte[] byArray, byte[] byArray2, String string, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, BigInteger bigInteger, Integer n, BigInteger bigInteger2) throws InvalidKeyException {
        this(pKCS11Object, byArray, byArray2, string, bl, bl2, bl3, bl4);
        if (bigInteger != null) {
            this.modulus = new BigInteger(bigInteger.toByteArray());
        }
        if (n != null) {
            this.modulusBits = new Integer(n);
        }
        if (bigInteger2 != null) {
            this.publicExponent = new BigInteger(bigInteger2.toByteArray());
        }
        this.algid = new AlgIdRSA();
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(2, this.modulus.toByteArray()), new DerValue(2, this.publicExponent.toByteArray())};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            this.key = derOutputStream.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("could not DER encode: " + iOException.getMessage());
        }
    }

    RSAPublicKey(byte[] byArray) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RSAPublicKey", (Object)byArray);
        }
        this.decode(byArray);
        this.label = this.genLabel();
        int[] nArray = new int[]{0, 256, 3, 1, 266, 260, 262, 288, 290};
        Object[] objectArray = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.RSA, this.label, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, this.modulus, this.publicExponent};
        PKCS11Session pKCS11Session = IBMPKCS11Impl.session;
        this.object = pKCS11Session.createObject(nArray, objectArray);
        this.subject = (byte[])this.getValue(this.object, 257);
        this.ID = (byte[])this.getValue(this.object, 258);
        this.isToken = (Boolean)this.getValue(this.object, 1);
        this.isVerify = (Boolean)this.getValue(this.object, 266);
        this.isEncrypt = (Boolean)this.getValue(this.object, 260);
        this.isWrap = (Boolean)this.getValue(this.object, 262);
        this.isPrivate = (Boolean)this.getValue(this.object, 2);
        this.isModifiable = (Boolean)this.getValue(this.object, 368);
        this.startDate = (Date)this.getValue(this.object, 272);
        this.endDate = (Date)this.getValue(this.object, 273);
        this.isDerive = (Boolean)this.getValue(this.object, 268);
        this.isLocal = (Boolean)this.getValue(this.object, 355);
        this.isVerifyRecover = (Boolean)this.getValue(this.object, 267);
        this.modulusBits = (Integer)this.getValue(this.object, 289);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "RSAPublicKey");
        }
    }

    protected void parseKeyBits() throws InvalidKeyException {
        if (debug != null) {
            debug.exit(16384L, (Object)className, "parseKeyBits");
        }
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            DerValue[] derValueArray = derInputStream.getSequence(2);
            this.modulus = derValueArray[0].getInteger();
            this.publicExponent = derValueArray[1].getInteger();
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "parseKeyBits", "Invalid key value");
            }
            throw new InvalidKeyException("Invalid key value \n" + exception.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "parseKeyBits");
        }
    }

    public PKCS11Object getObject() {
        return this.object;
    }

    public Boolean getToken() {
        return new Boolean(this.isToken);
    }

    public Boolean getPrivate() {
        return new Boolean(this.isPrivate);
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getModifiable() {
        return new Boolean(this.isModifiable);
    }

    public Integer getKeyType() {
        return this.keyType;
    }

    public byte[] getID() {
        return (byte[])this.ID.clone();
    }

    public Date getStartDate() {
        return (Date)this.startDate.clone();
    }

    public Date getEndDate() {
        return (Date)this.endDate.clone();
    }

    public Boolean getDerive() {
        return new Boolean(this.isDerive);
    }

    public Boolean getLocal() {
        return new Boolean(this.isLocal);
    }

    public byte[] getSubject() {
        return (byte[])this.subject.clone();
    }

    public Boolean getEncrypt() {
        return new Boolean(this.isEncrypt);
    }

    public Boolean getVerify() {
        return new Boolean(this.isVerify);
    }

    public Boolean getVerifyRecover() {
        return new Boolean(this.isVerifyRecover);
    }

    public Boolean getWrap() {
        return new Boolean(this.isWrap);
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public Integer getModulusBits() {
        return this.modulusBits;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public String toString() {
        String string = "IBMPKCS11Impl";
        String string2 = string + " RSA Public Key: ";
        if (this.isToken != null) {
            string2 = string2 + "\n Token: " + this.isToken;
        }
        if (this.isPrivate != null) {
            string2 = string2 + "\n Private: " + this.isPrivate;
        }
        if (this.label != null) {
            string2 = string2 + "\n Label: " + this.label;
        }
        if (this.isModifiable != null) {
            string2 = string2 + "\n Modifiable: " + this.isModifiable;
        }
        string2 = string2 + "\n KeyType: " + this.keyType.toString();
        if (this.ID != null) {
            string2 = string2 + "\n ID: " + new String(this.ID);
        }
        if (this.startDate != null) {
            string2 = string2 + "\n Start Date: " + this.startDate.toString();
        }
        if (this.endDate != null) {
            string2 = string2 + "\n End Date: " + this.endDate.toString();
        }
        if (this.isDerive != null) {
            string2 = string2 + "\n Derive: " + this.isDerive;
        }
        if (this.isLocal != null) {
            string2 = string2 + "\n Local: " + this.isLocal;
        }
        if (this.subject != null) {
            string2 = string2 + "\n Subject: " + new String(this.subject);
        }
        if (this.isEncrypt != null) {
            string2 = string2 + "\n Encrypt: " + this.isEncrypt;
        }
        if (this.isVerify != null) {
            string2 = string2 + "\n Verify: " + this.isVerify;
        }
        if (this.isVerifyRecover != null) {
            string2 = string2 + "\n VerifyRecover: " + this.isVerifyRecover;
        }
        if (this.isWrap != null) {
            string2 = string2 + "\n Wrap: " + this.isWrap;
        }
        if (this.modulus != null) {
            string2 = string2 + "\n modulus: " + this.modulus.toString();
        }
        if (this.modulusBits != null) {
            string2 = string2 + "\n modulus bits: " + this.modulusBits.toString();
        }
        if (this.publicExponent != null) {
            string2 = string2 + "\n public exponent: " + this.publicExponent.toString();
        }
        return string2;
    }

    public String getFormat() {
        return "PKCS#11";
    }

    public String getAlgorithm() {
        return "RSA";
    }

    private Object getValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pKCS11Object, (Object)new Integer(n));
        }
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", exception.getMessage());
            }
            object = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return object;
    }

    private String genLabel() {
        Serializable serializable;
        byte[] byArray = new byte[33];
        byte[] byArray2 = new byte[24];
        byte[] byArray3 = null;
        int n = 0;
        try {
            serializable = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
            ((SecureRandom)serializable).nextBytes(byArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable = new BigInteger(1, byArray2);
        try {
            byArray3 = ((BigInteger)serializable).toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("Can not convert string");
        }
        n = ((BigInteger)serializable).toString().length();
        if (n > 24) {
            n = 24;
        }
        System.arraycopy(byArray3, 0, byArray, 9, n);
        byArray[0] = 73;
        byArray[1] = 66;
        byArray[2] = 77;
        byArray[3] = 80;
        byArray[4] = 75;
        byArray[5] = 67;
        byArray[6] = 83;
        byArray[7] = 49;
        byArray[8] = 49;
        String string = null;
        try {
            string = new String(byArray, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray);
        }
        return string;
    }
}

