/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rastools.collector;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.TransactionService;
import com.ibm.websphere.models.config.loggingservice.ras.RASLoggingService;
import com.ibm.websphere.models.config.loggingservice.ras.ServiceLog;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.ServerComponent;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.process.StreamRedirect;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.traceservice.TraceService;
import com.ibm.websphere.product.VersionInfo;
import com.ibm.websphere.rastools.collector.ExecCmd;
import com.ibm.websphere.rastools.collector.Helper1;
import com.ibm.websphere.rastools.collector.Logger;
import com.ibm.websphere.rastools.collector.PODef;
import com.ibm.websphere.rastools.collector.POProcessor;
import com.ibm.websphere.rsadapter.CloudscapeDataStoreHelper;
import com.ibm.websphere.rsadapter.DB2DataStoreHelper;
import com.ibm.websphere.rsadapter.GenericDataStoreHelper;
import com.ibm.websphere.rsadapter.InformixDataStoreHelper;
import com.ibm.websphere.rsadapter.MSSQLDataStoreHelper;
import com.ibm.websphere.rsadapter.OracleDataStoreHelper;
import com.ibm.websphere.rsadapter.SybaseDataStoreHelper;
import com.ibm.ws.runtime.component.VariableMapImpl;
import com.ibm.ws.runtime.service.RepositoryImpl;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class Collector {
    static String pgmVersion = "05.02.00";
    static int verbosity;
    static boolean debug;
    static boolean prompt;
    static boolean showDBLocks;
    static boolean showOnlyDBLocks;
    static String installDirectory;
    static String configDirectory;
    static String wasNode;
    static String cellName;
    static String serverName;
    static String logRoot;
    static String mQRoot;
    static String wasPropsDir;
    static String appInstallRoot;
    static String tranLogRoot;
    static String serviceLogName;
    static String traceLogName;
    static String userInstallRoot;
    static RepositoryImpl repository;
    static String logFileName;
    static boolean summary;
    static boolean noSamples;
    static boolean includeInstalledApps;
    static Helper1 HC1;
    static Logger Log;
    static POProcessor po;
    static int exitRC;
    static final boolean abend = true;
    static final boolean noAbend = false;
    static final boolean leftJustify = true;
    static final boolean noLeftJustify = false;
    static final int padV1 = 18;
    static final int k_InError = 0;
    static final int k_getFile = 1;
    static final int k_getFiles = 2;
    static final int k_getFiles_R = 3;
    static final int k_getFile_P = 4;
    static final int k_getDir = 5;
    static final int k_getDir_R = 6;
    static final int k_execCmd = 7;
    static final String defaultInventoryName = "com/ibm/websphere/rastools/collector/default.inventory";
    static final String defaultInstallDir = "badInstallDir";
    static final String defaultJavaHome = "badJavaHome";
    static final String defaultJarName = "WASenv.jar";
    static Hashtable macros;
    static int action;
    static String vData;
    static String sExecFile;
    static boolean recursive;
    static int objectsGathered;
    static JarOutputStream jos;
    static File jarFile;
    static String currentDirectoryPath;
    static String absoluteDirectoryPath;
    static String hostNameDir;
    static String hostName;
    static String serverType;
    static String jarName;
    static String bundle;
    static String fileSep;
    static JarFile jf;
    static InputStream is;
    static JarInputStream jis;
    static boolean correctPlatform;
    static int[] lineCount;
    static final String k_Version = "Version";
    static final String k_Debug = "Debug";
    static final String k_Help = "?";
    static final String k_LogFileName = "Logfile";
    static final String k_Verbosity = "Verbosity";
    static final String k_PropertyFile = "PropertyFile";
    static final String k_ScratchFile = "ScratchFile";
    static final String k_Compression = "Compression";
    static final String k_Inventory = "Inventory";
    static final String k_Comment = "comment";
    static final String k_JarOutName = "JarOutName";
    static final String k_CaseSensitive = "CaseSensitive";
    static final String k_AutoCollect = "AutoCollect";
    static final String k_ManifestFile = "ManifestFile";
    static final String k_mfMainClass = "mfMainClass";
    static final String k_mfVersion = "mfVersion";
    static final String k_AidInventory = "AidInventory";
    static final String k_Test = "Test";
    static final String k_Prompt = "Prompt";
    static final String k_InstallDir = "InstallDir";
    static final String k_ShowDBLocks = "ShowDBLocks";
    static final String k_ShowOnlyDBLocks = "ShowOnlyDBLocks";
    static final String k_JavaHome = "JavaHome";
    static final String k_ConfigRoot = "ConfigRoot";
    static final String k_WasNode = "WasNode";
    static final String k_CellName = "CellName";
    static final String k_ServerName = "ServerName";
    static final String k_Summary = "Summary";
    static final String k_NoSamples = "NoSamples";
    static final String k_IncludeInstalledApps = "IncludeInstalledApps";
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;

    public static void main(String[] stringArray) {
        Log = new Logger(null, false, verbosity);
        Log.Open();
        HC1 = new Helper1(Log, verbosity);
        if (!Collector.curDirOK()) {
            return;
        }
        if (!Collector.ProcessOptions(stringArray)) {
            Log.Close();
            return;
        }
        if (!Collector.jarDirOK()) {
            return;
        }
        Collector.processVariablesMap();
        long l = System.currentTimeMillis();
        Collector.collect();
        if (!summary) {
            Collector.processServerXml();
            Object[] objectArray = new Object[1];
            objectArray[0] = HC1.FmtNum(Logger.errorCount, 0, 12, 0);
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_NUM_POSSIBLE_ERRORS", objectArray, "WSST_MSG_COL_NUM_POSSIBLE_ERRORS"));
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_LOGFILE", new Object[]{po.getFile(k_LogFileName).getAbsolutePath()}, "WSST_MSG_COL_LOGFILE"));
            if (jarFile.isAbsolute()) {
                Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_OUTPUT_JAR", new Object[]{jarName}, "WSST_MSG_COL_OUTPUT_JAR"));
            } else {
                Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_OUTPUT_JAR", new Object[]{absoluteDirectoryPath + jarName}, "WSST_MSG_COL_OUTPUT_JAR"));
            }
            Collector.includeLogFile();
            Collector.closeJarStream();
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_RETURN_CODE", new Object[]{Integer.toString(exitRC), HC1.CalcET(l)}, "WSST_MSG_COL_RETURN_CODE"));
            Log.Close();
        }
        if (exitRC > 0) {
            System.exit(exitRC);
        }
    }

    static boolean curDirOK() {
        String string = "TempCollectorTest";
        File file = new File(string);
        try {
            if (!file.createNewFile()) {
                Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_CURRENT_DIR_NOT_WRITABLE", new Object[]{string}, "WSST_ERR_COL_CURRENT_DIR_NOT_WRITABLE"));
                return false;
            }
            File file2 = new File(".");
            currentDirectoryPath = file2.getCanonicalPath();
            absoluteDirectoryPath = file2.getAbsolutePath();
            absoluteDirectoryPath = absoluteDirectoryPath.substring(0, absoluteDirectoryPath.length() - 1);
            file2.delete();
            file.delete();
        }
        catch (IOException iOException) {
            Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_IOEXCEPTION_IN_CURRENT_DIR", "WSST_ERR_COL_IOEXCEPTION_IN_CURRENT_DIR"), iOException, false);
            return false;
        }
        return true;
    }

    static boolean jarDirOK() {
        if (currentDirectoryPath.regionMatches(true, 0, installDirectory, 0, installDirectory.length())) {
            Log.Both(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_CURRENT_DIR_IS_WAS_HOME", "WSST_ERR_COL_CURRENT_DIR_IS_WAS_HOME"));
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_CURRENT_DIR_IS_WAS_HOME2", new Object[]{installDirectory}, "WSST_ERR_COL_CURRENT_DIR_IS_WAS_HOME2"));
            return false;
        }
        return true;
    }

    static void processVariablesMap() {
        block22: {
            boolean bl = false;
            try {
                BeanContextServicesSupport beanContextServicesSupport = new BeanContextServicesSupport();
                VariableMapImpl variableMapImpl = new VariableMapImpl();
                String string = null;
                repository = new RepositoryImpl("ws-server", configDirectory, cellName, wasNode, string);
                beanContextServicesSupport.addService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = Collector.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository, (BeanContextServiceProvider)repository);
                beanContextServicesSupport.add(variableMapImpl);
                try {
                    variableMapImpl.initialize((Object)configDirectory);
                    bl = true;
                }
                catch (Exception exception) {
                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Configuration error on node level VariableMap.xml, map.initialize() failed "));
                    String string2 = exception.getMessage();
                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error - exception msg: " + string2));
                    Collector.setDefaultVariables();
                }
                if (!bl) break block22;
                try {
                    userInstallRoot = variableMapImpl.expand("${USER_INSTALL_ROOT}");
                    if (userInstallRoot == null | userInstallRoot.trim().equals("")) {
                        Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Null or blank USER_INSTALL_ROOT: " + userInstallRoot));
                        userInstallRoot = installDirectory;
                    }
                }
                catch (Exception exception) {
                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Bad USER_INSTALL_ROOT: " + userInstallRoot + ", exception: " + exception.getMessage()));
                    userInstallRoot = installDirectory;
                }
                try {
                    logRoot = variableMapImpl.expand("${LOG_ROOT}");
                    if (logRoot == null | logRoot.trim().equals("")) {
                        Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Null or blank LOG_ROOT: " + logRoot));
                        logRoot = userInstallRoot + "/logs";
                    }
                }
                catch (Exception exception) {
                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Bad LOG_ROOT: " + logRoot + ", exception: " + exception.getMessage()));
                    logRoot = userInstallRoot + "/logs";
                }
                try {
                    mQRoot = variableMapImpl.expand("${MQ_INSTALL_ROOT}");
                    if (mQRoot == null | mQRoot.trim().equals("")) {
                        Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Null or blank MQ_INSTALL_ROOT: " + mQRoot));
                        mQRoot = userInstallRoot + "/logs";
                    }
                }
                catch (Exception exception) {
                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Bad MQ_INSTALL_ROOT: " + mQRoot + ", exception: " + exception.getMessage()));
                    mQRoot = installDirectory + "/../../WebSphere MQ";
                }
                try {
                    appInstallRoot = variableMapImpl.expand("${APP_INSTALL_ROOT}");
                    if (appInstallRoot == null | appInstallRoot.trim().equals("")) {
                        Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Null or blank APP_INSTALL_ROOT: " + appInstallRoot));
                        appInstallRoot = userInstallRoot + "/installedApps";
                    }
                }
                catch (Exception exception) {
                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Bad APP_INSTALL_ROOT: " + appInstallRoot + ", exception: " + exception.getMessage()));
                    appInstallRoot = userInstallRoot + "/installedApps";
                }
                try {
                    wasPropsDir = variableMapImpl.expand("${WAS_PROPS_DIR}");
                    if (wasPropsDir == null | wasPropsDir.trim().equals("")) {
                        Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Null or blank WAS_PROPS_DIR: " + wasPropsDir));
                        wasPropsDir = userInstallRoot + "/properties";
                    }
                }
                catch (Exception exception) {
                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Bad WAS_PROPS_DIR: " + wasPropsDir + ", exception: " + exception.getMessage()));
                    wasPropsDir = userInstallRoot + "/properties";
                }
                try {
                    tranLogRoot = variableMapImpl.expand("${TRANLOG_ROOT}");
                    if (tranLogRoot == null | tranLogRoot.trim().equals("")) {
                        Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Null or blank TRANLOG_ROOT: " + tranLogRoot));
                        tranLogRoot = userInstallRoot + "/tranlog";
                    }
                }
                catch (Exception exception) {
                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Bad TRANLOG_ROOT: " + tranLogRoot + ", exception: " + exception.getMessage()));
                    tranLogRoot = userInstallRoot + "/tranlog";
                }
            }
            catch (Exception exception) {
                Log.Log("Error: Problem setting up BeanContext or Repository, exception: " + exception.getMessage());
                Collector.setDefaultVariables();
            }
        }
    }

    static void setDefaultVariables() {
        userInstallRoot = installDirectory;
        logRoot = userInstallRoot + "/logs";
        appInstallRoot = userInstallRoot + "/installedApps";
        mQRoot = installDirectory + "/../../WebSphere MQ";
        wasPropsDir = userInstallRoot + "/properties";
        tranLogRoot = userInstallRoot + "/tranlog";
    }

    static void processServerXml() {
        try {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            Resource resource = repository.getConfigRoot().getResource(3, "serverindex.xml");
            RepositoryImpl repositoryImpl = null;
            String string = null;
            try {
                ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                EList eList = serverIndex.getServerEntries();
                for (int i = 0; i < eList.size(); ++i) {
                    ServerEntry serverEntry = (ServerEntry)eList.get(i);
                    string = serverEntry.getServerName();
                    bl2 = serverName == null ? true : string.equalsIgnoreCase(serverName);
                    if (!bl2) continue;
                    bl3 = true;
                    repositoryImpl = new RepositoryImpl("ws-server", configDirectory, cellName, wasNode, string);
                    Resource resource2 = null;
                    Server server = null;
                    Object var12_14 = null;
                    BeanContextServicesSupport beanContextServicesSupport = new BeanContextServicesSupport();
                    VariableMapImpl variableMapImpl = new VariableMapImpl();
                    beanContextServicesSupport.addService(class$com$ibm$ws$runtime$service$Repository == null ? Collector.class$("com.ibm.ws.runtime.service.Repository") : class$com$ibm$ws$runtime$service$Repository, (BeanContextServiceProvider)repositoryImpl);
                    beanContextServicesSupport.add(variableMapImpl);
                    bl = false;
                    try {
                        variableMapImpl.initialize((Object)configDirectory);
                        bl = true;
                    }
                    catch (Exception exception) {
                        Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Bad serverMap Init, exception: " + exception.getMessage()));
                    }
                    if (!bl) continue;
                    try {
                        resource2 = repositoryImpl.getConfigRoot().getResource(4, "server.xml");
                        try {
                            ServiceLog serviceLog;
                            String string2;
                            String string3;
                            String string4;
                            StreamRedirect streamRedirect;
                            server = (Server)resource2.getContents().get(0);
                            try {
                                streamRedirect = server.getOutputStreamRedirect();
                                string4 = streamRedirect.getFileName();
                                if (string4 != null && !string4.trim().equals("")) {
                                    vData = variableMapImpl.expand(string4);
                                    Collector.getFile(null, true);
                                }
                            }
                            catch (Exception exception) {
                                Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Bad System.out, exception: " + exception.getMessage()));
                            }
                            try {
                                streamRedirect = server.getErrorStreamRedirect();
                                string4 = streamRedirect.getFileName();
                                if (string4 != null && !string4.trim().equals("")) {
                                    vData = variableMapImpl.expand(string4);
                                    Collector.getFile(null, true);
                                }
                            }
                            catch (Exception exception) {
                                Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Bad System.err, exception: " + exception.getMessage()));
                            }
                            try {
                                streamRedirect = server.getProcessDefinition();
                                string4 = streamRedirect.getIoRedirect();
                                string3 = string4.getStdoutFilename();
                                string2 = string4.getStderrFilename();
                                try {
                                    if (string3 != null && !string3.trim().equals("")) {
                                        vData = variableMapImpl.expand(string3);
                                        Collector.getFile(null, true);
                                    }
                                    if (string2 != null && !string2.trim().equals("")) {
                                        vData = variableMapImpl.expand(string2);
                                        Collector.getFile(null, true);
                                    }
                                }
                                catch (Exception exception) {
                                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Can't expand Stdout or Stderr, exception: " + exception.getMessage()));
                                }
                            }
                            catch (Exception exception) {
                                Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Can't get ProcessDef for wccmServer, exception: " + exception.getMessage()));
                            }
                            streamRedirect = server.getServices();
                            for (int j = 0; j < streamRedirect.size(); ++j) {
                                string3 = (Service)streamRedirect.get(j);
                                if (string3 instanceof RASLoggingService) {
                                    string2 = (RASLoggingService)string3;
                                    serviceLog = string2.getServiceLog();
                                    try {
                                        serviceLogName = variableMapImpl.expand(serviceLog.getName());
                                        if (serviceLogName != null && !serviceLogName.trim().equals("")) {
                                            vData = serviceLogName;
                                            Collector.getFile(null, true);
                                        }
                                    }
                                    catch (Exception exception) {
                                        Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Can't expand serviceLogName, exception: " + exception.getMessage()));
                                    }
                                }
                                if (!(string3 instanceof TraceService)) continue;
                                string2 = (TraceService)string3;
                                serviceLog = string2.getTraceLog();
                                try {
                                    traceLogName = variableMapImpl.expand(serviceLog.getFileName());
                                    if (traceLogName == null || traceLogName.trim().equals("")) continue;
                                    vData = traceLogName;
                                    Collector.getFile(null, true);
                                    continue;
                                }
                                catch (Exception exception) {
                                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Can't expand traceLogName, exception: " + exception.getMessage()));
                                }
                            }
                            string4 = server.getComponents();
                            string3 = null;
                            for (int j = 0; j < string4.size(); ++j) {
                                try {
                                    serviceLog = (ServerComponent)string4.get(j);
                                    if (!(serviceLog instanceof ApplicationServer)) continue;
                                    ApplicationServer applicationServer = (ApplicationServer)serviceLog;
                                    EList eList2 = applicationServer.getServices();
                                    for (int k = 0; k < eList2.size(); ++k) {
                                        TransactionService transactionService;
                                        Service service = (Service)eList2.get(k);
                                        if (!(service instanceof TransactionService) || (string3 = (transactionService = (TransactionService)service).getTransactionLogDirectory()) == null || string3.trim().equals("")) continue;
                                        vData = string3;
                                        Collector.getFile(null, true);
                                    }
                                    continue;
                                }
                                catch (Exception exception) {
                                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Can't get Transaction Log Directory from Transaction Service, exception: " + exception.getMessage()));
                                }
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Can't Load WCCM Server, exception: " + exception.getMessage()));
                            continue;
                        }
                    }
                    catch (Exception exception) {
                        Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Can't get Server Resource, exception: " + exception.getMessage()));
                    }
                }
                if (!bl3) {
                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Server not found: " + serverName));
                }
            }
            catch (Exception exception) {
                Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Can't get Server Index, exception: " + exception.getMessage()));
            }
        }
        catch (Exception exception) {
            Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Can't get Node resource, exception: " + exception.getMessage()));
        }
    }

    static void collect() {
        if (!summary) {
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_COMPRESSION", new Object[]{po.getString(k_Compression)}, "WSST_MSG_COL_COMPRESSION"));
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_USERID", new Object[]{po.getString(System.getProperty("user.name"))}, "WSST_MSG_COL_USERID"));
        }
        block11: while (Collector.moreRequests()) {
            recursive = false;
            if (summary) {
                Collector.getSummary();
                break;
            }
            switch (action) {
                case 1: {
                    Collector.getFile(null, false);
                    continue block11;
                }
                case 3: {
                    recursive = true;
                }
                case 2: {
                    Collector.getFiles();
                    continue block11;
                }
                case 4: {
                    Collector.getFileP();
                    continue block11;
                }
                case 6: {
                    recursive = true;
                }
                case 5: {
                    Collector.getDir();
                    continue block11;
                }
                case 7: {
                    Collector.execCmd();
                    continue block11;
                }
            }
            String string = Integer.toString(action);
            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_UNHANDLED_INV_REQUEST", new Object[]{string, vData}, "WSST_ERR_COL_UNHANDLED_INV_REQUEST"), true);
        }
        if (!summary && includeInstalledApps) {
            action = 6;
            vData = appInstallRoot;
            recursive = true;
            Collector.getDir();
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_FILE_NOT_FOUND", new Object[]{iOException.getMessage()}, "WSST_ERR_COL_INV_FILE_NOT_FOUND"));
            }
            is = null;
        }
        if (!summary) {
            Collector.includeProps();
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_OBJS_GATHERED", new Object[]{HC1.FmtNum(objectsGathered, 0, 12, 0)}, "WSST_MSG_COL_OBJS_GATHERED"));
            if (null != po.getString(k_Comment)) {
                Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_COMMENT", new Object[]{po.getString(k_Comment)}, "WSST_MSG_COL_COMMENT"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void getFile(String string, boolean bl) {
        block15: {
            int n;
            if (string == null) {
                Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_INCLUDING_FILE", new Object[]{vData}, "WSST_MSG_COL_INCLUDING_FILE"));
            } else {
                Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_INCLUDING_FILE", new Object[]{string}, "WSST_MSG_COL_INCLUDING_FILE"));
            }
            File file = new File(vData);
            if (!file.exists()) {
                Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_FILE_DOES_NOT_EXIST", new Object[]{vData}, "WSST_ERR_COL_FILE_DOES_NOT_EXIST"));
                return;
            }
            if (!file.canRead()) {
                Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_CANNOT_READ_FILE", new Object[]{vData}, "WSST_ERR_COL_CANNOT_READ_FILE"));
                return;
            }
            FileInputStream fileInputStream = Collector.OpenInputStream(file);
            if (fileInputStream == null) {
                return;
            }
            if (string == null ? !Collector.createJarEntry(vData, bl) : !Collector.createJarEntry(string, bl)) {
                return;
            }
            byte[] byArray = new byte[4096];
            while ((n = fileInputStream.read(byArray)) != -1) {
                jos.write(byArray, 0, n);
            }
            Object var8_6 = null;
            try {
                fileInputStream.close();
                jos.closeEntry();
            }
            catch (IOException iOException) {
                Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_ERROR_CLOSING_FILE_OR_JAR", new Object[]{file.toString()}, "WSST_ERR_COL_ERROR_CLOSING_FILE_OR_JAR"), iOException, false);
            }
            break block15;
            {
                catch (IOException iOException) {
                    Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_ERROR_READING_FILE_OR_WRITING_JAR", "WSST_ERR_COL_ERROR_READING_FILE_OR_WRITING_JAR"), iOException, false);
                    Object var8_7 = null;
                    try {
                        fileInputStream.close();
                        jos.closeEntry();
                    }
                    catch (IOException iOException2) {
                        Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_ERROR_CLOSING_FILE_OR_JAR", new Object[]{file.toString()}, "WSST_ERR_COL_ERROR_CLOSING_FILE_OR_JAR"), iOException2, false);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    fileInputStream.close();
                    jos.closeEntry();
                }
                catch (IOException iOException) {
                    Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_ERROR_CLOSING_FILE_OR_JAR", new Object[]{file.toString()}, "WSST_ERR_COL_ERROR_CLOSING_FILE_OR_JAR"), iOException, false);
                }
                throw throwable;
            }
        }
        ++objectsGathered;
    }

    static void getFiles() {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        if (recursive) {
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_INCLUDING_DIR_RECURSE", new Object[]{vData}, "WSST_MSG_COL_INCLUDING_DIR_RECURSE"));
        } else {
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_INCLUDING_DIR_NON_RECURSE", new Object[]{vData}, "WSST_MSG_COL_INCLUDING_DIR_NON_RECURSE"));
        }
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        int n = HC1.FindFiles(vData, recursive, hashtable2, hashtable, po.getBool(k_CaseSensitive), stringBuffer, debug);
        int n2 = Math.max(vData.lastIndexOf("/"), vData.lastIndexOf("\\"));
        if (n2 != -1) {
            string2 = "";
            string = vData.substring(0, n2).concat(fileSep);
        } else {
            string2 = "." + fileSep;
            string = "";
        }
        Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_NUM_OBJECTS_IN_DIR", new Object[]{HC1.FmtNum(n, 0, 0, 0), string2 + string}, "WSST_MSG_COL_NUM_OBJECTS_IN_DIR"));
        Enumeration enumeration = hashtable2.elements();
        int n3 = stringBuffer.length() + 1;
        while (enumeration.hasMoreElements()) {
            File file = (File)enumeration.nextElement();
            vData = file.getAbsolutePath();
            String string3 = string.concat(vData.substring(n3));
            if (!includeInstalledApps && vData.substring(n3).endsWith(".ear") || noSamples && vData.substring(n3).endsWith("AccountManagement.ear") || vData.substring(n3).endsWith("activitysession.ear") || vData.substring(n3).endsWith("adminconsole.ear") || vData.substring(n3).endsWith("BRBeansSample.ear") || vData.substring(n3).endsWith("CompanyContext.ear") || vData.substring(n3).endsWith("DynamicQuery.ear") || vData.substring(n3).endsWith("EMSSamples.ear") || vData.substring(n3).endsWith("ivtApp.ear") || vData.substring(n3).endsWith("JTAExtensionsSamples.ear") || vData.substring(n3).endsWith("MDBSamples.ear") || vData.substring(n3).endsWith("petstore.ear") || vData.substring(n3).endsWith("PlantsByWebSphere.ear") || vData.substring(n3).endsWith("query.ear") || vData.substring(n3).endsWith("SamplesGallery.ear") || vData.substring(n3).endsWith("TechnologySamples.ear") || vData.substring(n3).endsWith("TravelBooking.ear")) continue;
            if (!vData.substring(n3).endsWith("Collector.log") & !vData.substring(n3).endsWith("security.xml") & vData.substring(n3).indexOf("server.") < 0 & !vData.substring(n3).endsWith("server-component-templates.xml")) {
                Collector.getFile(string3, false);
                continue;
            }
            if (!(vData.substring(n3).endsWith("security.xml") | vData.substring(n3).indexOf("server.") >= 0 | vData.substring(n3).endsWith("server-component-templates.xml"))) continue;
            vData = "'password=' " + vData;
            Collector.getFileP();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static void getFileP() {
        block45: {
            block43: {
                var0 = "";
                var1_1 = 0;
                var2_2 = new StringTokenizer(Collector.vData, " \t\n\r\f", true);
                var0 = var0.concat(var2_2.nextToken());
                Collector.vData = var2_2.nextToken("\t\n\r\f").trim();
                if ('\"' != (var0 = var0.trim()).charAt(0)) ** GOTO lbl12
                if ('\"' == var0.charAt(var0.length() - 1)) {
                    var0 = var0.substring(1, var0.length() - 1);
                } else {
                    Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_PW_LABEL_MISSING_QUOTES", new Object[]{var0}, "WSST_ERR_COL_PW_LABEL_MISSING_QUOTES"));
                    return;
lbl12:
                    // 1 sources

                    if ('\'' == var0.charAt(0)) {
                        if ('\'' == var0.charAt(var0.length() - 1)) {
                            var0 = var0.substring(1, var0.length() - 1);
                        } else {
                            Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_PW_LABEL_MISSING_SINGLE_QUOTE", new Object[]{var0}, "WSST_ERR_COL_PW_LABEL_MISSING_SINGLE_QUOTE"));
                            return;
                        }
                    }
                }
                var1_1 = var0.length();
                var3_3 = Collector.vData + ".P";
                var4_4 = new File(Collector.vData);
                var5_5 = var4_4.getName();
                var6_6 = Collector.absoluteDirectoryPath + var5_5 + ".P";
                Collector.Log.Both(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_MSG_COL_INCLUDING_PW_FILE", new Object[]{var6_6}, "WSST_MSG_COL_INCLUDING_PW_FILE"));
                if (!var4_4.exists()) {
                    Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_PW_FILE_DOES_NOT_EXIST", new Object[]{Collector.vData}, "WSST_ERR_COL_PW_FILE_DOES_NOT_EXIST"));
                    return;
                }
                if (!var4_4.canRead()) {
                    Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_PW_CANNOT_READ_FILE", new Object[]{Collector.vData}, "WSST_ERR_COL_PW_CANNOT_READ_FILE"));
                    return;
                }
                var7_7 = new File(var6_6);
                var8_8 = new byte[4096];
                try {
                    if (var7_7.createNewFile()) {
                        var10_9 = new BufferedReader(new FileReader(var4_4));
                        var11_11 = new BufferedWriter(new FileWriter(var7_7));
                        var16_13 = 0;
                        while (null != (var12_14 = var10_9.readLine())) {
                            var13_16 = var12_14.toLowerCase();
                            var17_19 = 0;
                            var18_20 = true;
                            while (var18_20) {
                                var20_22 = var1_1 + var13_16.indexOf(var0.toLowerCase(), var17_19);
                                if (var1_1 <= var20_22) {
                                    var21_23 = new StringBuffer(var12_14);
                                    var14_17 = var20_22;
                                    var16_13 = var21_23.substring(var20_22).length();
                                    var19_21 = 0;
                                    if (var16_13 > 0) {
                                        if (var12_14.charAt(var14_17) == '\"') {
                                            var15_18 = var12_14.indexOf(34, var14_17 + 1);
                                            if (var15_18 > 0) {
                                                var16_13 = var15_18 - var14_17 + 1 - 2;
                                                var19_21 = 1;
                                            }
                                        } else {
                                            var15_18 = var12_14.indexOf(32, var14_17);
                                            if (var15_18 > 0) {
                                                var16_13 = var15_18 - var14_17;
                                            }
                                            var19_21 = 0;
                                        }
                                        if (var16_13 > 0) {
                                            var22_24 = new char[var16_13];
                                            Arrays.fill(var22_24, '*');
                                            var21_23.replace(var14_17 + var19_21, var14_17 + var16_13 + var19_21, new String(var22_24));
                                            var12_14 = var21_23.toString();
                                        }
                                    }
                                    var17_19 = var20_22 + var16_13 + 1 * var19_21;
                                    continue;
                                }
                                var18_20 = false;
                            }
                            var11_11.write(var12_14, 0, var12_14.length());
                            var11_11.newLine();
                        }
                        var24_25 = null;
                        try {
                            var10_9.close();
                        }
                        catch (IOException var25_27) {
                            Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_ERROR_CLOSING_PW_FILE", new Object[]{var4_4.toString()}, "WSST_ERR_COL_ERROR_CLOSING_PW_FILE"), var25_27, false);
                        }
                        try {
                            var11_11.close();
                        }
                        catch (IOException var25_27) {
                            Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_ERROR_CLOSING_TEMP_FILE", new Object[]{var7_7.toString()}, "WSST_ERR_COL_ERROR_CLOSING_TEMP_FILE"), var25_27, false);
                        }
                        break block43;
                        {
                            catch (IOException var12_15) {
                                var7_7.delete();
                                Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_ERR_COL_ERROR_READING_PW_FILE_OR_WRITING_TEMP", "WSST_ERR_COL_ERROR_READING_PW_FILE_OR_WRITING_TEMP"), var12_15, false);
                                var24_25 = null;
                                try {
                                    var10_9.close();
                                }
                                catch (IOException var25_27) {
                                    Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_ERROR_CLOSING_PW_FILE", new Object[]{var4_4.toString()}, "WSST_ERR_COL_ERROR_CLOSING_PW_FILE"), var25_27, false);
                                }
                                try {
                                    var11_11.close();
                                }
                                catch (IOException var25_27) {
                                    Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_ERROR_CLOSING_TEMP_FILE", new Object[]{var7_7.toString()}, "WSST_ERR_COL_ERROR_CLOSING_TEMP_FILE"), var25_27, false);
                                }
                                break block43;
                            }
                        }
                        catch (Throwable var23_29) {
                            var24_26 = null;
                            try {
                                var10_9.close();
                            }
                            catch (IOException var25_28) {
                                Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_ERROR_CLOSING_PW_FILE", new Object[]{var4_4.toString()}, "WSST_ERR_COL_ERROR_CLOSING_PW_FILE"), var25_28, false);
                            }
                            try {
                                var11_11.close();
                            }
                            catch (IOException var25_28) {
                                Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_ERROR_CLOSING_TEMP_FILE", new Object[]{var7_7.toString()}, "WSST_ERR_COL_ERROR_CLOSING_TEMP_FILE"), var25_28, false);
                            }
                            throw var23_29;
                        }
                    }
                    Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_CREATING_TEMP_FILE", new Object[]{var7_7.toString()}, "WSST_ERR_COL_CREATING_TEMP_FILE"));
                    return;
                }
                catch (IOException var10_10) {
                    Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_ERR_COL_ERROR_OPENING_TEMP_FILE", "WSST_ERR_COL_ERROR_OPENING_TEMP_FILE"), var10_10, false);
                }
            }
            var10_9 = Collector.OpenInputStream(var7_7);
            if (var10_9 == null) {
                return;
            }
            if (!Collector.createJarEntry(var3_3, false)) {
                return;
            }
            while ((var9_30 = var10_9.read(var8_8)) != -1) {
                Collector.jos.write(var8_8, 0, var9_30);
            }
            var27_31 = null;
            try {
                var10_9.close();
                var7_7.delete();
                Collector.jos.closeEntry();
            }
            catch (IOException var28_34) {
                Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_CLOSING_TEMP_FILE_OR_JAR", new Object[]{var7_7.toString()}, "WSST_ERR_COL_CLOSING_TEMP_FILE_OR_JAR"));
            }
            break block45;
            {
                catch (IOException var11_12) {
                    Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_ERR_COL_ERROR_READING_TEMP_FILE_OR_WRITING_JAR", "WSST_ERR_COL_ERROR_READING_TEMP_FILE_OR_WRITING_JAR"), var11_12, false);
                    var27_32 = null;
                    try {
                        var10_9.close();
                        var7_7.delete();
                        Collector.jos.closeEntry();
                    }
                    catch (IOException var28_35) {
                        Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_CLOSING_TEMP_FILE_OR_JAR", new Object[]{var7_7.toString()}, "WSST_ERR_COL_CLOSING_TEMP_FILE_OR_JAR"));
                    }
                }
            }
            catch (Throwable var26_37) {
                var27_33 = null;
                try {
                    var10_9.close();
                    var7_7.delete();
                    Collector.jos.closeEntry();
                }
                catch (IOException var28_36) {
                    Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_CLOSING_TEMP_FILE_OR_JAR", new Object[]{var7_7.toString()}, "WSST_ERR_COL_CLOSING_TEMP_FILE_OR_JAR"));
                }
                throw var26_37;
            }
        }
        ++Collector.objectsGathered;
    }

    static void getDir() {
        if (!vData.endsWith(fileSep) & !vData.endsWith("/")) {
            vData = vData.concat(fileSep);
        }
        Collector.getFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void execCmd() {
        block18: {
            var0 = true;
            var1_1 = false;
            var2_2 = false;
            var3_3 = new ExecCmd(var0);
            var4_4 = new Vector<String>();
            var5_5 = new StringBuffer();
            if (!Collector.sExecFile.equals(Collector.po.getString("ScratchFile")) && !Collector.createJarEntry(Collector.sExecFile, false)) {
                return;
            }
            try {
                var6_6 = new StringTokenizer(Collector.vData, ",");
                while (var6_6.hasMoreTokens()) {
                    var7_8 = var6_6.nextToken();
                    var8_9 = new StringTokenizer(var7_8);
                    var9_10 = var8_9.nextToken().trim();
                    if (var9_10.equals("QUIET")) {
                        var7_8 = var8_9.nextToken(",").trim();
                    }
                    Collector.Log.Both(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_MSG_COL_EXECUTE", new Object[]{var7_8}, "WSST_MSG_COL_EXECUTE"));
                    if (!var9_10.equals("QUIET")) {
                        var4_4.add("Execute: " + var7_8);
                    }
                    var10_11 = new StringTokenizer(var7_8, ",");
                    var11_12 = new String[20];
                    var12_13 = 0;
                    while (var10_11.hasMoreTokens()) {
                        var13_14 = var10_11.nextToken("\"").trim();
                        if (var13_14.equals("")) continue;
                        var11_12[var12_13] = var13_14;
                        ++var12_13;
                    }
                    var13_14 = new String[var12_13];
                    for (var14_15 = 0; var14_15 < var12_13; ++var14_15) {
                        var13_14[var14_15] = var11_12[var14_15];
                    }
                    var14_15 = var3_3.Execute((String[])var13_14, var1_1, var2_2, var5_5, var4_4);
                    if (888 == var14_15 || 1 == var14_15) {
                        Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_EXECUTE_ERROR", new Object[]{var5_5.toString()}, "WSST_ERR_COL_EXECUTE_ERROR"));
                        var5_5.delete(0, var5_5.length());
                    }
                    Collector.Log.Both(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_MSG_COL_EXECUTE_RC", new Object[]{Integer.toString(var14_15)}, "WSST_MSG_COL_EXECUTE_RC"));
                    if (!Collector.sExecFile.equals(Collector.po.getString("ScratchFile"))) {
                        var15_16 = var4_4.elements();
                        while (var15_16.hasMoreElements()) {
                            var16_17 = (String)var15_16.nextElement() + System.getProperty("line.separator");
                            var17_18 = var16_17.getBytes();
                            Collector.jos.write(var17_18, 0, var17_18.length);
                        }
                    }
                    var4_4.clear();
                }
                var19_19 = null;
                if (Collector.sExecFile.equals(Collector.po.getString("ScratchFile"))) break block18;
                ** GOTO lbl74
            }
            catch (IOException var6_7) {
                Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_ERR_COL_EXECUTE_IOEXCEPTION", "WSST_ERR_COL_EXECUTE_IOEXCEPTION"), var6_7, false);
                var19_20 = null;
                if (!Collector.sExecFile.equals(Collector.po.getString("ScratchFile"))) {
                    try {
                        Collector.jos.closeEntry();
                    }
                    catch (IOException var20_23) {
                        Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_ERR_COL_EXECUTE_CLOSING_JAR", "WSST_ERR_COL_EXECUTE_CLOSING_JAR"), var20_23, false);
                    }
                }
                break block18;
            }
            {
                catch (Throwable var18_25) {
                    var19_21 = null;
                    if (Collector.sExecFile.equals(Collector.po.getString("ScratchFile")) != false) throw var18_25;
                    ** try [egrp 2[TRYBLOCK] [4 : 565->574)] { 
lbl69:
                    // 1 sources

                    Collector.jos.closeEntry();
                    throw var18_25;
lbl71:
                    // 1 sources

                    catch (IOException var20_24) {
                        Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_ERR_COL_EXECUTE_CLOSING_JAR", "WSST_ERR_COL_EXECUTE_CLOSING_JAR"), var20_24, false);
                    }
                    throw var18_25;
                }
lbl74:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [4 : 565->574)] { 
lbl75:
                // 1 sources

                Collector.jos.closeEntry();
lbl77:
                // 1 sources

                catch (IOException var20_22) {}
                Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_ERR_COL_EXECUTE_CLOSING_JAR", "WSST_ERR_COL_EXECUTE_CLOSING_JAR"), var20_22, false);
            }
        }
        if (Collector.sExecFile.equals(Collector.po.getString("ScratchFile")) != false) return;
        ++Collector.objectsGathered;
    }

    static void includeLogFile() {
        if (!po.getBool(k_AutoCollect)) {
            return;
        }
        vData = po.getString(k_LogFileName);
        Log.Close();
        Collector.getFile(vData, false);
        try {
            File file = new File(vData);
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++objectsGathered;
    }

    static void includeProps() {
        if (!po.getBool(k_AutoCollect)) {
            return;
        }
        Log.Both(TraceNLS.getStringFromBundle(bundle, "WSST_MSG_COL_JAVA_PROPS", "WSST_MSG_COL_JAVA_PROPS"));
        if (!Collector.createJarEntry("Java/Properties", false)) {
            return;
        }
        Properties properties = System.getProperties();
        int n = 30;
        String string = " = ";
        int n2 = 47;
        String string2 = "";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = System.getProperty(string3);
            if (string3.equals("line.separator")) {
                string4 = Helper1.Hex(string4, false, 2);
            }
            while (string4.length() > 0) {
                if (string4.length() < n2) {
                    string2 = string4;
                    string4 = "";
                } else {
                    string2 = string4.substring(0, n2);
                    string4 = string4.substring(n2);
                }
                String string5 = string3.length() > 0 ? HC1.Padit(string3, n, false, ' ') + string + string2 + System.getProperty("line.separator") : HC1.Padit(" ", n, false, ' ') + "   " + string2 + System.getProperty("line.separator");
                byte[] byArray = string5.getBytes();
                try {
                    jos.write(byArray, 0, byArray.length);
                }
                catch (IOException iOException) {
                    Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_IOEXCEPTION_JAVA_PROPS", "WSST_ERR_COL_IOEXCEPTION_JAVA_PROPS"), iOException, false);
                }
                string3 = "";
            }
        }
        try {
            jos.closeEntry();
        }
        catch (IOException iOException) {
            Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_IOEXCEPTION_JAVA_PROPS_JAR_CLOSE", "WSST_ERR_COL_IOEXCEPTION_JAVA_PROPS_JAR_CLOSE"), iOException, false);
        }
        ++objectsGathered;
    }

    static boolean moreRequests() {
        String string;
        String string2;
        block68: {
            string2 = "\u0013";
            string = po.getString(k_Inventory);
            if (is == null) {
                if (string.endsWith(".jar")) {
                    try {
                        jf = new JarFile(string);
                        ZipEntry zipEntry = jf.getEntry(defaultInventoryName);
                        if (zipEntry == null) {
                            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_FILE_NOT_FOUND", new Object[]{string, defaultInventoryName}, "WSST_ERR_COL_INV_FILE_NOT_FOUND"));
                            break block68;
                        }
                        is = jf.getInputStream(zipEntry);
                    }
                    catch (IOException iOException) {
                        Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_FILE_IOEXCEPTION_OPEN", new Object[]{string}, "WSST_ERR_COL_INV_FILE_IOEXCEPTION_OPEN"), iOException, true);
                    }
                } else {
                    try {
                        is = new FileInputStream(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_FILE_NOT_FOUND", new Object[]{string}, "WSST_ERR_COL_INV_FILE_NOT_FOUND"), fileNotFoundException, true);
                    }
                }
            }
        }
        boolean bl = true;
        while (bl) {
            String string3 = "";
            vData = "";
            sExecFile = "";
            string3 = HC1.getNextLogicalLine(lineCount, string, is);
            if (string3 == null) {
                return false;
            }
            if (debug) {
                Log.Both("Debug -- line #" + lineCount[0] + "  (" + string3 + ")");
            }
            if (string3.startsWith("[")) {
                Collector.checkPlatform(string3);
                continue;
            }
            if (!correctPlatform) continue;
            action = 0;
            String string4 = string3.toLowerCase();
            if (string4.startsWith("getfile ")) {
                action = 1;
                vData = Collector.resolveMacro(string3.substring("getfile ".length()).trim());
            } else {
                Object object;
                if (string4.startsWith(k_AutoCollect.toLowerCase())) {
                    vData = Collector.resolveMacro(string3.substring(k_AutoCollect.length()).trim());
                    if (vData.equalsIgnoreCase("yes") || vData.equalsIgnoreCase("no")) {
                        po.setDefault(k_AutoCollect, vData);
                        continue;
                    }
                    Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_AUTOCOLL_SPEC", new Object[]{k_AutoCollect, vData, Integer.toString(lineCount[0]), po.getString(k_Inventory)}, "WSST_ERR_COL_INV_AUTOCOLL_SPEC"));
                    continue;
                }
                if (string4.startsWith("getfiles ")) {
                    action = 2;
                    vData = Collector.resolveMacro(string3.substring("getfiles ".length()).trim());
                } else if (string4.startsWith("getfiles-r ")) {
                    action = 3;
                    vData = Collector.resolveMacro(string3.substring("getfiles-r ".length()).trim());
                } else if (string4.startsWith("getfile-p ")) {
                    object = new StringTokenizer(Collector.resolveMacro(string3));
                    if (((StringTokenizer)object).countTokens() < 3) {
                        Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_GETFILE_PW_SPEC", new Object[]{Integer.toString(lineCount[0]), po.getString(k_Inventory)}, "WSST_ERR_COL_INV_GETFILE_PW_SPEC"));
                        continue;
                    }
                    action = 4;
                    vData = Collector.resolveMacro(string3.substring("getfile-p ".length()).trim());
                } else if (string4.startsWith("getdir ")) {
                    action = 5;
                    vData = Collector.resolveMacro(string3.substring("getdir ".length()).trim());
                } else if (string4.startsWith("getdir-r ")) {
                    action = 6;
                    vData = Collector.resolveMacro(string3.substring("getdir-r ".length()).trim());
                } else if (string4.startsWith("exec ")) {
                    action = 7;
                    object = new StringTokenizer(Collector.resolveMacro(string3), " ");
                    if (((StringTokenizer)object).countTokens() < 3) {
                        Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_EXEC_REQ", new Object[]{Integer.toString(lineCount[0]), po.getString(k_Inventory)}, "WSST_ERR_COL_INV_EXEC_REQ"));
                        continue;
                    }
                    ((StringTokenizer)object).nextToken();
                    sExecFile = ((StringTokenizer)object).nextToken().trim();
                    vData = ((StringTokenizer)object).nextToken(string2).trim();
                } else {
                    int n;
                    String string5;
                    String string6;
                    String string7;
                    Object object2;
                    if (string4.startsWith("macro ")) {
                        object = new StringTokenizer(string3, " ");
                        if (((StringTokenizer)object).countTokens() < 3) {
                            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_MACRO_SPEC", new Object[]{Integer.toString(lineCount[0]), po.getString(k_Inventory)}, "WSST_ERR_COL_INV_MACRO_SPEC"));
                            continue;
                        }
                        ((StringTokenizer)object).nextToken();
                        object2 = ((StringTokenizer)object).nextToken().trim().toLowerCase();
                        string7 = ((StringTokenizer)object).nextToken(string2).trim();
                        if (string7.startsWith("{")) {
                            Log.Log(TraceNLS.getStringFromBundle(bundle, "WSST_MSG_COL_USER_QUESTION", "WSST_MSG_COL_USER_QUESTION"));
                            System.out.println();
                            string6 = string7.substring(1);
                            boolean bl2 = true;
                            string5 = null;
                            do {
                                if ((n = string6.indexOf("}")) > -1) {
                                    bl2 = false;
                                    string6 = string6.replace('}', ' ').trim();
                                }
                                if (prompt) {
                                    string5 = TraceNLS.getStringFromBundle(bundle, string6, string6);
                                    System.out.println(string5);
                                    Log.LogRaw(string5);
                                }
                                if (!bl2) continue;
                                string6 = HC1.getNextLogicalLine(lineCount, string, is);
                                if (string6 == null) {
                                    return false;
                                }
                                string6 = string6.trim();
                            } while (bl2);
                            if (prompt) {
                                string7 = po.getKeyBoard(true);
                            } else if (((String)object2).equalsIgnoreCase(k_InstallDir)) {
                                string7 = installDirectory;
                            } else if (((String)object2).equalsIgnoreCase(k_JavaHome)) {
                                string7 = po.getString(k_JavaHome);
                            } else if (((String)object2).equalsIgnoreCase("logroot")) {
                                string7 = logRoot;
                            } else if (((String)object2).equalsIgnoreCase("mqinstallroot")) {
                                string7 = mQRoot;
                            } else if (((String)object2).equalsIgnoreCase("appinstallroot")) {
                                string7 = appInstallRoot;
                            } else if (((String)object2).equalsIgnoreCase("waspropsdir")) {
                                string7 = wasPropsDir;
                            } else if (((String)object2).equalsIgnoreCase("configroot")) {
                                string7 = po.getString(k_ConfigRoot);
                            } else if (((String)object2).equalsIgnoreCase("tranlogroot")) {
                                string7 = tranLogRoot;
                            }
                            Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_USER_REPLY", new Object[]{string7}, "WSST_MSG_COL_USER_REPLY"));
                        }
                        macros.put(object2, string7);
                        continue;
                    }
                    if (string4.startsWith("checkuserid ")) {
                        int n2;
                        object = System.getProperty("user.name");
                        object2 = new StringTokenizer(string3, " ");
                        string7 = null;
                        if (((StringTokenizer)object2).countTokens() < 3) {
                            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_CHK_USER_ID_SPEC", new Object[]{Integer.toString(lineCount[0]), po.getString(k_Inventory)}, "WSST_ERR_COL_INV_CHK_USER_ID_SPEC"));
                            continue;
                        }
                        ((StringTokenizer)object2).nextToken();
                        string6 = ((StringTokenizer)object2).nextToken().trim();
                        if (((String)object).equals(string6)) {
                            String string8 = ((StringTokenizer)object2).nextToken(string2).trim();
                            if (string8.startsWith("{")) {
                                string5 = string8.substring(1);
                                n = 1;
                                do {
                                    if ((n2 = string5.indexOf("}")) > -1) {
                                        n = 0;
                                    }
                                    if (n == 0 || (string5 = HC1.getNextLogicalLine(lineCount, string, is)) != null) continue;
                                    return false;
                                } while (n != 0);
                                continue;
                            }
                            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_CHK_USER_ID_TEXT", new Object[]{Integer.toString(lineCount[0]), po.getString(k_Inventory)}, "WSST_ERR_COL_INV_CHK_USER_ID_TEXT"));
                            continue;
                        }
                        String string9 = ((StringTokenizer)object2).nextToken(string2).trim();
                        if (string9.startsWith("{")) {
                            Log.Log(TraceNLS.getStringFromBundle(bundle, "WSST_MSG_COL_USER_QUESTION", "WSST_MSG_COL_USER_QUESTION"));
                            System.out.println();
                            string5 = string9.substring(1);
                            n = 1;
                            do {
                                if ((n2 = string5.indexOf("}")) > -1) {
                                    n = 0;
                                    string5 = string5.replace('}', ' ').trim();
                                }
                                String string10 = TraceNLS.getStringFromBundle(bundle, string5, string5);
                                System.out.println(string10);
                                Log.LogRaw(string10);
                                if (n == 0) continue;
                                string5 = HC1.getNextLogicalLine(lineCount, string, is);
                                if (string5 == null) {
                                    return false;
                                }
                                string5 = string5.trim();
                            } while (n != 0);
                            String string11 = null;
                            if (!prompt) continue;
                            string11 = po.getKeyBoard(true);
                            Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_USER_REPLY", new Object[]{string11}, "WSST_MSG_COL_USER_REPLY"));
                            continue;
                        }
                        Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_CHK_USER_ID_TEXT", new Object[]{Integer.toString(lineCount[0]), po.getString(k_Inventory)}, "WSST_ERR_COL_INV_CHK_USER_ID_TEXT"));
                        continue;
                    }
                    if (string4.startsWith("jaroutname ")) {
                        po.setDefault(k_JarOutName, Collector.resolveMacro(string3.substring(11).trim()));
                        continue;
                    }
                    if (string4.startsWith("dblocks")) {
                        if (showOnlyDBLocks & prompt) {
                            Collector.showLockInfo();
                            return false;
                        }
                        if (!(showDBLocks & prompt)) continue;
                        Collector.showLockInfo();
                        continue;
                    }
                    if (string4.startsWith(k_Comment.toLowerCase() + " ")) {
                        po.setDefault(k_Comment, Collector.resolveMacro(string3.substring(1 + k_Comment.length()).trim()));
                        continue;
                    }
                    Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_INV_REQ", new Object[]{po.getString(k_Inventory), Integer.toString(lineCount[0])}, "WSST_ERR_COL_INV_INV_REQ"), false);
                    continue;
                }
            }
            if (action == 0) continue;
            bl = false;
        }
        return true;
    }

    static boolean checkPlatform(String string) {
        String string2 = string.replace('[', ' ');
        string2 = string2.replace(']', ' ');
        if ((string2 = string2.trim()).length() == 0) {
            correctPlatform = true;
        } else {
            String string3 = System.getProperty("os.name");
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            correctPlatform = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().trim();
                if (!string4.equalsIgnoreCase(string3)) continue;
                correctPlatform = true;
                break;
            }
        }
        return correctPlatform;
    }

    static String resolveMacro(String string) {
        String string2 = null;
        int n = string.indexOf("$(");
        while (n > -1) {
            int n2 = string.indexOf(")", n);
            if (n2 > -1) {
                String string3 = string.substring(n + 2, n2).toLowerCase();
                string2 = (String)macros.get(string3);
                if (string2 == null) {
                    string2 = System.getProperty(string3);
                }
                if (string2 != null) {
                    string = string.substring(0, n) + string2 + string.substring(n2 + 1);
                    string2 = null;
                }
            }
            if (n2 > 0) {
                n = string.indexOf("$(", n + 1);
                continue;
            }
            n = -2;
        }
        return string;
    }

    static boolean createJarEntry(String string, boolean bl) {
        Object object;
        String string2;
        if (jos == null) {
            jarName = po.getString(k_JarOutName);
            string2 = installDirectory.toLowerCase();
            hostName = "UnknownHost";
            serverType = "Unknown";
            object = null;
            object = new File("BASE.product");
            if (((File)object).exists()) {
                serverType = "BASE";
            } else {
                object = new File("ND.product");
            }
            if (((File)object).exists()) {
                serverType = "ND";
            } else if (string2.endsWith("appserver")) {
                serverType = "BASE";
            } else if (string2.endsWith("deploymentmanager")) {
                serverType = "ND";
            } else {
                int n;
                int n2 = string2.indexOf(System.getProperty("file.separator"));
                serverType = n2 < 0 ? string2 : (string2.substring((n = string2.lastIndexOf(System.getProperty("file.separator"))) + 1).regionMatches(0, "appserver", 0, "appserver".length()) ? "BASE" : (string2.substring(n + 1).regionMatches(0, "deploymentmanager", 0, "deploymentmanager".length()) ? "ND" : string2.substring(n2)));
                serverType = serverType.replace(' ', '-');
                serverType = serverType.replace(':', '-');
                serverType = serverType.replace('?', '-');
                serverType = serverType.replace('/', '-');
                if ((serverType = serverType.replace('\\', '-')).length() > 20) {
                    serverType = serverType.substring(0, 10) + serverType.substring(serverType.length() - 10, serverType.length());
                }
            }
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                hostName = wasNode.trim();
            }
            catch (SecurityException securityException) {
                hostName = wasNode.trim();
            }
            if (jarName == null | jarName.equals("") | jarName.equals(defaultJarName)) {
                jarName = hostName.trim() + "-" + serverType + "-" + defaultJarName;
            }
            if (jarName.length() > 50) {
                jarName = jarName.substring(0, 24) + "-" + jarName.substring(jarName.length() - 25, jarName.length());
                jarName = jarName.replace('/', '-');
                jarName = jarName.replace('\\', '-');
            }
            Manifest manifest = Collector.buildManifest();
            jos = Collector.CreateJarStream(jarName, manifest);
            jos.setLevel(po.getInt(k_Compression));
        }
        if ((string2 = string.replace('\\', '/').trim()).substring(1, 2).equals(":")) {
            string2 = "Drive_" + string2.substring(0, 1) + "/" + string2.substring(3);
        } else if (string2.startsWith("/")) {
            string2 = "root" + string2.substring(0);
        }
        hostNameDir = hostName + "-" + serverType + "/";
        object = new JarEntry(hostNameDir + string2);
        try {
            jos.putNextEntry((ZipEntry)object);
        }
        catch (IOException iOException) {
            if (!bl) {
                Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_CANT_ADD_JAR_ENTRY", new Object[]{string2}, "WSST_ERR_COL_CANT_ADD_JAR_ENTRY"), iOException, false);
            }
            return false;
        }
        return true;
    }

    static JarOutputStream CreateJarStream(String string, Manifest manifest) {
        try {
            jarFile = new File(string);
            if (!jarFile.exists()) {
                jarFile.createNewFile();
            }
            return new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_JAR_NOT_FOUND", new Object[]{string}, "WSST_ERR_COL_JAR_NOT_FOUND"), fileNotFoundException, true);
        }
        catch (IOException iOException) {
            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_JAR_IOEXCEPT", new Object[]{string}, "WSST_ERR_COL_JAR_IOEXCEPT"), iOException, true);
        }
        return null;
    }

    static void closeJarStream() {
        if (jos == null) {
            return;
        }
        try {
            jos.close();
        }
        catch (IOException iOException) {
            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_CLOSING_JAR", new Object[]{absoluteDirectoryPath + jarName}, "WSST_ERR_COL_CLOSING_JAR"), iOException, true);
        }
        jos = null;
    }

    static FileInputStream OpenInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_CANT_OPEN_FILE", new Object[]{file.toString()}, "WSST_ERR_COL_CANT_OPEN_FILE"), iOException, true);
            return null;
        }
    }

    static Manifest buildManifest() {
        Object object;
        Manifest manifest = null;
        if (po.getString(k_ManifestFile) != null) {
            try {
                object = new FileInputStream(po.getString(k_ManifestFile));
                manifest = new Manifest((InputStream)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_NO_INPUT_MANIFEST_FILE", new Object[]{po.getString(k_ManifestFile)}, "WSST_ERR_COL_NO_INPUT_MANIFEST_FILE"), fileNotFoundException, true);
            }
            catch (IOException iOException) {
                Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_IOEXCEPTION_MANIFEST_FILE", new Object[]{po.getString(k_ManifestFile)}, "WSST_ERR_COL_IOEXCEPTION_MANIFEST_FILE"), iOException, true);
            }
        } else {
            manifest = new Manifest();
        }
        object = manifest.getMainAttributes();
        ((Attributes)object).putValue(Attributes.Name.MANIFEST_VERSION.toString(), po.getString(k_mfVersion));
        ((Attributes)object).putValue("Created-By", "Collector");
        ((Attributes)object).putValue("TimeStamp", Log.CurrentTimeStamp());
        if (po.getString(k_mfMainClass) != null) {
            ((Attributes)object).putValue(Attributes.Name.MAIN_CLASS.toString(), po.getString(k_mfMainClass));
        }
        return manifest;
    }

    static boolean ProcessOptions(String[] stringArray) {
        String string = HC1.isCaseSensitive() ? "true" : "false";
        String string2 = Collector.determineSourcePath();
        String[] stringArray2 = new String[]{TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_NO_OUT_JAR1", "WSST_ERR_COL_NO_OUT_JAR1"), TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_NO_OUT_JAR1", "WSST_ERR_COL_NO_OUT_JAR2")};
        String[] stringArray3 = new String[]{TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_NO_INV_FILE1", "WSST_ERR_COL_NO_INV_FILE1"), TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_NO_INV_FILE2", "WSST_ERR_COL_NO_INV_FILE2")};
        logFileName = currentDirectoryPath.endsWith(fileSep) || currentDirectoryPath.endsWith("/") ? currentDirectoryPath + "Collector.log" : currentDirectoryPath + fileSep + "Collector.log";
        PODef[] pODefArray = new PODef[]{new PODef(k_Version, "Boolean", "false"), new PODef(k_Debug, "Boolean", "false"), new PODef(k_Help, "BuiltInHelp", "false"), new PODef(k_LogFileName, "OutFileAny", logFileName), new PODef(k_Verbosity, "Int", "3"), new PODef(k_PropertyFile, "Validating", null), new PODef(k_ScratchFile, "String", "SCRATCH"), new PODef(k_Compression, "int", "9"), new PODef(k_Inventory, "InFile", string2, stringArray3), new PODef(k_JarOutName, "OutFileAny", null, stringArray2), new PODef(k_Comment, "String", null), new PODef(k_CaseSensitive, "Boolean", string), new PODef(k_AutoCollect, "Boolean", "true"), new PODef(k_ManifestFile, "InFile", null), new PODef(k_mfMainClass, "String", null), new PODef(k_mfVersion, "String", "1.0"), new PODef(k_AidInventory, "Boolean", "false"), new PODef(k_Test, "Boolean", "false"), new PODef(k_Prompt, "Boolean", "false"), new PODef(k_InstallDir, "String", defaultInstallDir), new PODef(k_ShowDBLocks, "Boolean", "false"), new PODef(k_ShowOnlyDBLocks, "Boolean", "false"), new PODef(k_JavaHome, "String", defaultJavaHome), new PODef(k_ConfigRoot, "String", null), new PODef(k_WasNode, "String", "NoNodeName"), new PODef(k_CellName, "String", "NoCellName"), new PODef(k_ServerName, "String", null), new PODef(k_Summary, "Boolean", "false"), new PODef(k_NoSamples, "Boolean", "false"), new PODef(k_IncludeInstalledApps, "Boolean", "false")};
        po = new POProcessor(pODefArray, stringArray, null);
        debug = po.getBool(k_Debug);
        verbosity = po.getInt(k_Verbosity);
        prompt = po.getBool(k_Prompt);
        showDBLocks = po.getBool(k_ShowDBLocks);
        showOnlyDBLocks = po.getBool(k_ShowOnlyDBLocks);
        wasNode = po.getString(k_WasNode);
        cellName = po.getString(k_CellName);
        summary = po.getBool(k_Summary);
        noSamples = po.getBool(k_NoSamples);
        includeInstalledApps = po.getBool(k_IncludeInstalledApps);
        if (po.getBool(k_Help)) {
            Collector.OnLineHelp();
            return false;
        }
        if (po.getBool(k_Version)) {
            Collector.DisplayVersion(po);
            return false;
        }
        if (po.getBool(k_AidInventory)) {
            return false;
        }
        if (po.getString(k_LogFileName) != null) {
            Collector.RecycleLog();
        }
        if (Collector.po.errorCount > 0) {
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_COMMAND_OPTIONS", new Object[]{Integer.toString(Collector.po.errorCount)}, "WSST_ERR_COL_COMMAND_OPTIONS"));
            Log.Close();
            System.exit(8);
        }
        installDirectory = po.getString(k_InstallDir);
        configDirectory = po.getString(k_ConfigRoot);
        serverName = po.getString(k_ServerName);
        Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_COLLECTOR_VERSION", new Object[]{pgmVersion}, "WSST_MSG_COL_COLLECTOR_VERSION"));
        if (!summary) {
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_LOG_FILE", new Object[]{po.getString(k_LogFileName)}, "WSST_MSG_COL_LOG_FILE"));
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_CASE_SENSITIVE", new Object[]{po.getString(k_CaseSensitive)}, "WSST_MSG_COL_CASE_SENSITIVE"));
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_INVENTORY_FILE", new Object[]{po.getString(k_Inventory)}, "WSST_MSG_COL_INVENTORY_FILE"));
        }
        return true;
    }

    static String determineSourcePath() {
        String string = null;
        Class<?> clazz = new Collector().getClass();
        String string2 = clazz.getName();
        ClassLoader classLoader = clazz.getClassLoader();
        URL uRL = classLoader.getResource((string2 = string2.replace('.', '/')) + ".class");
        if (uRL == null) {
            Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_CANT_FIND_URL", "WSST_ERR_COL_CANT_FIND_URL"));
        } else {
            int n;
            String string3 = uRL.toString();
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_URL", new Object[]{string3}, "WSST_MSG_COL_URL"));
            if (string3.startsWith("jar:") && (n = string3.indexOf("!")) > 0) {
                int n2 = 9;
                if (System.getProperty("os.arch").equals("x86") && !System.getProperty("os.name").equalsIgnoreCase("Linux")) {
                    n2 = 10;
                }
                string = string3.substring(n2, n);
            }
        }
        return string;
    }

    static void RecycleLog() {
        Log.Close();
        Log = new Logger(po.getString(k_LogFileName), true, verbosity);
        Log.Open();
        HC1 = new Helper1(Log, verbosity);
    }

    static void DisplayVersion(POProcessor pOProcessor) {
        ExecCmd execCmd = new ExecCmd();
        Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_SYS_ARCH", new Object[]{System.getProperties().getProperty("os.arch")}, "WSST_MSG_COL_SYS_ARCH"));
        Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_OS_NAME", new Object[]{System.getProperties().getProperty("os.name")}, "WSST_MSG_COL_OS_NAME"));
        Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_JAVA_VERSION", new Object[]{System.getProperties().getProperty("java.version")}, "WSST_MSG_COL_JAVA_VERSION"));
        Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_COLLECTOR_VERSION", new Object[]{pgmVersion}, "WSST_MSG_COL_COLLECTOR_VERSION"));
        Object[] objectArray = new Object[1];
        objectArray[0] = "05.00.00";
        Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_HELPER1_VERSION", objectArray, "WSST_MSG_COL_HELPER1_VERSION"));
        Object[] objectArray2 = new Object[1];
        objectArray2[0] = "05.00.00";
        Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_LOGGER_VERSION", objectArray2, "WSST_MSG_COL_LOGGER_VERSION"));
        Object[] objectArray3 = new Object[1];
        objectArray3[0] = "05.00.00";
        Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_CMD_PROPS_OPTIONS_VERSION", objectArray3, "WSST_MSG_COL_CMD_PROPS_OPTIONS_VERSION"));
        Object[] objectArray4 = new Object[1];
        objectArray4[0] = "05.00.00";
        Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_EXEC_CMD_VERSION", objectArray4, "WSST_MSG_COL_EXEC_CMD_VERSION"));
    }

    private static void getSummary() {
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        String string = "Collector_Summary.txt";
        PrintWriter printWriter = null;
        boolean bl = System.getProperty("os.name").equals("OS/400");
        try {
            Object object;
            printWriter = new PrintWriter(new FileWriter(string, false));
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                hostName = wasNode.trim();
            }
            catch (SecurityException securityException) {
                hostName = wasNode.trim();
            }
            if (!bl) {
                System.setProperty("was.install.root", installDirectory);
            }
            String string2 = System.getProperty("was.install.root");
            System.out.println("Hostname: " + hostName + "   Nodename: " + wasNode);
            printWriter.println("Hostname: " + hostName + "   Nodename: " + wasNode);
            VersionInfo versionInfo = new VersionInfo();
            String string3 = null;
            try {
                versionInfo.runReport("TEXT", string3);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                versionInfo.runReport("TEXT", string);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            printWriter.flush();
            printWriter.close();
            printWriter = new PrintWriter(new FileWriter(string, true));
            System.out.println(" ");
            printWriter.println(" ");
            String string4 = bl ? System.getProperty("java.version") : System.getProperty("java.fullversion");
            System.out.println("Java Full Version: ");
            System.out.println(string4);
            printWriter.println("Java Full Version: ");
            printWriter.println(string4);
            System.out.println(" ");
            printWriter.println(" ");
            String string5 = System.getProperty("os.name");
            String string6 = System.getProperty("os.version");
            printWriter.println("Operating System: " + string5 + ", " + string6);
            System.out.println("Operating System: " + string5 + ", " + string6);
            boolean bl2 = true;
            boolean bl3 = false;
            boolean bl4 = false;
            ExecCmd execCmd = new ExecCmd(bl2);
            Vector vector = new Vector();
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = new String[1];
            System.out.println(" ");
            printWriter.println(" ");
            int n = 0;
            Enumeration enumeration = null;
            boolean bl5 = true;
            if (bl && !((File)(object = new File("/QSYS.LIB/QMQM.LIB/MQVER.PGM"))).exists()) {
                bl5 = false;
            }
            if (bl5) {
                stringArray[0] = !bl ? "mqver" : "/QSYS.LIB/QMQM.LIB/MQVER.PGM";
                n = execCmd.Execute(stringArray, bl3, bl4, stringBuffer, vector);
                if (888 == n || 1 == n) {
                    Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_EXECUTE_ERROR", new Object[]{stringBuffer.toString()}, "WSST_ERR_COL_EXECUTE_ERROR"));
                    stringBuffer.delete(0, stringBuffer.length());
                }
                Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_EXECUTE_RC", new Object[]{Integer.toString(n)}, "WSST_MSG_COL_EXECUTE_RC"));
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    if (((String)object).indexOf("001-0014") >= 0) {
                        printWriter.println("Command MQVER not found. MQ most likely is not installed.");
                        System.out.println("Command MQVER not found. MQ most likely is not installed.");
                        break;
                    }
                    printWriter.println((String)object);
                    System.out.println((String)object);
                }
                vector.clear();
                stringArray[0] = !bl ? "wempsservice" : System.getProperty("was.wemps.root") + "/bin/wempsservice";
                n = execCmd.Execute(stringArray, bl3, bl4, stringBuffer, vector);
                if (888 == n || 1 == n) {
                    Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_EXECUTE_ERROR", new Object[]{stringBuffer.toString()}, "WSST_ERR_COL_EXECUTE_ERROR"));
                    stringBuffer.delete(0, stringBuffer.length());
                }
                Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_EXECUTE_RC", new Object[]{Integer.toString(n)}, "WSST_MSG_COL_EXECUTE_RC"));
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    if (((String)object).indexOf("001-0078") >= 0) {
                        printWriter.println("Command wempsservice failed. WEMPS or MQ most likely not installed.");
                        System.out.println("Command wempsservice failed. WEMPS or MQ most likely not installed.");
                        break;
                    }
                    printWriter.println((String)object);
                    System.out.println((String)object);
                }
                vector.clear();
            } else {
                printWriter.println("WebSphere MQ product is not installed.");
                System.out.println("WebSphere MQ product is not installed.");
            }
            Locale.setDefault(locale);
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_LOG_FILE_CANT_OPEN", new Object[]{string, iOException.getMessage()}, "WSST_ERR_LOG_FILE_CANT_OPEN"));
            printWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void showLockInfo() {
        var0 = null;
        var1_1 = null;
        var2_2 = null;
        var3_3 = null;
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        var7_7 = null;
        var8_8 = null;
        var9_9 = null;
        try {
            var10_10 /* !! */  = null;
            if (Collector.prompt != true) return;
            System.out.println("\n");
            System.out.println(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_DB_LOCK_INFO_MSG001", ">At any prompt for database information, hit enter to stop collecting database lock information."));
            System.out.println(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_DB_LOCK_INFO_DBTYPE", "Enter the type of the database."));
            System.out.println(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_DB_LOCK_INFO_TYPES", "Valid database types are: DB2, Oracle, Sybase, Informix, DB2j, SQLServer, SQLServer3, SQLServer4."));
            var0 = Collector.po.getKeyBoard(false);
            if (var0 == null) return;
            if (var0.equals("")) {
                return;
            }
            var11_12 = new Properties();
            if (var0.equalsIgnoreCase("Db2")) {
                System.out.println(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_DB_LOCK_INFO_DB2DIR", ">Enter the directory where db2cmd.exe is installed (for example, C:\\SQLLIB\\bin\\."));
                var1_1 = Collector.po.getKeyBoard(false);
                if (var1_1 == null) return;
                if (var1_1.equals("")) {
                    return;
                }
                var11_12.setProperty("db2Install", var1_1);
                var3_3 = "db2lockinfo.txt";
                var12_13 = new File(var3_3);
                try {
                    var13_15 = var12_13.createNewFile();
                }
                catch (IOException var13_16) {
                    Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_DB_LOCK_INFO_IO_ERROR", "Input or output error creating db2 temporary file"), var13_16, false);
                    return;
                }
                var11_12.setProperty("outputFile", var3_3);
                var13_17 = System.getProperty("user.dir");
                var11_12.setProperty("workingDir", (String)var13_17);
                System.out.println(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_DB_LOCK_INFO_DBNAME", "Enter the database name."));
                var2_2 = Collector.po.getKeyBoard(false);
                if (var2_2 == null) return;
                if (var2_2.equals("")) {
                    return;
                }
                var11_12.setProperty("databaseName", var2_2);
                Collector.Log.Log(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_DB_LOCK_INFO_PROPS", new Object[]{var11_12}, "DB Lock Info Helper Properties: "));
                try {
                    var10_10 /* !! */  = new DB2DataStoreHelper(var11_12);
                    var9_9 = ((DB2DataStoreHelper)var10_10 /* !! */ ).showLockInfo(var11_12);
                }
                catch (Exception var14_18) {
                    Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_DB_LOCK_INFO_DSH_FAILURE", "DataStore Helper create failure"), var14_18, false);
                    return;
                }
            }
            if (var0.equalsIgnoreCase("oracle")) {
                System.out.println(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_DB_LOCK_INFO_ORACLE_DRIVER", ">For Oracle, thin driver type is assumed."));
                if (!Collector.getDBConnectInfo(var11_12, var4_4, var5_5, var6_6, var7_7)) {
                    return;
                }
                System.out.println(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_DB_LOCK_INFO_DBNAME", "Enter the database name."));
                var2_2 = Collector.po.getKeyBoard(false);
                if (var2_2 == null) return;
                if (var2_2.equals("")) {
                    return;
                }
                var11_12.setProperty("databaseName", var2_2);
                var11_12.setProperty("driverType", "thin");
                var10_10 /* !! */  = new OracleDataStoreHelper(null);
                var9_9 = ((OracleDataStoreHelper)var10_10 /* !! */ ).showLockInfo(var11_12);
            } else if (var0.equalsIgnoreCase("sybase")) {
                if (!Collector.getDBConnectInfo(var11_12, var4_4, var5_5, var6_6, var7_7)) {
                    return;
                }
                System.out.println(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_DB_LOCK_INFO_DBNAME", "Enter the database name."));
                var2_2 = Collector.po.getKeyBoard(false);
                if (var2_2 == null) return;
                if (var2_2.equals("")) {
                    return;
                }
                var11_12.setProperty("databaseName", var2_2);
                var10_10 /* !! */  = new SybaseDataStoreHelper(var11_12);
                var9_9 = ((SybaseDataStoreHelper)var10_10 /* !! */ ).showLockInfo(var11_12);
            } else if (var0.equalsIgnoreCase("informix")) {
                var10_10 /* !! */  = new InformixDataStoreHelper(var11_12);
                var9_9 = var10_10 /* !! */ .showLockInfo(var11_12);
            } else if (var0.equalsIgnoreCase("db2j")) {
                System.out.println(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_DB_LOCK_INFO_DBNAME", "Enter the database name."));
                var2_2 = Collector.po.getKeyBoard(false);
                if (var2_2 == null) return;
                if (var2_2.equals("")) {
                    return;
                }
                var11_12.setProperty("databaseName", var2_2);
                var10_10 /* !! */  = new CloudscapeDataStoreHelper(var11_12);
                var9_9 = ((CloudscapeDataStoreHelper)var10_10 /* !! */ ).showLockInfo(var11_12);
            } else if (var0.equalsIgnoreCase("sqlserver")) {
                if (!Collector.getDBConnectInfo(var11_12, var4_4, var5_5, var6_6, var7_7)) {
                    return;
                }
                var10_10 /* !! */  = new MSSQLDataStoreHelper(var11_12);
                var9_9 = ((MSSQLDataStoreHelper)var10_10 /* !! */ ).showLockInfo(var11_12);
            } else if (var0.equalsIgnoreCase("sqlserver3")) {
                if (!Collector.getDBConnectInfo(var11_12, var4_4, var5_5, var6_6, var7_7)) {
                    return;
                }
                var11_12.setProperty("driverType", "3");
                System.out.println("       SqlServer type3:  The props are: " + var11_12);
                var10_10 /* !! */  = new MSSQLDataStoreHelper(var11_12);
                var9_9 = ((MSSQLDataStoreHelper)var10_10 /* !! */ ).showLockInfo(var11_12);
            } else if (var0.equalsIgnoreCase("sqlserver4")) {
                if (!Collector.getDBConnectInfo(var11_12, var4_4, var5_5, var6_6, var7_7)) {
                    return;
                }
                var11_12.setProperty("driverType", "4");
                var10_10 /* !! */  = new MSSQLDataStoreHelper(var11_12);
                var9_9 = ((MSSQLDataStoreHelper)var10_10 /* !! */ ).showLockInfo(var11_12);
            } else {
                System.out.println("* Generic *");
                var10_10 /* !! */  = new GenericDataStoreHelper(var11_12);
                var9_9 = ((GenericDataStoreHelper)var10_10 /* !! */ ).showLockInfo(var11_12);
            }
            try {
                block61: {
                    block62: {
                        block60: {
                            if (Collector.createJarEntry("dblockinfo/" + var0 + "/" + var2_2, false)) break block60;
                            var25_21 = null;
                            ** GOTO lbl232
                        }
                        var12_13 = new StringBuffer(var0 + " " + "\n");
                        if (!var0.equalsIgnoreCase("db2")) break block61;
                        var13_17 = new File(var3_3);
                        var14_19 = Collector.OpenInputStream((File)var13_17);
                        if (var14_19 != null) break block62;
                        ** GOTO lbl238
                    }
                    var15_31 = new byte[4096];
                    try {
                        while ((var16_32 = var14_19.read(var15_31)) != -1) {
                            Collector.jos.write(var15_31, 0, var16_32);
                        }
                        var19_33 = null;
                        ** GOTO lbl-1000
                    }
                    catch (IOException var17_39) {
                        Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_LOCK_INFO_ERROR_READING_FILE_OR_WRITING_JAR", "WSST_LOCK_INFO_ERROR_READING_FILE_OR_WRITING_JAR"), var17_39, true);
                        var19_34 = null;
                        try {
                            var14_19.close();
                            Collector.jos.closeEntry();
                        }
                        catch (IOException var20_37) {
                            Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_LOCK_INFO_ERROR_CLOSING_FILE_OR_JAR", new Object[]{var13_17.toString()}, "WSST_LOCK_INFO_ERROR_CLOSING_FILE_OR_JAR"), var20_37, true);
                        }
                        ** GOTO lbl245
                    }
                    {
                        catch (Throwable var18_40) {
                            var19_35 = null;
                            ** try [egrp 7[TRYBLOCK] [6 : 1184->1198)] { 
lbl167:
                            // 1 sources

                            var14_19.close();
                            Collector.jos.closeEntry();
                            throw var18_40;
lbl170:
                            // 1 sources

                            catch (IOException var20_38) {
                                Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_LOCK_INFO_ERROR_CLOSING_FILE_OR_JAR", new Object[]{var13_17.toString()}, "WSST_LOCK_INFO_ERROR_CLOSING_FILE_OR_JAR"), var20_38, true);
                            }
                            throw var18_40;
                        }
lbl-1000:
                        // 1 sources

                        try {}
                        catch (IOException var20_36) {}
                        Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_LOCK_INFO_ERROR_CLOSING_FILE_OR_JAR", new Object[]{var13_17.toString()}, "WSST_LOCK_INFO_ERROR_CLOSING_FILE_OR_JAR"), var20_36, true);
                        ** GOTO lbl245
                        var14_19.close();
                        Collector.jos.closeEntry();
                    }
                }
                var13_17 = var12_13.toString().getBytes();
                try {
                    Collector.jos.write((byte[])var13_17, 0, ((Object)var13_17).length);
                }
                catch (IOException var14_20) {
                    Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_LOCK_INFO_WRITE_JAR_ERROR", "Error trying to write lock info to jar"), var14_20, true);
                    var22_42 = null;
                    try {
                        Collector.jos.closeEntry();
                    }
                    catch (IOException var23_45) {
                        Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, ""), var23_45, true);
                    }
                    ** GOTO lbl245
                }
                var22_41 = null;
                {
                    catch (Throwable var21_47) {
                        var22_43 = null;
                        ** try [egrp 10[TRYBLOCK] [11 : 1302->1311)] { 
lbl202:
                        // 1 sources

                        Collector.jos.closeEntry();
                        throw var21_47;
lbl204:
                        // 1 sources

                        catch (IOException var23_46) {
                            Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, ""), var23_46, true);
                        }
                        throw var21_47;
                    }
                    try {}
                    catch (IOException var23_44) {}
                    Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, ""), var23_44, true);
                    ** GOTO lbl245
                    Collector.jos.closeEntry();
                }
            }
            catch (Exception var12_14) {
                Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_LOCK_INFO_OBTAIN_ERROR", "Error trying to obtain lock info"), var12_14, false);
                var25_24 = null;
                try {
                    Collector.jos.closeEntry();
                    return;
                }
                catch (IOException var26_29) {
                    Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_LOCK_INFO_JAR_CLOSE", "Error trying to close jar for show db locks"), var26_29, false);
                }
                return;
            }
            {
                catch (Throwable var24_48) {
                    var25_25 = null;
                    ** try [egrp 11[TRYBLOCK] [20 : 1375->1384)] { 
lbl227:
                    // 1 sources

                    Collector.jos.closeEntry();
                    throw var24_48;
lbl229:
                    // 1 sources

                    catch (IOException var26_30) {
                        Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_LOCK_INFO_JAR_CLOSE", "Error trying to close jar for show db locks"), var26_30, false);
                    }
                    throw var24_48;
                }
lbl232:
                // 1 sources

                ** try [egrp 11[TRYBLOCK] [20 : 1375->1384)] { 
lbl233:
                // 1 sources

                Collector.jos.closeEntry();
                return;
lbl235:
                // 1 sources

                catch (IOException var26_26) {
                    Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_LOCK_INFO_JAR_CLOSE", "Error trying to close jar for show db locks"), var26_26, false);
                }
                return;
lbl238:
                // 1 sources

                var25_22 = null;
                ** try [egrp 11[TRYBLOCK] [20 : 1375->1384)] { 
lbl240:
                // 1 sources

                Collector.jos.closeEntry();
                return;
lbl242:
                // 1 sources

                catch (IOException var26_27) {
                    Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_LOCK_INFO_JAR_CLOSE", "Error trying to close jar for show db locks"), var26_27, false);
                }
                return;
lbl245:
                // 8 sources

                var25_23 = null;
                try {}
                catch (IOException var26_28) {}
                Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_LOCK_INFO_JAR_CLOSE", "Error trying to close jar for show db locks"), var26_28, false);
                return;
                Collector.jos.closeEntry();
                return;
            }
        }
        catch (Throwable var10_11) {
            Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_DB_LOCK_INFO_THROWABLE", "Error trying to get lock information, make sure the Collector tool is running on a server image."), var10_11);
        }
    }

    private static boolean getDBConnectInfo(Properties properties, String string, String string2, String string3, String string4) {
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_USERID", "Enter a user id that has permission to access the database."));
        string = po.getKeyBoard(false);
        if (string == null || string.equals("")) {
            return false;
        }
        properties.setProperty("user", string);
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_USERPW", "Enter a password for the user id."));
        string2 = po.getKeyBoard(false);
        if (string2 == null || string2.equals("")) {
            return false;
        }
        properties.setProperty("password", string2);
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_SERVER_NAME", "Enter server name on which the database is installed (for example, testsrv1.site1.company.com."));
        string3 = po.getKeyBoard(false);
        if (string3 == null || string3.equals("")) {
            return false;
        }
        properties.setProperty("serverName", string3);
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_PORT_NUMBER", "Enter port number to access the database (for example, 1521."));
        string4 = po.getKeyBoard(false);
        if (string4 == null || string4.equals("")) {
            return false;
        }
        properties.setProperty("portNumber", string4);
        return true;
    }

    private static void OnLineHelp() {
        System.out.println("\n   Collector.java                Version " + pgmVersion);
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG001", ">This program is intended to collect selected data from the computer"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG002", "upon which it is executed.  Control parameters consist of command line"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG003", "arguments and an Inventory file which specifies which data is to be"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG004", "collected.  Several items are automatically included which include:"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG005", "this program's log file and all the Java system properties.  When the"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG006", "same parameter may appear in both the command line and the inventory"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG007", "file, the command line takes precedence."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG008", "Command line syntax is:"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0086", "collector (simple) "));
        System.out.println("\n");
        System.out.println("\n");
    }

    private static void InventoryHelp() {
        System.out.println("\n   Collector.java                Version " + pgmVersion);
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0001", ">The inventory file describes what data to collect and insert into the output"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0002", "jar file.  Data items include files, directories and the results of commands"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0003", "executed.  Entries within the inventory file consist of two groups, options and"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0004", "requests.  The options must precede the requests.  The entries specified in the"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0005", "inventory file may be limited by platform.  Only one entry may be made per"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0006", "line.  Macros may be defined and used throughout."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0007", "A comment identifier may be specified by inclusion of a # or ! or * or // as"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0008", "the first non-white space data on the first line.  Thereafter, any line starting"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0009", "with the comment identifier or the apperance of a blank followed by the comment"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0010", "identifier will cause all data starting with the comment identifier to the"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0011", "end-of-line to be discarded."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0012", "Any non-comment line may be continued at any place.  There are two types of"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0013", "continuations: A comma as the last non-white space character will cause the"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0014", "next line to be concatenated and the comma to be preserved.  A hyphen will cause"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0015", "the next line to be appended and the hyphen to be replaced by the first non-white"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0016", "character of the next line."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0017", "The format of entries varies with the specific entry being made.  All entries are"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0018", "case insensitive."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0019", "Options:"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0020", "JarOutName  <jarName>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0021", "Where <jarName> is the output jar file name."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0022", "Comment  <comment>"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0023", "Where <comment> is text that will be printed in the log.  This is useful"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0024", "for example, for relating a particular inventory file to a Collector"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0025", "output jar file."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0026", "AutoCollect yes/no"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0027", "Whether to collect the BuildIn items which include the JVM properties and"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE__INVHELP_MSG0028", "the collector log."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0029", "Macro  <macroName>  <macroValue>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0030", "Macros may be used throughout the inventory file.  To"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0031", "invoke the macro, code the macro name inside the parenthesis"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0032", "in \"$()\", for example, $(macroName).  Macro resolution will"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0033", "first inspect if a local definition has been given.  If it"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0034", "hasn't, then an attempt will be made to extract the information"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0035", "from the environment.  If the macro value starts with a \"{\","));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0036", "then this will indicate a question to be asked of the user"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0037", "and the reply will be assigned to the macroName.  Once a \"{\""));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0038", "has been recognized, the inventory file will be scanned until"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0039", "the closing \"}\" is found.  Everything in between will be taken as"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0040", "the question."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0041", "CheckUserId  <user-id>  {<text>}"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0042", "Specifies that the user id executing Collector should be <user-id>."));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0043", "If it is, execution continues.  If it's not, <text> is displayed"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0044", "and the user is given the option to continue or exit."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0045", "[ <platform_list> ]"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0046", "The square bracket indicates the following options or requests"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0047", "are only to be included if the current operating system matches"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0048", "the specification within the brackets.  The <platform_List> is"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0049", "a comma delimited list and the entries must match"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0050", "(case sensitive) to the value return by the java getSystem"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0051", "property(os.name).  No blanks are allowed within the list except"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0052", "as part of the OS name.  To determine the current OS name, execute"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0053", "this program with the -Version option to reveal this value."));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0054", "Entering \"[]\" will reset the platform restriction.  This option"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0055", "may appear throughout the inventory file."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0056", "Requests:"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0057", "GetFile  <file-spec>"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0058", "Include this file where <file-spec> is a directory path and file"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0059", "name."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0060", "GetFiles  <directory>/<file-spec>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0061", "Where <directory> is the full path name of a directory and"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0062", "<file-spec> is a file specification that may include the wild"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0063", "card \"*\".  For example:"));
        System.out.println("\t\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0064", "$(InstallDir)/logs/trace*"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0065", "will collect all files that begin with \"trace\" in the"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0066", "$(InstallDir)/logs directory."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0067", "GetFiles-R  <directory>/<file-spec>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0068", "Same as the GetFiles request with the exception that this"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0069", "request is recursive.  For example:"));
        System.out.println("\t\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0070", "$(InstallDir)/logs/trace*"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0071", "will collect all files that begin with \"trace\" in the"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0072", "$(InstallDir)/logs directory and all directories under logs."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0073", "GetFile-P  <string>  <directory>/<file-spec>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0074", "Same as the GetFile request except that the file is copied"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0075", "to <file-spec>.P, any passwords in the file (identified by"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0076", "<string> are changed to \"*\", For example:"));
        System.out.println("\t\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0077", "Password=abc -> Password=***"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0078", "and the <file-spec>.P file is collected.  The <string>"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0079", "specifies the a string of characters that preceeds the"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0080", "password.  The <string> may contain blanks in which case"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0081", "it should be surrounded by single or double quotes.  For"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0082", "example:"));
        System.out.println("\t\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0083", "GetFile-P  Password=      foo.config"));
        System.out.println("\t\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0084", "GetFile-P  \"pass word =\"  bar.config"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0085", "All characters on the line following the <string> are"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0086", "considered to be part of the password and each will be"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0087", "changed to an asterisk."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0088", "GetDir  <directory>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0089", "Where <directory> is the full path name of a directory."));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0090", "GetDir is just a special case of GetFiles, for example, the"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0091", "following are equivalent:"));
        System.out.println("\n");
        System.out.println("\t\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0092", "GetDir    $(InstallDir)/logs"));
        System.out.println("\t\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0093", "GetFiles  $(InstallDir)/logs/*"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0094", "GetDir-R  <directory>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0095", "Same as the GetDir request with the exception that this"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0096", "request is recursive."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0097", "Exec  <file-spec>  <[QUIET] command...>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0098", "Where <command...> is a comma delimited list of commands to execute"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0099", "and <file-spec> is the directory path and file name in the output jar file"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0100", "in which to put the output of the command.  The default behavior is"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0101", "to write the command to the output stream followed by its stdout and"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0102", "stderr output.  If the command is preceeded by the word QUIET, only"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0103", "the command output will be written to the output stream.  In addition,"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0104", "all the output of the Exec request, the command and its stdout and"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0105", "stderr, can be surpressed if the <file-spec> has the value SCRATCH."));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0106", "This value can be changed with the -ScratchFile option of the"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0107", "Collector program."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0108", "Sample File:"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0109", "Macro InstallDir  { }"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0111", "Macro Name Value"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0112", "JarOutName Test3.jar"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0113", "[Windows 2000,Windows NT, Windows XP]"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0114", "GetFile      C:/Temp$$1.Bat"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0115", "GetFiles-R   F:/Temp/*.tmp"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0116", "GetFile-P    D:/Temp/server.properties"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0117", "Exec   /Drive_C/$(Frog)      dir C:/Temp"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0118", "Exec   /Drive_D/DirOfDTemp   dir D:/Temp, dir G:/"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0119", "[AIX,Solaris,Sun OS,HP-UX]"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0120", "GetFile    /usr/special/Downloads/jikes/Debug.Zip"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0121", "Exec   OS/name               uname -a"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0122", "[]"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0123", "GetDir       $(InstallDir)/logs"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0124", "[AIX]"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0125", "Exec   /usr/system/          ls -r /usr/applications"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0126", "[]"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0127", "GetFiles     $(InstallDir)/bin/*.config"));
        System.out.println("\n");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        logRoot = null;
        mQRoot = null;
        wasPropsDir = null;
        appInstallRoot = null;
        tranLogRoot = null;
        serviceLogName = null;
        traceLogName = null;
        userInstallRoot = null;
        repository = null;
        logFileName = null;
        summary = false;
        noSamples = false;
        includeInstalledApps = false;
        exitRC = 0;
        macros = new Hashtable();
        objectsGathered = 0;
        jos = null;
        jarFile = null;
        hostName = null;
        serverType = null;
        jarName = null;
        bundle = "com.ibm.websphere.rastools.collector.CollectorMessages";
        fileSep = System.getProperty("file.separator");
        is = null;
        correctPlatform = true;
        lineCount = new int[]{0};
    }
}

