/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rastools.collector;

import com.ibm.ejs.ras.TraceNLS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

class ExecCmd
extends Thread {
    public static final String pgmVersion = "05.00.00";
    final String errPrefix = "Error in ExecCmd.class -- ";
    BufferedReader stdxxx;
    Vector vLines;
    boolean fPrintLine;
    String linePf;
    boolean adjustCmd;
    static String bundle = "com.ibm.websphere.rastools.collector.CollectorMessages";

    ExecCmd() {
        this.adjustCmd = false;
    }

    ExecCmd(boolean bl) {
        this.adjustCmd = bl;
    }

    ExecCmd(BufferedReader bufferedReader, boolean bl, String string, Vector vector) {
        this.stdxxx = bufferedReader;
        this.vLines = vector;
        this.fPrintLine = bl;
        this.linePf = string;
    }

    int Execute(String string, boolean bl, boolean bl2, StringBuffer stringBuffer, Vector vector) {
        return this.launch(string, null, bl, bl2, stringBuffer, vector);
    }

    int Execute(String[] stringArray, boolean bl, boolean bl2, StringBuffer stringBuffer, Vector vector) {
        return this.launch(null, stringArray, bl, bl2, stringBuffer, vector);
    }

    protected int launch(String string, String[] stringArray, boolean bl, boolean bl2, StringBuffer stringBuffer, Vector vector) {
        BufferedReader bufferedReader;
        BufferedReader bufferedReader2;
        String[] stringArray2;
        if (!System.getProperty("os.name").equals("OS/400") && this.adjustCmd && !this.isCaseSensitive()) {
            if (string != null) {
                string = "CMD.EXE /C " + string;
            } else {
                stringArray2 = new String[stringArray.length + 2];
                stringArray2[0] = "CMD.EXE";
                stringArray2[1] = "/C";
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2[i + 2] = stringArray[i];
                }
                stringArray = stringArray2;
            }
        }
        stringArray2 = Runtime.getRuntime();
        Process process = null;
        try {
            process = string != null ? stringArray2.exec(string) : stringArray2.exec(stringArray);
        }
        catch (IOException iOException) {
            stringBuffer.append(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_EXC_RUNTIME_CREATE_IOEXCEPTION", new Object[]{"ExecCmd.class", "RunTime()", iOException.getMessage()}, "WSST_ERR_EXC_RUNTIME_CREATE_IOEXCEPTION"));
            return 888;
        }
        if (System.getProperty("os.name").equals("OS/400")) {
            try {
                bufferedReader2 = new BufferedReader(new InputStreamReader(process.getInputStream(), System.getProperty("char.encoding")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bufferedReader2 = new BufferedReader(new InputStreamReader(process.getInputStream()));
            }
        } else {
            bufferedReader2 = new BufferedReader(new InputStreamReader(process.getInputStream()));
        }
        try {
            String string2;
            while ((string2 = bufferedReader2.readLine()) != null) {
                vector.addElement(string2);
            }
        }
        catch (IOException iOException) {
            System.err.println("Error in ExecCmd.class -- IOException reading Stdout from the process. This behavior is expected on some encodings.");
            try {
                process.destroy();
                bufferedReader2.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (System.getProperty("os.name").equals("OS/400")) {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream(), System.getProperty("char.encoding")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            }
        } else {
            bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        }
        ExecCmd execCmd = new ExecCmd(bufferedReader, bl2, "StdErr: ", vector);
        execCmd.start();
        boolean bl3 = true;
        boolean bl4 = false;
        while (bl3 | bl4) {
            if (!execCmd.isAlive()) {
                bl3 = false;
            }
            try {
                ExecCmd.sleep(500L, 0);
            }
            catch (InterruptedException interruptedException) {
                System.out.println(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_EXC_INSOMNIA", new Object[]{"ExecCmd.class", interruptedException.getMessage()}, "WSST_ERR_EXC_INSOMNIA"));
            }
        }
        int n = process.exitValue();
        try {
            bufferedReader2.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    protected boolean isCaseSensitive() {
        String string = System.getProperty("os.name");
        if (string.equals("Windows NT")) {
            return false;
        }
        if (string.equals("Windows 2000")) {
            return false;
        }
        if (string.equals("Windows XP")) {
            return false;
        }
        if (string.startsWith("Windows ")) {
            return false;
        }
        if (string.equals("OS/400")) {
            return false;
        }
        if (string.equals("OS/2")) {
            return false;
        }
        if (string.equals("Linux")) {
            return true;
        }
        if (string.equals("Solaris")) {
            return true;
        }
        if (string.equals("SunOS")) {
            return true;
        }
        if (string.equals("AIX")) {
            return true;
        }
        if (string.equals("HP-UX")) {
            return true;
        }
        System.err.println(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_EXC_WEIRD_OS_NAME", new Object[]{"ExecCmd.class", pgmVersion, string}, "WSST_ERR_EXC_WEIRD_OS_NAME"));
        return true;
    }

    public void run() {
        try {
            String string;
            while ((string = this.stdxxx.readLine()) != null) {
                if (this.linePf != null) {
                    string = this.linePf.concat(string);
                }
                if (this.vLines != null) {
                    this.vLines.addElement(string);
                }
                if (!this.fPrintLine) continue;
                System.out.println(string);
            }
        }
        catch (IOException iOException) {
            System.err.println("Error in ExecCmd.class -- IOException reading Stdxxx " + iOException.getMessage());
        }
    }
}

