/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rastools.collector;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.rastools.collector.Logger;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class Helper1 {
    public static final String pgmVersion = "05.00.00";
    static int verbosity;
    static Logger Logit;
    static String FileSep;
    static String bundle;
    public final int k_fullname = 0;
    public final int k_drive = 1;
    public final int k_path = 2;
    public final int k_name = 3;
    public final int k_ext = 4;
    public final int k_elCount = 5;
    static String gnll_LastFileName;
    static BufferedReader gnll_br;
    static int gnllLineCount;
    static String gnllComment;

    Helper1(Logger logger, int n) {
        Logit = logger;
        verbosity = n;
        FileSep = System.getProperty("file.separator");
    }

    Helper1() {
        Logit = null;
        verbosity = 3;
        FileSep = System.getProperty("file.separator");
    }

    public int UnJar(String string, String string2, DataOutputStream dataOutputStream) {
        int n = 0;
        if (!string2.endsWith(FileSep)) {
            string2 = string2.concat(FileSep);
        }
        Logit.Both(TraceNLS.getFormattedMessage(bundle, "MSG_HC_UNJAR", new Object[]{string, string2}, "MSG_HC_UNJAR"), dataOutputStream);
        int n2 = 2048;
        byte[] byArray = new byte[n2];
        try {
            JarEntry jarEntry;
            JarFile jarFile = new JarFile(string, false);
            Logit.Both("\t" + TraceNLS.getFormattedMessage(bundle, "MSG_HC_NUM_JAR_ENTRIES", new Object[]{Integer.toString(jarFile.size())}, "MSG_HC_NUM_JAR_ENTRIES"), dataOutputStream);
            JarInputStream jarInputStream = new JarInputStream((InputStream)new FileInputStream(string), false);
            int n3 = 0;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                int n4;
                Object object;
                Object object2;
                if (verbosity > 3) {
                    Logit.Both(TraceNLS.getFormattedMessage(bundle, "MSG_HC_JAR_ENTRY_NUM", new Object[]{Integer.toString(++n3), Integer.toString(jarFile.size()), jarEntry}, "MSG_HC_JAR_ENTRY_NUM"), dataOutputStream);
                }
                if (jarEntry.isDirectory()) {
                    object2 = string2 + jarEntry;
                    Logit.Both("\t" + TraceNLS.getFormattedMessage(bundle, "MSG_HC_DIR", new Object[]{object2}, "MSG_HC_DIR"), dataOutputStream);
                    object = new File((String)object2);
                    ((File)object).mkdirs();
                    continue;
                }
                object2 = new File(string2 + jarEntry);
                object = ((File)object2).getAbsolutePath();
                String string3 = ((String)object).substring(0, n4 = ((String)object).lastIndexOf(FileSep));
                File file = new File(string3);
                if (!file.exists()) {
                    Logit.Both("\t" + TraceNLS.getFormattedMessage(bundle, "MSG_HC_DIR", new Object[]{object}, "MSG_HC_DIR"), dataOutputStream);
                    file.mkdirs();
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2 + jarEntry), n2);
                boolean bl = true;
                long l = 0L;
                while (bl) {
                    int n5 = jarInputStream.read(byArray, 0, n2);
                    if (n5 > 0) {
                        l += (long)n5;
                        bufferedOutputStream.write(byArray, 0, n5);
                        continue;
                    }
                    bl = false;
                }
                if (verbosity > 3) {
                    Logit.Both("\t" + TraceNLS.getFormattedMessage(bundle, "MSG_HC_BYTES_READ", new Object[]{Long.toString(l)}, "MSG_HC_BYTES_READ"), dataOutputStream);
                }
                bufferedOutputStream.close();
            }
            jarInputStream.close();
        }
        catch (IOException iOException) {
            Logit.Both("\t" + TraceNLS.getFormattedMessage(bundle, "WSST_ERR_HC_JAR_IOEXCP", new Object[]{iOException}, "WSST_ERR_HC_JAR_IOEXCP"), dataOutputStream);
            Logit.Both("\n");
            n = 8;
        }
        return n;
    }

    public int UnZip(String string, String string2, DataOutputStream dataOutputStream) {
        int n = 0;
        if (!string2.endsWith(FileSep)) {
            string2 = string2.concat(FileSep);
        }
        Logit.Both(TraceNLS.getFormattedMessage(bundle, "MSG_HC_UNZIP_FILE", new Object[]{string, string2}, "MSG_HC_UNZIP_FILE"), dataOutputStream);
        int n2 = 2048;
        byte[] byArray = new byte[n2];
        try {
            ZipEntry zipEntry;
            ZipFile zipFile = new ZipFile(string);
            Logit.Both("\t" + TraceNLS.getFormattedMessage(bundle, "MSG_HC_UNZIP_NUM_ENTRIES", new Object[]{Integer.toString(zipFile.size())}, "MSG_HC_UNZIP_NUM_ENTRIES"), dataOutputStream);
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(string));
            int n3 = 0;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n4;
                Object object;
                Object object2;
                if (verbosity > 3) {
                    Logit.Both(TraceNLS.getFormattedMessage(bundle, "MSG_HC_UNZIP_ENTRY_NUM", new Object[]{Integer.toString(++n3), Integer.toString(zipFile.size()), zipEntry}, "MSG_HC_UNZIP_ENTRY_NUM"), dataOutputStream);
                }
                if (zipEntry.isDirectory()) {
                    object2 = string2 + zipEntry;
                    Logit.Both("\t" + TraceNLS.getFormattedMessage(bundle, "MSG_HC_DIR", new Object[]{object2}, "MSG_HC_DIR"), dataOutputStream);
                    object = new File((String)object2);
                    ((File)object).mkdirs();
                    continue;
                }
                object2 = new File(string2 + zipEntry);
                object = ((File)object2).getAbsolutePath();
                String string3 = ((String)object).substring(0, n4 = ((String)object).lastIndexOf(FileSep));
                File file = new File(string3);
                if (!file.exists()) {
                    Logit.Both("\t" + TraceNLS.getFormattedMessage(bundle, "MSG_HC_DIR", new Object[]{object}, "MSG_HC_DIR"), dataOutputStream);
                    file.mkdirs();
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2 + zipEntry), n2);
                boolean bl = true;
                long l = 0L;
                while (bl) {
                    int n5 = zipInputStream.read(byArray, 0, n2);
                    if (n5 > 0) {
                        l += (long)n5;
                        bufferedOutputStream.write(byArray, 0, n5);
                        continue;
                    }
                    bl = false;
                }
                if (verbosity > 3) {
                    Logit.Both("\t" + TraceNLS.getFormattedMessage(bundle, "MSG_HC_BYTES_READ", new Object[]{Long.toString(l)}, "MSG_HC_BYTES_READ"), dataOutputStream);
                }
                bufferedOutputStream.close();
            }
            zipInputStream.close();
        }
        catch (IOException iOException) {
            Logit.Both("\t" + TraceNLS.getFormattedMessage(bundle, "WSST_ERR_HC_ZIP_IOEXCP", new Object[]{iOException}, "WSST_ERR_HC_ZIP_IOEXCP"), dataOutputStream);
            Logit.Both("\n");
            n = 8;
        }
        return n;
    }

    public String Padit(String string, int n, boolean bl) {
        return this.Padit(string, n, bl, ' ');
    }

    public String Padit(String string, int n, boolean bl, char c) {
        if (string.length() >= n) {
            return string;
        }
        int n2 = n - string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(c);
        }
        if (bl) {
            return string.concat(stringBuffer.toString());
        }
        return stringBuffer.toString().concat(string);
    }

    public String FmtNum(long l, int n, int n2) {
        return this.FmtNum(l, n, n2, 0);
    }

    public String FmtNum(long l, int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = 79;
        char[] cArray = new char[80];
        int n8 = n3 == 1 ? 48 : 32;
        for (n4 = 0; n4 < n7; ++n4) {
            cArray[n4] = n8;
        }
        String string = String.valueOf(l);
        char[] cArray2 = string.toCharArray();
        if (n != 0) {
            for (n4 = string.length() - 1; n4 < n; ++n4) {
                String string2 = "0";
                string = string2 = string2.concat(string);
            }
            cArray2 = string.toCharArray();
            int n9 = 0;
            while (n9 < n) {
                cArray[n7] = n4 > 0 ? cArray2[n4] : 48;
                ++n5;
                ++n9;
                --n4;
                --n7;
            }
            cArray[n7--] = 46;
            ++n5;
        }
        while (n4 > -1) {
            if (n6 > 2) {
                cArray[n7--] = 44;
                ++n5;
                n6 = 0;
            }
            cArray[n7--] = cArray2[n4--];
            ++n5;
            ++n6;
        }
        n4 = n2 == 0 ? n5 : Math.max(n2, n5);
        return String.valueOf(cArray, 80 - n4, n4);
    }

    public String CalcET(long l) {
        String string;
        String string2;
        String string3;
        long l2;
        long l3 = 3600000L;
        long l4 = 60000L;
        long l5 = 1000L;
        long l6 = System.currentTimeMillis() - l;
        if (l6 > l3) {
            l2 = l6 / l3;
            l6 -= l2 * l3;
            string3 = l2 < 10L ? "0" + Integer.toString((int)l2) : Integer.toString((int)l2);
        } else {
            string3 = "00";
        }
        if (l6 > l4) {
            l2 = l6 / l4;
            l6 -= l2 * l4;
            string2 = l2 < 10L ? "0" + Integer.toString((int)l2) : Integer.toString((int)l2);
        } else {
            string2 = "00";
        }
        if (l6 > l5) {
            l2 = l6 / l5;
            l6 -= l2 * l5;
            string = l2 < 10L ? "0" + Integer.toString((int)l2) : Integer.toString((int)l2);
        } else {
            string = "00";
        }
        return string3 + ":" + string2 + ":" + string + "." + l6;
    }

    public int FindFiles(String string, boolean bl, Hashtable hashtable, Hashtable hashtable2, boolean bl2, StringBuffer stringBuffer, boolean bl3) {
        String string2 = System.getProperty("file.separator");
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        if (string2.equals("\\")) {
            string = string.replace('/', string2.charAt(0));
        }
        int n = string.lastIndexOf(string2);
        String string3 = null;
        String string4 = null;
        File file = null;
        if (!bl2) {
            string = string.toLowerCase();
        }
        if (bl3) {
            System.out.println("Debug  Starting pattern (" + string + ") caseSensitivity " + bl2);
        }
        if (string.endsWith(string2)) {
            string3 = string.substring(0, string.length() - 1);
            string4 = "*";
        } else if (n == -1) {
            string3 = "*";
            if (string.length() > 1 && string.substring(1, 2).equals(":")) {
                string4 = string.substring(2);
                string3 = string.substring(0, 2);
            } else {
                string4 = string;
                string3 = ".";
            }
        } else {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        this.MakeTokens(string3, vector, bl3);
        this.MakeTokens(string4, vector2, bl3);
        String string5 = vector.size() > 0 ? (String)vector.elementAt(0) : "";
        if (!(System.getProperty("os.name").equals("OS/400") || this.isCaseSensitive() || string5.endsWith("\\"))) {
            string5 = string5.concat("\\");
        }
        file = new File(string5).getAbsoluteFile();
        if (bl3) {
            System.out.println("Debug absolute startingDir=(" + file.toString() + ")");
        }
        int n2 = file.toString().length();
        int n3 = Helper1.FFProcessDir(file, n2, bl, vector, vector2, hashtable, hashtable2, bl2, bl3);
        stringBuffer.append(file.toString());
        return n3;
    }

    protected int MakeTokens(String string, Vector vector, boolean bl) {
        if (string != null) {
            if (bl) {
                System.out.println("Debug tokenizing (" + string + ")");
            }
            String string2 = "";
            boolean bl2 = false;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '*') {
                    if (bl2) {
                        vector.addElement(string2);
                        bl2 = false;
                        string2 = "";
                    }
                    vector.addElement("*");
                    continue;
                }
                if (c == '?') {
                    if (bl2) {
                        vector.addElement(string2);
                        bl2 = false;
                        string2 = "";
                    }
                    vector.addElement("?");
                    continue;
                }
                string2 = string2.concat(String.valueOf(c));
                bl2 = true;
            }
            if (bl2) {
                vector.addElement(string2);
                bl2 = false;
            }
        }
        if (bl) {
            for (int i = 0; i < vector.size(); ++i) {
                System.out.println("Debug  token " + i + "  " + (String)vector.elementAt(i));
            }
        }
        return vector.size();
    }

    protected static int FFProcessDir(File file, int n, boolean bl, Vector vector, Vector vector2, Hashtable hashtable, Hashtable hashtable2, boolean bl2, boolean bl3) {
        String string = System.getProperties().getProperty("file.separator");
        char c = string.charAt(0);
        String[] stringArray = null;
        int n2 = 0;
        stringArray = file.list();
        if (stringArray != null) {
            String string2 = file.toString();
            if (string2.endsWith(string)) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(string2 + string + stringArray[i]);
                String string3 = file2.toString().replace(c, '*').substring(n);
                if (file2.isDirectory()) {
                    hashtable2.put(string3, file2);
                    if (bl) {
                        int n3 = Helper1.FFProcessDir(file2, n, bl, vector, vector2, hashtable, hashtable2, bl2, bl3);
                        n2 += n3;
                    }
                }
                if (!file2.isFile()) continue;
                ++n2;
                if (!Helper1.FFacceptFile(stringArray[i], vector2, bl2, bl3)) continue;
                if (bl2) {
                    hashtable.put(string3, file2);
                    continue;
                }
                hashtable.put(string3.toLowerCase(), file2);
            }
        }
        return n2;
    }

    protected static boolean FFacceptFile(String string, Vector vector, boolean bl, boolean bl2) {
        boolean bl3 = true;
        boolean bl4 = true;
        int n = string.length();
        if (bl2) {
            System.out.println(" Examining (" + string + ")");
        }
        boolean bl5 = false;
        int n2 = 0;
        for (int i = 0; i < vector.size() && bl4; ++i) {
            String string2 = (String)vector.elementAt(i);
            if (string2.equals("*")) {
                bl5 = true;
                continue;
            }
            if (string2.equals("?")) {
                if (++n2 > string.length()) {
                    bl4 = false;
                }
                bl5 = false;
                continue;
            }
            int n3 = string2.length();
            if (n3 > n - n2) {
                bl4 = false;
                if (!bl2) continue;
                System.out.println("  end of text  searching for (" + string2 + ") @ position (" + n2 + ")");
                continue;
            }
            if (!bl && bl3) {
                string = string.toLowerCase();
            }
            if (bl5) {
                int n4 = string.indexOf(string2, n2);
                if (n4 == -1) {
                    bl4 = false;
                    if (!bl2) break;
                    System.out.println("  scan failed searching for (" + string2 + ") starting @ " + n2);
                    break;
                }
                n2 = n4 + n3;
                bl5 = false;
                continue;
            }
            if (string2.equals(string.substring(n2, n2 + n3))) {
                if (bl2) {
                    System.out.println("  token " + string2 + " found @ " + n2);
                }
                n2 += n3;
                continue;
            }
            bl4 = false;
            if (!bl2) continue;
            System.out.println("  failed expecting " + string2 + " @ " + n2);
        }
        if (n2 != n && !bl5) {
            bl4 = false;
            if (bl2) {
                System.out.println("  Length failed nameLen = " + n + " ndx = " + n2);
            }
        }
        if (bl2) {
            System.out.println("               " + bl4);
        }
        return bl4;
    }

    public boolean ParseFileSpec(String string, String[] stringArray, boolean bl) {
        boolean bl2 = true;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < 5; ++i) {
            stringArray[i] = "";
        }
        if (string.startsWith("\\\\")) {
            n = string.indexOf("\\", 2);
            if (n == -1) {
                n = 0;
            } else if ((n = string.indexOf("\\", n + 1)) == -1) {
                n = 0;
            } else {
                stringArray[1] = string.substring(0, n);
            }
        } else if (string.length() > 1 && string.substring(1, 2).equals(":")) {
            stringArray[1] = string.substring(0, 2);
            n = 2;
        } else {
            stringArray[1] = "";
            n = 0;
        }
        n2 = string.lastIndexOf("\\");
        if (n2 == -1) {
            n2 = string.lastIndexOf("/");
        }
        if (n2 == -1) {
            n2 = n;
            n3 = n;
        } else if (n2 < n) {
            n2 = n;
            n3 = n;
            bl2 = false;
        } else {
            n3 = ++n2;
        }
        stringArray[2] = string.substring(n, n2);
        stringArray[0] = string.substring(n3);
        n4 = stringArray[0].lastIndexOf(".");
        if (n4 == -1) {
            stringArray[3] = stringArray[0];
            stringArray[4] = "";
        } else {
            stringArray[3] = stringArray[0].substring(0, n4);
            stringArray[4] = stringArray[0].substring(n4 + 1);
        }
        if (stringArray[2].length() == 2 && stringArray[2].substring(0, 1).equals(stringArray[2].substring(1, 2))) {
            stringArray[2] = stringArray[2].substring(1);
        }
        if (bl) {
            System.out.println("ParseFileSpec debug input - (" + string + ")");
            System.out.println("     1(" + stringArray[1] + ") 2(" + stringArray[2] + ") 3(" + stringArray[3] + ") 4(" + stringArray[4] + ") 0(" + stringArray[0] + ")");
        }
        return bl2;
    }

    public static String Hex(String string, boolean bl, int n) {
        String[] stringArray = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8A", "8B", "8C", "8D", "8E", "8F", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA", "AB", "AC", "AD", "AE", "AF", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "CA", "CB", "CC", "CD", "CE", "CF", "D0", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "DA", "DB", "DC", "DD", "DE", "DF", "E0", "E1", "E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "EA", "EB", "EC", "ED", "EE", "EF", "F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "FA", "FB", "FC", "FD", "FE", "FF"};
        byte[] byArray = string.getBytes();
        StringBuffer stringBuffer = new StringBuffer(byArray.length * n + 5);
        if (bl) {
            stringBuffer.append("dec ");
        } else {
            stringBuffer.append("  x'");
        }
        for (int i = 0; i < byArray.length; ++i) {
            Byte by = new Byte(byArray[i]);
            short s = by.shortValue();
            String string2 = bl ? by.toString() : stringArray[s];
            while (string2.length() < n) {
                string2 = new String(" ").concat(string2);
            }
            stringBuffer.append(string2);
        }
        if (!bl) {
            stringBuffer.append("'");
        }
        return stringBuffer.toString();
    }

    public String getSQLTimeStamp(long l) {
        Date date = l == 0L ? new Date() : new Date(l);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss.S");
        return simpleDateFormat.format(date);
    }

    public int GetJavaVersion() {
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[]{100, 10, 1, 0, 0, 0};
        int n3 = 3;
        String string = System.getProperty("java.version");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens() && n3 > 0) {
            String string2 = stringTokenizer.nextToken();
            char[] cArray = string2.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (Character.isDigit(cArray[i])) continue;
                string2 = "0";
            }
            n2 += Integer.parseInt(string2.trim()) * nArray[n++];
        }
        return n2;
    }

    public boolean isCaseSensitive() {
        String string = System.getProperty("os.name");
        if (string.equals("Windows NT")) {
            return false;
        }
        if (string.equals("Windows 2000")) {
            return false;
        }
        if (string.equals("Windows XP")) {
            return false;
        }
        if (string.startsWith("Windows ")) {
            return false;
        }
        if (string.equals("OS/400")) {
            return false;
        }
        if (string.equals("Linux")) {
            return true;
        }
        if (string.equals("Solaris")) {
            return true;
        }
        if (string.equals("SunOS")) {
            return true;
        }
        if (string.equals("AIX")) {
            return true;
        }
        if (string.equals("HP-UX")) {
            return true;
        }
        if (string.equals("OS/2")) {
            return true;
        }
        System.err.println("Error -- Un-recognized os.name in Helper1 v05.00.00 (" + string + ")");
        return true;
    }

    public String resolveMacro(String string, Hashtable hashtable) {
        String string2 = null;
        int n = string.indexOf("$(");
        while (n > -1) {
            int n2 = string.indexOf(")", n);
            if (n2 > -1) {
                String string3 = string.substring(n + 2, n2);
                if (hashtable != null) {
                    string2 = (String)hashtable.get(string3);
                }
                if (string2 == null) {
                    string2 = System.getProperty(string3);
                }
                if (string2 != null) {
                    string = string.substring(0, n) + string2 + string.substring(n2 + 1);
                    string2 = null;
                }
            }
            if (n2 > 0) {
                n = string.indexOf("$(", n + 1);
                continue;
            }
            n = -2;
        }
        return string;
    }

    String getNextLogicalLine(int[] nArray, String string) {
        return this.gnll(nArray, string, null);
    }

    String getNextLogicalLine(int[] nArray, String string, InputStream inputStream) {
        return this.gnll(nArray, string, inputStream);
    }

    String gnll(int[] nArray, String string, InputStream inputStream) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = inputStream == null ? new File(string).getAbsolutePath() : string;
        if (!gnll_LastFileName.equals(string2)) {
            if (gnll_br != null) {
                try {
                    gnll_br.close();
                    gnll_br = null;
                }
                catch (IOException iOException) {
                    Logit.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_HC_IOEXCEPTION_FILE_CLOSE", new Object[]{gnll_LastFileName}, "WSST_ERR_HC_IOEXCEPTION_FILE_CLOSE"), iOException);
                    return null;
                }
            }
            if (inputStream == null) {
                object = new File(string2);
                if (!((File)object).exists()) {
                    Logit.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_HC_IOEXCEPTION_FILE_NO_EXIST", new Object[]{gnll_LastFileName}, "WSST_ERR_HC_IOEXCEPTION_FILE_NO_EXIST"));
                    return null;
                }
                if (!((File)object).isFile()) {
                    Logit.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_HC_BAD_FILE_SPEC", new Object[]{gnll_LastFileName}, "WSST_ERR_HC_BAD_FILE_SPEC"));
                    return null;
                }
                if (!((File)object).canRead()) {
                    Logit.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_HC_FILE_NOT_READ", new Object[]{gnll_LastFileName}, "WSST_ERR_HC_FILE_NOT_READ"));
                    return null;
                }
            }
            try {
                gnll_br = inputStream == null ? new BufferedReader(new InputStreamReader(new FileInputStream(string2))) : new BufferedReader(new InputStreamReader(inputStream));
                gnllLineCount = 0;
                gnll_LastFileName = string2;
            }
            catch (IOException iOException) {
                Logit.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_HC_FILE_FAILED_OPEN", new Object[]{string}, "WSST_ERR_HC_FILE_FAILED_OPEN"), iOException);
                return null;
            }
        }
        object = null;
        boolean bl = true;
        while (bl) {
            try {
                object = gnll_br.readLine();
            }
            catch (Exception exception) {
                Logit.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_HC_UNABLE_TO_READ_FILE", new Object[]{string}, "WSST_ERR_HC_UNABLE_TO_READ_FILE"), exception);
                return null;
            }
            if (object != null) {
                nArray[0] = ++gnllLineCount;
                if (((String)(object = ((String)object).trim())).length() == 0) continue;
                if (gnllLineCount == 1) {
                    if (((String)object).startsWith("//")) {
                        gnllComment = "//";
                    }
                    if (((String)object).startsWith("#")) {
                        gnllComment = "#";
                    }
                    if (((String)object).startsWith("!")) {
                        gnllComment = "!";
                    }
                    if (((String)object).startsWith("*")) {
                        gnllComment = "*";
                    }
                }
                if (gnllComment != null) {
                    if (((String)object).startsWith(gnllComment)) continue;
                    int n = ((String)object).indexOf(" " + gnllComment);
                    if (n > -1) {
                        object = ((String)object).substring(0, n);
                        object = ((String)object).trim();
                    }
                }
                if (((String)object).endsWith(",") || ((String)object).endsWith("-")) {
                    if (((String)object).endsWith("-")) {
                        stringBuffer.append(((String)object).substring(0, ((String)object).length() - 1));
                        continue;
                    }
                    if (!((String)object).endsWith(",")) continue;
                    stringBuffer.append(((String)object).substring(0, ((String)object).length()));
                    continue;
                }
                stringBuffer.append((String)object);
                bl = false;
                continue;
            }
            try {
                gnll_br.close();
                bl = false;
                stringBuffer = null;
            }
            catch (IOException iOException) {
                Logit.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_HC_UNABLE_TO_CLOSE_FILE", new Object[]{string}, "WSST_ERR_HC_UNABLE_TO_CLOSE_FILE"), iOException);
                return null;
            }
            gnll_LastFileName = "";
        }
        if (stringBuffer == null) {
            return null;
        }
        return stringBuffer.toString();
    }

    static {
        bundle = "com.ibm.websphere.rastools.collector.CollectorMessages";
        gnll_LastFileName = "";
        gnll_br = null;
        gnllComment = null;
    }
}

