/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rastools.collector;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.rastools.collector.PODef;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class POProcessor {
    static final String pgmVersion = "05.00.00";
    protected static final int t_Error = 0;
    protected static final int t_Boolean = 1;
    protected static final int t_Int = 2;
    protected static final int t_IntList = 3;
    protected static final int t_Long = 4;
    protected static final int t_LongList = 5;
    protected static final int t_String = 6;
    protected static final int t_StringList = 7;
    protected static final int t_InFile = 8;
    protected static final int t_InFileList = 9;
    protected static final int t_OutFileNew = 10;
    protected static final int t_OutFileNewList = 11;
    protected static final int t_OutFileOld = 12;
    protected static final int t_OutFileOldList = 13;
    protected static final int t_OutFileAny = 14;
    protected static final int t_OutFileAnyList = 15;
    protected static final int t_Directory = 16;
    protected static final int t_DirectoryList = 17;
    protected static final int t_BuiltInHelp = 18;
    protected static final int t_Validating = 19;
    protected static final int t_NonValidating = 20;
    static String[] validTypes = new String[]{"Error", "boolean", "int", "intList", "Long", "LongList", "String", "StringList", "InFile", "InFileList", "OutFileNew", "OutFileNewList", "OutFileOld", "OutFileOldList", "OutFileAny", "OutFileAnyList", "Directory", "DirectoryList", "BuiltInHelp", "Validating", "NonValidating"};
    static final String[] srcDescriptions = new String[]{"Command Line", "Property File", "Default", "Console", "Unknown"};
    static final int k_CmdLine = 0;
    static final int k_PropFile = 1;
    static final int k_Default = 2;
    static final int k_UserResp = 3;
    static final int k_Unknown = 4;
    protected PODef[] po;
    int valueSource = 4;
    Properties[] props = new Properties[]{new Properties(), new Properties(), new Properties(), new Properties()};
    String delimiters = ",";
    protected static boolean builtInHelpMode = false;
    static String bundle = "com.ibm.websphere.rastools.collector.CollectorMessages";
    protected static final boolean ABEND = true;
    protected static final boolean NoABEND = false;
    int errorCount = 0;
    Vector errVector = null;

    POProcessor(PODef[] pODefArray, String[] stringArray, Vector vector) {
        this.errVector = vector;
        if (pODefArray == null) {
            this.LogError(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_POP_NULL_CMD_DEFAULTS", "WSST_ERR_POP_NULL_CMD_DEFAULTS"), true);
        } else {
            this.po = pODefArray;
        }
        if (stringArray == null) {
            this.LogError(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_POP_NULL_INPUT_CMD_ARGS", "WSST_ERR_POP_NULL_INPUT_CMD_ARGS"), true);
        }
        for (int i = 0; i < this.po.length; ++i) {
            if (this.po[i].defaultValue == null) continue;
            if (this.isList(this.po[i].type, this.po[i].key)) {
                this.props[2].setProperty(this.po[i].key + "_num1", this.po[i].defaultValue);
                this.props[2].setProperty(this.po[i].key + "_count", "1");
                continue;
            }
            this.props[2].setProperty(this.po[i].key, this.po[i].defaultValue);
        }
        this.ProcessArgs(stringArray);
    }

    void ProcessArgs(String[] stringArray) {
        String string = "";
        int n = stringArray.length - 1;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (builtInHelpMode && (string2.equals("-?") || string2.equals("?") || string2.equalsIgnoreCase("-help") || string2.equalsIgnoreCase("help"))) {
                string2 = "-?";
            }
            if (string2.startsWith("-")) {
                string = string2.substring(1).toLowerCase();
            } else {
                this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_INVALID_CMD_ARG", new Object[]{Integer.toString(i + 1), stringArray[i]}, "WSST_ERR_POP_INVALID_CMD_ARG"), true);
            }
            int n2 = this.FindKey(string);
            if (n2 == -1) {
                this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_UNDEFINED_CMD_ARG", new Object[]{Integer.toString(i + 1), stringArray[i]}, "WSST_ERR_POP_UNDEFINED_CMD_ARG"), true);
            }
            this.po[n2].used = true;
            String string3 = i + 2 <= stringArray.length ? stringArray[i + 1] : null;
            if (!this.ProcessKeyword(0, this.po[n2].key, string3, this.po[n2].type)) continue;
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean ProcessKeyword(int n, String string, String string2, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        switch (n2) {
            case 0: {
                this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_KEYWORD_TYPE_NOT_SET", new Object[]{string}, "WSST_ERR_POP_KEYWORD_TYPE_NOT_SET"), true);
                return bl2;
            }
            case 1: {
                boolean bl3 = true;
                if (string2 != null && !string2.startsWith("-")) {
                    bl3 = this.test4Boolean(string2, TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_PARAMETER_NOT_BOOL", new Object[]{string, string2.trim()}, "WSST_ERR_POP_PARAMETER_NOT_BOOL"));
                    bl2 = true;
                }
                this.props[n].setProperty(string, bl3 ? "true" : "false");
                String string3 = this.props[n].getProperty(string);
                return bl2;
            }
            case 2: {
                if (string2 == null) {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_PARAMETER_NOT_NUM1", new Object[]{string}, "WSST_ERR_POP_PARAMETER_NOT_NUM1"), false);
                    return bl2;
                }
                String string4 = this.test4Int(string2, TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_PARAMETER_NOT_NUM2", new Object[]{string, string2}, "WSST_ERR_POP_PARAMETER_NOT_NUM2"));
                this.props[n].setProperty(string, string4);
                return true;
            }
            case 3: {
                if (string2 == null) {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_PARAMETER_NOT_NUM3", new Object[]{string}, "WSST_ERR_POP_PARAMETER_NOT_NUM3"), false);
                    return bl2;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, this.delimiters);
                this.props[n].setProperty(string + "_count", Integer.toString(stringTokenizer.countTokens()));
                int n3 = 0;
                while (true) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        return true;
                    }
                    String string5 = stringTokenizer.nextToken();
                    String string6 = this.test4Int(string5, TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_LIST_ITEM_NOT_NUM", new Object[]{string, Integer.toString(++n3), string5}, "WSST_ERR_POP_LIST_ITEM_NOT_NUM"));
                    this.props[n].setProperty(string + "_num" + n3, string6);
                }
            }
            case 4: {
                if (string2 == null) {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_PARAMETER_NEEDS_NUM1", new Object[]{string}, "WSST_ERR_POP_PARAMETER_NEEDS_NUM1"), false);
                    return bl2;
                }
                String string7 = this.test4Long(string2, TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_PARAMETER_NEEDS_NUM2", new Object[]{string, string2}, "WSST_ERR_POP_PARAMETER_NEEDS_NUM2"));
                this.props[n].setProperty(string, string7);
                return true;
            }
            case 5: {
                if (string2 == null) {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_LIST_NEEDS_NUM", new Object[]{string}, "WSST_ERR_POP_LIST_NEEDS_NUM"), false);
                    return bl2;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, this.delimiters);
                this.props[n].setProperty(string + "_count", Integer.toString(stringTokenizer.countTokens()));
                int n4 = 0;
                while (true) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        return true;
                    }
                    String string8 = stringTokenizer.nextToken();
                    String string9 = this.test4Long(string8, TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_LIST_ITEM_NOT_NUM", new Object[]{string, Integer.toString(++n4), string8}, "WSST_ERR_POP_LIST_ITEM_NOT_NUM"));
                    this.props[n].setProperty(string + "_num" + n4, string9);
                }
            }
            case 6: {
                if (string2 == null) {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_PARAM_NEEDS_PARAM", new Object[]{string}, "WSST_ERR_POP_PARAM_NEEDS_PARAM"), false);
                    return bl2;
                }
                this.props[n].setProperty(string, string2);
                return true;
            }
            case 7: {
                if (string2 == null) {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_LIST_NEEDS_VALUES", new Object[]{string}, "WSST_ERR_POP_LIST_NEEDS_VALUES"), false);
                    return bl2;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, this.delimiters);
                this.props[n].setProperty(string + "_count", Integer.toString(stringTokenizer.countTokens()));
                int n5 = 0;
                while (true) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        return true;
                    }
                    String string10 = stringTokenizer.nextToken().trim();
                    this.props[n].setProperty(string + "_num" + ++n5, string10);
                }
            }
            case 8: {
                if (string2 == null) {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_NEED_FILE_SPEC", new Object[]{string}, "WSST_ERR_POP_NEED_FILE_SPEC"), false);
                    return bl2;
                }
                this.props[n].setProperty(string, this.canRead(string2, string));
                return true;
            }
            case 9: {
                if (string2 == null) {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_NEED_FILE_SPEC_VALUES", new Object[]{string}, "WSST_ERR_POP_NEED_FILE_SPEC_VALUES"), false);
                    return bl2;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, this.delimiters);
                this.props[n].setProperty(string + "_count", Integer.toString(stringTokenizer.countTokens()));
                int n6 = 0;
                while (true) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        return true;
                    }
                    String string11 = stringTokenizer.nextToken();
                    this.props[n].setProperty(string + "_num" + ++n6, this.canRead(string11, string));
                }
            }
            case 12: {
                if (string2 == null) {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_NEED_OUTFILE_SPEC", new Object[]{string}, "WSST_ERR_POP_NEED_OUTFILE_SPEC"), false);
                    return bl2;
                }
                this.props[n].setProperty(string, this.canWrite(string2, string));
                return true;
            }
            case 13: {
                if (string2 == null) {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_NEED_OUTFILE_VALUES", new Object[]{string}, "WSST_ERR_POP_NEED_OUTFILE_VALUES"), false);
                    return bl2;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, this.delimiters);
                this.props[n].setProperty(string + "_count", Integer.toString(stringTokenizer.countTokens()));
                int n7 = 0;
                while (true) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        return true;
                    }
                    String string12 = stringTokenizer.nextToken();
                    this.props[n].setProperty(string + "_num" + ++n7, this.canWrite(string12, string));
                }
            }
            case 10: {
                if (string2 == null) {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_NEED_OUTFILE_SPEC", new Object[]{string}, "WSST_ERR_POP_NEED_OUTFILE_SPEC"), false);
                    return bl2;
                }
                this.props[n].setProperty(string, this.newFile(string2, string));
                return true;
            }
            case 11: {
                if (string2 == null) {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_NEED_OUTFILE_VALUES", new Object[]{string}, "WSST_ERR_POP_NEED_OUTFILE_VALUES"), false);
                    return bl2;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, this.delimiters);
                this.props[n].setProperty(string + "_count", Integer.toString(stringTokenizer.countTokens()));
                int n8 = 0;
                while (true) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        return true;
                    }
                    String string13 = stringTokenizer.nextToken();
                    this.props[n].setProperty(string + "_num" + ++n8, this.newFile(string13, string));
                }
            }
            case 14: {
                if (string2 == null) {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_NEED_OUTFILE_SPEC", new Object[]{string}, "WSST_ERR_POP_NEED_OUTFILE_SPEC"), false);
                    return bl2;
                }
                this.props[n].setProperty(string, this.outFile(string2, string));
                return true;
            }
            case 15: {
                if (string2 == null) {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_NEED_OUTFILE_VALUES", new Object[]{string}, "WSST_ERR_POP_NEED_OUTFILE_VALUES"), false);
                    return bl2;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, this.delimiters);
                this.props[n].setProperty(string + "_count", Integer.toString(stringTokenizer.countTokens()));
                int n9 = 0;
                while (true) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        return true;
                    }
                    String string14 = stringTokenizer.nextToken();
                    this.props[n].setProperty(string + "_num" + ++n9, this.outFile(string14, string));
                }
            }
            case 16: {
                if (string2 == null) {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_NEED_DIR_SPEC", new Object[]{string}, "WSST_ERR_POP_NEED_DIR_SPEC"), false);
                    return bl2;
                }
                this.props[n].setProperty(string, this.isDirectory(string2, string));
                return true;
            }
            case 17: {
                if (string2 == null) {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_NEED_DIR_LIST_SPEC", new Object[]{string}, "WSST_ERR_POP_NEED_DIR_LIST_SPEC"), false);
                    return bl2;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, this.delimiters);
                this.props[n].setProperty(string + "_count", Integer.toString(stringTokenizer.countTokens()));
                int n10 = 0;
                while (true) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        return true;
                    }
                    String string15 = stringTokenizer.nextToken();
                    this.props[n].setProperty(string + "_num" + ++n10, this.isDirectory(string15, string));
                }
            }
            case 18: {
                this.props[n].setProperty(string, "true");
                return bl2;
            }
            case 19: {
                bl = true;
            }
            case 20: {
                if (string2 == null) {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_NEED_PROP_FILE_SPEC", new Object[]{string}, "WSST_ERR_POP_NEED_PROP_FILE_SPEC"), false);
                } else {
                    File file = new File(string2).getAbsoluteFile();
                    this.props[n].setProperty(string, file.toString());
                    if (!file.isFile()) {
                        this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_PROP_FILE_NOEXIST", new Object[]{string, string2}, "WSST_ERR_POP_NEED_PROP_FILE_SPEC"), false);
                    } else {
                        try {
                            try {
                                this.props[1].load(new FileInputStream(file));
                                bl2 = true;
                            }
                            catch (IOException iOException) {
                                this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_CANNOT_PROCESS_PROP_FILE", new Object[]{string2, iOException.getMessage()}, "WSST_ERR_POP_CANNOT_PROCESS_PROP_FILE"), false);
                                bl2 = true;
                            }
                        }
                        catch (Throwable throwable) {
                            bl2 = true;
                            throw throwable;
                        }
                    }
                    this.GoValidate(string2, bl);
                }
                bl = false;
                return bl2;
            }
        }
        this.LogError("Programming error 2, invalid value in switch, " + n2, true);
        return bl2;
    }

    String canRead(String string, String string2) {
        File file = new File(string).getAbsoluteFile();
        if (!file.exists()) {
            this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_NO_INPUT_FILE_SPEC", new Object[]{string2, file}, "WSST_ERR_POP_NO_INPUT_FILE_SPEC"), false);
        } else if (!file.canRead()) {
            this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_CANNOT_OPEN_INPUT_FILE", new Object[]{string2, file}, "WSST_ERR_POP_CANNOT_OPEN_INPUT_FILE"), false);
        }
        return file.toString();
    }

    String canWrite(String string, String string2) {
        File file = new File(string).getAbsoluteFile();
        if (!file.exists()) {
            this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_NO_OUTPUT_FILE_SPEC", new Object[]{string2, file}, "WSST_ERR_POP_NO_OUTPUT_FILE_SPEC"), false);
        } else if (!file.canWrite()) {
            this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_CANNOT_OPEN_OUTPUT_FILE", new Object[]{string2, file}, "WSST_ERR_POP_CANNOT_OPEN_OUTPUT_FILE"), false);
        }
        return file.toString();
    }

    String newFile(String string, String string2) {
        File file = new File(string).getAbsoluteFile();
        if (file.exists()) {
            this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_OUTPUT_FILE_PREEXISTS", new Object[]{string2, file}, "WSST_ERR_POP_OUTPUT_FILE_PREEXISTS"), false);
        } else if (file.isDirectory()) {
            this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_OUTPUT_FILE_IS_DIR", new Object[]{string2, file}, "WSST_ERR_POP_OUTPUT_FILE_IS_DIR"), false);
        }
        return file.toString();
    }

    String outFile(String string, String string2) {
        File file = new File(string).getAbsoluteFile();
        if (file.isDirectory()) {
            this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_OUTPUT_FILE_IS_DIR", new Object[]{string2, file}, "WSST_ERR_POP_OUTPUT_FILE_IS_DIR"), false);
        } else if (file.exists() && !file.canWrite()) {
            this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_CANNOT_OPEN_OUTPUT_FILE", new Object[]{string2, file}, "WSST_ERR_POP_CANNOT_OPEN_OUTPUT_FILE"), false);
        }
        return file.toString();
    }

    String isDirectory(String string, String string2) {
        File file = new File(string).getAbsoluteFile();
        if (!file.isDirectory()) {
            this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_DIR_SPEC_NOT_DIR", new Object[]{string2, file}, "WSST_ERR_POP_DIR_SPEC_NOT_DIR"), false);
        }
        return file.toString();
    }

    String test4Int(String string, String string2) {
        String string3 = "";
        try {
            string3 = Integer.toString(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            this.LogError(string2, false);
        }
        return string3;
    }

    String test4Long(String string, String string2) {
        String string3 = "";
        try {
            string3 = Long.toString(Long.parseLong(string));
        }
        catch (NumberFormatException numberFormatException) {
            this.LogError(string2, false);
        }
        return string3;
    }

    boolean test4Boolean(String string, String string2) {
        boolean bl = false;
        if ((string = string.trim()).equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equals("1") || string.equals("on")) {
            bl = true;
        } else if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no") || string.equals("0") || string.equals("off")) {
            bl = false;
        } else {
            this.LogError(string2, false);
        }
        return bl;
    }

    int FindKey(String string) {
        int n = -1;
        boolean bl = false;
        for (int i = 0; i < this.po.length; ++i) {
            if (!this.po[i].key.toLowerCase().startsWith(string.toLowerCase())) continue;
            if (bl) {
                this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_AMBIGUOUS_OPTION", new Object[]{string, this.po[n].key, this.po[i].key}, "WSST_ERR_POP_AMBIGUOUS_OPTION"), true);
                continue;
            }
            n = i;
            bl = true;
        }
        return n;
    }

    void GoValidate(String string, boolean bl) {
        Enumeration<?> enumeration = this.props[1].propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = this.props[1].getProperty(string2).trim();
            this.props[1].remove(string2);
            string2 = string2.toLowerCase();
            boolean bl2 = false;
            for (int i = 0; i < this.po.length; ++i) {
                PODef pODef = this.po[i];
                if (!pODef.key.equals(string2)) continue;
                if (bl2) {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_DUPE_KEY", new Object[]{string2, string}, "WSST_ERR_POP_DUPE_KEY"), false);
                    continue;
                }
                bl2 = true;
                pODef.used = true;
                this.ProcessKeyword(1, pODef.key, string3, pODef.type);
            }
            if (bl2 || !bl) continue;
            this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_UNDEF_KEY", new Object[]{string2, string}, "WSST_ERR_POP_UNDEF_KEY"), false);
        }
    }

    public boolean keywordUsed(String string) {
        int n = this.FindKey(string);
        return n > -1 && this.po[n].used;
    }

    void setDefault(String string, String string2) {
        this.props[2].setProperty(string.toLowerCase(), string2);
    }

    void setDefault(String string, boolean bl) {
        this.props[2].setProperty(string.toLowerCase(), bl ? "true" : "false");
    }

    void setDefault(String string, int n) {
        this.props[2].setProperty(string.toLowerCase(), Integer.toString(n));
    }

    int getCount(String string) {
        String string2 = this.getString(string + "_count");
        if (string2 == null) {
            return 0;
        }
        return Integer.parseInt(string2);
    }

    String getString(String string) {
        String string2 = string.toLowerCase();
        String string3 = this.props[0].getProperty(string2);
        if (string3 != null) {
            this.valueSource = 0;
            return string3;
        }
        string3 = this.props[1].getProperty(string2);
        if (string3 != null) {
            this.valueSource = 1;
            return string3;
        }
        string3 = this.props[2].getProperty(string2);
        if (string3 != null) {
            this.valueSource = 2;
            return string3;
        }
        string3 = this.props[3].getProperty(string2);
        if (string3 != null) {
            this.valueSource = 3;
            return string3;
        }
        int n = this.FindKey(string2);
        if (n > -1 && !this.po[n].alreadyAsked && this.po[n].haveQuestion) {
            string3 = this.AskQuestion(n);
            this.po[n].alreadyAsked = true;
            if (string3 != null) {
                this.valueSource = 3;
                this.props[3].setProperty(string2.toLowerCase(), string3);
                return string3;
            }
        }
        if (this.FindKey(string2) > -1 && this.isList(this.po[n].type, string2)) {
            this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_KEYWORD_NEED_INDEX", new Object[]{string2}, "WSST_ERR_POP_KEYWORD_NEED_INDEX"), true);
        }
        this.valueSource = 4;
        return string3;
    }

    String getString(String string, int n) {
        return this.getString(string + "_num" + n);
    }

    boolean getBool(String string) {
        String string2 = this.getString(string);
        if (string2 == null) {
            return false;
        }
        if (string2.equalsIgnoreCase("true") || string2.equals("1") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("on")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false") || string2.equals("0") || string2.equalsIgnoreCase("no") || string2.equalsIgnoreCase("off")) {
            return false;
        }
        System.err.println(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_KEY_VALUE_NOT_BOOLEAN", new Object[]{string}, "WSST_ERR_POP_KEY_VALUE_NOT_BOOLEAN"));
        System.exit(8);
        return false;
    }

    int getInt(String string) {
        String string2 = this.getString(string);
        if (string2 == null) {
            this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_KEYWORD_NO_DEFAULT", new Object[]{string}, "WSST_ERR_POP_KEYWORD_NO_DEFAULT"), false);
            return -1;
        }
        return Integer.parseInt(string2);
    }

    int getInt(String string, int n) {
        return this.getInt(string + "_num" + n);
    }

    long getLong(String string) {
        String string2 = this.getString(string);
        if (string2 == null) {
            this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_KEYWORD_NO_DEFAULT", new Object[]{string}, "WSST_ERR_POP_KEYWORD_NO_DEFAULT"), false);
            return -1L;
        }
        return Long.parseLong(string2);
    }

    long getLong(String string, int n) {
        return this.getLong(string + "_num" + n);
    }

    String getDirectory(String string) {
        String string2 = this.getString(string);
        return string2;
    }

    String getDirectory(String string, int n) {
        return this.getDirectory(string + "_num" + n);
    }

    File getFile(String string) {
        File file = null;
        String string2 = this.getString(string);
        if (string2 != null) {
            file = new File(this.getString(string));
        }
        return file;
    }

    File getFile(String string, int n) {
        return this.getFile(string + "_num" + n);
    }

    void LogError(String string, boolean bl) {
        ++this.errorCount;
        if (this.errVector == null) {
            System.err.println(string);
            System.exit(8);
        } else {
            this.errVector.add(string);
        }
    }

    String AskQuestion(int n) {
        if (!this.po[n].haveQuestion) {
            return null;
        }
        int n2 = 4096;
        System.out.println("");
        if (this.po[n].questionFile != null) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.po[n].questionFile), n2);
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println(string);
                }
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_QUESTION_FILE_NOTFOUND", new Object[]{new File(this.po[n].questionFile).getAbsolutePath(), this.po[n].key}, "WSST_ERR_POP_QUESTION_FILE_NOTFOUND"), false);
            }
            catch (IOException iOException) {
                this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_QUESTION_FILE_IOEXCP", new Object[]{this.po[n].questionFile, this.po[n].key, iOException.getMessage()}, "WSST_ERR_POP_QUESTION_FILE_IOEXCP"), true);
            }
        } else if (this.po[n].questionArray != null && this.po[n].questionArray.length > 0) {
            for (int i = 0; i < this.po[n].questionArray.length; ++i) {
                System.out.println(this.po[n].questionArray[i]);
            }
        }
        String string = null;
        boolean bl = false;
        while (!bl) {
            string = this.getKeyBoard(true);
            switch (this.po[n].type) {
                case 0: {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_INVALID_KEYWORD_TYPE", new Object[]{this.po[n].key}, "WSST_ERR_POP_INVALID_KEYWORD_TYPE"), true);
                    break;
                }
                case 1: {
                    if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equals("1") || string.equals("on")) {
                        bl = true;
                        break;
                    }
                    if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no") || string.equals("0") || string.equals("off")) {
                        bl = true;
                        break;
                    }
                    System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_POP_UNACCEPTABLE_REPLY", "WSST_ERR_POP_UNACCEPTABLE_REPLY"));
                    System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_POP_UNACCEPTABLE_REPLY2", "WSST_ERR_POP_UNACCEPTABLE_REPLY2"));
                    break;
                }
                case 2: {
                    try {
                        int n3 = Integer.parseInt(string);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_REPLY_NOT_NUMERIC", new Object[]{string}, "WSST_ERR_POP_REPLY_NOT_NUMERIC"));
                    }
                    break;
                }
                case 4: {
                    try {
                        long l = Long.parseLong(string);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_REPLY_NOT_NUMERIC", new Object[]{string}, "WSST_ERR_POP_REPLY_NOT_NUMERIC"));
                    }
                    break;
                }
                case 6: {
                    bl = true;
                    break;
                }
                case 8: {
                    File file = new File(string);
                    if (!file.exists()) {
                        System.out.println(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_INPUT_FILE_NO_EXIST", new Object[]{file.getAbsolutePath()}, "WSST_ERR_POP_INPUT_FILE_NO_EXIST"));
                        break;
                    }
                    if (!file.canRead()) {
                        System.out.println(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_INPUT_FILE_CANNOT_OPEN", new Object[]{file.getAbsolutePath()}, "WSST_ERR_POP_INPUT_FILE_CANNOT_OPEN"));
                        break;
                    }
                    bl = true;
                    break;
                }
                case 10: {
                    File file = new File(string);
                    if (file.exists()) {
                        System.out.println(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_INPUT_FILE_ALREADY_EXISTS", new Object[]{file.getAbsolutePath()}, "WSST_ERR_POP_INPUT_FILE_ALREADY_EXISTS"));
                        break;
                    }
                    bl = true;
                    break;
                }
                case 12: {
                    File file = new File(string);
                    if (!file.exists()) {
                        System.out.println(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_OUTPUT_FILE_NO_EXIST", new Object[]{file.getAbsolutePath()}, "WSST_ERR_POP_OUTPUT_FILE_NO_EXIST"));
                        break;
                    }
                    if (!file.canWrite()) {
                        System.out.println(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_OUTPUT_FILE_CANNOT_OPEN", new Object[]{file.getAbsolutePath()}, "WSST_ERR_POP_OUTPUT_FILE_CANNOT_OPEN"));
                        break;
                    }
                    bl = true;
                    break;
                }
                case 14: {
                    bl = true;
                    break;
                }
                case 16: {
                    File file = new File(string);
                    if (!file.isDirectory()) {
                        System.out.println(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_DIR_NOT_A_DIR", new Object[]{file.getAbsolutePath()}, "WSST_ERR_POP_DIR_NOT_A_DIR"));
                        break;
                    }
                    bl = true;
                    break;
                }
                default: {
                    this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_INVALID_TYPE_FOR_KEYWORD", new Object[]{Integer.toString(this.po[n].type), this.po[n].key}, "WSST_ERR_POP_INVALID_TYPE_FOR_KEYWORD"), true);
                }
            }
            if (bl) continue;
            System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ERR_POP_REENTER_RESP", "WSST_ERR_POP_REENTER_RESP"));
        }
        return string;
    }

    String getKeyBoard(boolean bl) {
        String string;
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        System.out.println("\u0007");
        if (bl) {
            System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_POP_ENTER_TO_TERMINATE", "WSST_ERR_POP_ENTER_TO_TERMINATE"));
        }
        try {
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            this.LogError(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_POP_KEYBOARD_IOEXCEPT", new Object[]{iOException.getMessage()}, "WSST_ERR_POP_KEYBOARD_IOEXCEPT"), true);
            string = null;
        }
        string = string.trim();
        if (bl && string.equalsIgnoreCase("exit")) {
            System.exit(8);
        }
        return string;
    }

    boolean isList(int n, String string) {
        boolean bl = false;
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                bl = false;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                bl = true;
                break;
            }
            default: {
                this.LogError("Programming error 2 in POProcessor: Un-Caught type in isList() :  Keyword=" + string + ", type=" + n, true);
            }
        }
        return bl;
    }

    void showProps() {
        System.out.println("Debug -- Listing content of Property Tables");
        System.out.println("Debug --   Command Line Entries");
        this.DisplayProps(this.props[0]);
        System.out.println("Debug --   Property File Entries");
        this.DisplayProps(this.props[1]);
        System.out.println("Debug --   User Responce Entries");
        this.DisplayProps(this.props[3]);
        System.out.println("Debug --   Default Entries");
        this.DisplayProps(this.props[2]);
        System.out.println("Debug --   KeyWord Definitions");
        for (int i = 0; i < this.po.length; ++i) {
            PODef pODef = this.po[i];
            System.out.println("  KeyWord=" + pODef.key + " type=" + validTypes[pODef.type]);
        }
    }

    private void DisplayProps(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        if (!enumeration.hasMoreElements()) {
            System.out.println("           No entries");
            return;
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println("   " + string + " = " + properties.getProperty(string));
        }
    }
}

