/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation;

import com.ibm.etools.emf.ecore.utilities.IDUtil;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.IMessageAccess;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.IValidator;
import com.ibm.etools.validation.Message;
import com.ibm.etools.validation.MessageFilter;
import com.ibm.etools.wft.nls.J2EEResourceHandler;
import com.ibm.websphere.validation.FullReporterConstants;
import com.ibm.websphere.validation.ValidationMessage;
import com.ibm.websphere.validation.ValidationMessageManager;
import com.ibm.websphere.validation.ValidatorStub;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.ecore.EObject;

public class IncrementalReporter
implements IReporter,
IMessageAccess,
FullReporterConstants {
    public void addMessage(IValidator iValidator, IMessage iMessage) {
        if (iValidator == null || iMessage == null) {
            return;
        }
        ValidationMessage validationMessage = ValidationMessageManager.getManager().getMessages(iValidator);
        if (validationMessage != null) {
            validationMessage.addValidationMessage(iValidator, iMessage);
        }
    }

    protected String annotateMessage(IMessage iMessage, Locale locale) {
        String string = iMessage.getText(locale);
        Object object = iMessage.getTargetObject();
        if (object != null) {
            if (object instanceof EObject) {
                EObject eObject = (EObject)object;
                String string2 = IDUtil.getOrAssignID((EObject)eObject);
                string = this.getMessage("com.ibm.websphere.validation.fullreporterNLS", "INFO_MOF_BANNER", new String[]{string2, string}, locale);
            } else {
                string = this.getMessage("com.ibm.websphere.validation.fullreporterNLS", "INFO_NON_MOF_BANNER", new String[]{object.toString(), object.getClass().getName()}, locale);
            }
        }
        return string;
    }

    public void displaySubtask(IValidator iValidator, IMessage iMessage) {
        System.err.println(iMessage.getText());
    }

    public String getMessage(String string, String string2, String[] stringArray, Locale locale) {
        return J2EEResourceHandler.getExternalizedMessage((String)string, (String)string2, this.getClass(), (Object[])stringArray, (Locale)locale);
    }

    public String getMessage(String string, String string2, Locale locale) {
        return J2EEResourceHandler.getExternalizedMessage((String)string, (String)string2, this.getClass(), (Locale)locale);
    }

    public IMessageAccess getMessageAccess() {
        return this;
    }

    public List getMessages(MessageFilter messageFilter) {
        int n = messageFilter != null ? messageFilter.getSeverity() : 7;
        return ValidationMessageManager.getManager().getMessages(n);
    }

    public List getMessagesAsText(MessageFilter messageFilter, Locale locale) {
        List list = this.getMessages(messageFilter);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            IMessage iMessage = (IMessage)list.get(n2);
            String string = this.annotateMessage(iMessage, locale);
            arrayList.add(string);
            ++n2;
        }
        return arrayList;
    }

    public boolean isCancelled() {
        return false;
    }

    public static void main(String[] stringArray) {
        Object object;
        IncrementalReporter incrementalReporter = new IncrementalReporter();
        IMessageAccess iMessageAccess = incrementalReporter.getMessageAccess();
        if (iMessageAccess == null) {
            System.err.println("Error: null message access");
            System.exit(-1);
        }
        ValidatorStub validatorStub = new ValidatorStub();
        Message message = new Message("com.ibm.websphere.validation.fullreporterNLS", 1, "INFO_COMPONENT_NAME");
        Message message2 = new Message("com.ibm.websphere.validation.fullreporterNLS", 2, "INFO_COMPONENT_NAME");
        Message message3 = new Message("com.ibm.websphere.validation.fullreporterNLS", 4, "INFO_COMPONENT_NAME");
        incrementalReporter.removeAllMessages(validatorStub);
        if (!iMessageAccess.getMessages(null).isEmpty()) {
            System.err.println("Error: removeAllMessages(validator) failed.");
            System.err.println("Reporter Contents:");
            incrementalReporter.report();
            System.exit(-1);
        }
        incrementalReporter.addMessage(validatorStub, (IMessage)message);
        incrementalReporter.addMessage(validatorStub, (IMessage)message2);
        incrementalReporter.addMessage(validatorStub, (IMessage)message3);
        List list = iMessageAccess.getMessages(null);
        if (list.size() != 3) {
            System.err.println("Error: Get all messages failed.");
            System.exit(-1);
        }
        System.out.println("\nAll Messages:");
        int n = 0;
        while (n < list.size()) {
            object = ((IMessage)list.get(n)).getText();
            System.out.println((String)object);
            ++n;
        }
        object = iMessageAccess.getMessagesAsText(null, Locale.getDefault());
        System.out.println("\nAll Messages as Text:");
        int n2 = 0;
        while (n2 < object.size()) {
            System.out.println(object.get(n2));
            ++n2;
        }
        incrementalReporter.removeAllMessages(validatorStub);
        if (!iMessageAccess.getMessages(null).isEmpty()) {
            System.err.println("Error: removeAllMessages(validator) failed.");
            System.err.println("Reporter Contents:");
            incrementalReporter.report();
            System.exit(-1);
        }
    }

    public void print(int n) {
    }

    public void removeAllMessages() {
        ValidationMessageManager.getManager().removeAllMessages();
    }

    public void removeAllMessages(IValidator iValidator) {
        ValidationMessageManager.getManager().removeAllMessages(iValidator);
    }

    public void removeAllMessages(IValidator iValidator, Object object) {
        ValidationMessageManager.getManager().removeAllMessages(iValidator, object);
    }

    public void removeMessageSubset(IValidator iValidator, Object object, String string) {
    }

    public void report() {
        List list = this.getMessages(null);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            System.out.println((IMessage)iterator.next());
        }
    }

    public void setCancelled(boolean bl) {
    }
}

