/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.bindings.webappbnd;

import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.j2ee.common.EjbRef;
import com.ibm.etools.validation.IFileDelta;
import com.ibm.etools.validation.IHelper;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.j2ee.J2EEValidator;
import com.ibm.etools.validation.mof.PassthruHelper;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.websphere.validation.FullReporter;
import com.ibm.websphere.validation.base.bindings.webappbnd.WebAppBindingMessageConstants;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;

public class WebAppBindingValidator
extends J2EEValidator
implements WebAppBindingMessageConstants {
    public String getBaseName() {
        return "webappbndvalidation";
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: first arg specifies full path to WAR file.");
        }
        String string = stringArray[0];
        try {
            WARFile wARFile = CommonarchiveFactoryImpl.getActiveFactory().openWARFile(string);
            WebAppBinding webAppBinding = wARFile.getBindings();
            PassthruHelper passthruHelper = new PassthruHelper((EObject)webAppBinding);
            FullReporter fullReporter = new FullReporter();
            WebAppBindingValidator webAppBindingValidator = new WebAppBindingValidator();
            webAppBindingValidator.validate((IHelper)passthruHelper, fullReporter, null);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void validate(WebAppBinding webAppBinding) {
        String string;
        String string2;
        EjbRef ejbRef;
        Iterator iterator;
        String string3;
        WebApp webApp = webAppBinding.getWebapp();
        if (webApp == null) {
            this.addError("NULL_WEBAPP_REFERENCE");
            return;
        }
        String string4 = webApp.getDisplayName();
        if (string4 == null || string4.length() == 0) {
            string4 = "?";
        }
        if ((string3 = webAppBinding.getVirtualHostName()) == null || string3.length() == 0) {
            string3 = "?";
        }
        Iterator iterator2 = webAppBinding.getEjbRefBindings().iterator();
        while (iterator2.hasNext()) {
            iterator = (EjbRefBinding)iterator2.next();
            ejbRef = iterator.getBindingEjbRef();
            if (ejbRef == null) {
                this.addError("NULL_EJBREF_REFERENCE", new String[]{string4});
                continue;
            }
            string2 = ejbRef.getHome();
            if (string2 == null || string2.length() == 0) {
                string2 = "?";
            }
            if ((string = iterator.getJndiName()) != null && string.length() != 0) continue;
            this.addWarning("NO_JNDINAME_FOR_EJBREF", new String[]{string2, string4});
        }
        iterator = webAppBinding.getResRefBindings().iterator();
        while (iterator.hasNext()) {
            String string5;
            String string6;
            ejbRef = (ResourceRefBinding)iterator.next();
            string2 = ejbRef.getBindingResourceRef();
            if (string2 == null) {
                this.addError("NULL_RESOURCEREF_REFERENCE", new String[]{string4});
                continue;
            }
            string = string2.getType();
            if (string == null || string.length() == 0) {
                string = "?";
            }
            if ((string6 = string2.getName()) == null || string6.length() == 0) {
                string6 = "?";
            }
            if ((string5 = ejbRef.getJndiName()) != null && string5.length() != 0) continue;
            this.addWarning("NO_JNDINAME_FOR_RESOURCEREF", new String[]{string6, string, string4});
        }
    }

    public void validate(IHelper iHelper, IReporter iReporter, IFileDelta[] iFileDeltaArray) throws ValidationException {
        this._reporter = iReporter;
        this._helper = iHelper;
        if (this._reporter == null || this._helper == null) {
            return;
        }
        try {
            Object object = this._helper.loadModel("WebAppBinding");
            if (object == null) {
                return;
            }
            this.validate((WebAppBinding)object);
        }
        catch (Exception exception) {
            this.addError("ERROR_WEBAPPBND_VALIDATION_FAILED", new String[]{exception.getMessage()});
            exception.printStackTrace();
        }
    }
}

