/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config;

import com.ibm.etools.validation.IFileDelta;
import com.ibm.etools.validation.IHelper;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.IValidator;
import com.ibm.etools.validation.Message;
import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.validation.base.config.MOFValidationConstants;
import com.ibm.websphere.validation.base.config.OutputSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;

public class MOFValidator
implements IValidator,
MOFValidationConstants {
    public static final String DEBUG_PROPERTY_NAME = "com.ibm.websphere.validation.debug";
    protected OutputSupport _trace;
    protected IHelper _helper;
    protected IReporter _reporter;
    protected IFileDelta[] _changedFiles;
    protected int _currentFileNo;
    protected HashSet _parents;
    protected static final boolean INCLUDE_NULLS = true;
    protected static final boolean NO_INCLUDE_NULLS = false;

    public MOFValidator() {
        if (Boolean.getBoolean(DEBUG_PROPERTY_NAME)) {
            this.enableTrace();
        }
        this._helper = null;
        this._reporter = null;
        this._changedFiles = null;
        this._currentFileNo = -1;
        this._parents = null;
    }

    protected IHelper getHelper() {
        return this._helper;
    }

    protected void setHelper(IHelper iHelper) {
        this._helper = iHelper;
    }

    protected IReporter getReporter() {
        return this._reporter;
    }

    protected void setReporter(IReporter iReporter) {
        this._reporter = iReporter;
    }

    protected String getCurrentFileName() {
        return this._changedFiles[this._currentFileNo].getFileName();
    }

    protected boolean hasAnotherFile() {
        return this._currentFileNo < this._changedFiles.length;
    }

    protected void moveToFirstFile() {
        this._currentFileNo = 0;
    }

    protected void moveToNextFile() {
        ++this._currentFileNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(IHelper iHelper, IReporter iReporter, IFileDelta[] iFileDeltaArray) throws ValidationException {
        this.traceBegin("validate");
        try {
            this._helper = iHelper;
            this._reporter = iReporter;
            this._changedFiles = iFileDeltaArray;
            this._parents = new HashSet();
            this.moveToFirstFile();
            while (this.hasAnotherFile()) {
                String string = this.getCurrentFileName();
                if (!string.startsWith("templates")) {
                    Object object = this.loadModel(string);
                    if (object instanceof Exception) {
                        this.handleLoadException((Exception)object, string);
                    } else {
                        this.visit(object);
                    }
                }
                this.moveToNextFile();
            }
            Object var7_6 = null;
            this.traceEnd();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.traceEnd();
            throw throwable;
        }
    }

    protected Object loadModel(String string) {
        this.trace("Loading: ", string);
        Object[] objectArray = null;
        return this._helper.loadModel(string, objectArray);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.mofvalidationNLS";
    }

    private String getValidationFailureCode() {
        return "ERROR_VALIDATION_FAILED";
    }

    protected String getRecognitionFailureCode() {
        return "WARNING_RECOGNITION_FAILED";
    }

    private void handleLoadException(Exception exception, String string) throws ValidationException {
        Message message = new Message("com.ibm.websphere.validation.base.config.mofvalidationNLS", 1, this.getValidationFailureCode(), new String[]{string}, null);
        ValidationException validationException = new ValidationException((IMessage)message, (Throwable)exception);
        throw validationException;
    }

    public void cleanup(IReporter iReporter) {
        this.traceBegin("cleanup");
        this.trace("This method has been deprecated.");
        this.traceEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Object object) throws ValidationException {
        this.traceBegin("visit(Object)");
        try {
            block10: {
                if (object instanceof List) {
                    this.visitList((List)object);
                } else if (object instanceof EObject && !(object instanceof EEnumLiteral)) {
                    if (!this._parents.contains(object)) {
                        this._parents.add(object);
                        try {
                            this.basicVisit(object);
                            this.visitList(this.getChildren(object));
                            Object var3_2 = null;
                            this._parents.remove(object);
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            this._parents.remove(object);
                            throw throwable;
                        }
                        {
                            break block10;
                        }
                    }
                    this.trace("Object already visited; skipping");
                } else if (this.isTraceEnabled()) {
                    this.trace("Not a Ref Object; skipping");
                }
            }
            Object var5_5 = null;
            this.traceEnd();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.traceEnd();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitList(List list) throws ValidationException {
        this.traceBegin("visitList");
        try {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.visit(iterator.next());
            }
            Object var4_3 = null;
            this.traceEnd();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.traceEnd();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicVisit(Object object) throws ValidationException {
        if (this.isTraceEnabled()) {
            this.traceBegin("basicVisit", object.getClass().getName());
        }
        try {
            this.basicValidate(object);
            Object var3_2 = null;
            this.traceEnd();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.traceEnd();
            throw throwable;
        }
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        if (!this.isTraceEnabled()) {
            return false;
        }
        String string = object.getClass().getName();
        this.trace("Unrecognized object type; skipping: ", string);
        this.addError(this.getRecognitionFailureCode(), new String[]{string}, object);
        return false;
    }

    protected List getChildren(Object object) {
        EList eList;
        this.traceBegin("getChildren");
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            eList = eObject.eContents();
        } else {
            eList = new ArrayList();
        }
        this.traceEnd();
        return eList;
    }

    public String getTraceName() {
        return this.getClass().getName();
    }

    public void setTrace(OutputSupport outputSupport) {
        this._trace = outputSupport;
    }

    public OutputSupport getTrace() {
        return this._trace;
    }

    public boolean isTraceEnabled() {
        return this._trace != null;
    }

    public void enableTrace() {
        if (this._trace == null) {
            this._trace = new OutputSupport(System.out);
            this.trace("Enabled trace");
        }
    }

    public void disableTrace() {
        if (this._trace != null) {
            this.trace("Disabling trace");
            this._trace = null;
        }
    }

    public void trace(Object object) {
        if (this._trace != null) {
            this._trace.printlnBeginning(object);
        }
    }

    public void trace(Object object, Object object2) {
        if (this._trace != null) {
            this._trace.printlnBeginning(object, object2);
        }
    }

    public void traceBegin(String string) {
        if (this._trace != null) {
            this._trace.begin(this.getTraceName(), string);
        }
    }

    public void traceBegin(String string, Object object) {
        if (this._trace != null) {
            this._trace.begin(this.getTraceName(), string, object);
        }
    }

    public void traceEnd() {
        if (this._trace != null) {
            this._trace.end();
        }
    }

    public void traceEnd(Object object) {
        if (this._trace != null) {
            this._trace.end(object);
        }
    }

    public void traceEnd(boolean bl) {
        if (this._trace != null) {
            this._trace.end(bl);
        }
    }

    public void traceStub(Object object) {
        if (this._trace != null) {
            this._trace.printlnBeginning("Stubbed: " + object);
        }
    }

    public void traceStub(Object object, Object object2) {
        if (this._trace != null) {
            this._trace.printlnBeginning("Stubbed: " + object + object2);
        }
    }

    public void addError(String string, String[] stringArray, Object object) {
        this.addError(this.getBundleId(), string, stringArray, object);
    }

    public void addError(String string, Object object) {
        this.addError(this.getBundleId(), string, new String[0], object);
    }

    public void addError(String string, String string2, String[] stringArray, Object object) {
        Message message = new Message(string, 1, string2, stringArray, object);
        if (message == null) {
            System.out.println(">>>> Add Error: Null <<<<");
        }
        this._reporter.addMessage((IValidator)this, (IMessage)message);
    }

    public void addInfo(String string, String[] stringArray, Object object) {
        this.addInfo(this.getBundleId(), string, stringArray, object);
    }

    public void addInfo(String string, Object object) {
        this.addInfo(this.getBundleId(), string, null, object);
    }

    public void addInfo(String string, String string2, String[] stringArray, Object object) {
        Message message = new Message(string, 4, string2, stringArray, object);
        if (message == null) {
            System.out.println(">>>> Add Info: Null <<<<");
        }
        this._reporter.addMessage((IValidator)this, (IMessage)message);
    }

    public void addWarning(String string, String[] stringArray, Object object) {
        this.addWarning(this.getBundleId(), string, stringArray, object);
    }

    public void addWarning(String string, Object object) {
        this.addWarning(this.getBundleId(), string, null, object);
    }

    public void addWarning(String string, String string2, String[] stringArray, Object object) {
        Message message = new Message(string, 2, string2, stringArray, object);
        if (message == null) {
            System.out.println(">>>> Add Warning: Null <<<<");
        }
        this._reporter.addMessage((IValidator)this, (IMessage)message);
    }

    protected String trimLeadingChainOf(String string) {
        int n = string.lastIndexOf("/");
        string = n == -1 ? "" : string.substring(0, n);
        return string;
    }

    protected String nabHeadOf(String string) {
        int n = string.indexOf("/");
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    protected String nabTailOf(String string) {
        int n = string.indexOf("/");
        return n == -1 ? null : string.substring(n + 1);
    }

    protected String nabEndOf(String string) {
        int n = string.lastIndexOf("/");
        if (n != -1) {
            string = string.substring(n);
        }
        return string;
    }

    public boolean isEnumValueValid(int n, EEnum eEnum) {
        EList eList = eEnum.getELiterals();
        int n2 = eList.size();
        int n3 = 0;
        while (n3 < n2) {
            EEnumLiteral eEnumLiteral = (EEnumLiteral)eList.get(n3);
            if (n == eEnumLiteral.getValue()) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean isEnumValueValid(Integer n, EEnum eEnum) {
        return this.isEnumValueValid((int)n, eEnum);
    }
}

