/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.validation.base.config.NodeServersValidationConstants;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;

public class NodeServersCrossValidator
extends WebSpherePlatformCrossValidator
implements NodeServersValidationConstants {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.nodeserversvalidationNLS";
    }

    public String getTraceName() {
        return "NodeServersCrossValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof ServerIndex) {
            this.validateAcross((ServerIndex)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    protected void validateAcross(ServerIndex serverIndex) {
        this.validateServerNames(serverIndex);
        this.validateDeployedApplications(serverIndex);
        this.traceStub("Matching of configured ports with ports in other documents.");
    }

    protected void validateServerNames(ServerIndex serverIndex) {
        String string = this.getNodeUri();
        String string2 = this.getNodeName();
        HashMap hashMap = this.getNodeServerNames();
        HashSet hashSet = (HashSet)hashMap.get(string);
        Iterator iterator = serverIndex.getServerEntries().iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            String string3 = serverEntry.getServerName();
            if (hashSet.contains(string3)) continue;
            this.addError("ERROR_SERVER_ENTRY_MISSING_SERVER", new String[]{string3, string2, this.getCurrentFileName()}, serverEntry);
        }
        this.traceStub("Ensure that all configured servers have a member.");
    }

    protected void validateDeployedApplications(ServerIndex serverIndex) {
        Iterator iterator = serverIndex.getServerEntries().iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            this.validateDeployedApplications(serverEntry);
        }
    }

    protected void validateDeployedApplications(ServerEntry serverEntry) {
        EList eList = serverEntry.getDeployedApplications();
        if (eList == null) {
            return;
        }
        int n = eList.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)eList.get(n2);
            int n3 = string.indexOf("/");
            if (n3 != -1) {
                string = string.substring(0, n3);
            }
            if (!this.isDeployed(string)) {
                this.addError("ERROR_DEPLOYED_APPLICATION_NOT_FOUND", new String[]{string}, serverEntry);
            }
            ++n2;
        }
    }
}

