/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionManager;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.datareplicationserver.SystemMessageServer;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.multibroker.MultiBrokerRoutingEntry;
import com.ibm.websphere.models.config.multibroker.MultibrokerDomain;
import com.ibm.websphere.models.config.process.ManagedObject;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.validation.base.config.ServerValidationConstants;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;

public class ServerCrossValidator
extends WebSpherePlatformCrossValidator
implements ServerValidationConstants {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.servervalidationNLS";
    }

    public String getTraceName() {
        return "ServerCrossValidator";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Object object) throws ValidationException {
        this.traceBegin("visit(Object)");
        try {
            block10: {
                if (object instanceof List) {
                    this.visitList((List)object);
                } else if (object instanceof EObject && !(object instanceof EEnumLiteral)) {
                    if (!this._parents.contains(object)) {
                        this._parents.add(object);
                        try {
                            this.basicVisit(object);
                            this.visitList(this.getChildren(object));
                            Object var3_2 = null;
                            this._parents.remove(object);
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            this._parents.remove(object);
                            throw throwable;
                        }
                        {
                            break block10;
                        }
                    }
                    this.trace("Object already visited; skipping");
                } else if (this.isTraceEnabled()) {
                    this.trace("Not a Ref Object; skipping");
                }
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.traceEnd();
            throw throwable;
        }
        this.traceEnd();
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        if (object instanceof Server) {
            this.trace("Object recognized as a server; validating");
            this.validateAcross((Server)object);
        } else if (object instanceof SystemMessageServer) {
            this.trace("Object recognized as a system message server; validating");
            this.validateAcross((SystemMessageServer)object);
        } else if (object instanceof DRSSettings) {
            this.trace("Object recognized as DRS settings; validating");
            this.validateAcross((DRSSettings)object);
        } else if (object instanceof WebContainer) {
            this.trace("Object recognized as a session manager; validating");
            this.validateAcross((WebContainer)object);
        }
        return true;
    }

    public void validateAcross(Server server) {
        this.validateServerClusterName(server);
    }

    protected void validateServerClusterName(Server server) {
        Object e;
        Iterator iterator;
        String string;
        String string2 = server.getClusterName();
        if (string2 == null || string2.length() == 0) {
            return;
        }
        Iterator iterator2 = this.getClusterNames().iterator();
        boolean bl = false;
        while (!bl && iterator2.hasNext()) {
            string = (String)iterator2.next();
            bl = string2.equals(string);
        }
        if (!bl) {
            this.addError("ERROR_SERVER_CLUSTER_NAME_MATCHES_NO_CLUSTER", new String[]{server.getName(), string2}, server);
            return;
        }
        string = this.getNodeUri() + "/" + "clusters" + "/" + string2 + "/" + "cluster.xml";
        Object object = this.loadModel(string);
        boolean bl2 = false;
        if (object instanceof List && (iterator = ((List)object).iterator()).hasNext() && (e = iterator.next()) instanceof ServerCluster) {
            ServerCluster serverCluster = (ServerCluster)e;
            Iterator iterator3 = serverCluster.getMembers().iterator();
            while (!bl2 && iterator3.hasNext()) {
                ClusterMember clusterMember = (ClusterMember)iterator3.next();
                String string3 = clusterMember.getMemberName();
                bl2 = string2.equals(string3);
            }
        }
        if (!bl2) {
            this.addError("ERROR_SERVER_NOT_PRESENT_IN_CLUSTER", new String[]{server.getName(), string2}, server);
        }
    }

    protected void validateAcross(SystemMessageServer systemMessageServer) {
        this.trace("validateAcross(SystemMessageServer)");
        String string = systemMessageServer.getBrokerName();
        String string2 = systemMessageServer.getDomainName();
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return;
        }
        Iterator iterator = this.getMultibrokerDomains().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            MultibrokerDomain multibrokerDomain = (MultibrokerDomain)iterator.next();
            String string3 = multibrokerDomain.getName();
            if (!string2.equals(string3)) continue;
            Iterator iterator2 = multibrokerDomain.getEntries().iterator();
            while (iterator2.hasNext()) {
                MultiBrokerRoutingEntry multiBrokerRoutingEntry = (MultiBrokerRoutingEntry)iterator2.next();
                String string4 = multiBrokerRoutingEntry.getBrokerName();
                if (!string.equals(string4)) continue;
                ++n;
            }
        }
        if (n == 0) {
            if (this.isSetToStart((ManagedObject)systemMessageServer)) {
                this.addError("ERROR_SYSTEM_MESSAGE_SERVER_NO_BROKER_MATCHES", new String[]{systemMessageServer.getName(), string2, string}, systemMessageServer);
            } else {
                this.addWarning("WARNING_SYSTEM_MESSAGE_SERVER_NO_BROKER_MATCHES", new String[]{systemMessageServer.getName(), string2, string}, systemMessageServer);
            }
        } else if (n != 1) {
            this.addError("ERROR_SYSTEM_MESSAGE_SERVER_MULTIPLE_BROKER_MATCHES", new String[]{systemMessageServer.getName(), string2, string}, systemMessageServer);
        }
    }

    public void validateAcross(SessionManager sessionManager) {
        Object object;
        String string;
        int n = sessionManager.getSessionPersistenceMode().getValue();
        if (n == 2) {
            return;
        }
        DRSSettings dRSSettings = sessionManager.getSessionDRSPersistence();
        if (dRSSettings == null) {
            return;
        }
        String string2 = dRSSettings.getMessageBrokerDomainName();
        if (string2 == null || string2.length() == 0) {
            return;
        }
        Iterator iterator = this.getMultibrokerDomains().iterator();
        String string3 = null;
        while (string3 == null && iterator.hasNext()) {
            string = (MultibrokerDomain)iterator.next();
            object = string.getName();
            if (!string2.equals(object)) continue;
            string3 = string;
        }
        if (string3 == null) {
            this.addError("ERROR_SESSION_MANAGER_NO_MATCHING_DOMAIN", new String[]{string2}, sessionManager);
            return;
        }
        string = dRSSettings.getPreferredLocalDRSBrokerName();
        if (string == null || string.length() == 0) {
            return;
        }
        object = string3.getEntries().iterator();
        MultiBrokerRoutingEntry multiBrokerRoutingEntry = null;
        while (multiBrokerRoutingEntry == null && object.hasNext()) {
            MultiBrokerRoutingEntry multiBrokerRoutingEntry2 = (MultiBrokerRoutingEntry)object.next();
            String string4 = multiBrokerRoutingEntry2.getBrokerName();
            if (!string.equals(string4)) continue;
            multiBrokerRoutingEntry = multiBrokerRoutingEntry2;
        }
        if (string3 == null) {
            this.addError("ERROR_SESSION_MANAGER_NO_MATCHING_ENTRY", new String[]{string2, string}, sessionManager);
        }
    }

    public void validateAcross(WebContainer webContainer) {
        Iterator iterator = webContainer.getTransports().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        HashSet hashSet = this.getCellSecurityAliasTable();
        while (iterator.hasNext()) {
            String string;
            Transport transport = (Transport)iterator.next();
            boolean bl = transport.isSslEnabled();
            if (!bl || (string = transport.getSslConfig()) == null && string.length() == 0 || hashSet.contains(string)) continue;
            EndPoint endPoint = transport.getAddress();
            String string2 = endPoint != null ? endPoint.getHost() : null;
            int n = endPoint != null ? endPoint.getPort() : 0;
            String string3 = String.valueOf(n);
            this.addError("ERROR_TRANSPORT_ALIAS_NOT_FOUND", new String[]{webContainer.getName(), string2, string3, string}, transport);
        }
    }

    public void validateAcross(DRSSettings dRSSettings) {
        String string = dRSSettings.getPreferredLocalDRSBrokerName();
        if (string == null || string.length() == 0) {
            return;
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
        Iterator iterator = this.getNodeSystemMessageServers().iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            SystemMessageServer systemMessageServer = (SystemMessageServer)objectArray[3];
            String string2 = systemMessageServer.getBrokerName();
            if (!string.equals(string2)) continue;
            if (this.isSetToStart((ManagedObject)systemMessageServer)) {
                arrayList.add(objectArray);
                continue;
            }
            arrayList2.add(objectArray);
        }
        int n = arrayList.size();
        int n2 = arrayList2.size();
        if (n == 0) {
            if (n2 == 0) {
                this.addError("ERROR_DRS_SETTINGS_NO_SYSTEM_MESSAGE_SERVER", new String[]{string}, dRSSettings);
            } else {
                this.addError("ERROR_DRS_SETTINGS_STOPPED_SYSTEM_MESSAGE_SERVER", new String[]{string}, dRSSettings);
            }
        } else if (n > 0) {
            this.addError("ERROR_DRS_SETTINGS_MULTIPLE_STARTING_SYSTEM_MESSAGE_SERVERS", new String[]{string}, dRSSettings);
        }
    }
}

