/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.websphere.validation.base.config.VariablesValidationConstants;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VariablesCrossValidator
extends WebSpherePlatformCrossValidator
implements VariablesValidationConstants {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";
    public static final String WAS_INSTALL_ROOT = "WAS_INSTALL_ROOT";
    public static final String USER_INSTALL_ROOT = "USER_INSTALL_ROOT";
    public static final String VARIABLES_XML = "variables.xml";

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.variablesvalidationNLS";
    }

    public String getTraceName() {
        return "VariablesCrossValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof VariableMap) {
            this.trace("Object recognized as a variable map; validating");
            this.validateAcross((VariableMap)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(VariableMap variableMap) {
        if (this.getServerName() != null && this.getCurrentFileName().equals(this.getServerUri() + "/" + VARIABLES_XML)) {
            this.checkServerForInstallPath(variableMap);
        } else if (this.getNodeName() != null && this.getCurrentFileName().equals(this.getNodeUri() + "/" + VARIABLES_XML)) {
            this.checkNodeForInstallPath(variableMap);
        } else if (this.getCellName() == null || this.getCurrentFileName().equals(this.getCellUri() + "/" + VARIABLES_XML)) {
            // empty if block
        }
    }

    protected void checkServerForInstallPath(VariableMap variableMap) {
        List list = this.getParentVariableMaps(variableMap);
        String string = null;
        String string2 = null;
        Iterator iterator = variableMap.getEntries().iterator();
        while (iterator.hasNext()) {
            VariableSubstitutionEntry variableSubstitutionEntry = (VariableSubstitutionEntry)iterator.next();
            String string3 = variableSubstitutionEntry.getSymbolicName();
            if (string3 == null) continue;
            if (string3.equals(WAS_INSTALL_ROOT)) {
                string = variableSubstitutionEntry.getValue();
            }
            if (!string3.equals(USER_INSTALL_ROOT)) continue;
            string2 = variableSubstitutionEntry.getValue();
        }
        if (string != null) {
            this.addInfo("INFO_VARIABLE_MAP_ROOT_OVERLOADED", new String[]{WAS_INSTALL_ROOT, this.getServerName(), string}, variableMap);
        }
        if (string2 != null) {
            this.addInfo("INFO_VARIABLE_MAP_ROOT_OVERLOADED", new String[]{USER_INSTALL_ROOT, this.getServerName(), string2}, variableMap);
        }
    }

    protected void checkNodeForInstallPath(VariableMap variableMap) {
        String string;
        List list = this.getParentVariableMaps(variableMap);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        VariableSubstitutionEntry variableSubstitutionEntry = null;
        Iterator iterator = variableMap.getEntries().iterator();
        while (iterator.hasNext()) {
            variableSubstitutionEntry = (VariableSubstitutionEntry)iterator.next();
            string = variableSubstitutionEntry.getSymbolicName();
            if (string == null) continue;
            if (string.equals(WAS_INSTALL_ROOT)) {
                string4 = variableSubstitutionEntry.getValue();
            }
            if (!string.equals(USER_INSTALL_ROOT)) continue;
            string5 = variableSubstitutionEntry.getValue();
        }
        string = this.getCellUri() + "/" + VARIABLES_XML;
        Object object = this.loadModel(string);
        VariableSubstitutionEntry variableSubstitutionEntry2 = null;
        if (object instanceof List) {
            iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                String string6;
                Object e = iterator.next();
                if (!(e instanceof VariableSubstitutionEntry) || (string6 = (variableSubstitutionEntry2 = (VariableSubstitutionEntry)e).getSymbolicName()) == null) continue;
                if (string6.equals(WAS_INSTALL_ROOT)) {
                    string2 = variableSubstitutionEntry2.getValue();
                }
                if (!string6.equals(USER_INSTALL_ROOT)) continue;
                string3 = variableSubstitutionEntry2.getValue();
            }
        }
        if ((string2 != null || string4 != null) && string2 != null && string4 != null) {
            if (string2.equals(string4)) {
                this.addInfo("INFO_VARIABLE_MAP_WAS_INSTALL_ROOT_OVERLOADED", new String[]{WAS_INSTALL_ROOT, this.getCellName(), this.getNodeName()}, variableSubstitutionEntry);
            } else {
                this.addError("ERROR_VARIABLE_MAP_WAS_INSTALL_ROOT_REDEFINED", new String[]{WAS_INSTALL_ROOT, this.getCellName(), this.getNodeName(), string3, string5}, variableSubstitutionEntry);
            }
        }
        if ((string3 != null || string5 != null) && string3 != null && string4 != null) {
            if (string3.equals(string5)) {
                this.addInfo("INFO_VARIABLE_MAP_USER_INSTALL_ROOT_OVERLOADED", new String[]{USER_INSTALL_ROOT, this.getCellName(), this.getNodeName()}, variableSubstitutionEntry);
            } else {
                this.addError("ERROR_VARIABLE_MAP_USER_INSTALL_ROOT_REDEFINED", new String[]{USER_INSTALL_ROOT, this.getCellName(), this.getNodeName(), string3, string5}, variableSubstitutionEntry);
            }
        }
    }

    protected List getParentVariableMaps(VariableMap variableMap) {
        ArrayList<VariableMap> arrayList = new ArrayList<VariableMap>();
        arrayList.add(variableMap);
        this.traceStub("Retrieve of parent variable maps.");
        return arrayList;
    }
}

