/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config;

import com.ibm.websphere.models.config.datareplicationserver.SystemMessageServer;
import com.ibm.websphere.models.config.jaaslogin.JAASAuthData;
import com.ibm.websphere.models.config.multibroker.MultibrokerDomain;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.ExecutionState;
import com.ibm.websphere.models.config.process.ManagedObject;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.StateManageable;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.validation.base.config.MOFCrossValidator;
import com.ibm.websphere.validation.base.config.TypeTester;
import com.ibm.websphere.validation.base.config.WebSpherePlatformConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class WebSpherePlatformCrossValidator
extends MOFCrossValidator
implements WebSpherePlatformConstants {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";
    protected TypeTester _typeTester = new TypeTester(this);
    protected boolean _computedCellData;
    protected String _cellUri;
    protected String _cellName;
    protected String _nodeUri;
    protected String _nodeName;
    protected String _serverUri;
    protected String _serverName;
    protected List _clusterUris;
    protected List _clusterNames;
    protected List _nodeUris;
    protected List _nodeNames;
    protected List _applicationUris;
    protected List _applicationNames;
    protected boolean _computedMultiBrokerData;
    protected List _multibrokerDomains;
    protected boolean _computedNodeServerData;
    protected HashMap _nodeServerUris;
    protected HashMap _nodeServerNames;
    protected List _nodeSystemMessageServers;
    protected boolean _computedDeploymentMap;
    protected HashSet _deploymentMap;
    protected boolean _computedCellSecurityData;
    protected Security _cellSecurity;
    protected HashSet _cellSecurityAliasTable;
    protected HashSet _cellSecurityJAASAuthDataTable;
    protected static final int SYSTEM_MESSAGE_SERVER_DATA_NODE_NAME_OFFSET = 0;
    protected static final int SYSTEM_MESSAGE_SERVER_DATA_SERVER_NAME_OFFSET = 1;
    protected static final int SYSTEM_MESSAGE_SERVER_DATA_SERVER_OFFSET = 2;
    protected static final int SYSTEM_MESSAGE_SERVER_DATA_COMPONENT_OFFSET = 3;

    public WebSpherePlatformCrossValidator() {
        this.clearCachedData();
    }

    protected void clearCachedData() {
        this.clearCellData();
        this.clearMultiBrokerData();
        this.clearCellSecurityData();
        this.clearNodeServerData();
        this.clearDeploymentMap();
    }

    protected void clearCellData() {
        this._computedCellData = false;
        this._cellUri = null;
        this._cellName = null;
        this._nodeUri = null;
        this._nodeName = null;
        this._serverUri = null;
        this._serverName = null;
        this._nodeUris = null;
        this._nodeNames = null;
        this._clusterUris = null;
        this._clusterNames = null;
        this._applicationUris = null;
        this._applicationNames = null;
    }

    protected void clearNodeServerData() {
        this._computedNodeServerData = false;
        this._nodeServerUris = null;
        this._nodeServerNames = null;
        this._nodeSystemMessageServers = null;
    }

    protected void ensureCellData() {
        if (!this._computedCellData) {
            this._computedCellData = true;
            this.computeCellData();
        }
    }

    protected void computeCellData() {
        this.trace("Computing cell data:");
        String string = this.getCurrentFileName();
        this.trace("Current file uri: ", string);
        if (!string.startsWith("cells/")) {
            this.trace("Not beneath a cell");
            return;
        }
        string = string.substring("cells/".length());
        this._cellName = this.nabHeadOf(string);
        this._cellUri = "cells/" + this._cellName;
        this.trace("Cell name: " + this._cellName);
        this.trace("Cell URI: " + this._cellUri);
        if (string.length() > this._cellName.length() && (string = string.substring(this._cellName.length() + 1)).startsWith("nodes/")) {
            string = string.substring("nodes/".length());
            this._nodeName = this.nabHeadOf(string);
            this._nodeUri = this._cellUri + "/nodes/" + this._nodeName;
            this.trace("Node name: " + this._nodeName);
            this.trace("Node URI: " + this._nodeUri);
            if (string.length() > this._nodeName.length() && (string = string.substring(this._nodeName.length() + 1)).startsWith("servers/")) {
                string = string.substring("servers/".length());
                this._serverName = this.nabHeadOf(string);
                this._serverUri = this._nodeUri + "/servers/" + this._serverName;
                this.trace("Server name: " + this._serverName);
                this.trace("Server URI: " + this._serverUri);
            }
            if (this._serverName == null) {
                this.trace("Not beneath a server");
            }
        }
        if (this._nodeName == null) {
            this.trace("Not beneath a node");
        }
        this._nodeUris = new ArrayList();
        this._nodeNames = new ArrayList();
        this._clusterUris = new ArrayList();
        this._clusterNames = new ArrayList();
        this._applicationUris = new ArrayList();
        this._applicationNames = new ArrayList();
        int n = this._cellUri.length() + 1;
        Object object = this.loadModel(this._cellUri);
        Iterator iterator = object instanceof List ? ((List)object).iterator() : new ArrayList().iterator();
        this.trace("Filling cell data");
        while (iterator.hasNext()) {
            String string2;
            String string3 = (String)iterator.next();
            String string4 = string3.substring(n);
            if (string4.startsWith("nodes/")) {
                this._nodeUris.add(string3);
                string2 = string4.substring("nodes/".length());
                this._nodeNames.add(string2);
                this.trace("Adding node name: ", string2);
                continue;
            }
            if (string4.startsWith("clusters/")) {
                this._clusterUris.add(string3);
                string2 = string4.substring("clusters/".length());
                this._clusterNames.add(string2);
                this.trace("Adding cluster name: ", string2);
                continue;
            }
            if (!string4.startsWith("applications/")) continue;
            this._applicationUris.add(string3);
            string2 = string4.substring("applications/".length());
            this._applicationNames.add(string2);
            this.trace("Adding application name: ", string2);
        }
    }

    protected String getCellUri() {
        this.ensureCellData();
        return this._cellUri;
    }

    protected String getCellName() {
        this.ensureCellData();
        return this._cellName;
    }

    protected String getNodeUri() {
        this.ensureCellData();
        return this._nodeUri;
    }

    protected String getNodeName() {
        this.ensureCellData();
        return this._nodeName;
    }

    protected String getServerUri() {
        this.ensureCellData();
        return this._serverUri;
    }

    protected String getServerName() {
        this.ensureCellData();
        return this._serverName;
    }

    protected List getNodeUris() {
        this.ensureCellData();
        return this._nodeUris;
    }

    protected List getNodeNames() {
        this.ensureCellData();
        return this._nodeNames;
    }

    protected List getClusterUris() {
        this.ensureCellData();
        return this._clusterUris;
    }

    protected List getClusterNames() {
        this.ensureCellData();
        return this._clusterNames;
    }

    protected List getApplicationUris() {
        this.ensureCellData();
        return this._applicationUris;
    }

    protected List getApplicationNames() {
        this.ensureCellData();
        return this._applicationNames;
    }

    protected void clearMultiBrokerData() {
        this._computedMultiBrokerData = false;
        this._multibrokerDomains = null;
    }

    protected List getMultibrokerDomains() {
        if (!this._computedMultiBrokerData) {
            this._computedMultiBrokerData = true;
            this._multibrokerDomains = this.computeMultibrokerDomains();
        }
        return this._multibrokerDomains;
    }

    protected List computeMultibrokerDomains() {
        String string = this.getCellUri();
        if (string == null) {
            return null;
        }
        String string2 = string + "/" + "multibroker.xml";
        Object object = this.loadModel(string2);
        if (!(object instanceof List)) {
            return null;
        }
        Iterator iterator = ((List)object).iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Object e = iterator.next();
        if (!(e instanceof MultibrokerDomain)) {
            return null;
        }
        return (List)object;
    }

    protected void ensureNodeServerData() {
        if (!this._computedNodeServerData) {
            this._computedNodeServerData = true;
            this.computeNodeServers();
            this.computeNodeSystemMessageServers();
        }
    }

    protected void computeNodeServers() {
        this._nodeServerUris = new HashMap();
        this._nodeServerNames = new HashMap();
        Iterator iterator = this.getNodeUris().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            Object object = this.loadModel(string);
            Iterator iterator2 = object instanceof List ? ((List)object).iterator() : new ArrayList().iterator();
            int n = string.length() + 1;
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                String string3 = string2.substring(n);
                if (!string3.startsWith("servers/")) continue;
                hashSet.add(string2);
                String string4 = string3.substring("servers/".length());
                hashSet2.add(string4);
            }
            this._nodeServerUris.put(string, hashSet);
            this._nodeServerNames.put(string, hashSet2);
        }
    }

    protected void computeNodeSystemMessageServers() {
        this._nodeSystemMessageServers = new ArrayList();
        HashMap hashMap = this.getNodeServerUris();
        Iterator iterator = this.getNodeUris().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.nabEndOf(string);
            HashSet hashSet = (HashSet)hashMap.get(string);
            if (hashSet == null) continue;
            Iterator iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                String string4 = this.nabEndOf(string3);
                Object object = this.loadModel(string3);
                if (!(object instanceof List)) continue;
                Iterator iterator3 = ((List)object).iterator();
                while (iterator3.hasNext()) {
                    Object e = iterator3.next();
                    if (!(e instanceof Server)) continue;
                    Server server = (Server)e;
                    this.fillMessageServers(this._nodeSystemMessageServers, (List)server.getComponents(), string2, string4, server);
                }
            }
        }
    }

    protected void fillMessageServers(List list, List list2, String string, String string2, Server server) {
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            if (component instanceof SystemMessageServer) {
                Object[] objectArray = new Object[]{string, string2, server, component};
                list.add(component);
            }
            this.fillMessageServers(list, (List)component.getComponents(), string, string2, server);
        }
    }

    protected void fillMessageServers(List list, List list2, String string) {
        Iterator iterator = this.getNodeSystemMessageServers().iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            SystemMessageServer systemMessageServer = (SystemMessageServer)objectArray[2];
            String string2 = systemMessageServer.getBrokerName();
            if (!string.equals(string2)) continue;
            if (this.isSetToStart((ManagedObject)systemMessageServer)) {
                list.add(systemMessageServer);
                continue;
            }
            list2.add(systemMessageServer);
        }
    }

    protected HashMap getNodeServerUris() {
        this.ensureNodeServerData();
        return this._nodeServerUris;
    }

    protected HashMap getNodeServerNames() {
        this.ensureNodeServerData();
        return this._nodeServerNames;
    }

    protected List getNodeSystemMessageServers() {
        this.ensureNodeServerData();
        return this._nodeSystemMessageServers;
    }

    protected void clearDeploymentMap() {
        this._computedDeploymentMap = false;
        this._deploymentMap = null;
    }

    protected void ensureDeploymentMap() {
        if (!this._computedDeploymentMap) {
            this._computedDeploymentMap = true;
            this.computeDeploymentMap();
        }
    }

    protected void computeDeploymentMap() {
        this.trace("Computing deployment map");
        this._deploymentMap = new HashSet();
        Iterator iterator = this.getApplicationUris().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.trace("Next application URI: " + string);
            Object object = this.loadModel(string);
            if (!(object instanceof List)) {
                this.trace("Unable to load deployment context: " + string);
                continue;
            }
            String string2 = this.nabEndOf(string);
            String string3 = string + "/" + "deployment.xml";
            Object object2 = this.loadModel(string3);
            if (object2 instanceof List) {
                this._deploymentMap.add(string3);
                this.trace("Loaded deployment.xml");
                continue;
            }
            this.trace("Unable to load deployment.xml");
        }
    }

    protected HashSet getDeploymentMap() {
        this.ensureDeploymentMap();
        return this._deploymentMap;
    }

    protected boolean isDeployed(String string) {
        Iterator iterator = this.getApplicationNames().iterator();
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            String string2 = (String)iterator.next();
            bl = string.equals(string2);
        }
        return bl;
    }

    protected void clearCellSecurityData() {
        this._computedCellSecurityData = false;
        this._cellSecurity = null;
        this._cellSecurityAliasTable = null;
        this._cellSecurityJAASAuthDataTable = null;
    }

    protected void ensureCellSecurityData() {
        if (!this._computedCellSecurityData) {
            this._computedCellSecurityData = true;
            this.computeCellSecurity();
            this.computeCellSecurityAliasTable();
            this.computeCellSecurityJAASAuthDataTable();
        }
    }

    protected void computeCellSecurity() {
        String string = this.getCellUri() + "/" + "security.xml";
        List list = (List)this.loadModel(string);
        if (!(list instanceof List)) {
            this.addError("com.ibm.websphere.validation.base.config.websphereplatformvalidationNLS", "ERROR_UNABLE_TO_RETRIEVE_SECURITY_TRANSPORT_ALIASES", new String[]{string}, string);
            return;
        }
        Iterator iterator = list.iterator();
        if (!iterator.hasNext()) {
            this.addError("com.ibm.websphere.validation.base.config.websphereplatformvalidationNLS", "ERROR_INVALID_SECURITY_TRANSPORT_ALIASES", new String[]{string}, string);
            return;
        }
        Object e = iterator.next();
        if (!(e instanceof Security)) {
            this.addError("com.ibm.websphere.validation.base.config.websphereplatformvalidationNLS", "ERROR_INVALID_SECURITY_ROOT_TRANSPORT_ALIASES", new String[]{string}, string);
            return;
        }
        this._cellSecurity = (Security)e;
    }

    protected void computeCellSecurityAliasTable() {
        this._cellSecurityAliasTable = new HashSet();
        if (this._cellSecurity == null) {
            return;
        }
        Iterator iterator = this._cellSecurity.getRepertoire().iterator();
        while (iterator.hasNext()) {
            SSLConfig sSLConfig = (SSLConfig)iterator.next();
            String string = sSLConfig.getAlias();
            if (string == null) continue;
            this._cellSecurityAliasTable.add(string);
        }
    }

    protected void computeCellSecurityJAASAuthDataTable() {
        this._cellSecurityJAASAuthDataTable = new HashSet();
        if (this._cellSecurity == null) {
            return;
        }
        Iterator iterator = this._cellSecurity.getAuthDataEntries().iterator();
        while (iterator.hasNext()) {
            JAASAuthData jAASAuthData = (JAASAuthData)iterator.next();
            String string = jAASAuthData.getAlias();
            if (string == null) continue;
            this._cellSecurityJAASAuthDataTable.add(string);
        }
    }

    protected Security getCellSecurity() {
        this.ensureCellSecurityData();
        return this._cellSecurity;
    }

    protected HashSet getCellSecurityAliasTable() {
        this.ensureCellSecurityData();
        return this._cellSecurityAliasTable;
    }

    protected HashSet getCellSecurityJAASAuthDataTable() {
        this.ensureCellSecurityData();
        return this._cellSecurityJAASAuthDataTable;
    }

    protected void moveToNextFile() {
        this.clearCachedData();
        super.moveToNextFile();
    }

    protected void moveToFirstFile() {
        this.clearCachedData();
        super.moveToFirstFile();
    }

    protected boolean isSetToStart(StateManageable stateManageable) {
        ExecutionState executionState = stateManageable.getInitialState();
        if (executionState == null) {
            return false;
        }
        int n = executionState.getValue();
        return n == 0;
    }

    protected boolean isSetToStart(ManagedObject managedObject) {
        StateManageable stateManageable = managedObject.getStateManagement();
        if (stateManageable == null) {
            return false;
        }
        return this.isSetToStart(stateManageable);
    }

    public boolean testClassPath(String string) {
        return this._typeTester.testClassPath(string);
    }

    public boolean testFile(String string) {
        return this._typeTester.testFile(string);
    }

    protected boolean testInteger(int n, int n2, int n3, String string, Object object) {
        return this._typeTester.testInteger(n, n2, n3, string, object);
    }

    protected boolean testInteger(Integer n, String string, int n2, int n3, String string2, Object object) {
        return this._typeTester.testInteger(n, string, n2, n3, string2, object);
    }

    protected boolean testInteger(String string, int n, int n2, String string2, String string3, Object object) {
        return this._typeTester.testInteger(string, n, n2, string2, string3, object);
    }

    protected boolean testInteger(String string, String string2, Object object) {
        return this._typeTester.testInteger(string, string2, object);
    }

    protected boolean testIntegerMax(int n, int n2, String string, Object object) {
        return this._typeTester.testIntegerMax(n, n2, string, object);
    }

    protected boolean testIntegerMax(Integer n, String string, int n2, String string2, Object object) {
        return this._typeTester.testIntegerMax(n, string, n2, string2, object);
    }

    protected boolean testIntegerMax(String string, int n, String string2, String string3, Object object) {
        return this._typeTester.testIntegerMax(string, n, string2, string3, object);
    }

    protected boolean testIntegerMin(int n, int n2, String string, Object object) {
        return this._typeTester.testIntegerMin(n, n2, string, object);
    }

    protected boolean testIntegerMin(Integer n, String string, int n2, String string2, Object object) {
        return this._typeTester.testIntegerMin(n, string, n2, string2, object);
    }

    protected boolean testIntegerMin(String string, int n, String string2, String string3, Object object) {
        return this._typeTester.testIntegerMin(string, n, string2, string3, object);
    }

    protected boolean testJarPath(String string) {
        return this._typeTester.testJarPath(string);
    }

    protected boolean testJavaClass(String string) {
        return this._typeTester.testJavaClass(string);
    }

    protected boolean testLong(long l, long l2, long l3, String string, Object object) {
        return this._typeTester.testLong(l, l2, l3, string, object);
    }

    protected boolean testLong(Long l, String string, long l2, long l3, String string2, Object object) {
        return this._typeTester.testLong(l, string, l2, l3, string2, object);
    }

    protected boolean testLong(String string, long l, long l2, String string2, String string3, Object object) {
        return this._typeTester.testLong(string, l, l2, string2, string3, object);
    }

    protected boolean testLong(String string, String string2, Object object) {
        return this._typeTester.testLong(string, string2, object);
    }

    protected boolean testLongMax(long l, long l2, String string, String[] stringArray, Object object) {
        return this._typeTester.testLongMax(l, l2, string, stringArray, object);
    }

    protected boolean testLongMax(Long l, long l2, String string, String[] stringArray, String string2, String[] stringArray2, Object object) {
        return this._typeTester.testLongMax(l, l2, string, stringArray, string2, stringArray2, object);
    }

    protected boolean testLongMax(String string, long l, String string2, String[] stringArray, String string3, String[] stringArray2, Object object) {
        return this._typeTester.testLongMax(string, l, string2, stringArray, string3, stringArray2, object);
    }

    protected boolean testLongMin(long l, long l2, String string, String[] stringArray, Object object) {
        return this._typeTester.testLongMin(l, l2, string, stringArray, object);
    }

    protected boolean testLongMin(Long l, long l2, String string, String[] stringArray, String string2, String[] stringArray2, Object object) {
        return this._typeTester.testLongMin(l, l2, string, stringArray, string2, stringArray2, object);
    }

    protected boolean testLongMin(String string, long l, String string2, String[] stringArray, String string3, String[] stringArray2, Object object) {
        return this._typeTester.testLongMin(string, l, string2, stringArray, string3, stringArray2, object);
    }

    protected boolean testPath(String string) {
        return this._typeTester.testPath(string);
    }

    protected boolean testPort(int n, boolean bl, String string, Object object) {
        return this._typeTester.testPort(n, bl, string, object);
    }

    protected boolean testURI(String string) {
        return this._typeTester.testURI(string);
    }

    protected boolean testURL(String string) {
        return this._typeTester.testURL(string);
    }
}

