/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.process.ManagedObject;
import com.ibm.websphere.models.config.process.ProcessPackage;
import com.ibm.websphere.models.config.process.StateManageable;
import com.ibm.websphere.models.config.process.StatisticsProvider;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.validation.base.config.MOFValidator;
import com.ibm.websphere.validation.base.config.TypeTester;
import com.ibm.websphere.validation.base.config.WebSpherePlatformConstants;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EEnum;

public class WebSpherePlatformValidator
extends MOFValidator
implements WebSpherePlatformConstants {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";
    protected TypeTester _typeTester = new TypeTester(this);
    protected int MAX_WAS_QUEUE_LENGTH = 45;

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (!(object instanceof Property)) {
            if (object instanceof EndPoint) {
                this.trace("Object recognized as an end point; validating");
                this.validateLocal((EndPoint)object);
                this.validateAcross((EndPoint)object);
            } else if (object instanceof Transport) {
                this.trace("Object recognized a transport; validating");
                this.validateLocal((Transport)object);
                this.validateAcross((Transport)object);
            } else if (object instanceof ManagedObject) {
                this.trace("Object recognized a managed object; validating");
                this.validateLocal((ManagedObject)object);
                this.validateAcross((ManagedObject)object);
            } else if (!(object instanceof StateManageable) && !(object instanceof StatisticsProvider)) {
                bl = super.basicValidate(object);
            }
        }
        return bl;
    }

    public void validateProperties(Object object, String string, List list, String string2, String string3) {
        this.validateProperties(this.getBundleId(), object, string, list, string2, string3);
    }

    public void validateProperties(String string, Object object, String string2, List list, String string3, String string4) {
        Iterator iterator = list.iterator();
        Hashtable<String, Property> hashtable = new Hashtable<String, Property>();
        Hashtable<String, Property> hashtable2 = new Hashtable<String, Property>();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            String string5 = property.getName();
            if (string5 == null || hashtable.put(string5, property) == null || hashtable2.put(string5, property) != null) continue;
            String[] stringArray = string2 == null ? new String[]{string5} : new String[]{string5, string2};
            this.addError(string, string3, stringArray, object);
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            this.basicValidate(string, (Property)iterator.next(), object, string2, string4);
        }
    }

    protected void basicValidate(String string, Property property, Object object, String string2, String string3) {
        String string4 = property.getName();
        if (string4 == null || string4.length() == 0) {
            if (string2 == null) {
                this.addError(string, string3, new String[0], object);
            } else {
                this.addError(string, string3, new String[]{string2}, object);
            }
        }
    }

    public void validateAcross(EndPoint endPoint) {
    }

    public void validateAcross(Transport transport) {
        this.validateProperties("com.ibm.websphere.validation.base.config.websphereplatformvalidationNLS", transport, null, (List)transport.getProperties(), "ERROR_TRANSPORT_PROPERTY_DUPLICATION", "ERROR_TRANSPORT_PROPERTY_NAME_REQUIRED");
    }

    public void validateLocal(EndPoint endPoint) {
        String string = endPoint.getHost();
        int n = endPoint.getPort();
        this.testPort("com.ibm.websphere.validation.base.config.websphereplatformvalidationNLS", n, false, "ERROR_ENDPOINT_PORT_INVALID", endPoint);
    }

    public void validateLocal(Transport transport) {
        String string;
        boolean bl = transport.isSslEnabled();
        if (bl && ((string = transport.getSslConfig()) == null || string.length() == 0)) {
            this.addError("com.ibm.websphere.validation.base.config.websphereplatformvalidationNLS", "ERROR_TRANSPORT_SSLCONFIG_REQUIRED", new String[0], transport);
        }
    }

    public void validateAcross(ManagedObject managedObject) {
        if (managedObject.getStatisticsProvider() != null) {
            this.validateLocal(managedObject.getStatisticsProvider(), managedObject);
            this.validateAcross(managedObject.getStatisticsProvider(), managedObject);
        }
        if (managedObject.getStateManagement() != null) {
            this.validateLocal(managedObject.getStateManagement(), managedObject);
            this.validateAcross(managedObject.getStateManagement(), managedObject);
        }
    }

    public void validateLocal(ManagedObject managedObject) {
    }

    public void validateLocal(StateManageable stateManageable, ManagedObject managedObject) {
        EEnum eEnum;
        int n = stateManageable.getInitialState().getValue();
        if (!this.isEnumValueValid(n, eEnum = ProcessPackage.eINSTANCE.getExecutionState())) {
            this.addError("com.ibm.websphere.validation.base.config.websphereplatformvalidationNLS", "ERROR_STATE_MANAGEABLE_INITIAL_STATE_INVALID", new String[]{String.valueOf(n), managedObject.getName()}, stateManageable);
        }
    }

    public void validateAcross(StatisticsProvider statisticsProvider, ManagedObject managedObject) {
        this.traceBegin("validateAcross(StatisticsProvider)");
        this.traceStub("validateAcross(StatisticsProvider)");
        this.traceEnd();
    }

    public void validateLocal(StatisticsProvider statisticsProvider, ManagedObject managedObject) {
        this.traceBegin("validateLocal(StatisticsProvider)");
        this.traceStub("validateLocal(StatisticsProvider)");
        this.traceEnd();
    }

    protected boolean isSetToStart(StateManageable stateManageable) {
        int n = stateManageable.getInitialState().getValue();
        return n == 0;
    }

    protected boolean isSetToStart(ManagedObject managedObject) {
        StateManageable stateManageable = managedObject.getStateManagement();
        if (stateManageable == null) {
            return false;
        }
        return this.isSetToStart(stateManageable);
    }

    public void validateAcross(StateManageable stateManageable, ManagedObject managedObject) {
    }

    public boolean testClassPath(String string) {
        return this._typeTester.testClassPath(string);
    }

    public boolean testFile(String string) {
        return this._typeTester.testFile(string);
    }

    protected boolean testInteger(int n, int n2, int n3, String string, Object object) {
        return this._typeTester.testInteger(n, n2, n3, string, object);
    }

    protected boolean testInteger(Integer n, String string, int n2, int n3, String string2, Object object) {
        return this._typeTester.testInteger(n, string, n2, n3, string2, object);
    }

    protected boolean testInteger(String string, int n, int n2, String string2, String string3, Object object) {
        return this._typeTester.testInteger(string, n, n2, string2, string3, object);
    }

    protected boolean testInteger(String string, String string2, Object object) {
        return this._typeTester.testInteger(string, string2, object);
    }

    protected boolean testIntegerMax(int n, int n2, String string, Object object) {
        return this._typeTester.testIntegerMax(n, n2, string, object);
    }

    protected boolean testIntegerMax(Integer n, String string, int n2, String string2, Object object) {
        return this._typeTester.testIntegerMax(n, string, n2, string2, object);
    }

    protected boolean testIntegerMax(String string, int n, String string2, String string3, Object object) {
        return this._typeTester.testIntegerMax(string, n, string2, string3, object);
    }

    protected boolean testIntegerMin(int n, int n2, String string, Object object) {
        return this._typeTester.testIntegerMin(n, n2, string, object);
    }

    protected boolean testIntegerMin(Integer n, String string, int n2, String string2, Object object) {
        return this._typeTester.testIntegerMin(n, string, n2, string2, object);
    }

    protected boolean testIntegerMin(String string, int n, String string2, String string3, Object object) {
        return this._typeTester.testIntegerMin(string, n, string2, string3, object);
    }

    protected boolean testJarPath(String string) {
        return this._typeTester.testJarPath(string);
    }

    protected boolean testJavaClass(String string) {
        return this._typeTester.testJavaClass(string);
    }

    protected boolean testLong(long l, long l2, long l3, String string, Object object) {
        return this._typeTester.testLong(l, l2, l3, string, object);
    }

    protected boolean testLong(Long l, String string, long l2, long l3, String string2, Object object) {
        return this._typeTester.testLong(l, string, l2, l3, string2, object);
    }

    protected boolean testLong(String string, long l, long l2, String string2, String string3, Object object) {
        return this._typeTester.testLong(string, l, l2, string2, string3, object);
    }

    protected boolean testLong(String string, String string2, Object object) {
        return this._typeTester.testLong(string, string2, object);
    }

    protected boolean testLongMax(long l, long l2, String string, String[] stringArray, Object object) {
        return this._typeTester.testLongMax(l, l2, string, stringArray, object);
    }

    protected boolean testLongMax(Long l, long l2, String string, String[] stringArray, String string2, String[] stringArray2, Object object) {
        return this._typeTester.testLongMax(l, l2, string, stringArray, string2, stringArray2, object);
    }

    protected boolean testLongMax(String string, long l, String string2, String[] stringArray, String string3, String[] stringArray2, Object object) {
        return this._typeTester.testLongMax(string, l, string2, stringArray, string3, stringArray2, object);
    }

    protected boolean testLongMin(long l, long l2, String string, String[] stringArray, Object object) {
        return this._typeTester.testLongMin(l, l2, string, stringArray, object);
    }

    protected boolean testLongMin(Long l, long l2, String string, String[] stringArray, String string2, String[] stringArray2, Object object) {
        return this._typeTester.testLongMin(l, l2, string, stringArray, string2, stringArray2, object);
    }

    protected boolean testLongMin(String string, long l, String string2, String[] stringArray, String string3, String[] stringArray2, Object object) {
        return this._typeTester.testLongMin(string, l, string2, stringArray, string3, stringArray2, object);
    }

    protected boolean testPath(String string) {
        return this._typeTester.testPath(string);
    }

    protected boolean testPort(int n, boolean bl, String string, Object object) {
        return this._typeTester.testPort(n, bl, string, object);
    }

    protected boolean testPort(String string, int n, boolean bl, String string2, Object object) {
        return this._typeTester.testPort(string, n, bl, string2, object);
    }

    protected boolean testURI(String string) {
        return this._typeTester.testURI(string);
    }

    protected boolean testURL(String string) {
        return this._typeTester.testURL(string);
    }

    protected boolean testValidChars(String string, String string2) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (string2.indexOf(c) == -1) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

