/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.extensions.webappext;

import com.ibm.ejs.models.base.extensions.webappext.FileServingAttribute;
import com.ibm.ejs.models.base.extensions.webappext.InvokerAttribute;
import com.ibm.ejs.models.base.extensions.webappext.JSPAttribute;
import com.ibm.ejs.models.base.extensions.webappext.MarkupLanguage;
import com.ibm.ejs.models.base.extensions.webappext.MimeFilter;
import com.ibm.ejs.models.base.extensions.webappext.Page;
import com.ibm.ejs.models.base.extensions.webappext.ServletCachingConfiguration;
import com.ibm.ejs.models.base.extensions.webappext.ServletExtension;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.etools.validation.IHelper;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.j2ee.J2EEValidator;
import com.ibm.etools.webapplication.Servlet;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.websphere.validation.base.extensions.webappext.WebAppExtensionMessageConstants;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;

public class WebAppExtensionValidator
extends J2EEValidator
implements WebAppExtensionMessageConstants {
    WebAppExtension wae;

    public String getBaseName() {
        return "webappextvalidation";
    }

    public String getWebAppDisplayName() {
        String string = "?";
        if (this.wae == null || this.wae.getWebApp() == null || this.wae.getWebApp().getDisplayName() == null || this.wae.getWebApp().getDisplayName().length() == 0) {
            return string;
        }
        return this.wae.getWebApp().getDisplayName();
    }

    public void validate(WebAppExtension webAppExtension) {
        try {
            this.wae = webAppExtension;
            WebApp webApp = webAppExtension.getWebApp();
            if (webApp == null) {
                this.addError("NULL_WEBAPP_REFERENCE");
                return;
            }
            this.validateReloadInterval(webAppExtension);
            this.validateDefaultErrorPage(webAppExtension);
            this.validateAdditionalClassPath(webAppExtension);
            this.validateMimeFilters(webAppExtension);
            this.validateExtendedServlets(webAppExtension);
            this.validateServletCacheConfigs(webAppExtension);
            this.validateJspAttributes(webAppExtension);
            this.validateFileServingAttributes(webAppExtension);
            this.validateInvokerAttributes(webAppExtension);
            System.out.println("All tests executed in WARExtensionValidator");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void validate(IHelper iHelper, IReporter iReporter, String[] stringArray) throws ValidationException {
        try {
            WebAppExtension webAppExtension = (WebAppExtension)iHelper.loadModel("ibm-web-ext");
            this.validate(webAppExtension);
        }
        catch (Exception exception) {
            this.addError("ERROR_WEBAPPEXT_VALIDATION_FAILED", new String[]{exception.getMessage()});
            exception.printStackTrace();
        }
    }

    public void validateAdditionalClassPath(WebAppExtension webAppExtension) {
        String string = webAppExtension.getAdditionalClassPath();
    }

    public void validateDefaultErrorPage(WebAppExtension webAppExtension) {
        String string = webAppExtension.getDefaultErrorPage();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_MISSING_DEFAULT_ERROR_PAGE_URI", new String[]{this.getWebAppDisplayName()});
        }
    }

    public void validateExtendedServlets(WebAppExtension webAppExtension) {
        EList eList = webAppExtension.getExtendedServlets();
        if (eList == null) {
            return;
        }
        HashMap<Servlet, ServletExtension> hashMap = new HashMap<Servlet, ServletExtension>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ServletExtension servletExtension = (ServletExtension)iterator.next();
            Servlet servlet = servletExtension.getExtendedServlet();
            String string = servlet.getDisplayName();
            if (string == null || string.length() == 0) {
                string = "?";
            }
            if (hashMap.containsKey(servlet)) {
                this.addError("ERROR_MORE_THAN_ONE_EXTENSION_FOR_SERVLET", new String[]{string, this.getWebAppDisplayName()});
                continue;
            }
            hashMap.put(servlet, servletExtension);
            Iterator iterator2 = servletExtension.getMarkupLanguages().iterator();
            while (iterator2.hasNext()) {
                MarkupLanguage markupLanguage = (MarkupLanguage)iterator2.next();
                String string2 = markupLanguage.getName();
                String string3 = markupLanguage.getMimeType();
                Page page = markupLanguage.getErrorPage();
                Page page2 = markupLanguage.getDefaultPage();
                if (string2 == null || string2.length() == 0) {
                    this.addError("MISSING_MARKUP_LANGUAGE_NAME", new String[]{this.getWebAppDisplayName()});
                    string2 = "?";
                }
                if (string3 == null || string3.length() == 0) {
                    this.addError("MISSING_MARKUP_LANGUAGE_MIME_TYPE", new String[]{string2, this.getWebAppDisplayName()});
                }
                if (page2 != null && !webAppExtension.getWebApp().getErrorPages().contains((Object)page2)) {
                    this.addError("MARKUP_LANGUAGE_DEFAULTPAGE_NOT_EXIST_WITHIN_PAGES", new String[]{string2, this.getWebAppDisplayName()});
                }
                if (page != null && !webAppExtension.getWebApp().getErrorPages().contains((Object)page)) {
                    this.addError("MARKUP_LANGUAGE_ERRORPAGE_NOT_EXIST_WITHIN_PAGES", new String[]{string2, this.getWebAppDisplayName()});
                }
                this.validateMarkupLanguagePages(markupLanguage);
            }
        }
    }

    public void validateFileServingAttributes(WebAppExtension webAppExtension) {
        EList eList = webAppExtension.getFileServingAttributes();
        if (eList != null) {
            return;
        }
        HashMap<String, FileServingAttribute> hashMap = new HashMap<String, FileServingAttribute>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            FileServingAttribute fileServingAttribute = (FileServingAttribute)iterator.next();
            String string = fileServingAttribute.getName();
            if (string == null) {
                this.addError("ERROR_MISSING_FILESERVINGATTRIBUTES_NAME", new String[]{this.getWebAppDisplayName()});
                string = "?";
            }
            if (hashMap.containsKey(string)) {
                this.addError("ERROR_DUPLICATE_FILESERVINGATTRIBUTES", new String[]{string, this.getWebAppDisplayName()});
                continue;
            }
            hashMap.put(string, fileServingAttribute);
        }
    }

    public void validateInvokerAttributes(WebAppExtension webAppExtension) {
        EList eList = webAppExtension.getInvokerAttributes();
        if (eList == null) {
            return;
        }
        HashMap<String, InvokerAttribute> hashMap = new HashMap<String, InvokerAttribute>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            InvokerAttribute invokerAttribute = (InvokerAttribute)iterator.next();
            String string = invokerAttribute.getName();
            if (string == null) {
                this.addError("ERROR_MISSING_INVOKERATTRIBUTES_NAME", this.getWebAppDisplayName());
            }
            if (hashMap.containsKey(string)) {
                this.addError(this.getBaseName(), "ERROR_DUPLICATE_INVOKERATTRIBUTES", new String[]{string, this.getWebAppDisplayName()});
                continue;
            }
            hashMap.put(string, invokerAttribute);
        }
    }

    public void validateJspAttributes(WebAppExtension webAppExtension) {
        EList eList = webAppExtension.getJspAttributes();
        if (eList == null) {
            return;
        }
        HashMap<String, JSPAttribute> hashMap = new HashMap<String, JSPAttribute>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            JSPAttribute jSPAttribute = (JSPAttribute)iterator.next();
            String string = jSPAttribute.getName();
            if (string == null) {
                this.addError("JSP_ATTRIBUTE_MISSING_NAME", new String[]{this.getWebAppDisplayName()});
                continue;
            }
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, jSPAttribute);
                continue;
            }
            this.addError("DUPLICATE_JSP_ATTRIBUTE", new String[]{string, this.getWebAppDisplayName()});
        }
    }

    public void validateMarkupLanguagePages(MarkupLanguage markupLanguage) {
        EList eList = markupLanguage.getPages();
        String string = markupLanguage.getName();
        if (eList == null) {
            return;
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Page page = (Page)iterator.next();
            if (page == null) continue;
            String string2 = page.getName();
            String string3 = page.getUri();
            if (string2 == null) {
                this.addError("MISSING_MARKUP_LANGUAGE_PAGE_NAME", new String[]{string, this.getWebAppDisplayName()});
                string2 = "?";
            }
            if (string3 != null) continue;
            this.addError("MISSING_OR_INVALID_MARKUP_LANGUAGE_PAGE_URI", new String[]{string2, string, this.getWebAppDisplayName()});
        }
    }

    public void validateMimeFilters(WebAppExtension webAppExtension) {
        EList eList = webAppExtension.getMimeFilters();
        if (eList == null) {
            return;
        }
        HashMap<String, MimeFilter> hashMap = new HashMap<String, MimeFilter>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            MimeFilter mimeFilter = (MimeFilter)iterator.next();
            String string = mimeFilter.getType();
            String string2 = mimeFilter.getTarget();
            if (string == null || string.length() == 0) {
                this.addError("MIMEFILTERS_UNSPECIFIED_TYPE", new String[]{this.getWebAppDisplayName()});
                continue;
            }
            if (string2 == null || string2.length() == 0) {
                this.addError("MIMEFILTERS_UNSPECIFIED_TARGET", new String[]{string, this.getWebAppDisplayName()});
            }
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, mimeFilter);
                continue;
            }
            this.addError("MULTIPLE_MIMEFILTERS_SAME_TYPE", new String[]{string, this.getWebAppDisplayName()});
        }
    }

    public void validateReloadInterval(WebAppExtension webAppExtension) {
        int n = webAppExtension.getReloadInterval();
        if (n < 0) {
            this.addError("ERROR_INVALID_RELOAD_INTERVAL", new String[]{Integer.toString(n), this.getWebAppDisplayName()});
        }
    }

    public void validateServletCacheConfigs(WebAppExtension webAppExtension) {
        EList eList = webAppExtension.getServletCacheConfigs();
        if (eList != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ServletCachingConfiguration servletCachingConfiguration = (ServletCachingConfiguration)iterator.next();
            }
        }
    }
}

