/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.encoders.EncoderDecoder;
import com.ibm.etools.encoders.EncoderDecoderRegistry;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskDependency;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.AppDeploymentTaskInfo;
import com.ibm.websphere.management.application.client.ArchiveDeploymentInfo;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.PartialDeploymentInfo;
import com.ibm.ws.management.application.client.BindJndiForEJBNonMessageBindingDependencyHelper;
import com.ibm.ws.management.application.client.CorrectOracleIsolationLevelDependencyHelper;
import com.ibm.ws.management.application.client.DefaultBinding;
import com.ibm.ws.management.application.client.DefaultBindingHelper;
import com.ibm.ws.management.application.client.EJBDeployOptionsDependencyHelper;
import com.ibm.ws.management.application.client.MapEJBRefToEJBDependencyHelper;
import com.ibm.ws.management.application.client.MapResRefToEJBDependencyHelper;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import com.ibm.ws.util.ImplFactory;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class AppDeploymentController
implements Serializable {
    static final long serialVersionUID = -3828436921961863062L;
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$websphere$management$application$client$AppDeploymentController == null ? (class$com$ibm$websphere$management$application$client$AppDeploymentController = AppDeploymentController.class$("com.ibm.websphere.management.application.client.AppDeploymentController")) : class$com$ibm$websphere$management$application$client$AppDeploymentController), (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String taskPackageName = "com.ibm.ws.management.application.client.";
    public static final String taskHelperSuffix = "Helper";
    private static boolean encoderInit = false;
    protected Vector taskInfo = null;
    protected Vector taskNames = null;
    protected Vector tasks = null;
    protected int currentTask;
    protected transient AppDeploymentInfo deploymentInfo;
    protected transient ResourceBundle resBundle;
    static /* synthetic */ Class class$com$ibm$websphere$management$application$client$AppDeploymentController;
    static /* synthetic */ Class class$com$ibm$etools$encoders$EncoderDecoder;

    public static AppDeploymentController readArchive(String string, Hashtable hashtable) throws AppDeploymentException {
        return AppManagementFactory.readArchive(string, hashtable);
    }

    public static AppDeploymentController readArchive(String string, Hashtable hashtable, Vector vector) throws AppDeploymentException {
        return AppManagementFactory.readArchive(string, hashtable, vector);
    }

    public static Vector getDefaultTaskInfo(AppDeploymentInfo appDeploymentInfo) throws AppDeploymentException {
        return AppDeploymentController.getDefaultTaskInfo(appDeploymentInfo, null);
    }

    public static Vector getDefaultTaskInfo(AppDeploymentInfo appDeploymentInfo, Hashtable hashtable) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultTaskInfo");
        }
        Vector<AppDeploymentTaskInfo> vector = new Vector<AppDeploymentTaskInfo>();
        Vector vector2 = AppDeploymentController.createAppDeploymentTaskNames();
        Vector vector3 = AppDeploymentController.createAppDeploymentDependencyTaskHelpers();
        Vector vector4 = AppDeploymentController.createAppDeploymentTaskHelpers(vector2);
        for (int i = 0; i < vector2.size(); ++i) {
            Locale locale = null;
            if (hashtable != null) {
                locale = (Locale)hashtable.get("app.client.locale");
            }
            AppDeploymentTaskInfo appDeploymentTaskInfo = new AppDeploymentTaskInfo((String)vector2.elementAt(i), (AppDeploymentTaskHelper)vector4.elementAt(i), (AppDeploymentTaskDependency)vector3.elementAt(i), locale);
            vector.addElement(appDeploymentTaskInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDefaultTaskInfo");
        }
        return vector;
    }

    protected static Vector createAppDeploymentTaskNames() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createAppDeploymentTaskNames");
        }
        Vector<String> vector = new Vector<String>();
        vector.addElement("MapRolesToUsers");
        vector.addElement("MapRunAsRolesToUsers");
        vector.addElement("CorrectUseSystemIdentity");
        vector.addElement("BindJndiForEJBNonMessageBinding");
        vector.addElement("BindJndiForEJBMessageBinding");
        vector.addElement("MapEJBRefToEJB");
        vector.addElement("MapResRefToEJB");
        vector.addElement("MapResEnvRefToRes");
        vector.addElement("DataSourceFor10EJBModules");
        vector.addElement("DataSourceFor20EJBModules");
        vector.addElement("DataSourceFor10CMPBeans");
        vector.addElement("DataSourceFor20CMPBeans");
        vector.addElement("MapWebModToVH");
        vector.addElement("MapModulesToServers");
        vector.addElement("EnsureMethodProtectionFor10EJB");
        vector.addElement("EnsureMethodProtectionFor20EJB");
        vector.addElement("CorrectOracleIsolationLevel");
        vector.addElement("BackendIdSelection");
        vector.addElement("AppDeploymentOptions");
        vector.addElement("EJBDeployOptions");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createAppDeploymentTaskNames");
        }
        return vector;
    }

    protected static Vector createAppDeploymentTaskHelpers(Vector vector) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createAppDeploymentTaskHelpers");
        }
        Vector<AppDeploymentTaskHelper> vector2 = new Vector<AppDeploymentTaskHelper>();
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(AppDeploymentController.getTaskHelper((String)vector.elementAt(i)));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createAppDeploymentTaskHelpers");
        }
        return vector2;
    }

    protected static Vector createAppDeploymentDependencyTaskHelpers() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createAppDeploymentDependencyTaskHelpers");
        }
        Vector<AppDeploymentTaskDependency> vector = new Vector<AppDeploymentTaskDependency>();
        vector.addElement(null);
        vector.addElement(null);
        vector.addElement(null);
        vector.addElement(new BindJndiForEJBNonMessageBindingDependencyHelper());
        vector.addElement(null);
        vector.addElement(new MapEJBRefToEJBDependencyHelper());
        vector.addElement(new MapResRefToEJBDependencyHelper());
        vector.addElement(null);
        vector.addElement(null);
        vector.addElement(null);
        vector.addElement(null);
        vector.addElement(null);
        vector.addElement(null);
        vector.addElement(null);
        vector.addElement(null);
        vector.addElement(null);
        vector.addElement(new CorrectOracleIsolationLevelDependencyHelper());
        vector.addElement(null);
        vector.addElement(null);
        vector.addElement(new EJBDeployOptionsDependencyHelper());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createAppDeploymentDependencyTaskHelpers");
        }
        return vector;
    }

    public AppDeploymentController(AppDeploymentInfo appDeploymentInfo, Hashtable hashtable, Vector vector) throws AppDeploymentException {
        this(appDeploymentInfo, null, hashtable, vector);
    }

    public AppDeploymentController(Vector vector, Vector vector2, Hashtable hashtable) throws AppDeploymentException {
        this(null, vector, hashtable, vector2);
    }

    public AppDeploymentController(AppDeploymentInfo appDeploymentInfo, Vector vector, Hashtable hashtable, Vector vector2) throws AppDeploymentException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"AppDeploymentController");
        }
        this.deploymentInfo = appDeploymentInfo;
        this.taskInfo = vector2;
        this.taskNames = new Vector();
        for (n = 0; n < this.taskInfo.size(); ++n) {
            this.taskNames.addElement(((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)n)).name);
        }
        this.handlePreferences(hashtable);
        this.initializeEncoderDecoder();
        if (vector == null) {
            this.createAppDeploymentTasks();
        } else {
            this.tasks = vector;
            for (n = 0; n < this.tasks.size(); ++n) {
                Object e = this.tasks.elementAt(n);
                if (e == null || !(e instanceof AppDeploymentTask)) continue;
                ((AppDeploymentTask)e).setAppDeploymentController(this);
            }
        }
        Locale locale = null;
        if (hashtable != null) {
            locale = (Locale)hashtable.get("app.client.locale");
        }
        this.resBundle = AppUtils.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", locale);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"AppDeploymentController");
        }
    }

    protected void handlePreferences(Hashtable hashtable) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handlePreferences");
        }
        if (hashtable == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handlePreferences");
            }
            return;
        }
        Object v = hashtable.get("usedefaultbindings");
        if (v != null) {
            this.handleDefaultBindings(v);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handlePreferences");
        }
    }

    private void handleDefaultBindings(Object object) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleDefaultBindings");
        }
        if (!(this.deploymentInfo instanceof ArchiveDeploymentInfo)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Deployment not from an ear file.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleDefaultBindings");
            }
            return;
        }
        Preferences preferences = null;
        if (object instanceof Preferences) {
            preferences = (Preferences)object;
        }
        if (object instanceof DefaultBinding) {
            preferences = DefaultBindingHelper.getPreferences((DefaultBinding)object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Default bndg prefs: " + preferences));
        }
        if (preferences == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No preference data for default bindings " + object));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleDefaultBindings");
            }
            return;
        }
        ((ArchiveDeploymentInfo)this.deploymentInfo).createDefaultBindings(preferences);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleDefaultBindings");
        }
    }

    protected void initializeEncoderDecoder() throws AppDeploymentException {
        if (encoderInit) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeEncoderDecoder");
        }
        try {
            EncoderDecoder encoderDecoder = (EncoderDecoder)ImplFactory.loadImplFromKey((Class)(class$com$ibm$etools$encoders$EncoderDecoder == null ? (class$com$ibm$etools$encoders$EncoderDecoder = AppDeploymentController.class$("com.ibm.etools.encoders.EncoderDecoder")) : class$com$ibm$etools$encoders$EncoderDecoder));
            EncoderDecoderRegistry.getDefaultRegistry().setDefaultEncoderDecoder(encoderDecoder);
            encoderInit = true;
        }
        catch (Throwable throwable) {
            throw new AppDeploymentException("", throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeEncoderDecoder");
        }
    }

    protected void createAppDeploymentTasks() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createAppDeploymentTasks");
        }
        this.tasks = new Vector();
        for (int i = 0; i < this.taskNames.size(); ++i) {
            this.tasks.addElement(((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)i)).helper.createTask(this, (String)this.taskNames.elementAt(i)));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createAppDeploymentTasks");
        }
    }

    protected static AppDeploymentTaskHelper getTaskHelper(String string) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTaskHelper");
        }
        try {
            Class<?> clazz = string.indexOf(".") < 0 ? Class.forName(taskPackageName + string + taskHelperSuffix) : Class.forName(string + taskHelperSuffix);
            AppDeploymentTaskHelper appDeploymentTaskHelper = (AppDeploymentTaskHelper)clazz.newInstance();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getTaskHelper");
            }
            return appDeploymentTaskHelper;
        }
        catch (Throwable throwable) {
            throw new AppDeploymentException("", throwable);
        }
    }

    protected AppDeploymentTaskHelper getTaskHelper(int n) throws AppDeploymentException {
        if (n < this.taskInfo.size() && ((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)n)).helper != null) {
            return ((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)n)).helper;
        }
        throw new AppDeploymentException(MessageFormat.format(AppUtils.getMessage(this.resBundle, "ADMA0012E"), (String)this.tasks.elementAt(n)), null);
    }

    public String[] getAppDeploymentTaskNames() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAppDeploymentTaskNames");
        }
        Object[] objectArray = new String[this.taskNames.size()];
        this.taskNames.copyInto(objectArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAppDeploymentTaskNames");
        }
        return objectArray;
    }

    public AppDeploymentTask getFirstTask() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getFirstTask");
        }
        this.currentTask = 0;
        return this.getNthTask(this.currentTask);
    }

    protected AppDeploymentTask getNthTask(int n) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNthTask");
        }
        AppDeploymentTask appDeploymentTask = (AppDeploymentTask)this.tasks.elementAt(n);
        try {
            if (appDeploymentTask.getTaskData() == null && !appDeploymentTask.isTaskEmpty()) {
                this.prepareTask(n, appDeploymentTask);
                this.getDependencyTask(n);
            }
        }
        catch (Throwable throwable) {
            String string = (String)this.taskNames.elementAt(n);
            throw new AppDeploymentException(MessageFormat.format(AppUtils.getMessage(this.resBundle, "ADMA0092E"), string), throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getNthTask");
        }
        return appDeploymentTask;
    }

    protected void prepareTask(int n, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        this.getTaskHelper(n).prepareTask(this.deploymentInfo, appDeploymentTask);
    }

    public AppDeploymentTask getNextTask() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNextTask");
        }
        if (this.currentTask < 0) {
            return null;
        }
        if (this.currentTask + 1 >= this.tasks.size()) {
            return null;
        }
        return this.getNthTask(++this.currentTask);
    }

    public AppDeploymentTask getTaskByName(String string, boolean bl) throws AppDeploymentException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTaskByName");
        }
        if ((n = this.taskNames.indexOf(string)) < 0) {
            return null;
        }
        if (bl) {
            this.currentTask = n;
        }
        return this.getNthTask(n);
    }

    public Vector getAllTasks() {
        return this.tasks;
    }

    public AppDeploymentTask getTaskByName(String string) throws AppDeploymentException {
        return this.getTaskByName(string, true);
    }

    protected void getDependencyTask(int n) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDependencyTask");
        }
        if (n < this.taskInfo.size()) {
            if (((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)n)).dependency != null) {
                ((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)n)).dependency.setupDependency(this, (AppDeploymentTask)this.tasks.elementAt(n));
            }
        } else {
            throw new AppDeploymentException(MessageFormat.format(AppUtils.getMessage(this.resBundle, "ADMA0013E"), (String)this.tasks.elementAt(n)), null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDependencyTask");
        }
    }

    public void getDependencyTask(String string) throws AppDeploymentException {
        this.getDependencyTask(this.taskNames.indexOf(string));
    }

    public void close(boolean bl, boolean bl2, boolean bl3) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("close:" + bl + ", " + bl2 + ", " + bl3));
        }
        if (bl2) {
            String[] stringArray;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"validating ..");
            }
            if ((stringArray = this.validate()) != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]);
                    stringBuffer.append("\n");
                }
                throw new AppDeploymentException(MessageFormat.format(AppUtils.getMessage(this.resBundle, "ADMA0014E"), stringBuffer), null);
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"saving ..");
            }
            for (int i = 0; i < this.tasks.size(); ++i) {
                try {
                    this.getTaskHelper(i).completeTask(this.deploymentInfo, (AppDeploymentTask)this.tasks.elementAt(i));
                    continue;
                }
                catch (Throwable throwable) {
                    String string = (String)this.taskNames.elementAt(i);
                    throw new AppDeploymentException(MessageFormat.format(AppUtils.getMessage(this.resBundle, "ADMA0093E"), string), throwable);
                }
            }
        }
        if (bl3) {
            this.deploymentInfo.close(bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }

    public void saveAndClose() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"saveAndClose");
        }
        this.close(true, true, true);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"saveAndClose");
        }
    }

    public String[] validate() throws AppDeploymentException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validate");
        }
        Vector<String> vector = new Vector<String>();
        String[] stringArray = null;
        for (n = 0; n < this.tasks.size(); ++n) {
            String[] stringArray2 = this.getNthTask(n).validate();
            if (stringArray2 == null) continue;
            for (int i = 0; i < stringArray2.length; ++i) {
                vector.addElement(stringArray2[i]);
            }
        }
        if (vector.size() > 0) {
            stringArray = new String[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                stringArray[n] = (String)vector.elementAt(n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validate");
        }
        return stringArray;
    }

    public Hashtable getAppOptions() {
        return this.deploymentInfo.getAppOptions();
    }

    public void setAppOptions(Hashtable hashtable) {
        this.deploymentInfo.setAppOptions(hashtable);
    }

    public Hashtable getAppDeploymentSavedResults() {
        return this.deploymentInfo.getSavedResults();
    }

    public AppDeploymentTaskInfo getTaskInfo() {
        return (AppDeploymentTaskInfo)this.taskInfo.elementAt(this.currentTask);
    }

    public AppDeploymentTaskInfo getTaskInfo(String string) {
        int n = this.taskNames.indexOf(string);
        if (n < 0) {
            return null;
        }
        return (AppDeploymentTaskInfo)this.taskInfo.elementAt(n);
    }

    public boolean isPartialDeploymentInfo() {
        return this.deploymentInfo instanceof PartialDeploymentInfo;
    }

    public String getSecurityPolicyData() throws AppDeploymentException {
        return this.deploymentInfo.getSecurityPolicyData(this.resBundle);
    }

    public String getSecurityPolicyWarning() {
        return this.deploymentInfo.getSecurityPolicyWarning();
    }

    public void saveAsFile(String string, String string2, InputStream inputStream) throws AppDeploymentException {
        this.deploymentInfo.saveAsFile(string, string2, inputStream);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

