/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.application.Module;
import com.ibm.etools.archive.FileIterator;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.commonarchive.ReadOnlyDirectory;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.init.ArchiveInit;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppDeploymentProfile;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.dfltbndngs.BindEarCmd;
import com.ibm.ws.management.application.dfltbndngs.BindingError;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ArchiveDeploymentInfo
extends AppDeploymentInfo {
    protected EARFile archive;
    protected String archivePath;
    protected Vector saveAsFileTempDirs;
    protected String j2ee12SecurityWarning;
    protected Hashtable moduleForDD;
    protected ApplicationDeployment appDepl;
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$websphere$management$application$client$ArchiveDeploymentInfo == null ? (class$com$ibm$websphere$management$application$client$ArchiveDeploymentInfo = ArchiveDeploymentInfo.class$("com.ibm.websphere.management.application.client.ArchiveDeploymentInfo")) : class$com$ibm$websphere$management$application$client$ArchiveDeploymentInfo), (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    static /* synthetic */ Class class$com$ibm$websphere$management$application$client$ArchiveDeploymentInfo;

    public ArchiveDeploymentInfo(EARFile eARFile) throws AppDeploymentException {
        this(eARFile, new Hashtable());
    }

    public ArchiveDeploymentInfo(EARFile eARFile, Hashtable hashtable) throws AppDeploymentException {
        this.archive = eARFile;
        this.j2ee12SecurityWarning = null;
        this.moduleForDD = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ArchiveDeploymentInfo");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ear is: " + eARFile.getURI()));
        }
        this.setApplication(this.archive.getDeploymentDescriptor());
        this.setApplicationBindings(this.archive.getBindings());
        this.setApplicationExtensions(this.archive.getExtensions());
        if (this.appBinding == null) {
            throw new AppDeploymentException("Null application bindings. Possibly corrupt ear file.", null);
        }
        if (this.appExtension == null) {
            throw new AppDeploymentException("Null application extension. Possibly corrupt ear file.", null);
        }
        if (this.appBinding.getApplication() == null) {
            throw new AppDeploymentException("Application bindings file does not contain a reference to the deployment descriptor.  Corrupt ear file. Check if META-INF/ibm-application-bnd.xmi uri in the ear file contains a valid application href tag.", null);
        }
        if (this.appExtension.getApplication() == null) {
            throw new AppDeploymentException("Application extensions file does not contain a reference to the deployment descriptor.  Corrupt ear file. Check if META-INF/ibm-application-ext.xmi uri in the ear file contains a valid application href tag.", null);
        }
        this.readDeployment(eARFile, hashtable);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ArchiveDeploymentInfo");
        }
    }

    protected void readDeployment(EARFile eARFile, Hashtable hashtable) {
        block4: {
            try {
                if (this.archive.containsFile("deployment.xml")) {
                    AppdeploymentPackageImpl.init();
                    Resource resource = this.archive.getMofResource("deployment.xml");
                    if (resource != null) {
                        this.appDepl = (ApplicationDeployment)((Deployment)resource.getContents().get(0)).getDeployedObject();
                    }
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Exception reading deployment.xml: " + throwable));
            }
        }
        AppDeploymentProfile.files2Hash(AppDeploymentProfile.OP_INSTALL, this.appDepl, eARFile, this.options);
    }

    protected Vector createModuleConfig(String string) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createModuleConfig");
        }
        if (this.archive == null) {
            return null;
        }
        Vector vector = AppInstallHelper.getModuleConfig(this.archive, string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createModuleConfig");
        }
        return vector;
    }

    public Module getModuleForDD(EObject eObject) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getModuleForDD");
        }
        Module module = null;
        if (this.moduleForDD == null) {
            this.moduleForDD = new Hashtable();
            EList eList = this.archive.getDeploymentDescriptor().getModules();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Module module2 = (Module)iterator.next();
                try {
                    this.moduleForDD.put(this.archive.getDeploymentDescriptor(module2), module2);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Got Exception in getting module dd " + module2 + " -- exc: " + exception));
                    }
                    throw new AppDeploymentException("", exception);
                }
            }
        }
        module = (Module)this.moduleForDD.get(eObject);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The returned module is: " + module));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getModuleForDDLocal");
        }
        return module;
    }

    public ModuleFile getModuleFileForDD(EObject eObject) throws AppDeploymentException {
        return AppInstallHelper.getModuleFileForDDLocal(this.archive, eObject);
    }

    public void close(boolean bl) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close");
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting all config data so that it is instantiated.");
            }
            this.getModuleConfig("JAR_BND");
            this.getModuleConfig("JAR_EXT");
            this.getModuleConfig("WAR_BND");
            this.getModuleConfig("WAR_EXT");
        }
        this.archivePath = AppInstallHelper.closeLocal(this.archive, bl);
        this.archive = null;
        this.moduleData.clear();
        if (this.saveAsFileTempDirs != null) {
            for (int i = 0; i < this.saveAsFileTempDirs.size(); ++i) {
                try {
                    AppUtils.deleteDirTree((String)this.saveAsFileTempDirs.elementAt(i));
                    continue;
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Error deleting temp dir: " + (String)this.saveAsFileTempDirs.elementAt(i) + ", " + exception));
                }
            }
            this.saveAsFileTempDirs = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Archive closed. moduleData cleared");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }

    public Hashtable getSavedResults() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.options.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashtable.put(string, this.options.get(string));
        }
        if (this.archivePath != null) {
            hashtable.put("original.ear.location", this.archivePath);
        }
        return hashtable;
    }

    public void createDefaultBindings(Preferences preferences) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createDefaultBindings" + preferences));
        }
        try {
            BindEarCmd bindEarCmd = new BindEarCmd(this.archive, preferences);
            bindEarCmd.bind();
        }
        catch (BindingError bindingError) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception during creation of default bindings: " + bindingError));
            }
            Throwable throwable = this.getRootError(bindingError);
            throw new AppDeploymentException(bindingError.toString(), throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createDefaultBindings");
        }
    }

    public String getSecurityPolicyData(ResourceBundle resourceBundle) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSecurityPolicyData");
        }
        String string = null;
        InputStream inputStream = null;
        if (this.archive != null) {
            try {
                Object object;
                try {
                    inputStream = this.archive.getResourceInputStream("META-INF/was.policy");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    inputStream = null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Input stream: " + inputStream));
                }
                if (inputStream == null) {
                    object = this.getJ2EEAppVersion();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("App Version: " + (String)object));
                    }
                    if (object != null && ((String)object).equals("J2EE 1.2")) {
                        ClassLoader classLoader = this.getClass().getClassLoader();
                        inputStream = classLoader.getResourceAsStream("was.policy");
                        if (inputStream != null) {
                            this.saveAsFile(null, "META-INF/was.policy", inputStream);
                            this.j2ee12SecurityWarning = AppUtils.getMessage(resourceBundle, "ADMA0080W");
                            Tr.warning((TraceComponent)tc, (String)"ADMA0080W");
                            try {
                                inputStream = this.archive.getResourceInputStream("META-INF/was.policy");
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                inputStream = null;
                            }
                        } else {
                            this.j2ee12SecurityWarning = AppUtils.getMessage(resourceBundle, "ADMA0081W");
                            Tr.warning((TraceComponent)tc, (String)"ADMA0081W");
                        }
                    }
                }
                if (inputStream != null) {
                    byte[] byArray;
                    int n;
                    object = new ByteArrayOutputStream();
                    int n2 = inputStream.available();
                    while (n2 > 0 && (n = inputStream.read(byArray = new byte[n2])) != -1) {
                        ((ByteArrayOutputStream)object).write(byArray, 0, n);
                        n2 = inputStream.available();
                    }
                    ((OutputStream)object).flush();
                    string = ((ByteArrayOutputStream)object).toString();
                    ((ByteArrayOutputStream)object).close();
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                AppUtils.dbg(tc, "Unexpected exception caught while: " + exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSecurityPolicyData - " + string));
        }
        return string;
    }

    public String getSecurityPolicyWarning() {
        return this.j2ee12SecurityWarning;
    }

    public void saveAsFile(String string, String string2, InputStream inputStream) throws AppDeploymentException {
        String string3 = ArchiveDeploymentInfo.saveAsFile(this.archive, string, string2, inputStream);
        if (string3 != null) {
            if (this.saveAsFileTempDirs == null) {
                this.saveAsFileTempDirs = new Vector();
            }
            this.saveAsFileTempDirs.addElement(string3);
        }
    }

    public static String saveAsFile(EARFile eARFile, String string, String string2, InputStream inputStream) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"saveAsFile");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("moduleUri: " + string + ", fileUri: " + string2));
        }
        String string3 = null;
        if (inputStream == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"inputStream is null");
            }
        } else {
            CommonarchiveFactory commonarchiveFactory;
            if (eARFile == null) {
                return null;
            }
            EARFile eARFile2 = null;
            if (string == null || string.trim().equals("")) {
                eARFile2 = eARFile;
            } else {
                commonarchiveFactory = eARFile.getArchiveFiles().iterator();
                while (commonarchiveFactory.hasNext() && !(eARFile2 = (Archive)commonarchiveFactory.next()).getURI().equals(string)) {
                    eARFile2 = null;
                }
            }
            if (eARFile2 != null) {
                Exception exception;
                block37: {
                    String string4;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("found matching archive: " + eARFile2));
                    }
                    ArchiveInit.init();
                    commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
                    exception = null;
                    string3 = System.getProperty("java.io.tmpdir");
                    if (!string3.endsWith(File.separator)) {
                        string3 = string3 + File.separator;
                    }
                    File file = new File(eARFile.getURI());
                    string3 = string3 + file.getName();
                    if (string != null && !string.equals("")) {
                        string3 = string3 + "_" + string;
                    }
                    if (string2 != null && !string2.equals("")) {
                        string4 = string2.replace('/', '_');
                        string4 = string4.replace('\\', '_');
                        string3 = string3 + "_" + string4;
                    }
                    string3 = string3 + "_" + System.currentTimeMillis();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("temp dirname: " + string3));
                    }
                    string4 = string3;
                    if (string2 != null && !string2.equals("")) {
                        string4 = string4 + File.separator + string2;
                    }
                    File file2 = new File(string4);
                    file2 = new File(file2.getParent());
                    FileOutputStream fileOutputStream = null;
                    try {
                        if (file2.exists()) {
                            AppUtils.deleteDirTree(file2);
                        }
                        file2.mkdirs();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("save file location: " + string4));
                        }
                        if ((fileOutputStream = new FileOutputStream(string4)) != null) {
                            int n = 0;
                            byte[] byArray = new byte[1024];
                            while ((n = inputStream.read(byArray)) != -1) {
                                fileOutputStream.write(byArray, 0, n);
                            }
                            fileOutputStream.close();
                            fileOutputStream = null;
                            ReadOnlyDirectory readOnlyDirectory = commonarchiveFactory.openReadOnlyDirectory(string3);
                            com.ibm.etools.commonarchive.File file3 = readOnlyDirectory.getFileInSelfOrSubdirectory(string2);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("file in readDir: " + file3));
                            }
                            if (file3 != null && eARFile2.isDuplicate(string2)) {
                                FileIterator fileIterator = eARFile2.getFilesForSave();
                                while (fileIterator.hasNext()) {
                                    com.ibm.etools.commonarchive.File file4 = fileIterator.next();
                                    if (!file4.getURI().equals(string2)) continue;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)".... Removing existing file");
                                    }
                                    eARFile2.remove(file4);
                                    break;
                                }
                            }
                            if (file3 != null) {
                                eARFile2.addCopy(file3);
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Not able to create the input stream as a file");
                        }
                    }
                    catch (Exception exception2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("File IO exception: " + exception2));
                        }
                        exception = exception2;
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            if (!tc.isDebugEnabled()) break block37;
                            Tr.debug((TraceComponent)tc, (String)("Error closing save file: " + fileOutputStream + ", " + iOException));
                        }
                    }
                }
                if (exception != null) {
                    throw new AppDeploymentException(exception.toString(), exception);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Not able to find matching module: " + string));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"saveAsFile");
        }
        return string3;
    }

    public String getAppDisplayName() {
        return AppInstallHelper.getAppDisplayName(this.archive, this.options);
    }

    public String getURI() {
        return this.archive.getURI();
    }

    private Throwable getRootError(BindingError bindingError) {
        Throwable throwable;
        for (throwable = bindingError; throwable != null && throwable instanceof BindingError && throwable.getChainedEx() != null; throwable = throwable.getChainedEx()) {
        }
        return throwable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

