/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.DefaultBinding;
import com.ibm.ws.management.application.client.DefaultBindingHelper;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import java.util.Hashtable;
import java.util.Vector;

public class RedeploymentController
extends AppDeploymentController {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$websphere$management$application$client$RedeploymentController == null ? (class$com$ibm$websphere$management$application$client$RedeploymentController = RedeploymentController.class$("com.ibm.websphere.management.application.client.RedeploymentController")) : class$com$ibm$websphere$management$application$client$RedeploymentController));
    Vector tasksWOBindings = null;
    Vector oldAppTasks = null;
    boolean forceDfltBndg = false;
    String mode = "redeploy.default.merge";
    static /* synthetic */ Class class$com$ibm$websphere$management$application$client$RedeploymentController;

    public RedeploymentController(AppDeploymentInfo appDeploymentInfo, Hashtable hashtable, Vector vector, Vector vector2, Vector vector3) throws AppDeploymentException {
        super(appDeploymentInfo, hashtable, vector);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RedeploymentController");
        }
        this.oldAppTasks = vector2;
        this.tasksWOBindings = vector3;
        if (hashtable.get("redeploy.ignore.new") != null) {
            this.mode = "redeploy.ignore.new";
        }
        RedeploymentController.dbg("Mode is: " + this.mode);
        Object v = hashtable.get("usedefaultbindings");
        if (v != null) {
            Preferences preferences = null;
            if (v instanceof Preferences) {
                preferences = (Preferences)v;
            } else if (v instanceof DefaultBinding) {
                preferences = DefaultBindingHelper.getPreferences((DefaultBinding)v);
            }
            if (preferences != null) {
                this.forceDfltBndg = preferences.getForceBindings();
            }
            RedeploymentController.dbg("Force : " + this.forceDfltBndg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RedeploymentController");
        }
    }

    protected void prepareTask(int n, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("prepareTask: redepl:" + appDeploymentTask.getName()));
        }
        super.prepareTask(n, appDeploymentTask);
        if (appDeploymentTask.isTaskEmpty()) {
            return;
        }
        if (this.oldAppTasks == null && this.tasksWOBindings == null) {
            return;
        }
        AppDeploymentTask appDeploymentTask2 = this.findMatchingTask(appDeploymentTask, this.oldAppTasks);
        AppDeploymentTask appDeploymentTask3 = this.findMatchingTask(appDeploymentTask, this.tasksWOBindings);
        if (appDeploymentTask2 == null && appDeploymentTask3 == null) {
            RedeploymentController.dbg("No match: " + appDeploymentTask.getName());
            return;
        }
        String[][] stringArray = this.createNewData(appDeploymentTask, appDeploymentTask2, appDeploymentTask3);
        appDeploymentTask.setTaskData(stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareTask");
        }
    }

    private AppDeploymentTask findMatchingTask(AppDeploymentTask appDeploymentTask, Vector vector) {
        if (vector == null) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findMatchingTask");
        }
        AppDeploymentTask appDeploymentTask2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray;
            AppDeploymentTask appDeploymentTask3 = (AppDeploymentTask)vector.elementAt(i);
            if (!appDeploymentTask3.getName().equals(appDeploymentTask.getName())) continue;
            String[] stringArray2 = appDeploymentTask.getColumnNames();
            if (stringArray2.length != (stringArray = appDeploymentTask3.getColumnNames()).length) break;
            boolean bl = true;
            for (int j = 0; j < stringArray2.length; ++j) {
                if (stringArray2[j].equals(stringArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) break;
            appDeploymentTask2 = (AppDeploymentTask)vector.elementAt(i);
            if (!tc.isDebugEnabled()) break;
            Tr.debug((TraceComponent)tc, (String)("found match: " + appDeploymentTask2.getName()));
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("findMatchingTask: " + appDeploymentTask2));
        }
        return appDeploymentTask2;
    }

    private String[][] createNewData(AppDeploymentTask appDeploymentTask, AppDeploymentTask appDeploymentTask2, AppDeploymentTask appDeploymentTask3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createNewData: " + appDeploymentTask.getName()));
        }
        String[][] stringArray = appDeploymentTask.getTaskData();
        String[][] stringArray2 = new String[stringArray.length][];
        stringArray2[0] = stringArray[0];
        RedeploymentController.dbg("For: " + appDeploymentTask.getName() + " data rows: " + (stringArray.length - 1));
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray3 = this.findMatchingRow(stringArray[i], appDeploymentTask, appDeploymentTask2);
            String[] stringArray4 = this.findMatchingRow(stringArray[i], appDeploymentTask, appDeploymentTask3);
            String[] stringArray5 = stringArray[i];
            if (appDeploymentTask.getName().equals("AppDeploymentOptions") || appDeploymentTask.getName().equals("MapModulesToServers")) {
                stringArray4 = stringArray5;
                RedeploymentController.dbg("Setting b to null for AppDeplOptions and Mod2Svr");
            }
            RedeploymentController.printSA(stringArray3, "a row");
            RedeploymentController.printSA(stringArray4, "b row");
            RedeploymentController.printSA(stringArray5, "c row");
            if (this.mode.equals("redeploy.ignore.new")) {
                if (this.isFull(appDeploymentTask, stringArray3)) {
                    stringArray2[i] = stringArray3;
                    RedeploymentController.dbg("a won ignoreNew.");
                } else {
                    stringArray2[i] = stringArray5;
                    RedeploymentController.dbg("c won ignoreNew.");
                }
            } else {
                if (this.isFull(appDeploymentTask, stringArray4)) {
                    if (this.forceDfltBndg) {
                        stringArray2[i] = stringArray5;
                        RedeploymentController.dbg("c won - default mode - forcedflt.");
                    } else {
                        stringArray2[i] = stringArray4;
                        RedeploymentController.dbg("b won - default mode.");
                        this.copyNonReqColumns(stringArray2[i], stringArray3, appDeploymentTask);
                    }
                } else if (this.tasksWOBindings == null && this.isFull(appDeploymentTask, stringArray5)) {
                    stringArray2[i] = stringArray5;
                    RedeploymentController.dbg("c won nodfltbndg.");
                    this.copyNonReqColumns(stringArray2[i], stringArray3, appDeploymentTask);
                } else if (this.isFull(appDeploymentTask, stringArray3)) {
                    stringArray2[i] = stringArray3;
                    RedeploymentController.dbg("a won - default mode.");
                }
                if (stringArray2[i] == null) {
                    stringArray2[i] = stringArray5;
                    RedeploymentController.dbg("c won finally in default mode.");
                }
            }
            RedeploymentController.printSA(stringArray2[i], appDeploymentTask.getName() + "[" + i + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createNewData");
        }
        return stringArray2;
    }

    private String[] findMatchingRow(String[] stringArray, AppDeploymentTask appDeploymentTask, AppDeploymentTask appDeploymentTask2) {
        if (appDeploymentTask2 == null || appDeploymentTask2.getTaskData() == null) {
            return null;
        }
        boolean[] blArray = appDeploymentTask.getMutableColumns();
        String[][] stringArray2 = appDeploymentTask2.getTaskData();
        for (int i = 1; i < stringArray2.length; ++i) {
            boolean bl = true;
            for (int j = 0; j < stringArray2[i].length; ++j) {
                if (blArray[j] || stringArray2[i][j] == null || stringArray2[i][j].equals(stringArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return stringArray2[i];
        }
        return null;
    }

    private boolean isFull(AppDeploymentTask appDeploymentTask, String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        boolean[] blArray = appDeploymentTask.getRequiredColumns();
        if (blArray.length != stringArray.length) {
            RedeploymentController.printSA(stringArray, "isFull - Something wrong in " + appDeploymentTask.getName());
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!blArray[i] || !AppUtils.isEmpty(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    private void copyNonReqColumns(String[] stringArray, String[] stringArray2, AppDeploymentTask appDeploymentTask) {
        if (stringArray2 == null || stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray2[i] == null) continue;
            if (AppUtils.isEmpty(stringArray[i])) {
                stringArray[i] = stringArray2[i];
                continue;
            }
            if (!appDeploymentTask.getName().equals("MapRolesToUsers") || !"AppDeploymentOption.No".equals(stringArray[i]) || !"AppDeploymentOption.Yes".equals(stringArray2[i])) continue;
            stringArray[i] = stringArray2[i];
        }
    }

    private static void printSA(String[] stringArray, String string) {
        if (stringArray == null) {
            RedeploymentController.dbg("Null array");
            return;
        }
        String string2 = string + " --> ";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + stringArray[i];
        }
        RedeploymentController.dbg(string2);
    }

    private static void dbg(String string) {
        if (System.getProperty("redeploy.debug") != null) {
            AppUtils.dbg(tc, string);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

