/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.task;

import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class AbstractTask {
    private static final String defaultBundleName = "com.ibm.ws.management.resources.AppDeploymentMessages";
    protected Locale locale;
    protected String appTaskName = "xxx";
    protected ResourceBundle bundle;
    protected Scheduler scheduler;

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setAppTaskName(String string) {
        this.appTaskName = string;
    }

    protected String getResourceBundleName() {
        return defaultBundleName;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = AppUtils.getBundle(this.getResourceBundleName(), this.locale);
        }
        return this.bundle;
    }

    public abstract boolean performTask() throws AdminException;

    protected String getShortName() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    protected AppNotification createNotification(String string, String string2, Object[] objectArray) {
        String string3 = AppUtils.getMessage(this.getResourceBundle(), string2, objectArray);
        return new AppNotification(this.appTaskName, this.getShortName(), "InProgress", string, string3);
    }

    protected AppNotification createTranslatedNotification(String string, String string2, Object[] objectArray) {
        return new AppNotification(this.appTaskName, this.getShortName(), "InProgress", string, string2);
    }
}

