/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appcfg.AppcfgFactory;
import com.ibm.websphere.models.config.appcfg.DeployedObjectConfig;
import com.ibm.websphere.models.config.appcfg.EJBModuleConfiguration;
import com.ibm.websphere.models.config.appcfg.ModuleConfig;
import com.ibm.websphere.models.config.appcfg.WebModuleConfig;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentFactory;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentPackage;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.DeployedObject;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.EJBModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.appdeployment.WebModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.EditApplication;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public class AppAssociation {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$application$AppAssociation == null ? (class$com$ibm$ws$management$application$AppAssociation = AppAssociation.class$("com.ibm.ws.management.application.AppAssociation")) : class$com$ibm$ws$management$application$AppAssociation), null, (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static AppdeploymentFactory appFactory = null;
    private static boolean isReg = false;
    AppManagementImpl appM;
    String workspaceID;
    Hashtable prefs;
    ResourceBundle resBundle;
    static /* synthetic */ Class class$com$ibm$ws$management$application$AppAssociation;

    private static AppdeploymentFactory getAppFactory() {
        if (appFactory == null) {
            AppdeploymentPackage appdeploymentPackage = (AppdeploymentPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appdeployment.xmi");
            appFactory = appdeploymentPackage.getAppdeploymentFactory();
        }
        return appFactory;
    }

    public AppAssociation(AppManagementImpl appManagementImpl, Hashtable hashtable, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("AppAssociation: , " + string));
        }
        this.appM = appManagementImpl;
        this.workspaceID = string;
        this.prefs = hashtable;
        this.resBundle = AppUtils.getBundle(this.prefs);
        if (!isReg) {
            ConfigInit.init();
            AppdeploymentPackage appdeploymentPackage = (AppdeploymentPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appdeployment.xmi");
            AppdeploymentPackageImpl.init();
            isReg = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"AppAssociation");
        }
    }

    public static void handleCatch(Throwable throwable, String string, String string2, Object object) throws AdminException {
        FFDCFilter.processException((Throwable)throwable, (String)(object.getClass().getName() + "." + string), (String)string2, (Object)object);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Exception thrown in " + string + ": " + throwable));
        }
        if (throwable instanceof AdminException) {
            throw (AdminException)((Object)throwable);
        }
        throw new AdminException(throwable, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAllAppsFromNode(String string, String string2) throws AdminException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeAllAppsFromNode: " + string + ", " + string2));
        }
        WorkSpace workSpace = null;
        boolean bl2 = false;
        try {
            try {
                workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                RepositoryContext repositoryContext = AppUtils.findContext("cells", string2, null, null, workSpace, true);
                if (repositoryContext == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5047E", new Object[]{string2}));
                }
                RepositoryContext repositoryContext2 = AppUtils.findContext("nodes", string, null, repositoryContext, workSpace, false);
                if (repositoryContext2 == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5040E", new String[]{string}));
                }
                URI uRI = URI.createURI((String)"serverindex.xml");
                Resource resource = repositoryContext2.getResourceSet().getResource(uRI, true);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found for node " + repositoryContext2 + " SI doc res: " + resource));
                }
                ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                Vector<String> vector = new Vector<String>();
                EList eList = serverIndex.getServerEntries();
                for (int i = 0; i < eList.size(); ++i) {
                    vector.addElement(((ServerEntry)eList.get(i)).getServerName());
                }
                Hashtable<String, Vector<String>> hashtable = new Hashtable<String, Vector<String>>();
                hashtable.put(string, vector);
                this.removeAppAssociation(string2, hashtable, new Vector(), workSpace);
            }
            catch (Throwable throwable) {
                bl2 = true;
                AppAssociation.handleCatch(throwable, "removeAllAppsFromNode", "106", this);
                Object var14_16 = null;
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl2);
                if (!tc.isEntryEnabled()) return;
                Tr.exit((TraceComponent)tc, (String)"removeAllAppsFromNode");
                return;
            }
            Object var14_15 = null;
            bl = !bl2;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            EditApplication.doFinally(workSpace, this.workspaceID, null, !bl2);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"removeAllAppsFromNode");
            throw throwable;
        }
        EditApplication.doFinally(workSpace, this.workspaceID, null, bl);
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"removeAllAppsFromNode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAllAppsFromServer(ObjectName objectName) throws AdminException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeAllAppsFromServer: " + objectName));
        }
        WorkSpace workSpace = null;
        boolean bl2 = false;
        try {
            try {
                workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                String string = objectName.getKeyProperty("cell");
                String string2 = objectName.getKeyProperty("node");
                String string3 = objectName.getKeyProperty("server");
                Vector<String> vector = new Vector<String>();
                vector.addElement(string3);
                Hashtable<String, Vector<String>> hashtable = new Hashtable<String, Vector<String>>();
                hashtable.put(string2, vector);
                this.removeAppAssociation(string, hashtable, new Vector(), workSpace);
            }
            catch (Throwable throwable) {
                bl2 = true;
                AppAssociation.handleCatch(throwable, "removeAllAppsFromServer", "106", this);
                Object var10_11 = null;
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl2);
                if (!tc.isEntryEnabled()) return;
                Tr.exit((TraceComponent)tc, (String)"removeAllAppsFromServer");
                return;
            }
            Object var10_10 = null;
            bl = !bl2;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            EditApplication.doFinally(workSpace, this.workspaceID, null, !bl2);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"removeAllAppsFromServer");
            throw throwable;
        }
        EditApplication.doFinally(workSpace, this.workspaceID, null, bl);
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"removeAllAppsFromServer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAllAppsFromCluster(ObjectName objectName) throws AdminException {
        block15: {
            boolean bl;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("removeAllAppsFromCluster: " + objectName));
            }
            WorkSpace workSpace = null;
            boolean bl2 = false;
            try {
                try {
                    workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                    String string = objectName.getKeyProperty("cell");
                    String string2 = objectName.getKeyProperty("cluster");
                    RepositoryContext repositoryContext = AppUtils.findContext("cells", string, null, null, workSpace, true);
                    if (repositoryContext == null) {
                        throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5047E", new Object[]{string}));
                    }
                    Vector<String> vector = new Vector<String>();
                    vector.addElement(string2);
                    Hashtable<String, Vector<String>> hashtable = new Hashtable<String, Vector<String>>();
                    RepositoryContext repositoryContext2 = AppUtils.findContext("clusters", string2, string, repositoryContext, workSpace, true);
                    if (repositoryContext2 == null) {
                        Tr.warning((TraceComponent)tc, (String)AppUtils.getMessage(this.resBundle, "ADMA5051W", new Object[]{string2}));
                    } else {
                        URI uRI = URI.createURI((String)"cluster.xml");
                        Resource resource = repositoryContext2.getResourceSet().getResource(uRI, true);
                        ServerCluster serverCluster = (ServerCluster)resource.getContents().get(0);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Cluster obj: " + serverCluster));
                        }
                        EList eList = serverCluster.getMembers();
                        for (int i = 0; i < eList.size(); ++i) {
                            ClusterMember clusterMember = (ClusterMember)eList.get(i);
                            String string3 = clusterMember.getMemberName();
                            String string4 = clusterMember.getNodeName();
                            Vector<String> vector2 = (Vector<String>)hashtable.get(string4);
                            if (vector2 == null) {
                                vector2 = new Vector<String>();
                                hashtable.put(string4, vector2);
                            }
                            vector2.addElement(string3);
                        }
                    }
                    this.removeAppAssociation(string, hashtable, vector, workSpace);
                }
                catch (Throwable throwable) {
                    bl2 = true;
                    AppAssociation.handleCatch(throwable, "removeAllAppsFromCluster", "106", this);
                    Object var20_21 = null;
                    EditApplication.doFinally(workSpace, this.workspaceID, null, !bl2);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"removeAllAppsFromCluster");
                    }
                    break block15;
                }
                Object var20_20 = null;
                bl = !bl2;
            }
            catch (Throwable throwable) {
                Object var20_22 = null;
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl2);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"removeAllAppsFromCluster");
                }
                throw throwable;
            }
            EditApplication.doFinally(workSpace, this.workspaceID, null, bl);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeAllAppsFromCluster");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeAllAppsFromCluster");
        }
    }

    private void removeAppAssociation(String string, Hashtable hashtable, Vector vector, WorkSpace workSpace) throws Exception {
        URI uRI;
        RepositoryContext repositoryContext;
        Vector vector2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeAppAssociation: " + hashtable));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("clusters: " + vector));
        }
        RepositoryContext repositoryContext2 = AppUtils.findContext("cells", string, null, null, workSpace, true);
        Vector vector3 = new Vector();
        Enumeration enumeration = hashtable.keys();
        HashMap hashMap = new HashMap();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            vector2 = (Vector)hashtable.get(string2);
            repositoryContext = AppUtils.findContext("nodes", string2, null, repositoryContext2, workSpace, false);
            if (repositoryContext == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)(string2 + " not found."));
                continue;
            }
            uRI = URI.createURI((String)"serverindex.xml");
            Resource resource = repositoryContext.getResourceSet().getResource(uRI, true);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found for node " + repositoryContext + " SI doc res: " + resource));
            }
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)eList.get(i);
                if (!vector2.contains(serverEntry.getServerName())) continue;
                EList eList2 = serverEntry.getDeployedApplications();
                while (eList2.size() > 0) {
                    if (!vector3.contains(eList2.get(0))) {
                        vector3.add(eList2.get(0));
                    }
                    eList2.remove(0);
                }
            }
            resource.save(new HashMap(0));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("depls: " + vector3));
        }
        for (int i = 0; i < vector3.size(); ++i) {
            vector2 = ConfigRepoHelper.getAppContextFromSIEntry((String)vector3.elementAt(i), repositoryContext2, workSpace);
            if (vector2 == null) {
                Tr.warning((TraceComponent)tc, (String)"ADMA5041E", (Object)new Object[]{vector3.get(i), ""});
                continue;
            }
            repositoryContext = ConfigRepoHelper.getAppDeploymentResource((RepositoryContext)vector2);
            uRI = (Deployment)repositoryContext.getContents().get(0);
            this.removeAppTargets((Deployment)uRI, hashtable, vector);
            repositoryContext.save(new HashMap(0));
        }
    }

    private void removeAppTargets(Deployment deployment, Hashtable hashtable, Vector vector) throws Exception {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeAppTargets");
        }
        EList eList = deployment.getDeploymentTargets();
        ArrayList<DeploymentTarget> arrayList = new ArrayList<DeploymentTarget>();
        for (int i = 0; i < eList.size(); ++i) {
            DeploymentTarget deploymentTarget = (DeploymentTarget)eList.get(i);
            if (deploymentTarget instanceof ClusteredTarget) {
                if (!vector.contains(deploymentTarget.getName())) continue;
                arrayList.add(deploymentTarget);
                continue;
            }
            Vector vector2 = (Vector)hashtable.get(((ServerTarget)deploymentTarget).getNodeName());
            if (vector2 == null || !vector2.contains(deploymentTarget.getName())) continue;
            arrayList.add(deploymentTarget);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeDT: " + arrayList));
        }
        this.removeDTFromDeployment(deployment.getDeployedObject(), arrayList);
        EList eList2 = ((ApplicationDeployment)deployment.getDeployedObject()).getModules();
        for (n = 0; n < eList2.size(); ++n) {
            this.removeDTFromDeployment((DeployedObject)eList2.get(n), arrayList);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            deployment.getDeploymentTargets().remove(arrayList.get(n));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeAppTargets");
        }
    }

    private void removeDTFromDeployment(DeployedObject deployedObject, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeDTFromDeployment");
        }
        for (int i = 0; i < deployedObject.getTargetMappings().size(); ++i) {
            DeploymentTargetMapping deploymentTargetMapping = (DeploymentTargetMapping)deployedObject.getTargetMappings().get(i);
            if (!list.contains(deploymentTargetMapping.getTarget())) continue;
            deployedObject.getTargetMappings().remove((Object)deploymentTargetMapping);
            --i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeDTFromDeployment");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changeServerToCluster(ObjectName objectName, ObjectName objectName2) throws AdminException {
        RepositoryContext repositoryContext;
        RepositoryContext repositoryContext2;
        int n;
        Vector<RepositoryContext> vector;
        Resource resource;
        String string4;
        String string3;
        String string2;
        boolean bl;
        WorkSpace workSpace;
        block19: {
            RepositoryContext repositoryContext3;
            block18: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("changeServerToCluster: " + objectName + " -to-> " + objectName2));
                }
                workSpace = null;
                bl = false;
                try {
                    try {
                        workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                        String string = objectName.getKeyProperty("cell");
                        string2 = objectName.getKeyProperty("node");
                        string3 = objectName.getKeyProperty("server");
                        string4 = objectName2.getKeyProperty("cluster");
                        repositoryContext3 = AppUtils.findContext("cells", string, null, null, workSpace, true);
                        if (repositoryContext3 == null) {
                            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5047E", new Object[]{string}));
                        }
                        RepositoryContext repositoryContext4 = AppUtils.findContext("nodes", string2, string, repositoryContext3, workSpace, true);
                        if (repositoryContext4 == null) {
                            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5052E", new Object[]{objectName}));
                        }
                        URI uRI = URI.createURI((String)"serverindex.xml");
                        resource = repositoryContext4.getResourceSet().getResource(uRI, true);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Found for node " + repositoryContext4 + " SI doc res: " + resource));
                        }
                        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                        vector = new Vector<RepositoryContext>();
                        EList eList = serverIndex.getServerEntries();
                        for (n = 0; n < eList.size(); ++n) {
                            if (!((ServerEntry)eList.get(n)).getServerName().equals(string3)) continue;
                            repositoryContext2 = ((ServerEntry)eList.get(n)).getDeployedApplications();
                            break block18;
                        }
                        break block19;
                    }
                    catch (Throwable throwable) {
                        bl = true;
                        AppAssociation.handleCatch(throwable, "changeServerToCluster", "106", this);
                        Object var24_29 = null;
                        EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
                        if (!tc.isEntryEnabled()) return;
                        Tr.exit((TraceComponent)tc, (String)"changeServerToCluster");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var24_30 = null;
                    EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
                    if (!tc.isEntryEnabled()) throw throwable;
                    Tr.exit((TraceComponent)tc, (String)"changeServerToCluster");
                    throw throwable;
                }
            }
            for (int i = 0; i < repositoryContext2.size(); ++i) {
                try {
                    repositoryContext = ConfigRepoHelper.getAppContextFromSIEntry((String)repositoryContext2.get(i), repositoryContext3, workSpace);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("rc: " + repositoryContext));
                    }
                    vector.addElement(repositoryContext);
                    continue;
                }
                catch (Exception exception) {
                    Tr.warning((TraceComponent)tc, (String)AppUtils.getMessage(this.resBundle, "ADMA5053W", new Object[]{exception, repositoryContext2.get(i)}));
                }
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            repositoryContext2 = (RepositoryContext)vector.elementAt(n);
            try {
                resource = ConfigRepoHelper.getAppDeploymentResource(repositoryContext2);
                Deployment deployment = (Deployment)resource.getContents().get(0);
                repositoryContext = null;
                EList eList2 = deployment.getDeploymentTargets();
                for (int i = 0; i < eList2.size(); ++i) {
                    ServerTarget serverTarget;
                    if (!(eList2.get(i) instanceof ServerTarget) || !(serverTarget = (ServerTarget)eList2.get(i)).getName().equals(string3) || !serverTarget.getNodeName().equals(string2)) continue;
                    repositoryContext = serverTarget;
                    break;
                }
                if (repositoryContext == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("ServerTarget not found for " + string3 + "-" + string2 + " in " + deployment));
                    continue;
                }
                ClusteredTarget clusteredTarget = AppAssociation.getAppFactory().createClusteredTarget();
                clusteredTarget.setName(string4);
                this.replaceTarget((DeploymentTarget)repositoryContext, (DeploymentTarget)clusteredTarget, deployment);
                resource.save(new HashMap(0));
                continue;
            }
            catch (Throwable throwable) {
                Tr.warning((TraceComponent)tc, (String)AppUtils.getMessage(this.resBundle, "ADMA5054W", new Object[]{throwable, repositoryContext2.getName(), string3, string4}));
            }
        }
        Object var24_28 = null;
        EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"changeServerToCluster");
    }

    private void replaceTarget(DeploymentTarget deploymentTarget, DeploymentTarget deploymentTarget2, Deployment deployment) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("replaceTarget: " + deploymentTarget));
        }
        deployment.getDeploymentTargets().add((Object)deploymentTarget2);
        this.replaceTarget(deploymentTarget, deploymentTarget2, deployment.getDeployedObject());
        EList eList = ((ApplicationDeployment)deployment.getDeployedObject()).getModules();
        for (int i = 0; i < eList.size(); ++i) {
            this.replaceTarget(deploymentTarget, deploymentTarget2, (DeployedObject)eList.get(i));
        }
        deployment.getDeploymentTargets().remove((Object)deploymentTarget);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"replaceTarget");
        }
    }

    private void replaceTarget(DeploymentTarget deploymentTarget, DeploymentTarget deploymentTarget2, DeployedObject deployedObject) throws Exception {
        EList eList = deployedObject.getTargetMappings();
        for (int i = 0; i < eList.size(); ++i) {
            DeploymentTargetMapping deploymentTargetMapping = (DeploymentTargetMapping)eList.get(i);
            if (!deploymentTargetMapping.getTarget().equals(deploymentTarget)) continue;
            deploymentTargetMapping.setTarget(deploymentTarget2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clusterMemberAdded(ObjectName objectName, ObjectName objectName2) throws AdminException {
        int n;
        EList eList;
        Deployment deployment;
        RepositoryContext repositoryContext;
        ClusterMember clusterMember;
        EList eList3;
        Resource resource;
        URI uRI;
        RepositoryContext repositoryContext4;
        RepositoryContext repositoryContext2;
        String string4;
        String string3;
        boolean bl;
        WorkSpace workSpace;
        block23: {
            EList eList4;
            block24: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("clusterMemberAdded: " + objectName + " to " + objectName2));
                }
                workSpace = null;
                bl = false;
                try {
                    try {
                        workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                        String string = objectName.getKeyProperty("cell");
                        String string2 = objectName.getKeyProperty("node");
                        string3 = objectName.getKeyProperty("server");
                        string4 = objectName2.getKeyProperty("cluster");
                        repositoryContext2 = AppUtils.findContext("cells", string, null, null, workSpace, true);
                        if (repositoryContext2 == null) {
                            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5047E", new Object[]{string}));
                        }
                        RepositoryContext repositoryContext3 = AppUtils.findContext("clusters", string4, string, repositoryContext2, workSpace, true);
                        if (repositoryContext3 == null) {
                            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5055E", new Object[]{string4, string3}));
                        }
                        repositoryContext4 = AppUtils.findContext("nodes", string2, string, repositoryContext2, workSpace, true);
                        if (repositoryContext4 == null) {
                            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5052E", new Object[]{string2}));
                        }
                        uRI = URI.createURI((String)"cluster.xml");
                        resource = repositoryContext3.getResourceSet().getResource(uRI, true);
                        ServerCluster serverCluster = (ServerCluster)resource.getContents().get(0);
                        EList eList2 = serverCluster.getMembers();
                        eList3 = null;
                        if (eList2.size() <= 1) break block23;
                        for (int i = 0; i < eList2.size(); ++i) {
                            clusterMember = (ClusterMember)eList2.get(i);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Member: " + clusterMember.getMemberName() + " - " + clusterMember.getNodeName() + " sName: " + string3 + " nName: " + string2));
                            }
                            if (clusterMember.getMemberName().equals(string3) && clusterMember.getNodeName().equals(string2)) continue;
                            repositoryContext = AppUtils.findContext("nodes", clusterMember.getNodeName(), string, repositoryContext2, workSpace, true);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Node context: " + repositoryContext));
                            }
                            if (repositoryContext == null) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)("Invalid member: " + clusterMember.getMemberName()));
                                continue;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Member: " + clusterMember.getMemberName() + " - " + clusterMember.getNodeName()));
                            }
                            uRI = URI.createURI((String)"serverindex.xml");
                            deployment = repositoryContext.getResourceSet().getResource(uRI, true);
                            eList = (ServerIndex)deployment.getContents().get(0);
                            eList4 = eList.getServerEntries();
                            break block24;
                        }
                        break block23;
                    }
                    catch (Throwable throwable) {
                        bl = true;
                        AppAssociation.handleCatch(throwable, "clusterMemberAdded", "106", this);
                        Object var26_34 = null;
                        EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
                        if (!tc.isEntryEnabled()) return;
                        Tr.exit((TraceComponent)tc, (String)"clusterMemberAdded");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var26_35 = null;
                    EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
                    if (!tc.isEntryEnabled()) throw throwable;
                    Tr.exit((TraceComponent)tc, (String)"clusterMemberAdded");
                    throw throwable;
                }
            }
            for (int j = 0; j < eList4.size(); ++j) {
                ServerEntry serverEntry = (ServerEntry)eList4.get(j);
                if (!serverEntry.getServerName().equals(clusterMember.getMemberName())) continue;
                eList3 = serverEntry.getDeployedApplications();
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("add: " + eList3));
                break;
            }
        }
        if (eList3 == null) {
            eList3 = new ArrayList();
            Object[] objectArray = AppUtils.getContextArray("deployments", repositoryContext2, workSpace);
            block8: for (int i = 0; i < objectArray.length; ++i) {
                repositoryContext = (RepositoryContext)objectArray[i];
                resource = ConfigRepoHelper.getAppDeploymentResource(repositoryContext);
                deployment = (Deployment)resource.getContents().get(0);
                eList = deployment.getDeploymentTargets();
                for (int j = 0; j < eList.size(); ++j) {
                    if (!(eList.get(j) instanceof ClusteredTarget) || !((ClusteredTarget)eList.get(j)).getName().equals(string4)) continue;
                    eList3.add(ConfigRepoHelper.getSIEntryText(repositoryContext));
                    continue block8;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("add is: " + eList3));
        }
        uRI = URI.createURI((String)"serverindex.xml");
        resource = repositoryContext4.getResourceSet().getResource(uRI, true);
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        clusterMember = serverIndex.getServerEntries();
        for (n = 0; n < clusterMember.size(); ++n) {
            deployment = (ServerEntry)clusterMember.get(n);
            if (!deployment.getServerName().equals(string3)) continue;
            for (int i = 0; i < eList3.size(); ++i) {
                if (deployment.getDeployedApplications().contains(eList3.get(i))) continue;
                deployment.getDeployedApplications().add(eList3.get(i));
            }
            break;
        }
        resource.save(new HashMap(0));
        uRI = URI.createURI((String)"deployment.xml");
        for (n = 0; n < eList3.size(); ++n) {
            try {
                deployment = ConfigRepoHelper.getAppContextFromSIEntry((String)eList3.get(n), repositoryContext2, workSpace);
                resource = deployment.getResourceSet().getResource(uRI, true);
                resource.save(new HashMap(0));
                continue;
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Exception: " + throwable + " in touching deployment.xml " + " in " + eList3.get(n)));
            }
        }
        Object var26_33 = null;
        EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"clusterMemberAdded");
    }

    public static void populateDeployTargets(Deployment deployment, ModuleDeployment moduleDeployment, String string, String string2, RepositoryContext repositoryContext, WorkSpace workSpace, AppcfgFactory appcfgFactory, AppdeploymentFactory appdeploymentFactory) throws Exception {
        DeploymentTargetMapping deploymentTargetMapping;
        int n;
        int n2;
        Object object;
        int n3;
        Object object2;
        int n4;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("populateDeployTargets: " + string));
        }
        if (AppUtils.isEmpty(string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"populateDeployTargets");
            }
            return;
        }
        Vector vector = AppAssociation.getServerNames(string, string2, repositoryContext, workSpace);
        EList eList = moduleDeployment.getTargetMappings();
        Vector<DeploymentTargetMapping> vector2 = new Vector<DeploymentTargetMapping>();
        Vector vector3 = new Vector();
        for (n4 = 0; n4 < eList.size(); ++n4) {
            object2 = (DeploymentTargetMapping)eList.get(n4);
            n3 = AppAssociation.existsInNewConfig(object2, vector);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("For mapping with target: " + object2.getTarget() + ", " + " config: " + object2.getConfig() + " --> Index: " + n3));
            }
            if (n3 == -1) {
                vector2.add((DeploymentTargetMapping)object2);
                continue;
            }
            vector3.add(vector.elementAt(n3));
        }
        for (n4 = 0; n4 < vector2.size(); ++n4) {
            eList.remove(vector2.elementAt(n4));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("After deleting changed maps:  mapping are --> " + eList));
        }
        for (n4 = 0; n4 < vector3.size(); ++n4) {
            object2 = vector3.elementAt(n4);
            n3 = vector.indexOf(object2);
            if (n3 < 0) continue;
            vector.removeElementAt(n3);
            vector.removeElementAt(n3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("After deleting unchanged targets: " + vector));
        }
        for (n4 = 0; n4 < vector.size(); n4 += 2) {
            object2 = (RepositoryContext)vector.elementAt(n4);
            String string3 = (String)vector.elementAt(n4 + 1);
            object = AppAssociation.getOrCreateConfig(moduleDeployment, string3, appcfgFactory);
            DeploymentTarget deploymentTarget = AppAssociation.getOrCreateTarget(deployment, (RepositoryContext)object2, appdeploymentFactory);
            DeploymentTargetMapping deploymentTargetMapping2 = appdeploymentFactory.createDeploymentTargetMapping();
            deploymentTargetMapping2.setTarget(deploymentTarget);
            if (object != null) {
                deploymentTargetMapping2.setConfig((DeployedObjectConfig)object);
            }
            moduleDeployment.getTargetMappings().add((Object)deploymentTargetMapping2);
        }
        Vector<Object> vector4 = new Vector<Object>();
        object2 = ((ApplicationDeployment)deployment.getDeployedObject()).getModules();
        for (n2 = 0; n2 < deployment.getDeploymentTargets().size(); ++n2) {
            object = (DeploymentTarget)deployment.getDeploymentTargets().get(n2);
            boolean bl = false;
            for (int i = 0; i < object2.size(); ++i) {
                eList = ((DeployedObject)object2.get(i)).getTargetMappings();
                for (n = 0; n < eList.size(); ++n) {
                    deploymentTargetMapping = (DeploymentTargetMapping)eList.get(n);
                    if (deploymentTargetMapping.getTarget() == null || !deploymentTargetMapping.getTarget().equals(object)) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
            if (bl) continue;
            vector4.add(object);
        }
        for (n2 = 0; n2 < vector4.size(); ++n2) {
            deployment.getDeploymentTargets().remove(vector4.elementAt(n2));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Finally App level targets: " + deployment.getDeploymentTargets()));
        }
        Vector vector5 = new Vector();
        object = new Vector();
        EList eList2 = deployment.getDeployedObject().getTargetMappings();
        EList eList3 = deployment.getDeploymentTargets();
        for (n = 0; n < eList3.size(); ++n) {
            deploymentTargetMapping = (DeploymentTarget)eList3.get(n);
            boolean bl = false;
            for (int i = 0; i < eList2.size(); ++i) {
                DeploymentTarget deploymentTarget = ((DeploymentTargetMapping)eList2.get(i)).getTarget();
                if (deploymentTarget == null || !deploymentTarget.equals(deploymentTargetMapping)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            ((Vector)object).addElement(deploymentTargetMapping);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("add DTMS: " + object));
        }
        for (n = 0; n < eList2.size(); ++n) {
            deploymentTargetMapping = ((DeploymentTargetMapping)eList2.get(n)).getTarget();
            if (deploymentTargetMapping == null || eList3.contains(deploymentTargetMapping)) continue;
            vector5.add(eList2.get(n));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("remove DTMS: " + vector5));
        }
        for (n = 0; n < vector5.size(); ++n) {
            deployment.getDeployedObject().getTargetMappings().remove(vector5.elementAt(n));
        }
        for (n = 0; n < ((Vector)object).size(); ++n) {
            deploymentTargetMapping = appdeploymentFactory.createDeploymentTargetMapping();
            deploymentTargetMapping.setTarget((DeploymentTarget)((Vector)object).elementAt(n));
            deploymentTargetMapping.setEnable(true);
            deployment.getDeployedObject().getTargetMappings().add((Object)deploymentTargetMapping);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Final targets: " + deployment.getDeploymentTargets()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Final configs: " + moduleDeployment.getConfigs()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Final mappings: " + moduleDeployment.getTargetMappings()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Final app mappings: " + deployment.getDeployedObject().getTargetMappings()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"populateDeployTargets");
        }
    }

    public static Vector getServerNames(String string, String string2, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        RepositoryContext repositoryContext2;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerNames");
        }
        Vector<Object> vector = new Vector<Object>();
        if (string == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getServerNames: null");
            }
            return vector;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
        Object[] objectArray = AppUtils.getContextArray("servers", repositoryContext, workSpace);
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4 = stringTokenizer.nextToken().trim();
            if (AppUtils.isEmpty(string4)) continue;
            object = null;
            try {
                object = new ObjectName(string4);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Bad token: " + string4));
                }
                throw new AdminException(malformedObjectNameException, AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5025E", new Object[]{string4}));
            }
            repositoryContext2 = null;
            String string5 = ((ObjectName)object).getKeyProperty("cluster");
            if (!AppUtils.isEmpty(string5)) {
                repositoryContext2 = AppUtils.findContext("clusters", string5 = string5.trim(), null, repositoryContext, workSpace, true);
                if (repositoryContext2 == null) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5022E", new Object[]{string5, string2}));
                }
            } else {
                string3 = ((ObjectName)object).getKeyProperty("server");
                if (AppUtils.isEmpty(string3)) {
                    string3 = ((ObjectName)object).getKeyProperty("process");
                }
                String string6 = ((ObjectName)object).getKeyProperty("node");
                if (AppUtils.isEmpty(string3)) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5026E", new Object[]{string4, string2}));
                }
                string3 = string3.trim();
                repositoryContext2 = AppUtils.getContextFromArray(objectArray, string3, string6, false);
            }
            if (repositoryContext2 == null) {
                throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5026E", new Object[]{string4, string2}));
            }
            string3 = ((ObjectName)object).getKeyProperty("config");
            if (string3 == null) {
                string3 = "";
            }
            if (!vector.contains(repositoryContext2)) {
                vector.addElement(repositoryContext2);
                vector.addElement(string3);
                continue;
            }
            Tr.warning((TraceComponent)tc, (String)AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5032W", new Object[]{repositoryContext2.getName(), string, string4}));
        }
        for (int i = 0; i < vector.size(); i += 2) {
            object = (RepositoryContext)vector.elementAt(i);
            if (AppUtils.isCluster((RepositoryContext)object) || (repositoryContext2 = AppUtils.getClusterFromMember((RepositoryContext)object, workSpace)) == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Target has member: " + object + " which belongs to " + repositoryContext2));
            }
            if (vector.contains(repositoryContext2)) continue;
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5033E", new Object[]{object.getName(), repositoryContext2.getName(), string2}));
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getServerNames: " + vector));
        }
        return vector;
    }

    private static int existsInNewConfig(DeploymentTargetMapping deploymentTargetMapping, Vector vector) {
        for (int i = 0; i < vector.size(); i += 2) {
            RepositoryContext repositoryContext = (RepositoryContext)vector.elementAt(i);
            String string = (String)vector.elementAt(i + 1);
            String string2 = null;
            ModuleConfig moduleConfig = (ModuleConfig)deploymentTargetMapping.getConfig();
            if (moduleConfig != null) {
                string2 = moduleConfig.getName();
            }
            if ((!AppUtils.isEmpty(string) || !AppUtils.isEmpty(string2)) && !string.equals(string2) || !repositoryContext.getName().equals(deploymentTargetMapping.getTarget().getName())) continue;
            if (deploymentTargetMapping.getTarget() instanceof ClusteredTarget && AppUtils.isCluster(repositoryContext)) {
                return i;
            }
            if (!(deploymentTargetMapping.getTarget() instanceof ServerTarget) || !AppUtils.isServer(repositoryContext) || !repositoryContext.getParent().getName().equals(((ServerTarget)deploymentTargetMapping.getTarget()).getNodeName())) continue;
            return i;
        }
        return -1;
    }

    private static ModuleConfig getOrCreateConfig(ModuleDeployment moduleDeployment, String string, AppcfgFactory appcfgFactory) throws Exception {
        EList eList = moduleDeployment.getConfigs();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleConfig moduleConfig = (ModuleConfig)eList.get(i);
            if (!moduleConfig.getName().equals(string)) continue;
            return moduleConfig;
        }
        if (AppUtils.isEmpty(string)) {
            return null;
        }
        if (moduleDeployment instanceof EJBModuleDeployment) {
            EJBModuleConfiguration eJBModuleConfiguration = appcfgFactory.createEJBModuleConfiguration();
            eJBModuleConfiguration.setName(string);
            eList.add((Object)eJBModuleConfiguration);
            return eJBModuleConfiguration;
        }
        if (moduleDeployment instanceof WebModuleDeployment) {
            WebModuleConfig webModuleConfig = appcfgFactory.createWebModuleConfig();
            webModuleConfig.setName(string);
            eList.add((Object)webModuleConfig);
            return webModuleConfig;
        }
        return null;
    }

    private static DeploymentTarget getOrCreateTarget(Deployment deployment, RepositoryContext repositoryContext, AppdeploymentFactory appdeploymentFactory) throws Exception {
        EList eList = deployment.getDeploymentTargets();
        for (int i = 0; i < eList.size(); ++i) {
            DeploymentTarget deploymentTarget = (DeploymentTarget)eList.get(i);
            if (deploymentTarget instanceof ClusteredTarget && AppUtils.isCluster(repositoryContext) && deploymentTarget.getName().equals(repositoryContext.getName())) {
                return deploymentTarget;
            }
            if (!(deploymentTarget instanceof ServerTarget) || !AppUtils.isServer(repositoryContext) || !deploymentTarget.getName().equals(repositoryContext.getName()) || !repositoryContext.getParent().getName().equals(((ServerTarget)deploymentTarget).getNodeName())) continue;
            return deploymentTarget;
        }
        Object object = null;
        object = AppUtils.isCluster(repositoryContext) ? appdeploymentFactory.createClusteredTarget() : appdeploymentFactory.createServerTarget();
        object.setName(repositoryContext.getName());
        if (object instanceof ServerTarget) {
            ((ServerTarget)object).setNodeName(repositoryContext.getParent().getName());
        }
        deployment.getDeploymentTargets().add(object);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created target: " + object));
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

