/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.application.AppAssociation;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.EditApplication;
import com.ibm.ws.management.application.InstallSchedulerImpl;
import com.ibm.ws.management.application.RedeploymentManager;
import com.ibm.ws.management.application.UninstallSchedulerImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.policy.ApplicationPolicyParser;
import com.ibm.ws.security.policy.FilterPolicyParser;
import com.ibm.ws.security.policy.PolicyTemplate;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.Permission;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class AppManagementImpl
extends RuntimeCollaborator
implements AppManagement {
    public static final String TEMP_EXTRACT_DIR = "Temp extraction dir for multiserver";
    public static final String CONFIG_ROOT = "Config Root for variable map";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$application$AppManagementImpl == null ? (class$com$ibm$ws$management$application$AppManagementImpl = AppManagementImpl.class$("com.ibm.ws.management.application.AppManagementImpl")) : class$com$ibm$ws$management$application$AppManagementImpl), (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String PROPERTIES_PATH = "version.properties";
    private static final String VERSION_KEY = "app.management.roam.key";
    private static final String VERSION_VALUE = "3828436921961863062";
    private Hashtable _props;
    private static ObjectName objectName;
    private static long seqNum;
    private boolean readOnly = false;
    private String readOnlyPath = null;
    private long readOnlyTimeStamp;
    static /* synthetic */ Class class$com$ibm$ws$management$application$AppManagementImpl;
    static /* synthetic */ Class class$java$lang$String;

    public static AppManagement createLocalImpl() {
        return AppManagementFactory.createLocalAppManagementImpl();
    }

    public static AppManagement createLocalImpl(String string) {
        return AppManagementFactory.createLocalAppManagementImpl(string);
    }

    public AppManagementImpl(Hashtable hashtable) {
        this._props = hashtable;
    }

    public Hashtable getGlobalSettings() {
        return this._props;
    }

    public void setObjectName(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setObjectName: " + objectName));
        }
        super.setObjectName(objectName);
        AppManagementImpl.objectName = objectName;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setObjectName");
        }
    }

    public static boolean isLocalMode() {
        return objectName == null;
    }

    public void sendJMXEvent(Object object) {
        this.sendJMXEvent("websphere.admin.appmgmt", object);
    }

    public void sendJMXEvent(String string, Object object) {
        block5: {
            if (AppManagementImpl.isLocalMode()) {
                return;
            }
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"sendJMXEvent");
            }
            try {
                Notification notification = new Notification("websphere.admin.appmgmt", objectName, ++seqNum);
                notification.setUserData(object);
                this.sendNotification(notification);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl.sendJMXEvent", (String)"163", (Object)this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("Exception from sending JMX event: " + throwable));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendJMXEvent");
        }
    }

    public boolean checkIfAppExists(String string, Hashtable hashtable, String string2) throws AdminException {
        Tr.entry((TraceComponent)tc, (String)("checkIfAppExists: " + string));
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        if (string == null) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0045E"));
        }
        WorkSpace workSpace = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string2);
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(string, workSpace, hashtable);
            Tr.debug((TraceComponent)tc, (String)("App " + string + " exists: " + repositoryContext));
            Tr.exit((TraceComponent)tc, (String)"checkIfAppExists");
            boolean bl = repositoryContext != null;
            return bl;
        }
        catch (Throwable throwable) {
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, "");
        }
        finally {
            EditApplication.doFinally(workSpace, string2, null, false);
        }
    }

    public void installApplication(String string, Hashtable hashtable, String string2) throws AdminException {
        this.installApplication(string, null, hashtable, string2);
    }

    public void installApplication(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        this._installApplication(string, string2, hashtable, null, true, string3);
    }

    public void installApplicationLocal(String string, String string2, Hashtable hashtable, AppNotification.Listener listener) throws AdminException {
        this._installApplication(string, string2, hashtable, listener, false, null);
    }

    public void installApplicationLocal(String string, String string2, Hashtable hashtable, AppNotification.Listener listener, String string3) throws AdminException {
        this._installApplication(string, string2, hashtable, listener, false, string3);
    }

    private void _installApplication(String string, String string2, Hashtable hashtable, AppNotification.Listener listener, boolean bl, String string3) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("_installApplication " + string + ", " + string2));
        }
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        if (this.isReadOnlyMode()) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"installApplication"}));
        }
        if (string == null) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0041E"));
        }
        if (hashtable == null) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0042E"));
        }
        if (!new File(string).exists()) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0043E", new Object[]{string}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Create new installscheduler");
        }
        InstallSchedulerImpl installSchedulerImpl = new InstallSchedulerImpl(string, string2, hashtable, this, listener);
        Locale locale = null;
        if (hashtable != null) {
            locale = (Locale)hashtable.get("app.client.locale");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        installSchedulerImpl.setLocale(locale);
        try {
            installSchedulerImpl.setWorkSpaceID(string3);
            Thread thread = new Thread(installSchedulerImpl);
            thread.start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl._installApplication", (String)"190", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"_installAppliction");
            }
            throwable.printStackTrace();
            throw new AdminException(throwable, AppUtils.getMessage(resourceBundle, "ADMA0044E", new Object[]{string}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"_installAppliction");
        }
    }

    public void uninstallApplicationLocal(String string, Hashtable hashtable, AppNotification.Listener listener) throws AdminException {
        this._uninstallApplication(string, hashtable, listener, false, null);
    }

    public void uninstallApplicationLocal(String string, Hashtable hashtable, AppNotification.Listener listener, String string2) throws AdminException {
        this._uninstallApplication(string, hashtable, listener, false, string2);
    }

    public void uninstallApplication(String string, Hashtable hashtable, String string2) throws AdminException {
        this._uninstallApplication(string, hashtable, null, true, string2);
    }

    public void _uninstallApplication(String string, Hashtable hashtable, AppNotification.Listener listener, boolean bl, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("_uninstallApplication " + string));
        }
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        if (this.isReadOnlyMode()) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"uninstallApplication"}));
        }
        if (string == null) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0045E"));
        }
        if (!bl && hashtable == null) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0046E"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Create new uninstallscheduler");
        }
        UninstallSchedulerImpl uninstallSchedulerImpl = new UninstallSchedulerImpl(string, hashtable, this, listener);
        Locale locale = null;
        if (hashtable != null) {
            locale = (Locale)hashtable.get("app.client.locale");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        uninstallSchedulerImpl.setLocale(locale);
        try {
            uninstallSchedulerImpl.setWorkSpaceID(string2);
            Thread thread = new Thread(uninstallSchedulerImpl);
            thread.start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl._uninstallApplication", (String)"190", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"_uninstallAppliction");
            }
            throw new AdminException(throwable, AppUtils.getMessage(resourceBundle, "ADMA0047E", new Object[]{string}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("_uninstallApplication " + string));
        }
    }

    public void redeployApplicationLocal(String string, String string2, Hashtable hashtable, AppNotification.Listener listener, String string3) throws AdminException {
        if (this.isReadOnlyMode()) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"redeployApplication"}));
        }
        RedeploymentManager redeploymentManager = new RedeploymentManager(string, string2, hashtable, string3, listener, true, this);
        redeploymentManager.performTask();
    }

    public void redeployApplication(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        if (this.isReadOnlyMode()) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"redeployApplication"}));
        }
        RedeploymentManager redeploymentManager = new RedeploymentManager(string, string2, hashtable, string3, null, false, this);
        redeploymentManager.performTask();
    }

    public Vector getApplicationInfo(String string, Hashtable hashtable, String string2) throws AdminException {
        return this._getApplicationInfo(string, hashtable, null, string2);
    }

    public Vector getModuleInfo(String string, Hashtable hashtable, String string2, String string3) throws AdminException {
        return this._getApplicationInfo(string, hashtable, string2, string3);
    }

    private Vector _getApplicationInfo(String string, Hashtable hashtable, String string2, String string3) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getApplicationInfo:" + string + ", " + string2));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, string2, string3, this);
        Vector vector = editApplication.getApplicationInfo();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getApplicationInfo");
        }
        return vector;
    }

    public void setApplicationInfo(String string, Hashtable hashtable, String string2, Vector vector) throws AdminException {
        this._setApplicationInfo(string, hashtable, null, string2, vector);
    }

    public void setModuleInfo(String string, Hashtable hashtable, String string2, String string3, Vector vector) throws AdminException {
        this._setApplicationInfo(string, hashtable, string2, string3, vector);
    }

    private void _setApplicationInfo(String string, Hashtable hashtable, String string2, String string3, Vector vector) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("_setApplicationInfo: " + string + ", " + string2));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, string2, string3, this);
        editApplication.setApplicationInfo(vector);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setApplicationInfo");
        }
    }

    public void moveModule(String string, Hashtable hashtable, String string2, ObjectName objectName, String string3) throws AdminException {
    }

    public void exportApplication(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("exportApplication: " + string));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, null, string3, this);
        editApplication.exportApplication(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("exportApplication: " + string));
        }
    }

    public void extractDDL(String string, String string2, String string3, Hashtable hashtable, String string4) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("extractDDL: " + string));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, null, string4, this);
        editApplication.extractDDL(string2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("extractDDL: " + string));
        }
    }

    public void publishWSDL(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("publishWSDL: " + string));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, null, string3, this);
        editApplication.publishWSDL(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("publishWSDL: " + string));
        }
    }

    public Vector listApplications(Hashtable hashtable, String string) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"listApplications");
        }
        Vector vector = EditApplication.listApplications(hashtable, string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("listApplications: " + vector));
        }
        return vector;
    }

    public Object listModules(String string, Hashtable hashtable, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("listModules: " + string));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, null, string2, this);
        AppDeploymentTask appDeploymentTask = editApplication.listModules();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("listModules: " + string + ", " + appDeploymentTask));
        }
        return appDeploymentTask;
    }

    public void removeAllAppsFromNode(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        if (this.isReadOnlyMode()) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"removeAllAppsFromNode"}));
        }
        AppAssociation appAssociation = new AppAssociation(this, hashtable, string3);
        appAssociation.removeAllAppsFromNode(string, string2);
    }

    public void removeAllAppsFromServer(ObjectName objectName, Hashtable hashtable, String string) throws AdminException {
        if (this.isReadOnlyMode()) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"removeAllAppsFromServer"}));
        }
        AppAssociation appAssociation = new AppAssociation(this, hashtable, string);
        appAssociation.removeAllAppsFromServer(objectName);
    }

    public void removeAllAppsFromCluster(ObjectName objectName, Hashtable hashtable, String string) throws AdminException {
        if (this.isReadOnlyMode()) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"removeAllAppsFromCluster"}));
        }
        AppAssociation appAssociation = new AppAssociation(this, hashtable, string);
        appAssociation.removeAllAppsFromCluster(objectName);
    }

    public void changeServerToCluster(ObjectName objectName, ObjectName objectName2, Hashtable hashtable, String string) throws AdminException {
        AppAssociation appAssociation = new AppAssociation(this, hashtable, string);
        appAssociation.changeServerToCluster(objectName, objectName2);
    }

    public void clusterMemberAdded(ObjectName objectName, ObjectName objectName2, Hashtable hashtable, String string) throws AdminException {
        AppAssociation appAssociation = new AppAssociation(this, hashtable, string);
        appAssociation.clusterMemberAdded(objectName, objectName2);
    }

    public void updateAccessIDs(String string, Boolean bl, Hashtable hashtable, String string2) throws AdminException {
        EditApplication editApplication = new EditApplication(string, hashtable, null, string2, this);
        editApplication.updateAccessIDs(bl);
    }

    public void deleteUserAndGroupEntries(String string, Hashtable hashtable, String string2) throws AdminException {
        EditApplication editApplication = new EditApplication(string, hashtable, null, string2, this);
        editApplication.deleteUserAndGroupEntries();
    }

    public String startApplication(String string, Hashtable hashtable, String string2) throws AdminException {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("startApplication: " + string));
        }
        if (AppManagementImpl.isLocalMode()) {
            throw new AdminException(nls.getFormattedMessage("ADMA0090", new Object[]{"startApplication"}, "Invalid usage of {0}. Operation {0} can only be called in JMX mode of AppManagement"));
        }
        if (string == null) {
            throw new AdminException(nls.getFormattedMessage("ADMA0016E", new Object[0], "appName can not be null."));
        }
        AdminHelper.getInstance().audit("ADMN1008I", "ADMN1009I", new Object[]{string, null});
        String string4 = null;
        WorkSpace workSpace = null;
        Subject subject = SecurityHelper.retrieveSubject();
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string2);
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(string, workSpace, hashtable);
            if (repositoryContext == null) {
                throw new AdminException(nls.getFormattedMessage("ADMA0017E", new Object[]{string}, "Unable to obtain context for {0}"));
            }
            RepositoryContext repositoryContext2 = repositoryContext.getParent().getParent();
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
            Vector vector = ConfigRepoHelper.getServersForAppDeployment(applicationDeployment, null, repositoryContext2, workSpace, false);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("All targets: " + vector));
            }
            vector = ConfigRepoHelper.getAllServers(workSpace, vector);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("All server targets: " + vector));
            }
            if (subject != null) {
                subject = SecurityHelper.pushInvocationSubject(subject);
            }
            for (int i = 0; i < vector.size(); ++i) {
                repositoryContext = (RepositoryContext)vector.elementAt(i);
                ObjectName objectName = new ObjectName("WebSphere:type=ApplicationManager,node=" + repositoryContext.getParent().getName() + ",process=" + repositoryContext.getName() + ",*");
                try {
                    Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
                    if (iterator.hasNext()) {
                        objectName = (ObjectName)iterator.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Starting app: " + string + " using " + objectName));
                        }
                        AdminServiceFactory.getAdminService().invoke(objectName, "startApplication", new Object[]{string}, new String[]{(class$java$lang$String == null ? AppManagementImpl.class$("java.lang.String") : class$java$lang$String).getName()});
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Started app: " + string + " using " + objectName));
                        }
                        string4 = ConfigRepoHelper.getTargetString(repositoryContext, string4);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("No ApplicationManager MBean on: " + repositoryContext));
                    continue;
                }
                catch (Throwable throwable) {
                    Tr.warning((TraceComponent)tc, (String)("Unable to start: " + string + " using: " + objectName + " exception is: " + throwable));
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl.startApplication", (String)"564", (Object)this);
                }
            }
            string3 = string4;
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            try {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl.startApplication", (String)"572", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown in startApplication: " + throwable));
                }
                if (throwable instanceof AdminException) {
                    throw (AdminException)((Object)throwable);
                }
                throw new AdminException(throwable, "");
            }
            catch (Throwable throwable2) {
                block20: {
                    Object var15_18 = null;
                    EditApplication.doFinally(workSpace, string2, null, false);
                    if (subject == null) break block20;
                    SecurityHelper.popInvocationSubject(subject);
                }
                throw throwable2;
            }
        }
        EditApplication.doFinally(workSpace, string2, null, false);
        if (subject != null) {
            SecurityHelper.popInvocationSubject(subject);
        }
        return string3;
    }

    public String stopApplication(String string, Hashtable hashtable, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("stopApplication: " + string));
        }
        if (AppManagementImpl.isLocalMode()) {
            throw new AdminException(nls.getFormattedMessage("ADMA0090", new Object[]{"stopApplication"}, "Invalid usage of {0}. Operation {0} can only be called in JMX mode of AppManagement"));
        }
        if (string == null) {
            throw new AdminException(nls.getFormattedMessage("ADMA0016E", new Object[0], "appName can not be null."));
        }
        AdminHelper.getInstance().audit("ADMN1010I", "ADMN1011I", new Object[]{string, null});
        Object object = null;
        Subject subject = SecurityHelper.retrieveSubject();
        try {
            Iterator iterator;
            if (subject != null) {
                subject = SecurityHelper.pushInvocationSubject(subject);
            }
            ObjectName objectName = new ObjectName("WebSphere:type=Application,name=" + string + ",*");
            Iterator iterator2 = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            while (iterator2.hasNext()) {
                objectName = (ObjectName)iterator2.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Stopping: " + objectName));
                }
                objectName = new ObjectName("WebSphere:type=ApplicationManager,node=" + objectName.getKeyProperty("node") + ",process=" + objectName.getKeyProperty("process") + ",*");
                try {
                    iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
                    if (iterator.hasNext()) {
                        objectName = (ObjectName)iterator.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Stopping app: " + string + " using " + objectName));
                        }
                        AdminServiceFactory.getAdminService().invoke(objectName, "stopApplication", new Object[]{string}, new String[]{(class$java$lang$String == null ? AppManagementImpl.class$("java.lang.String") : class$java$lang$String).getName()});
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Stopped app: " + string + " using " + objectName));
                        }
                        object = ConfigRepoHelper.getTargetString(objectName, object);
                        continue;
                    }
                    Tr.warning((TraceComponent)tc, (String)("No MBean found for: " + objectName));
                }
                catch (Throwable throwable) {
                    Tr.warning((TraceComponent)tc, (String)("Unable to stop: " + string + " using: " + objectName));
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl.stopApplication", (String)"635", (Object)this);
                }
            }
            iterator = object;
            return iterator;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl.stopApplication", (String)"643", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception thrown in stopApplication: " + throwable));
            }
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, "");
        }
        finally {
            if (subject != null) {
                SecurityHelper.popInvocationSubject(subject);
            }
        }
    }

    public void installStandaloneRAR(String string, Hashtable hashtable, String string2) throws AdminException {
    }

    public Vector compareSecurityPolicy(String string, Hashtable hashtable, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"compareSecurityPolicy");
        }
        Vector<String> vector = new Vector<String>();
        WorkSpace workSpace = null;
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        if (string != null && !string.trim().equals("")) {
            try {
                Object object;
                workSpace = ConfigRepoHelper.getWorkSpace(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("workspace: " + workSpace));
                }
                RepositoryContext repositoryContext = null;
                Object[] objectArray = AppUtils.getContextArray("cells", null, workSpace);
                if (objectArray != null) {
                    object = (String)hashtable.get("cell.name");
                    repositoryContext = object != null ? AppUtils.getContextFromArray(objectArray, (String)object, null, true) : (RepositoryContext)objectArray[0];
                }
                if (objectArray == null || repositoryContext == null) {
                    Tr.warning((TraceComponent)tc, (String)"ADMA0070W");
                    vector.addElement(AppUtils.getMessage(resourceBundle, "ADMA0070W"));
                    return vector;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("context found: " + repositoryContext));
                }
                if (repositoryContext.isAvailable("filter.policy")) {
                    repositoryContext.extract("filter.policy", false);
                    object = repositoryContext.getInputStream("filter.policy");
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object);
                    String string3 = Security.getProperty("policy.expandProperties");
                    boolean bl = false;
                    if (string3 != null) {
                        bl = string3.equalsIgnoreCase("true");
                    }
                    FilterPolicyParser filterPolicyParser = new FilterPolicyParser((Reader)inputStreamReader, bl);
                    filterPolicyParser.parse();
                    ArrayList arrayList = filterPolicyParser.getFilterPermissions();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Permissions to be filtered: " + arrayList));
                    }
                    ((InputStream)object).close();
                    byte[] byArray = string.getBytes();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    InputStreamReader inputStreamReader2 = new InputStreamReader(byteArrayInputStream);
                    ApplicationPolicyParser applicationPolicyParser = new ApplicationPolicyParser((Reader)inputStreamReader2, bl);
                    applicationPolicyParser.parse();
                    PolicyTemplate policyTemplate = applicationPolicyParser.getPolicyTemplate();
                    String[] stringArray = policyTemplate.getSymbols();
                    for (int i = 0; i < stringArray.length; ++i) {
                        ArrayList arrayList2 = policyTemplate.get(stringArray[i]);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Permissions for symbol " + stringArray[i] + ": " + arrayList2));
                        }
                        Iterator iterator = arrayList2.iterator();
                        while (iterator.hasNext()) {
                            boolean bl2 = true;
                            Permission permission = (Permission)iterator.next();
                            String string4 = permission.toString();
                            if (!(string4.startsWith("(java") || string4.startsWith("(javax") || string4.startsWith("(unresolved java") || string4.startsWith("(unresolved javax"))) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Custom permission found: " + permission));
                                }
                                vector3.addElement(string4);
                                continue;
                            }
                            Iterator iterator2 = arrayList.iterator();
                            while (iterator2.hasNext() && bl2) {
                                Permission permission2 = (Permission)iterator2.next();
                                if (!permission2.implies(permission)) continue;
                                bl2 = false;
                            }
                            if (bl2) continue;
                            vector2.addElement(string4);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                vector.addElement(AppUtils.getMessage(resourceBundle, "ADMA0071W", new Object[]{throwable.toString()}));
                Tr.warning((TraceComponent)tc, (String)"ADMA0071W", (Object)throwable);
            }
        }
        if (workSpace != null && string2 == null) {
            try {
                ConfigRepoHelper.removeWorkSpace(false, workSpace);
            }
            catch (Throwable throwable) {
                Tr.warning((TraceComponent)tc, (String)"ADMA0077W", (Object)throwable);
                throwable.printStackTrace();
            }
        }
        if (!vector2.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("policy file contains filter permissions: " + vector2));
            }
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0072E"));
        }
        if (!vector3.isEmpty()) {
            vector.addElement(AppUtils.getMessage(resourceBundle, "ADMA0073W", new Object[]{vector3}));
            Tr.warning((TraceComponent)tc, (String)"ADMA0073W", vector3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"compareSecurityPolicy");
        }
        return vector;
    }

    private boolean isReadOnlyMode() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        System.out.println(this.readOnlyPath + ", " + this.readOnly + ", " + this.readOnlyTimeStamp);
        if (this.readOnlyPath == null) {
            URL uRL = classLoader.getResource(PROPERTIES_PATH);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("url: " + uRL));
            }
            if (uRL == null) {
                this.readOnlyTimeStamp = 0L;
                this.readOnly = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"url not found");
                }
            } else {
                this.readOnlyPath = uRL.getFile();
                try {
                    this.readOnlyPath = URLDecoder.decode(this.readOnlyPath, "UTF-8");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Decoded url: " + this.readOnlyPath));
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("exception in decoding url: " + unsupportedEncodingException));
                    }
                    FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.websphere.management.application.AppManagementBaseFactory", (String)"1153");
                }
                File file = new File(this.readOnlyPath);
                this.readOnly = AppManagementImpl.getReadOnlyFlag(file);
                this.readOnlyTimeStamp = file.lastModified();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(this.readOnlyPath + ", " + this.readOnly + ", " + this.readOnlyTimeStamp));
                }
            }
        } else {
            File file = new File(this.readOnlyPath);
            if (!file.exists()) {
                URL uRL;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("File not found: " + this.readOnlyPath + ", so look again"));
                }
                if ((uRL = classLoader.getResource(PROPERTIES_PATH)) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"file not in classpath");
                    }
                    this.readOnlyTimeStamp = 0L;
                    this.readOnly = true;
                } else {
                    this.readOnlyPath = uRL.getFile();
                    try {
                        this.readOnlyPath = URLDecoder.decode(this.readOnlyPath, "UTF-8");
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Decoded url: " + this.readOnlyPath));
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("exception in decoding url: " + unsupportedEncodingException));
                        }
                        FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.websphere.management.application.AppManagementBaseFactory", (String)"1153");
                    }
                    File file2 = new File(this.readOnlyPath);
                    this.readOnly = AppManagementImpl.getReadOnlyFlag(file2);
                    this.readOnlyTimeStamp = file2.lastModified();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("new: " + this.readOnlyPath + ", " + this.readOnly + ", " + this.readOnlyTimeStamp));
                    }
                }
            } else if (file.lastModified() == this.readOnlyTimeStamp) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("lock not changed: " + this.readOnly));
                }
            } else {
                this.readOnly = AppManagementImpl.getReadOnlyFlag(file);
                this.readOnlyTimeStamp = file.lastModified();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("timestamp changed: " + this.readOnly + ", " + this.readOnlyTimeStamp));
                }
            }
        }
        return this.readOnly;
    }

    private static boolean getReadOnlyFlag(final File file) {
        boolean bl;
        Properties properties = null;
        try {
            properties = (Properties)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object run() {
                    Properties properties;
                    Properties properties2 = new Properties();
                    FileInputStream fileInputStream = null;
                    try {
                        try {
                            fileInputStream = new FileInputStream(file);
                            if (fileInputStream != null) {
                                properties2.load(fileInputStream);
                            }
                            properties = properties2;
                            Object var6_5 = null;
                            if (fileInputStream == null) return properties;
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.management.application.AppManagementBaseFactory", (String)"154");
                            Object var4_11 = null;
                            Object var6_6 = null;
                            if (fileInputStream == null) return var4_11;
                            try {
                                ((InputStream)fileInputStream).close();
                                return var4_11;
                            }
                            catch (IOException iOException) {
                                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.websphere.management.application.AppManagementBaseFactory", (String)"1194");
                            }
                            return var4_11;
                        }
                    }
                    catch (Throwable throwable2) {
                        Object var6_7 = null;
                        if (fileInputStream == null) throw throwable2;
                        try {}
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.websphere.management.application.AppManagementBaseFactory", (String)"1194");
                            throw throwable2;
                        }
                        ((InputStream)fileInputStream).close();
                        throw throwable2;
                    }
                    try {}
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.websphere.management.application.AppManagementBaseFactory", (String)"1194");
                        return properties;
                    }
                    ((InputStream)fileInputStream).close();
                    return properties;
                }
            });
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.management.application.AppManagementBaseFactory", (String)"151");
        }
        if (properties == null) {
            bl = true;
        } else {
            String string = properties.getProperty(VERSION_KEY);
            if (VERSION_VALUE.equals(string)) {
                bl = false;
            } else {
                bl = true;
                Tr.audit((TraceComponent)tc, (String)"ADMA0096I");
            }
        }
        if (bl) {
            Tr.audit((TraceComponent)tc, (String)"ADMA0097I");
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        seqNum = 0L;
    }
}

