/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.classloader.ClassloaderFactory;
import com.ibm.websphere.models.config.classloader.ClassloaderPackage;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.runtime.component.VariableMapImpl;
import com.ibm.ws.runtime.service.RepositoryImpl;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.MBeanException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public class AppUtils {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$application$AppUtils == null ? (class$com$ibm$ws$management$application$AppUtils = AppUtils.class$("com.ibm.ws.management.application.AppUtils")) : class$com$ibm$ws$management$application$AppUtils), null, (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static ClassloaderFactory classloaderFactory;
    static /* synthetic */ Class class$com$ibm$ws$management$application$AppUtils;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static void printEx(Throwable throwable) {
        AppUtils.printEx(throwable, true);
    }

    private static ClassloaderFactory getClassloaderFactory() {
        if (classloaderFactory == null) {
            ClassloaderPackage classloaderPackage = (ClassloaderPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/classloader.xmi");
            classloaderFactory = classloaderPackage.getClassloaderFactory();
        }
        return classloaderFactory;
    }

    public static void printEx(Throwable throwable, boolean bl) {
        if (throwable instanceof AdminException && ((AdminException)((Object)throwable)).getCause() != null) {
            AppUtils.printEx(((AdminException)((Object)throwable)).getCause(), bl);
        } else if (throwable instanceof MBeanException && ((MBeanException)throwable).getTargetException() != null) {
            AppUtils.printEx(((MBeanException)throwable).getTargetException(), bl);
        } else if (throwable instanceof AppDeploymentException && ((AppDeploymentException)throwable).getEmbeddedEx() != null) {
            AppUtils.printEx(((AppDeploymentException)throwable).getEmbeddedEx(), bl);
        } else {
            AppUtils.dbg(tc, "Exception: " + throwable);
            if (bl) {
                throwable.printStackTrace();
            }
        }
    }

    public static ResourceBundle getBundle(String string, Locale locale) {
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = Locale.getDefault();
        }
        try {
            return ResourceBundle.getBundle(string, locale2);
        }
        catch (MissingResourceException missingResourceException) {
            FFDCFilter.processException((Throwable)missingResourceException, (String)"com.ibm.ws.management.application.AppUtils.getBundle", (String)"90");
            AppUtils.dbg(tc, "Error loading class: " + string + ", locale " + locale2 + ", " + missingResourceException);
            return null;
        }
    }

    public static ResourceBundle getBundle(Hashtable hashtable) {
        Locale locale = null;
        if (hashtable != null) {
            locale = (Locale)hashtable.get("app.client.locale");
        }
        ResourceBundle resourceBundle = AppUtils.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", locale);
        return resourceBundle;
    }

    public static String getMessage(ResourceBundle resourceBundle, String string) {
        if (resourceBundle == null) {
            return string;
        }
        try {
            String string2 = resourceBundle.getString(string);
            if (string2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Translation key not found: " + string));
                }
                return string;
            }
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            FFDCFilter.processException((Throwable)missingResourceException, (String)"com.ibm.ws.management.application.AppUtils.getMessage", (String)"114");
            return string;
        }
    }

    public static String getMessage(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        String string2 = AppUtils.getMessage(resourceBundle, string);
        if (objectArray == null) {
            return string2;
        }
        return MessageFormat.format(string2, objectArray);
    }

    public static void dbg(String string) {
        System.out.println(string);
    }

    public static void dbg(TraceComponent traceComponent, String string, Object object) {
        System.out.println(string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)traceComponent, (String)string, (Object)object);
        }
    }

    public static void dbg(TraceComponent traceComponent, String string) {
        System.out.println(string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)traceComponent, (String)string);
        }
    }

    public static RepositoryContextType getContextType(String string) throws Exception {
        return RepositoryMetaDataFactory.getRepositoryMetaData().getContextType(string);
    }

    public static RepositoryContext getContextFromArray(Object[] objectArray, String string, String string2, boolean bl) throws Exception {
        RepositoryContext repositoryContext = null;
        for (int i = 0; i < objectArray.length; ++i) {
            RepositoryContext repositoryContext2 = (RepositoryContext)objectArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("aaa: " + repositoryContext2.getName()));
            }
            if (!repositoryContext2.getName().equals(string)) continue;
            if (string2 != null) {
                if (!repositoryContext2.getParent().getName().equals(string2)) continue;
                return repositoryContext2;
            }
            if (bl) {
                return repositoryContext2;
            }
            if (repositoryContext == null) {
                repositoryContext = repositoryContext2;
                continue;
            }
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5023E", new Object[]{repositoryContext.getName(), repositoryContext.getParent().getName(), repositoryContext2.getParent().getName(), repositoryContext2.getParent().getType().getName()}));
        }
        return repositoryContext;
    }

    public static Object[] getContextArray(String string, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        if (string.equals("cells")) {
            return workSpace.findContext(AppUtils.getContextType("cells")).toArray();
        }
        return repositoryContext.findContext(AppUtils.getContextType(string)).toArray();
    }

    public static RepositoryContext findContext(String string, String string2, String string3, RepositoryContext repositoryContext, WorkSpace workSpace, boolean bl) throws Exception {
        Object[] objectArray = AppUtils.getContextArray(string, repositoryContext, workSpace);
        if (objectArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ar is null: type: " + string));
            }
            return null;
        }
        return AppUtils.getContextFromArray(objectArray, string2, string3, bl);
    }

    public static RepositoryContext findAppContextFromConfig(String string, WorkSpace workSpace, Hashtable hashtable) throws Exception {
        Object[] objectArray;
        RepositoryContext repositoryContext;
        String string2;
        String string3 = AppUtils.getAppBinDirName(hashtable, string);
        String string4 = string2 = hashtable == null ? null : (String)hashtable.get("cell.name");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("findAppContextFromConfig:" + string + ", " + string2 + ", " + string3));
        }
        if (string2 != null) {
            RepositoryContext repositoryContext2 = AppUtils.findContext("cells", string2, null, null, workSpace, false);
            if (repositoryContext2 == null) {
                throw new AdminException(null, AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5047E", new Object[]{string2}));
            }
            return AppUtils.findContext("deployments", string, string3, repositoryContext2, workSpace, false);
        }
        if (string3 != null && (repositoryContext = AppUtils.getContextFromArray(objectArray = workSpace.findContext(AppUtils.getContextType("applications")).toArray(), string3, null, false)) == null) {
            return null;
        }
        objectArray = workSpace.findContext(AppUtils.getContextType("deployments")).toArray();
        return AppUtils.getContextFromArray(objectArray, string, string3, false);
    }

    public static boolean isCluster(RepositoryContext repositoryContext) {
        if (repositoryContext == null) {
            return false;
        }
        return repositoryContext.getType().getName().equals("clusters");
    }

    public static RepositoryContext getClusterFromMember(RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        Object[] objectArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getClusterFromMember: " + repositoryContext.getName()));
        }
        if ((objectArray = AppUtils.getContextArray("clusters", repositoryContext.getParent().getParent(), workSpace)) == null || objectArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getClusterFromMember:none");
            }
            return null;
        }
        URI uRI = URI.createURI((String)"server.xml");
        Resource resource = repositoryContext.getResourceSet().createResource(uRI);
        HashMap hashMap = new HashMap();
        resource.load(hashMap);
        Server server = (Server)resource.getContents().get(0);
        String string = server.getClusterName();
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getClusterFromMember:null");
            }
            return null;
        }
        RepositoryContext repositoryContext2 = AppUtils.getContextFromArray(objectArray, string, null, false);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("For server: " + repositoryContext.getName() + ", clusterName: " + string + ", clContext: " + repositoryContext2));
        }
        if (repositoryContext2 == null) {
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5029E", new Object[]{repositoryContext.getName(), string}));
        }
        return repositoryContext2;
    }

    public static boolean isServer(RepositoryContext repositoryContext) {
        if (repositoryContext == null) {
            return false;
        }
        return repositoryContext.getType().getName().equals("servers");
    }

    public static String getAppDir(String string) {
        String string2 = string;
        string2 = string2.replace(' ', '_');
        string2 = string2.replace('.', '_');
        return string2;
    }

    public static String getAppDir(Scheduler scheduler) {
        return AppUtils.getAppDir(scheduler.getAppName());
    }

    public static String getAppTempDir(Scheduler scheduler) {
        String string = (String)scheduler.getAppManagement().getGlobalSettings().get("Temp extraction dir for multiserver");
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        string = string + AppUtils.getAppDir("app." + scheduler.getID());
        return string;
    }

    public static String getAppTempExtractDir(Scheduler scheduler) throws AdminException {
        return AppUtils.getAppTempDir(scheduler) + File.separator + "ear";
    }

    public static String getAppTempDeployDir(Scheduler scheduler) throws AdminException {
        return AppUtils.getAppTempDir(scheduler) + File.separator + "dpl";
    }

    public static String getAppDeployFileName(String string) {
        return "dpl_" + AppUtils.getAppDir(string) + ".ear";
    }

    public static String getPreAppDeployFileName(String string) {
        return "predpl_" + AppUtils.getAppDir(string) + ".ear";
    }

    public static String getAppTempExportDir(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get("Temp extraction dir for multiserver");
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        string2 = string2 + "tmp." + System.currentTimeMillis();
        return string2;
    }

    public static String getAppInstallDir(Scheduler scheduler) throws Exception {
        String string = (String)scheduler.getProperties().get("installed.ear.destination");
        if (AppUtils.isEmpty(string)) {
            string = "$(APP_INSTALL_ROOT)/" + scheduler.getCellContext().getName() + "/";
        } else if (!(string = string.trim().replace(File.separatorChar, '/')).endsWith("/")) {
            string = string + "/";
        }
        string = string + AppUtils.getAppBinDirName(scheduler);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Install Dir: " + string));
        }
        return string;
    }

    public static String getAppBinDirName(Scheduler scheduler) {
        return AppUtils.getAppBinDirName(scheduler.getProperties(), scheduler.getAppName());
    }

    public static String getAppBinDirName(Hashtable hashtable, String string) {
        String string2 = null;
        if (hashtable != null) {
            string2 = (String)hashtable.get("appbinary.name");
        }
        if (string2 != null) {
            return string2;
        }
        return string + ".ear";
    }

    public static String convert2AbsPath(String string, VariableMap variableMap) throws Exception {
        if (string.indexOf("$(") == -1 && string.indexOf("${") == -1) {
            return string;
        }
        if (variableMap == null) {
            return string;
        }
        String string2 = variableMap.expand(string);
        string2 = string2.replace('/', File.separatorChar);
        string2 = string2.replace('\\', File.separatorChar);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("convert2AbsPath: " + string + " = " + string2));
        }
        return string2;
    }

    public static VariableMap createVarMap(RepositoryContext repositoryContext, String string) throws Exception {
        if (AppManagementImpl.isLocalMode()) {
            String string2 = repositoryContext.getParent().getName();
            List list = repositoryContext.getParent().getChildren();
            String string3 = null;
            if (list.size() > 0) {
                string3 = ((RepositoryContext)list.get(0)).getName();
            }
            return AppUtils.createVarMap(string, string2, string3, null);
        }
        return AppUtils.createVarMap(string, AdminServiceFactory.getAdminService().getCellName(), AdminServiceFactory.getAdminService().getNodeName(), AdminServiceFactory.getAdminService().getProcessName());
    }

    public static VariableMap createVarMap(String string, String string2, String string3, String string4) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createVarMap");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ConfigRoot: " + string + ", " + "CellName: " + string2 + ", " + "NodeName: " + string3 + ", " + "ProcName: " + string4));
        }
        BeanContextServicesSupport beanContextServicesSupport = new BeanContextServicesSupport();
        RepositoryImpl repositoryImpl = new RepositoryImpl("ws-server", string, string2, string3, string4);
        beanContextServicesSupport.addService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = AppUtils.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository, (BeanContextServiceProvider)repositoryImpl);
        VariableMapImpl variableMapImpl = new VariableMapImpl();
        beanContextServicesSupport.add(variableMapImpl);
        variableMapImpl.initialize(null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createVarMap: " + variableMapImpl));
        }
        return variableMapImpl;
    }

    public static synchronized void deleteDirTree(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteDirTree");
        }
        AppUtils._deleteDirTree(new File(string).getCanonicalFile(), true);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteDirTree");
        }
    }

    public static synchronized void deleteDirTree(String string, boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteDirTree");
        }
        AppUtils._deleteDirTree(new File(string).getCanonicalFile(), bl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteDirTree");
        }
    }

    public static synchronized void deleteDirTree(File file) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteDirTree");
        }
        AppUtils._deleteDirTree(file.getCanonicalFile(), true);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteDirTree");
        }
    }

    public static synchronized void deleteDirTree(File file, boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteDirTree");
        }
        AppUtils._deleteDirTree(file.getCanonicalFile(), bl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteDirTree");
        }
    }

    private static synchronized void _deleteDirTree(File file, boolean bl) throws IOException {
        if (!file.exists()) {
            Tr.event((TraceComponent)tc, (String)"directory does not exist");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"deleteDirTree");
            }
            return;
        }
        if (!(bl || System.getProperty("os.name").startsWith("Windows") || file.getAbsolutePath().equals(file.getCanonicalPath()))) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("file/dir a symlink: " + file));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"deleteDirTree");
            }
            return;
        }
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file.getPath(), stringArray[i]);
                AppUtils._deleteDirTree(file2, bl);
            }
        }
        if (!file.delete()) {
            Tr.warning((TraceComponent)tc, (String)"ADMA0078W", (Object)file);
        }
    }

    public static void xcopy(RepositoryContext repositoryContext, String string, Vector vector) throws Exception {
        String string2;
        String string3;
        int n;
        File file = new File(string);
        String string4 = file.getAbsolutePath();
        file.mkdirs();
        repositoryContext.extract(false);
        String string5 = repositoryContext.getPath();
        List list = new ArrayList(repositoryContext.getFiles());
        for (n = 0; n < list.size(); ++n) {
            string3 = (String)list.get(n);
            if (vector.contains(string3)) continue;
            if (File.separatorChar != '/') {
                string3 = string3.replace('/', File.separatorChar);
            }
            string2 = string5 + File.separator + string3;
            AppUtils.copyFile(new File(string2), string4 + File.separator + string3);
        }
        list = repositoryContext.getChildren();
        for (n = 0; n < list.size(); ++n) {
            string3 = (RepositoryContext)list.get(n);
            string2 = string3.getPath();
            AppUtils.xcopy((RepositoryContext)string3, string + File.separator + string3.getName(), vector);
        }
    }

    public static void copyFile(File file, String string) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Copying..: " + file.getAbsolutePath() + " to " + string));
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        AppUtils.copyFile(fileInputStream, string);
        fileInputStream.close();
    }

    public static void copyFile(InputStream inputStream, String string) throws Exception {
        File file = new File(string);
        file.getParentFile().mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[4096];
        int n = inputStream.read(byArray);
        while (n != -1) {
            fileOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public static String getInstallDirFromBinariesURL(ApplicationDeployment applicationDeployment) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInstallDirFromBinariesURL " + applicationDeployment));
        }
        String string = applicationDeployment.getBinariesURL();
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(92);
        if (n2 > n) {
            n = n2;
        }
        if (n == -1) {
            return string;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInstallDirFromBinariesURL " + string));
        }
        return string.substring(0, n);
    }

    public static String getBinaryContextFromBinariesURL(ApplicationDeployment applicationDeployment) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getBinaryContextFromBinariesURL " + applicationDeployment));
        }
        String string = applicationDeployment.getBinariesURL();
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(92);
        if (n2 > n) {
            n = n2;
        }
        if (n == -1) {
            return string;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getBinaryContextFromBinariesURL " + string));
        }
        return string.substring(n + 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

