/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.Subject;
import com.ibm.ejs.models.base.bindings.commonbnd.AbstractAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBBindingsHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.init.ArchiveInit;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appcfg.AppcfgFactory;
import com.ibm.websphere.models.config.appcfg.AppcfgPackage;
import com.ibm.websphere.models.config.appcfg.impl.AppcfgPackageImpl;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentFactory;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentPackage;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppAssociation;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.client.AppDeploymentProfile;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.ListModules;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public class EditApplication {
    public static final String TableDDL = "META-INF/Table.ddl";
    public static final String BackendDir = "META-INF/backends/";
    private static AppdeploymentFactory appFactory = null;
    private static AppcfgFactory appCfgFactory = null;
    private String appName;
    private Hashtable prefs;
    private String uniqueModuleURI;
    private String workspaceID;
    private AppManagement appM;
    boolean isApp = false;
    ResourceBundle resBundle = null;
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$application$EditApplication == null ? (class$com$ibm$ws$management$application$EditApplication = EditApplication.class$("com.ibm.ws.management.application.EditApplication")) : class$com$ibm$ws$management$application$EditApplication), null, (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    static /* synthetic */ Class class$com$ibm$ws$management$application$EditApplication;
    static /* synthetic */ Class class$com$ibm$ws$sm$workspace$RepositoryContext;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$management$AttributeList;
    static /* synthetic */ Class class$java$util$Properties;

    private static AppdeploymentFactory getAppFactory() {
        if (appFactory != null) {
            return appFactory;
        }
        ArchiveInit.init();
        CommonarchiveFactoryImpl.getActiveFactory();
        ConfigInit.init();
        AppdeploymentPackageImpl.init();
        AppdeploymentPackage appdeploymentPackage = (AppdeploymentPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appdeployment.xmi");
        appFactory = appdeploymentPackage.getAppdeploymentFactory();
        return appFactory;
    }

    private static AppcfgFactory getAppcfgFactory() {
        if (appCfgFactory != null) {
            return appCfgFactory;
        }
        ArchiveInit.init();
        CommonarchiveFactoryImpl.getActiveFactory();
        ConfigInit.init();
        AppcfgPackageImpl.init();
        AppcfgPackage appcfgPackage = (AppcfgPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appcfg.xmi");
        appCfgFactory = appcfgPackage.getAppcfgFactory();
        return appCfgFactory;
    }

    public EditApplication(String string, Hashtable hashtable, String string2, String string3, AppManagement appManagement) {
        this.appName = string;
        this.prefs = hashtable;
        this.uniqueModuleURI = string2;
        this.workspaceID = string3;
        this.appM = appManagement;
        this.isApp = this.uniqueModuleURI == null;
        this.resBundle = AppUtils.getBundle(this.prefs);
    }

    private void doFinally(WorkSpace workSpace, EARFile eARFile, boolean bl) {
        EditApplication.doFinally(workSpace, this.workspaceID, eARFile, bl);
    }

    public static void doFinally(WorkSpace workSpace, String string, EARFile eARFile, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("doFinally: " + bl));
        }
        if (eARFile != null) {
            eARFile.close();
        }
        if (workSpace != null && string == null) {
            try {
                ConfigRepoHelper.removeWorkSpace(bl, workSpace);
            }
            catch (Throwable throwable) {
                Tr.warning((TraceComponent)tc, (String)"ADMA0077W", (Object)throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doFinally");
        }
    }

    public Vector getApplicationInfo() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getApplicationInfo:" + this.appName + ", " + this.uniqueModuleURI));
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        Vector<AppDeploymentTask> vector = new Vector<AppDeploymentTask>();
        WorkSpace workSpace = null;
        EARFile eARFile = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            AppdeploymentPackageImpl.init();
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.appName, workSpace, this.prefs);
            if (repositoryContext == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
            }
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
            eARFile = applicationDeployment.isUseMetadataFromBinaries() ? ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, this.resBundle, null) : ConfigRepoHelper.getEarFileFromDeployment(workSpace, repositoryContext);
            if (this.uniqueModuleURI == null) {
                this.prefs.put("EditAppOnly", "");
            } else {
                this.prefs.put("EditModuleOnly", this.uniqueModuleURI);
            }
            this.prefs.put("AppDeplObj", applicationDeployment);
            AppDeploymentController appDeploymentController = AppManagementFactory.readPartialArchive(eARFile, this.prefs);
            Hashtable hashtable = appDeploymentController.getAppOptions();
            Hashtable hashtable2 = ConfigRepoHelper.getCNP(this.uniqueModuleURI, applicationDeployment, repositoryContext.getParent().getParent(), workSpace, eARFile);
            hashtable.put("moduleToServer", hashtable2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Created partial controller: " + appDeploymentController));
            }
            AppDeploymentTask appDeploymentTask = appDeploymentController.getFirstTask();
            while (appDeploymentTask != null) {
                vector.add(appDeploymentTask);
                appDeploymentTask = appDeploymentController.getNextTask();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Read tasks from controller: " + vector.size()));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getApplicationInfo");
            }
            Vector<AppDeploymentTask> vector2 = vector;
            this.doFinally(workSpace, eARFile, false);
            return vector2;
        }
        catch (Throwable throwable) {
            try {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.getApplicationInfo", (String)"354", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown in getApplicationInfo: " + throwable));
                }
                if (throwable instanceof AdminException) {
                    throw (AdminException)((Object)throwable);
                }
                throw new AdminException(throwable, "");
            }
            catch (Throwable throwable2) {
                this.doFinally(workSpace, eARFile, false);
                throw throwable2;
            }
        }
    }

    public void setApplicationInfo(Vector vector) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setApplicationInfo: " + this.appName + ", " + this.uniqueModuleURI));
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace workSpace = null;
        EARFile eARFile = null;
        boolean bl = false;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            AppdeploymentPackageImpl.init();
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.appName, workSpace, this.prefs);
            if (repositoryContext == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
            }
            EditSchedulerImpl editSchedulerImpl = new EditSchedulerImpl(repositoryContext, workSpace);
            editSchedulerImpl.run();
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
            this.prefs.put("AppDeplObj", applicationDeployment);
            boolean bl2 = applicationDeployment.isUseMetadataFromBinaries();
            eARFile = bl2 ? ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, this.resBundle, null) : ConfigRepoHelper.getEarFileFromDeployment(workSpace, repositoryContext);
            AppDeploymentController appDeploymentController = AppManagementFactory.writeTasks(eARFile, vector, this.prefs, this.uniqueModuleURI);
            appDeploymentController.close(true, true, false);
            this.saveOptions(workSpace, repositoryContext, appDeploymentController, eARFile);
            String string = (String)this.appM.getGlobalSettings().get("Temp extraction dir for multiserver");
            if (bl2) {
                eARFile.saveNoReopen();
                eARFile.close();
                repositoryContext.getParent().notifyChanged(1, repositoryContext.getParent().getName());
            } else {
                ConfigRepoHelper.saveEarFileToDeployment(eARFile, repositoryContext, string);
            }
            editSchedulerImpl.run();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setApplicationInfo");
            }
            this.doFinally(workSpace, eARFile, !bl);
        }
        catch (Throwable throwable) {
            try {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.setApplicationInfo", (String)"423", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown in setApplicationInfo: " + throwable));
                }
                bl = true;
                if (throwable instanceof AdminException) {
                    throw (AdminException)((Object)throwable);
                }
                throw new AdminException(throwable, "");
            }
            catch (Throwable throwable2) {
                this.doFinally(workSpace, eARFile, !bl);
                throw throwable2;
            }
        }
    }

    private void saveOptions(WorkSpace workSpace, RepositoryContext repositoryContext, AppDeploymentController appDeploymentController, EARFile eARFile) throws Exception {
        Hashtable hashtable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"saveOptions");
        }
        Hashtable hashtable2 = appDeploymentController.getAppOptions();
        Resource resource = ConfigRepoHelper.getAppDeploymentResource(repositoryContext);
        ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(resource);
        if (this.uniqueModuleURI == null) {
            AppDeploymentProfile.hash2Files(AppDeploymentProfile.OP_EDIT, hashtable2, applicationDeployment, null);
        }
        if ((hashtable = (Hashtable)hashtable2.get("moduleToServer")) != null) {
            this.moveModules(hashtable, (Deployment)resource.getContents().get(0), repositoryContext, workSpace, eARFile);
        }
        HashMap hashMap = new HashMap();
        resource.save(hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"saveOptions");
        }
    }

    public void moveModules(Hashtable hashtable, Deployment deployment, RepositoryContext repositoryContext, WorkSpace workSpace, EARFile eARFile) throws Exception {
        Object object;
        Object object2;
        Vector[] vectorArray;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"moveModule");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("New cnp: " + hashtable));
        }
        ApplicationDeployment applicationDeployment = (ApplicationDeployment)deployment.getDeployedObject();
        Vector vector = ConfigRepoHelper.getServersForAppDeployment(applicationDeployment, null, repositoryContext.getParent().getParent(), workSpace, false);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ModuleDeployment moduleDeployment;
            object3 = (String)enumeration.nextElement();
            vectorArray = util.getModuleURIFromUniqueName((String)object3);
            object2 = util.getDDURIFromUniqueName((String)object3);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("mURI: " + (String)vectorArray + ", dURI: " + (String)object2));
            }
            if ((moduleDeployment = ConfigRepoHelper.getMDFromModuleRef(applicationDeployment, (ModuleRef)(object = ConfigRepoHelper.getModuleRef(eARFile, (String)vectorArray, (String)object2)))) == null) {
                Tr.warning((TraceComponent)tc, (String)"ADMA0030E", (Object)object3);
                continue;
            }
            AppAssociation.populateDeployTargets(deployment, moduleDeployment, (String)hashtable.get(object3), (String)object3, repositoryContext.getParent().getParent(), workSpace, EditApplication.getAppcfgFactory(), EditApplication.getAppFactory());
        }
        object3 = ConfigRepoHelper.getServersForAppDeployment(applicationDeployment, null, repositoryContext.getParent().getParent(), workSpace, false);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Old servers: " + vector));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("New servers: " + object3));
        }
        vectorArray = this.getAddedRemoved(vector, (Vector)object3);
        object2 = vectorArray[0];
        object = vectorArray[1];
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Added to: " + object2));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Removed from: " + object));
        }
        if (((Vector)object).size() > 0) {
            ConfigRepoHelper.updateServerIndexDocs(repositoryContext, workSpace, (Vector)object, false, this.resBundle);
        }
        if (((Vector)object2).size() > 0) {
            ConfigRepoHelper.updateServerIndexDocs(repositoryContext, workSpace, (Vector)object2, true, this.resBundle);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"moveModule");
        }
    }

    private Vector[] getAddedRemoved(Vector vector, Vector vector2) {
        int n;
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector[] vectorArray = new Vector[]{vector3, vector4};
        for (n = 0; n < vector.size(); ++n) {
            if (vector2.contains(vector.elementAt(n))) continue;
            vector4.addElement(vector.elementAt(n));
        }
        for (n = 0; n < vector2.size(); ++n) {
            if (vector.contains(vector2.elementAt(n))) continue;
            vector3.addElement(vector2.elementAt(n));
        }
        return vectorArray;
    }

    /*
     * Loose catch block
     */
    public void exportApplication(String string) throws AdminException {
        block22: {
            String string2;
            EARFile eARFile;
            WorkSpace workSpace;
            block20: {
                block19: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)("exportApplication: " + string));
                    }
                    if (this.appName == null) {
                        throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
                    }
                    workSpace = null;
                    eARFile = null;
                    string2 = null;
                    workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                    RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.appName, workSpace, this.prefs);
                    if (repositoryContext == null) {
                        throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
                    }
                    eARFile = ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, this.resBundle, (String)this.appM.getGlobalSettings().get("Config Root for variable map"));
                    File file = new File(string);
                    if (file.getParentFile() != null) {
                        file.getParentFile().mkdirs();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Export path: " + string));
                    }
                    ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
                    boolean bl = applicationDeployment.isUseMetadataFromBinaries();
                    AppUtils.dbg(tc, "useMetadataFromBinaries = " + bl);
                    if (bl) {
                        eARFile.saveAs(string);
                        break block19;
                    }
                    string2 = AppUtils.getAppTempExportDir(this.appName, this.appM.getGlobalSettings());
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Temp export at: " + string2));
                    }
                    EarUtils.extractEar(eARFile, string2, true, 126);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Ear file extracted to: " + string2));
                    }
                    eARFile.close();
                    Vector<String> vector = new Vector<String>();
                    vector.add("deployment.xml");
                    AppUtils.xcopy(repositoryContext, string2, vector);
                    eARFile = AppInstallHelper.getEarFile(string2, false, this.resBundle);
                    eARFile.saveAs(string);
                }
                Object var11_11 = null;
                this.doFinally(workSpace, eARFile, false);
                try {
                    AppUtils.deleteDirTree(string2);
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block20;
                    Tr.debug((TraceComponent)tc, (String)("Error deleting temp dir " + string2 + " after export: " + throwable));
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("exportApplication: " + string));
            }
            break block22;
            {
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.exportApplication", (String)"538", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception thrown in exportApplication: " + throwable));
                    }
                    if (throwable instanceof AdminException) {
                        throw (AdminException)((Object)throwable);
                    }
                    throw new AdminException(throwable, "");
                }
            }
            catch (Throwable throwable) {
                block21: {
                    Object var11_12 = null;
                    this.doFinally(workSpace, eARFile, false);
                    try {
                        AppUtils.deleteDirTree(string2);
                    }
                    catch (Throwable throwable2) {
                        if (!tc.isDebugEnabled()) break block21;
                        Tr.debug((TraceComponent)tc, (String)("Error deleting temp dir " + string2 + " after export: " + throwable2));
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("exportApplication: " + string));
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractDDL(String string, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("extractDDL: " + string2));
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace workSpace = null;
        EARFile eARFile = null;
        try {
            try {
                String string3;
                String string4;
                Object object;
                workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.appName, workSpace, this.prefs);
                if (repositoryContext == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
                }
                eARFile = ConfigRepoHelper.getEarFileFromDeployment(workSpace, repositoryContext);
                if (eARFile == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0019E", new Object[]{eARFile}));
                }
                HashMap<String, String> hashMap = new HashMap<String, String>(20);
                List list = eARFile.getEJBJarFiles();
                for (int i = 0; i < list.size(); ++i) {
                    object = (EJBJarFile)list.get(i);
                    EJBJar eJBJar = object.getDeploymentDescriptor();
                    string4 = EJBBindingsHelper.getEJBJarBinding((EJBJar)eJBJar).getCurrentBackendId();
                    string3 = object.getName();
                    hashMap.put(string3, string4);
                }
                eARFile.close();
                eARFile = ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, this.resBundle, (String)this.appM.getGlobalSettings().get("Config Root for variable map"));
                if (eARFile == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0019E", new Object[]{eARFile}));
                }
                File file = new File(string2);
                file.mkdirs();
                object = file.getAbsolutePath();
                list = eARFile.getEJBJarFiles();
                for (int i = 0; i < list.size(); ++i) {
                    Object object2;
                    Object object3;
                    Object object4;
                    string4 = (EJBJarFile)list.get(i);
                    string3 = string4.getName();
                    String string5 = (String)hashMap.get(string3);
                    if (string5 != null) {
                        object4 = BackendDir + string5 + "/Table.ddl";
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("backend Table ddl name for " + string5 + " is " + (String)object4));
                        }
                        if (string4.containsFile((String)object4)) {
                            object3 = string4.getFile((String)object4);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Table ddl for " + string3 + " is " + (String)object4));
                            }
                            object2 = (String)object + File.separator + (string == null ? "" : string) + "_" + string3 + "_" + string5 + "_" + "Table.ddl";
                            InputStream inputStream = object3.getInputStream();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Copying Table.ddl to " + (String)object2));
                            }
                            AppUtils.copyFile(inputStream, (String)object2);
                            inputStream.close();
                        } else {
                            string5 = null;
                            Tr.warning((TraceComponent)tc, (String)"ADMA0095W", (Object)new Object[]{object4, string3});
                        }
                    }
                    if (string5 != null || !string4.containsFile(TableDDL)) continue;
                    object4 = string4.getFile(TableDDL);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Table ddl for " + string4.getName() + " is " + object4));
                    }
                    object3 = (String)object + File.separator + (string == null ? "" : string) + "_" + string4.getName() + "_" + "Table.ddl";
                    object2 = object4.getInputStream();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Copying Table.ddl to " + (String)object3));
                    }
                    AppUtils.copyFile((InputStream)object2, (String)object3);
                    ((InputStream)object2).close();
                }
                Object var19_21 = null;
                this.doFinally(workSpace, eARFile, false);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.exportApplication", (String)"538", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown in extractDDL: " + throwable));
                }
                if (!(throwable instanceof AdminException)) throw new AdminException(throwable, "");
                throw (AdminException)((Object)throwable);
            }
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            this.doFinally(workSpace, eARFile, false);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)("extractDDL: " + string2));
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)("extractDDL: " + string2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void publishWSDL(String string) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("publishWSDL " + string));
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace workSpace = null;
        try {
            try {
                workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.appName, workSpace, this.prefs);
                if (repositoryContext == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
                }
                Class<?> clazz = Class.forName("com.ibm.ws.webservices.deploy.DeployUtils");
                Class[] classArray = new Class[]{class$com$ibm$ws$sm$workspace$RepositoryContext == null ? (class$com$ibm$ws$sm$workspace$RepositoryContext = EditApplication.class$("com.ibm.ws.sm.workspace.RepositoryContext")) : class$com$ibm$ws$sm$workspace$RepositoryContext, class$java$lang$String == null ? (class$java$lang$String = EditApplication.class$("java.lang.String")) : class$java$lang$String, class$javax$management$AttributeList == null ? (class$javax$management$AttributeList = EditApplication.class$("javax.management.AttributeList")) : class$javax$management$AttributeList};
                Method method = clazz.getMethod("publishWSDLFiles", classArray);
                AttributeList attributeList = (AttributeList)this.prefs.get("PREFIXES");
                Object[] objectArray = new Object[]{repositoryContext, string, attributeList};
                try {
                    method.invoke(null, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
                Object var11_11 = null;
                this.doFinally(workSpace, null, false);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.publishWSDL", (String)"708", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown in publishWSDL: " + throwable));
                }
                if (!(throwable instanceof AdminException)) throw new AdminException(throwable, "");
                throw (AdminException)((Object)throwable);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.doFinally(workSpace, null, false);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)("publishWSDL: " + string));
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)("publishWSDL: " + string));
    }

    public static Vector listApplications(Hashtable hashtable, String string) throws AdminException {
        Vector<String> vector;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"listApplications");
        }
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        WorkSpace workSpace = null;
        Vector<String> vector2 = new Vector<String>();
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string);
            String string2 = (String)hashtable.get("cell.name");
            Object[] objectArray = null;
            if (string2 == null) {
                objectArray = AppUtils.getContextArray("cells", null, workSpace);
            } else {
                RepositoryContext repositoryContext = AppUtils.findContext("cells", string2, null, null, workSpace, false);
                objectArray = new RepositoryContext[]{repositoryContext};
            }
            for (int i = 0; i < objectArray.length; ++i) {
                Object[] objectArray2 = AppUtils.getContextArray("deployments", (RepositoryContext)objectArray[i], workSpace);
                if (objectArray2 == null) continue;
                for (int j = 0; j < objectArray2.length; ++j) {
                    vector2.addElement(((RepositoryContext)objectArray2[j]).getName());
                }
            }
            vector = vector2;
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown in listApplications: " + throwable));
                }
                if (throwable instanceof AdminException) {
                    throw (AdminException)((Object)throwable);
                }
                throw new AdminException(throwable, "");
            }
            catch (Throwable throwable2) {
                block12: {
                    Object var11_14 = null;
                    EditApplication.doFinally(workSpace, string, null, false);
                    if (!tc.isEntryEnabled()) break block12;
                    Tr.exit((TraceComponent)tc, (String)"listApplications");
                }
                throw throwable2;
            }
        }
        EditApplication.doFinally(workSpace, string, null, false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"listApplications");
        }
        return vector;
    }

    public AppDeploymentTask listModules() throws AdminException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("listModules: " + this.appName));
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace workSpace = null;
        EARFile eARFile = null;
        ListModules listModules = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.appName, workSpace, this.prefs);
            if (repositoryContext == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
            }
            eARFile = ConfigRepoHelper.getEarFileFromDeployment(workSpace, repositoryContext);
            if (eARFile == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0019E", new Object[]{eARFile}));
            }
            Hashtable hashtable = ConfigRepoHelper.getModRef_vs_Deployment(null, ConfigRepoHelper.getAppDeploymentForApp(repositoryContext), workSpace, eARFile);
            listModules = new ListModules(null);
            Vector<String> vector = new Vector<String>();
            String[] stringArray = listModules.getColumnNames();
            for (int i = 0; i < stringArray.length; ++i) {
                vector.addElement(stringArray[i]);
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (ModuleRef)enumeration.nextElement();
                ModuleDeployment moduleDeployment = (ModuleDeployment)hashtable.get(object);
                String string = null;
                if (object.isEJB()) {
                    string = ((EJBJar)object.getDeploymentDescriptor()).getDisplayName();
                }
                if (object.isWeb()) {
                    string = ((WebApp)object.getDeploymentDescriptor()).getDisplayName();
                }
                if (AppUtils.isEmpty(string)) {
                    string = object.getUri();
                }
                vector.addElement(string);
                String string2 = util.createUniqueModuleName(ConfigRepoHelper.getDDUri(object), object.getModule().getUri());
                vector.addElement(string2);
                vector.addElement(ConfigRepoHelper.getCNP(workSpace, moduleDeployment, repositoryContext.getParent().getParent()));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Data is: " + vector));
            }
            listModules.setTaskData(util.buildTaskData(vector, stringArray.length));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Task is: " + listModules));
            }
            object = listModules;
            Object var14_15 = null;
            this.doFinally(workSpace, eARFile, false);
        }
        catch (Throwable throwable) {
            try {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.exportApplication", (String)"538", (Object)this);
                if (throwable instanceof AdminException) {
                    throw (AdminException)((Object)throwable);
                }
                throw new AdminException(throwable, "");
            }
            catch (Throwable throwable2) {
                block17: {
                    Object var14_16 = null;
                    this.doFinally(workSpace, eARFile, false);
                    if (!tc.isEntryEnabled()) break block17;
                    Tr.exit((TraceComponent)tc, (String)("listModules: " + this.appName));
                }
                throw throwable2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("listModules: " + this.appName));
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateAccessIDs(Boolean bl) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("updateAccessIDs: " + this.appName + "bAll: " + bl));
        }
        if (AppManagementImpl.isLocalMode()) {
            if (!tc.isDebugEnabled()) throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0090E", new Object[]{"updateAccessIDs"}));
            Tr.debug((TraceComponent)tc, (String)"Local mode: no-op");
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0090E", new Object[]{"updateAccessIDs"}));
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace workSpace = null;
        EARFile eARFile = null;
        boolean bl2 = false;
        boolean bl3 = Boolean.TRUE.equals(bl);
        try {
            try {
                Object object;
                RepositoryContext repositoryContext;
                Iterator iterator = AdminServiceFactory.getAdminService().queryNames(new ObjectName("WebSphere:type=SecurityAdmin,process=" + AdminServiceFactory.getAdminService().getProcessName() + ",*"), null).iterator();
                ObjectName objectName = (ObjectName)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("MBean: " + objectName));
                }
                if ((repositoryContext = AppUtils.findAppContextFromConfig(this.appName, workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID), this.prefs)) == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
                }
                ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
                boolean bl4 = applicationDeployment.isUseMetadataFromBinaries();
                eARFile = bl4 ? ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, this.resBundle, (String)this.appM.getGlobalSettings().get("Config Root for variable map")) : ConfigRepoHelper.getEarFileFromDeployment(workSpace, repositoryContext);
                ApplicationBinding applicationBinding = eARFile.getBindings();
                AuthorizationTable authorizationTable = applicationBinding.getAuthorizationTable();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Table: " + authorizationTable));
                }
                if (authorizationTable != null) {
                    object = authorizationTable.getAuthorizations().iterator();
                    while (object.hasNext()) {
                        RoleAssignment roleAssignment = (RoleAssignment)object.next();
                        this.updateID((List)roleAssignment.getUsers(), objectName, true, bl3);
                        this.updateID((List)roleAssignment.getGroups(), objectName, false, bl3);
                    }
                }
                if (bl4) {
                    eARFile.save();
                }
                object = (String)this.appM.getGlobalSettings().get("Temp extraction dir for multiserver");
                ConfigRepoHelper.saveEarFileToDeployment(eARFile, repositoryContext, (String)object);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.updateAccessIDs", (String)"794", (Object)this);
                bl2 = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown in updateAccessIDs: " + throwable));
                }
                if (!(throwable instanceof AdminException)) throw new AdminException(throwable, "");
                throw (AdminException)((Object)throwable);
            }
            Object var16_16 = null;
            this.doFinally(workSpace, eARFile, !bl2);
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            this.doFinally(workSpace, eARFile, !bl2);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)("updateAccessIDs: " + this.appName));
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)("updateAccessIDs: " + this.appName));
    }

    private void updateID(List list, ObjectName objectName, boolean bl, boolean bl2) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Subject subject = (Subject)list.get(i);
            if (!bl2 && subject.getAccessId() != null) continue;
            String string = (String)AdminServiceFactory.getAdminService().invoke(objectName, "getAccessIds", new Object[]{new Boolean(bl), subject.getName(), null}, new String[]{Boolean.TYPE.getName(), (class$java$lang$String == null ? EditApplication.class$("java.lang.String") : class$java$lang$String).getName(), (class$java$util$Properties == null ? EditApplication.class$("java.util.Properties") : class$java$util$Properties).getName()});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("name: " + subject.getName() + " --> id: " + string));
            }
            if (string == null) continue;
            subject.setAccessId(string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteUserAndGroupEntries() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("deleteUserAndGroupEntries: " + this.appName));
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace workSpace = null;
        EARFile eARFile = null;
        boolean bl = false;
        try {
            try {
                Object object;
                Object object2;
                workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.appName, workSpace, this.prefs);
                if (repositoryContext == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
                }
                ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
                boolean bl2 = applicationDeployment.isUseMetadataFromBinaries();
                eARFile = bl2 ? ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, this.resBundle, (String)this.appM.getGlobalSettings().get("Config Root for variable map")) : ConfigRepoHelper.getEarFileFromDeployment(workSpace, repositoryContext);
                ApplicationBinding applicationBinding = eARFile.getBindings();
                AuthorizationTable authorizationTable = applicationBinding.getAuthorizationTable();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Table: " + authorizationTable));
                }
                if (authorizationTable != null) {
                    object2 = authorizationTable.getAuthorizations().iterator();
                    while (object2.hasNext()) {
                        object = (RoleAssignment)object2.next();
                        object.getUsers().clear();
                        object.getGroups().clear();
                        object.getSpecialSubjects().clear();
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Cleared: " + object));
                    }
                }
                object2 = applicationBinding.getRunAsMap();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Map: " + object2));
                }
                if (object2 != null) {
                    object = object2.getRunAsBindings();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Bnd: " + object));
                    }
                    if (object != null) {
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            RunAsBinding runAsBinding = (RunAsBinding)iterator.next();
                            AbstractAuthData abstractAuthData = runAsBinding.getAuthData();
                            if (abstractAuthData == null || !(abstractAuthData instanceof BasicAuthData)) continue;
                            BasicAuthData basicAuthData = (BasicAuthData)abstractAuthData;
                            basicAuthData.setUserId(null);
                            basicAuthData.setPassword(null);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Zap for: " + runAsBinding));
                        }
                    }
                }
                if (bl2) {
                    eARFile.save();
                }
                object = (String)this.appM.getGlobalSettings().get("Temp extraction dir for multiserver");
                ConfigRepoHelper.saveEarFileToDeployment(eARFile, repositoryContext, (String)object);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.deleteUserAndGroupEntries", (String)"794", (Object)this);
                bl = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown in deleteUserAndGroupEntries:" + throwable));
                }
                if (!(throwable instanceof AdminException)) throw new AdminException(throwable, "");
                throw (AdminException)((Object)throwable);
            }
            Object var16_16 = null;
            this.doFinally(workSpace, eARFile, !bl);
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            this.doFinally(workSpace, eARFile, !bl);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)("deleteUserAndGroupEntries: " + this.appName));
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)("deleteUserAndGroupEntries: " + this.appName));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class EditSchedulerImpl
    implements Scheduler {
        private static final String EditTask = "com.ibm.ws.management.application.EditApplication.EditTask";
        WorkSpace ws;
        RepositoryContext appC;
        Locale locale;
        Vector tasks = new Vector();
        int edit_index = 0;
        boolean before = true;

        public EditSchedulerImpl(RepositoryContext repositoryContext, WorkSpace workSpace) {
            this.appC = repositoryContext;
            this.ws = workSpace;
            if (EditApplication.this.prefs != null) {
                this.locale = (Locale)EditApplication.this.prefs.get("app.client.locale");
            }
            if (this.locale == null) {
                this.locale = Locale.getDefault();
            }
            this.tasks.addElement(EditTask);
            try {
                ExtensionHelper.processServerExtensionsForEdit(EditApplication.this.prefs, this.tasks, this);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication", (String)"1040", (Object)this);
            }
            this.before = true;
            this.edit_index = this.tasks.indexOf(EditTask);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("edit_index: " + this.edit_index));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("tasks: " + this.tasks));
            }
        }

        public void setLocale(Locale locale) {
        }

        public String getAppName() {
            return this.appC.getName();
        }

        public Hashtable getProperties() {
            return EditApplication.this.prefs;
        }

        public void propagateTaskEvent(AppNotification appNotification) {
        }

        public String getID() {
            return null;
        }

        public AppManagement getAppManagement() {
            return EditApplication.this.appM;
        }

        public WorkSpace getWorkSpace() {
            return this.ws;
        }

        public void setWorkSpaceID(String string) throws Exception {
        }

        public RepositoryContext getCellContext() throws Exception {
            return this.appC.getParent().getParent();
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"run: EditScheduler");
            }
            int n = 0;
            int n2 = -1;
            if (this.before) {
                n = 0;
                n2 = this.edit_index - 1;
                this.before = false;
            } else {
                n = this.edit_index + 1;
                n2 = this.tasks.size() - 1;
            }
            try {
                for (int i = n; i <= n2; ++i) {
                    AbstractTask abstractTask = null;
                    try {
                        Class<?> clazz = Class.forName((String)this.tasks.elementAt(i));
                        abstractTask = (AbstractTask)clazz.newInstance();
                    }
                    catch (Throwable throwable) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Exception instantiating: " + this.tasks.elementAt(i)));
                        }
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.run", (String)"1132", (Object)this);
                    }
                    abstractTask.setScheduler(this);
                    abstractTask.setLocale(this.locale);
                    abstractTask.setAppTaskName("EditApplication");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Executing: " + abstractTask));
                    }
                    boolean bl = abstractTask.performTask();
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Done: " + bl));
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.run", (String)"1073", (Object)this);
            }
            this.before = false;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"run: EditScheduler");
            }
        }
    }
}

