/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.archive.impl.ArchiveOptions;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.SchedulerImpl;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class InstallSchedulerImpl
extends SchedulerImpl
implements InstallScheduler {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$application$InstallSchedulerImpl == null ? (class$com$ibm$ws$management$application$InstallSchedulerImpl = InstallSchedulerImpl.class$("com.ibm.ws.management.application.InstallSchedulerImpl")) : class$com$ibm$ws$management$application$InstallSchedulerImpl), (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    String sourcePath;
    String earPath;
    private EARFile earFile;
    static /* synthetic */ Class class$com$ibm$ws$management$application$InstallSchedulerImpl;
    static /* synthetic */ Class class$com$ibm$ws$management$application$task$DeployEJBTask;
    static /* synthetic */ Class class$com$ibm$ws$management$application$task$ExtractionTask;
    static /* synthetic */ Class class$com$ibm$ws$management$application$task$CompileJspTask;
    static /* synthetic */ Class class$com$ibm$ws$management$application$task$ConfigureTask;
    static /* synthetic */ Class class$com$ibm$ws$management$application$task$BackupAppTask;

    public InstallSchedulerImpl(String string, String string2, Hashtable hashtable, AppManagement appManagement, AppNotification.Listener listener) {
        super(string2, hashtable, appManagement, listener);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"InstallSchedulerImpl");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Ear: " + string + ", appName: " + string2 + ", options: " + hashtable));
        }
        this.sourcePath = string;
        this.earPath = string;
        this.appTaskName = "InstallApplication";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Uniquie id: " + this.id));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"InstallSchedulerImpl");
        }
    }

    public String getEarPath() {
        return this.earPath;
    }

    public void setEarPath(String string) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setEarPath");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("new path: " + string));
        }
        this.earPath = string;
        if (this.earFile != null) {
            try {
                Tr.debug((TraceComponent)tc, (String)("********** closing: " + this.earFile.getURI()));
                this.earFile.close();
                this.earFile = null;
            }
            catch (Throwable throwable) {
                if (this.resBundle != null) {
                    throw new AdminException(throwable, AppUtils.getMessage(this.resBundle, "ADMA0053E", new Object[]{this.earPath}));
                }
                throw new AdminException(throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setEarPath");
        }
    }

    public EARFile getEarFile() throws AdminException {
        return this.getEarFile(false, false);
    }

    public EARFile getEarFile(boolean bl, boolean bl2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEarFile: " + bl2 + ", " + bl));
        }
        if (this.earFile == null) {
            try {
                this.earFile = AppInstallHelper.getEarFile(this.earPath, bl, bl2, this.resBundle);
                Tr.debug((TraceComponent)tc, (String)("********** opening: " + this.earFile.getURI()));
            }
            catch (AppDeploymentException appDeploymentException) {
                throw new AdminException(appDeploymentException.getEmbeddedEx(), appDeploymentException.getMessage());
            }
        }
        ArchiveOptions archiveOptions = this.earFile.getOptions();
        boolean bl3 = !bl2 && archiveOptions.isReadOnly();
        boolean bl4 = bl3 = bl3 || bl && !archiveOptions.useJavaReflection();
        if (bl3) {
            this.earFile.close();
            this.earFile = null;
            try {
                AppUtils.dbg(tc, "Reopening since: read=" + archiveOptions.isReadOnly() + ", refl=" + archiveOptions.useJavaReflection());
                this.earFile = AppInstallHelper.getEarFile(this.earPath, bl, bl2, this.resBundle);
            }
            catch (AppDeploymentException appDeploymentException) {
                throw new AdminException(appDeploymentException.getEmbeddedEx(), appDeploymentException.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEarFile");
        }
        return this.earFile;
    }

    protected String getJMXEventType() {
        return "websphere.admin.appmgmt.install";
    }

    protected AppNotification createStartEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createStartEvent");
        }
        String string = "";
        if (this.resBundle != null) {
            string = AppUtils.getMessage(this.resBundle, "ADMA5016I", new String[]{this.appName});
        }
        AppNotification appNotification = new AppNotification("InstallApplication", "", "InProgress", "", string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createStartEvent");
        }
        return appNotification;
    }

    protected AppNotification createCompletionEvent(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createCompletionEvent");
        }
        String string = "";
        if (this.resBundle != null) {
            string = AppUtils.getMessage(this.resBundle, bl ? "ADMA5013I" : "ADMA5014E", new String[]{this.appName});
        }
        AppNotification appNotification = new AppNotification("InstallApplication", "", bl ? "Completed" : "Failed", "", string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCompletionEvent");
        }
        return appNotification;
    }

    protected void setupTasks() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setupTasks");
        }
        this.updateAppAndCellName();
        boolean bl = this.properties.get("preCompileJSPs") != null && this.properties.get("preCompileJSPs").equals(Boolean.TRUE);
        boolean bl2 = this.properties.get("deployejb") != null && this.properties.get("deployejb").equals(Boolean.TRUE);
        boolean bl3 = Boolean.TRUE.equals(this.properties.get("zeroBinaryCopy"));
        Tr.debug((TraceComponent)tc, (String)("preCompileJsp: " + bl + "deployEJB: " + bl2));
        this.tasks = new Vector();
        RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.getAppName(), this.getWorkSpace(), this.getProperties());
        if (repositoryContext != null) {
            this.showEx = false;
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5015E", new String[]{this.appName}));
        }
        if (bl2) {
            this.tasks.addElement((class$com$ibm$ws$management$application$task$DeployEJBTask == null ? (class$com$ibm$ws$management$application$task$DeployEJBTask = InstallSchedulerImpl.class$("com.ibm.ws.management.application.task.DeployEJBTask")) : class$com$ibm$ws$management$application$task$DeployEJBTask).getName());
        }
        if (bl) {
            this.tasks.addElement((class$com$ibm$ws$management$application$task$ExtractionTask == null ? (class$com$ibm$ws$management$application$task$ExtractionTask = InstallSchedulerImpl.class$("com.ibm.ws.management.application.task.ExtractionTask")) : class$com$ibm$ws$management$application$task$ExtractionTask).getName());
        }
        if (bl) {
            this.tasks.addElement((class$com$ibm$ws$management$application$task$CompileJspTask == null ? (class$com$ibm$ws$management$application$task$CompileJspTask = InstallSchedulerImpl.class$("com.ibm.ws.management.application.task.CompileJspTask")) : class$com$ibm$ws$management$application$task$CompileJspTask).getName());
        }
        this.tasks.addElement((class$com$ibm$ws$management$application$task$ConfigureTask == null ? (class$com$ibm$ws$management$application$task$ConfigureTask = InstallSchedulerImpl.class$("com.ibm.ws.management.application.task.ConfigureTask")) : class$com$ibm$ws$management$application$task$ConfigureTask).getName());
        if (!bl3) {
            this.tasks.addElement((class$com$ibm$ws$management$application$task$BackupAppTask == null ? (class$com$ibm$ws$management$application$task$BackupAppTask = InstallSchedulerImpl.class$("com.ibm.ws.management.application.task.BackupAppTask")) : class$com$ibm$ws$management$application$task$BackupAppTask).getName());
        }
        try {
            ExtensionHelper.processServerInstallExtensions(this.properties, this.tasks, this);
        }
        catch (AppDeploymentException appDeploymentException) {
            throw new AdminException(appDeploymentException);
        }
        AppUtils.dbg(tc, AppUtils.getMessage(this.resBundle, "ADMA6010I", new Object[]{this.tasks}));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setupTasks");
        }
    }

    private void updateAppAndCellName() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateAppAndCellName");
        }
        if (this.appName == null) {
            this.appName = (String)this.getProperties().get("appname");
            if (AppUtils.isEmpty(this.appName)) {
                this.appName = AppInstallHelper.getAppDisplayName(this.getEarFile(false, true), this.properties);
            }
            if (this.appName != null) {
                this.appName = this.appName.trim();
            }
        }
        if (!ConfigServiceHelper.checkIfNameValid(this.appName)) {
            throw new AdminException(null, AppUtils.getMessage(this.resBundle, "ADMA5019E", new Object[]{this.appName}));
        }
        String string = null;
        Hashtable hashtable = (Hashtable)this.getProperties().get("moduleToServer");
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.getProperties().put("moduleToServer", hashtable);
        }
        Iterator iterator = hashtable.values().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "+");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken().trim();
                if (AppUtils.isEmpty(string3)) continue;
                ObjectName objectName = null;
                try {
                    objectName = new ObjectName(string3);
                    string = objectName.getKeyProperty("cell");
                    if (string == null) continue;
                    break;
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Bad token: " + string3));
                    }
                    throw new AdminException(malformedObjectNameException, AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5025E", new Object[]{string3}));
                }
            }
            if (string == null) continue;
        }
        System.out.println("================== " + string);
        if (string != null) {
            this.getProperties().put("cell.name", string);
        }
        if ((string = (String)this.getProperties().get("cell.name")) == null) {
            throw new AdminException(null, AppUtils.getMessage(this.resBundle, "ADMA5046E", new Object[0]));
        }
        this.cellContext = AppUtils.findContext("cells", string, null, null, this.getWorkSpace(), true);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("updateAppAndCellName:" + this.appName + ", " + string));
        }
    }

    protected void performCleanup(boolean bl) throws Exception {
        File file;
        Object v;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performCleanup");
        }
        if (this.earFile != null) {
            Tr.debug((TraceComponent)tc, (String)("Closing ear: " + this.earFile.getURI()));
            this.earFile.close();
        }
        if ((v = this.getProperties().get("DeleteSourceEar")) != null && v.equals(Boolean.TRUE)) {
            file = new File(this.sourcePath);
            boolean bl2 = file.delete();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Delete original ear: " + this.sourcePath + " -- success: " + bl2));
            }
        }
        if (!this.setupDone) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"performCleanup:  nosetupDone");
            }
            return;
        }
        this.earFile = null;
        AppUtils.dbg(tc, AppUtils.getMessage(this.resBundle, "ADMA6011I", new Object[]{AppUtils.getAppTempDir(this)}));
        AppUtils.deleteDirTree(AppUtils.getAppTempDir(this));
        if (bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"performCleanup: success");
            }
            return;
        }
        file = AppUtils.findAppContextFromConfig(this.getAppName(), this.getWorkSpace(), this.getProperties());
        RepositoryContext repositoryContext = null;
        try {
            if (file != null && file.isAvailable("deployment.xml")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Install failed. Found deployment.xml");
                }
                ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)file);
                Vector vector = ConfigRepoHelper.getServersForAppDeployment(applicationDeployment, null, this.getCellContext(), this.getWorkSpace(), false);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("App was to be installed on: " + vector));
                }
                String string = ConfigRepoHelper.updateServerIndexDocs((RepositoryContext)file, this.getWorkSpace(), vector, false, this.resBundle);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Removed entry from: " + string));
                }
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception in cleaning SI entry: " + throwable));
            }
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.InstallSchedulerImpl.performCleanup", (String)"405", (Object)this);
        }
        if (file != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Deleting application ctx " + file + " after install failed."));
            }
            repositoryContext = file.getParent();
            file.delete(true);
        }
        if (repositoryContext != null && repositoryContext.getChildren().size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Deleting backup ctx " + repositoryContext + " after install failed."));
            }
            repositoryContext.delete(true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"performCleanup");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

