/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client.driver;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.deployment.deploywrapper.DeployOptions;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentMessages;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskMessages;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.DefaultBinding;
import com.ibm.ws.management.application.client.DefaultBindingHelper;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class InstallApp
implements AppNotification.Listener,
NotificationListener {
    public static final String INTERACTIVE = "interactive";
    public static final String API = "api";
    public static final String PREPAREONLY = "prepareonly";
    public static final String USEJMX = "usejmx";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String TYPE = "conntype";
    public static final String HOST_DEFAULT = "localhost";
    public static final String PORT_DEFAULT = "8880";
    public static final String TYPE_DEFAULT = "SOAP";
    private static final String CMDLINE_YES = "yes";
    private static final String CMDLINE_NO = "no";
    private static final String BACKENDID_OPTION = "BackendIdSelection";
    private static final String TRACE_PROP = "com.ibm.ejs.ras.traceString";
    private static final String TRACE_FILE_PROP = "com.ibm.ejs.ras.traceFile";
    public static final String MODULESERVER = "moduleserverfile";
    public static final String TIMEOUT = "timeout";
    public static final int TIMEOUT_DEFAULT = 300;
    private static ResourceBundle resBundle;
    private static TraceComponent tc;
    private static Vector lSide;
    private static Vector rSide;
    private Hashtable argOptions;
    private ObjectName _on;
    AdminClient _soapClient;
    private String appName;
    private AppDeploymentMessages msgs = new AppDeploymentTaskMessages();
    static /* synthetic */ Class class$com$ibm$ws$management$application$client$driver$InstallApp;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1 || stringArray[0].equals("")) {
            InstallApp.displayHelp();
            System.exit(0);
        }
        InstallApp.setTrace();
        resBundle = AppUtils.getBundle(null);
        String string = stringArray[0];
        Hashtable hashtable = InstallApp.parseCmdLine(stringArray);
        InstallApp.dbg("");
        InstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6001I"));
        InstallApp installApp = new InstallApp(string, hashtable);
        installApp.prepareApp();
    }

    private static void setTrace() {
        String string = System.getProperty(TRACE_PROP);
        if (string == null || string.trim().equals("")) {
            return;
        }
        String string2 = "stdout";
        String string3 = System.getProperty(TRACE_FILE_PROP);
        if (string3 != null) {
            string2 = "named file";
        }
        ManagerAdmin.configureClientTrace((String)string, (String)string2, (String)string3, (boolean)true, null, (boolean)false);
    }

    private static void dbg(Object object) {
        System.out.println(object);
    }

    private static void errorAndExit(String string) {
        System.out.println(string);
        System.exit(-1);
    }

    private static void createOptionsText(boolean bl) {
        lSide = new Vector();
        if (!bl) {
            rSide = new Vector();
        }
        lSide.addElement("original.ear.location");
        if (!bl) {
            rSide.addElement("earfilepath (must be specified)");
        }
        lSide.addElement("installed.ear.destination");
        if (!bl) {
            rSide.addElement("destination_folder (must be specified and must be an absolute path.");
        }
        lSide.addElement("was.install.root");
        if (!bl) {
            rSide.addElement(" -- deprecated");
        }
        lSide.addElement("config.root");
        if (!bl) {
            rSide.addElement(" -- deprecated");
        }
        lSide.addElement("cell.name");
        if (!bl) {
            rSide.addElement("cell (default is hostname)");
        }
        lSide.addElement("node.name");
        if (!bl) {
            rSide.addElement("node (default is hostname)");
        }
        lSide.addElement("server.name");
        if (!bl) {
            rSide.addElement("server (default is server1)");
        }
        lSide.addElement("cluster.name");
        if (!bl) {
            rSide.addElement("cluster");
        }
        lSide.addElement(MODULESERVER);
        if (!bl) {
            rSide.addElement("a properties file specifying module to server relations in format <moduleURI+ddURI=WebSphere:cell=cellName,server=serverName>");
        }
        lSide.addElement(HOST);
        if (!bl) {
            rSide.addElement("host name used for -usejmx option, default is localhost");
        }
        lSide.addElement(PORT);
        if (!bl) {
            rSide.addElement("port num used for -usejmx option, default is 8880");
        }
        lSide.addElement(TYPE);
        if (!bl) {
            rSide.addElement("connection type used for -usejmx option, default is SOAP");
        }
        lSide.addElement(TIMEOUT);
        if (!bl) {
            rSide.addElement("timeout (sec) to wait for JMX events, default is 300, -1 for no timeout");
        }
        lSide.addElement("copy.sessionmgr.servername");
        if (!bl) {
            rSide.addElement("specifies the server name from  which the install logic copies session manager settings into  the app's deployment.xml");
        }
        lSide.addElement("-----");
        if (!bl) {
            rSide.addElement("----- -----");
        }
        lSide.addElement("-----");
        if (!bl) {
            rSide.addElement("----- -----");
        }
        lSide.addElement(INTERACTIVE);
        if (!bl) {
            rSide.addElement("(allows user to enter binding information)");
        }
        lSide.addElement(API);
        if (!bl) {
            rSide.addElement("(calls AppManagement MBean api directly)");
        }
        lSide.addElement(PREPAREONLY);
        if (!bl) {
            rSide.addElement("(only collects binding information, does not perform install, ignored in noninteractive mode)");
        }
        lSide.addElement(USEJMX);
        if (!bl) {
            rSide.addElement("(performs installation by calling AppManagementMBean)");
        }
        lSide.addElement("depl.extension.reg");
        if (!bl) {
            rSide.addElement("(specifies location of properties file for deployment extensions)");
        }
        lSide.addElement("useMetaDataFromBinary");
        if (!bl) {
            rSide.addElement(" yes/no (specifies useMetadataFromBinaries from deployment.xml");
        }
        lSide.addElement("distributeApp");
        if (!bl) {
            rSide.addElement(" yes/no (specifies isDistributionEnabled from deployment.xml");
        }
        lSide.addElement("zeroBinaryCopy");
        if (!bl) {
            rSide.addElement(" yes/no (specifies zero bin copy. Implicitly means useMetdataFromBin=true and enableDistrib=false");
        }
        lSide.addElement("-----");
        if (!bl) {
            rSide.addElement("----- -----");
        }
        lSide.addElement("-----");
        if (!bl) {
            rSide.addElement("----- -----");
        }
        lSide.addElement("redeploy");
        if (!bl) {
            rSide.addElement(" specifies the reinstall / upgrade operation");
        }
        lSide.addElement("redeploy.ignore.old");
        if (!bl) {
            rSide.addElement(" specifies that bindings from the older version are ignored during reinstall operation");
        }
        lSide.addElement("redeploy.ignore.new");
        if (!bl) {
            rSide.addElement(" specifies that bindings from the newer version are ignored during reinstall operation if the older ones exist");
        }
        lSide.addElement("-----");
        if (!bl) {
            rSide.addElement("----- -----");
        }
        lSide.addElement("-----");
        if (!bl) {
            rSide.addElement("----- -----");
        }
        lSide.addElement("usedefaultbindings");
        if (!bl) {
            rSide.addElement(" yes/no (runs default binding generator)");
        }
        lSide.addElement("defaultbinding.datasource.jndi");
        if (!bl) {
            rSide.addElement("jndi_name (specifies JNDI name for default datasource)");
        }
        lSide.addElement("defaultbinding.datasource.username");
        if (!bl) {
            rSide.addElement("user_name (specifies user name for default datasource)");
        }
        lSide.addElement("defaultbinding.datasource.password");
        if (!bl) {
            rSide.addElement("password (specifies password for default datasource)");
        }
        lSide.addElement("defaultbinding.cf.jndi");
        if (!bl) {
            rSide.addElement("jndi_name (specifies JNDI name for default connection factory)");
        }
        lSide.addElement("defaultbinding.cf.resauth");
        if (!bl) {
            rSide.addElement("resauth (resauth for connection factory -PerConnFact or Container)");
        }
        lSide.addElement("defaultbinding.ejbjndi.prefix");
        if (!bl) {
            rSide.addElement("prefix (specifies prefix for JNDI name of EJBs)");
        }
        lSide.addElement("defaultbinding.virtual.host");
        if (!bl) {
            rSide.addElement("vhost_name (default name for virtual host)");
        }
        lSide.addElement("defaultbinding.force");
        if (!bl) {
            rSide.addElement("(specifies whether to override current bindings)");
        }
        lSide.addElement("defaultbinding.strategy.file");
        if (!bl) {
            rSide.addElement("filename (specifies custom strategy file)");
        }
        lSide.addElement("-----");
        if (!bl) {
            rSide.addElement("----- -----");
        }
        lSide.addElement("-----");
        if (!bl) {
            rSide.addElement("----- -----");
        }
        lSide.addElement("deployejb");
        if (!bl) {
            rSide.addElement("yes/no (specifies if EJBDeploy should be run during install)");
        }
        lSide.addElement("deployejb.dbtype");
        if (!bl) {
            rSide.addElement("(database type " + InstallApp.getDBTypes() + " default:" + "DB2UDB_V81" + ")");
        }
        lSide.addElement("deployejb.dbschema");
        if (!bl) {
            rSide.addElement("(database schema, default:)");
        }
        lSide.addElement("deployejb.classpath");
        if (!bl) {
            rSide.addElement("(extra classpath used in EJBDeploy)");
        }
        lSide.addElement("deployejb.rmic");
        if (!bl) {
            rSide.addElement("(extra RMIC options to be used during EJBDeploy)");
        }
        lSide.addElement(BACKENDID_OPTION);
        if (!bl) {
            rSide.addElement("(specified backendId options for EJBModule)");
        }
    }

    private static String getDBTypes() {
        String string = "[";
        String[] stringArray = DeployOptions.getDatabaseTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                string = string + ", ";
            }
            string = string + stringArray[i];
        }
        string = string + "]";
        return string;
    }

    private static void displayHelp() {
        InstallApp.dbg("Usage syntax is: InstallApp applicationName [[-option.name optionValue]...]");
        InstallApp.dbg("");
        InstallApp.dbg("Valid options are:");
        InstallApp.dbg("==================");
        InstallApp.createOptionsText(false);
        for (int i = 0; i < lSide.size(); ++i) {
            InstallApp.dbg("\t-" + lSide.elementAt(i) + " " + rSide.elementAt(i));
        }
        InstallApp.dbg("");
        InstallApp.dbg("==================");
        InstallApp.dbg("");
        InstallApp.dbg("For example: ");
        InstallApp.dbg("InstallApp sampleApp -installed.ear.destination C:\\WebSphere\\AppServer\\installedApps -original.ear.location C:\\WebSphere\\AppServer\\installableApps\\sampleApp.ear -server.name server1 -interactive");
    }

    private static String fixPath(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (File.separatorChar == '/') {
            string2 = string2.replace('\\', File.separatorChar);
        }
        if (File.separatorChar == '\\') {
            string2 = string2.replace('/', File.separatorChar);
        }
        return string2;
    }

    private static Hashtable parseCmdLine(String[] stringArray) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseCmdLine");
        }
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        InstallApp.createOptionsText(true);
        for (int i = 1; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("-")) {
                InstallApp.errorAndExit("Usage error: expected option name beginning with \"-\"; found " + stringArray[i]);
            }
            if (!lSide.contains(object2 = stringArray[i].substring(1, stringArray[i].length()))) {
                InstallApp.errorAndExit("Invalid option: " + (String)object2);
            }
            if (((String)object2).equals(INTERACTIVE) || ((String)object2).equals(PREPAREONLY) || ((String)object2).equals(USEJMX) || ((String)object2).equals(API) || ((String)object2).equals("redeploy") || ((String)object2).equals("redeploy.ignore.old") || ((String)object2).equals("redeploy.ignore.new")) {
                hashtable.put(object2, new Boolean(true));
                continue;
            }
            if (((String)object2).equals("defaultbinding.force")) {
                hashtable.put(object2, "AppDeploymentOption.Yes");
                continue;
            }
            object = stringArray[i + 1];
            if (((String)object2).equals("original.ear.location") || ((String)object2).equals("installed.ear.destination")) {
                object = InstallApp.fixPath(object);
            }
            hashtable.put(object2, object);
            ++i;
        }
        if (hashtable.get("original.ear.location") == null) {
            InstallApp.errorAndExit("Usage error: Original ear not specified.");
        }
        if (hashtable.get(API) != null && hashtable.get(MODULESERVER) == null) {
            InstallApp.errorAndExit("Usage error: The -api option can only be used with -moduleserverfile option");
        }
        if (hashtable.get(USEJMX) != null) {
            if (hashtable.get(HOST) == null) {
                hashtable.put(HOST, HOST_DEFAULT);
            }
            if (hashtable.get(PORT) == null) {
                hashtable.put(PORT, PORT_DEFAULT);
            }
            if (hashtable.get(TYPE) == null) {
                hashtable.put(TYPE, TYPE_DEFAULT);
            }
        } else {
            String string = (String)hashtable.get("installed.ear.destination");
            if (string != null && string.indexOf(File.separatorChar) == -1 && string.indexOf("$(") == -1 && string.indexOf("${") == -1) {
                InstallApp.errorAndExit("Usage error: installed.ear.destination is a relative path since it does not contain " + File.separatorChar + " or a pathmap variable " + " like $(APP_INSTALL_ROOT)");
            }
        }
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (hashtable.get("cell.name") == null) {
            if (string == null) {
                hashtable.put("cell.name", "BaseApplicationServerCell");
            } else {
                hashtable.put("cell.name", string);
            }
        }
        if (hashtable.get("node.name") == null) {
            if (string == null) {
                hashtable.put("node.name", "DefaultNode");
            } else {
                hashtable.put("node.name", string);
            }
        }
        if (hashtable.get("server.name") == null) {
            hashtable.put("server.name", "server1");
        }
        InstallApp.dbg("");
        InstallApp.dbg("======================");
        InstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6002I"));
        object2 = hashtable.keys();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            InstallApp.dbg(object + " = " + hashtable.get(object));
        }
        InstallApp.dbg("======================");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseCmdLine");
        }
        return hashtable;
    }

    public InstallApp(String string, Hashtable hashtable) {
        this.appName = string;
        this.argOptions = hashtable;
    }

    public void prepareApp() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareApp");
        }
        try {
            String string = (String)this.argOptions.get("original.ear.location");
            Hashtable hashtable = this.createPrefsForController();
            InstallApp.dbg("");
            InstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6003I"));
            AppDeploymentController appDeploymentController = null;
            if (this.argOptions.get("redeploy") != null && this.argOptions.get("redeploy.ignore.old") == null) {
                if (this.argOptions.get("redeploy.ignore.new") != null) {
                    hashtable.put("redeploy.ignore.new", this.argOptions.get("redeploy.ignore.new"));
                }
                appDeploymentController = AppManagementFactory.readArchiveForRedeployment(string, hashtable, this.getOldAppTasks());
            } else if (this.argOptions.get(API) == null) {
                appDeploymentController = AppManagementFactory.readArchive(string, hashtable);
            }
            Hashtable hashtable2 = null;
            if (this.argOptions.get(API) == null) {
                hashtable2 = appDeploymentController.getAppOptions();
                this.patchAppDeploymentController(hashtable2);
                this.compareSecurityPolicy(appDeploymentController);
                this.getTasks(appDeploymentController);
                hashtable2 = this.saveAndClose(appDeploymentController);
            } else {
                hashtable2 = new Hashtable();
                this.patchAppDeploymentController(hashtable2);
            }
            this.performInstall(string, hashtable2);
        }
        catch (Exception exception) {
            AppUtils.printEx(exception);
            InstallApp.errorAndExit(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareApp");
        }
    }

    private Hashtable createPrefsForController() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createPrefsForController");
        }
        Hashtable hashtable = new Hashtable();
        Object v = this.argOptions.get("depl.extension.reg");
        if (v != null) {
            InstallApp.dbg("Setting extensions to : " + v);
            hashtable.put("depl.extension.reg", v);
        }
        try {
            Object object;
            Object object2;
            Object object3 = (String)this.argOptions.get("usedefaultbindings");
            object3 = object3 == null ? "AppDeploymentOption.No" : (((String)object3).equalsIgnoreCase(this.msgs.getMessage("AppDeploymentOption.No")) ? "AppDeploymentOption.No" : "AppDeploymentOption.Yes");
            if (this.argOptions.get(INTERACTIVE) != null) {
                object2 = this.msgs.getMessage("defaultbinding.enable");
                object = this.promptInput(this.msgs, "", true, "AppDeploymentOption.Yes", (String)(object2 = (String)object2 + "[" + this.msgs.getMessage((String)object3) + "]:"), "");
                if (object != null) {
                    object3 = object;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Answer about gen bindings: " + (String)object3));
            }
            if (((String)object3).equalsIgnoreCase("AppDeploymentOption.Yes")) {
                this.argOptions.put("app.client.locale", Locale.getDefault());
                object2 = new DefaultBindingHelper(this.argOptions);
                object = (DefaultBinding)((DefaultBindingHelper)object2).createTask(null);
                String string = (String)this.argOptions.get("original.ear.location");
                ((DefaultBindingHelper)object2).prepareTask(string, (AppDeploymentTask)object);
                if (this.argOptions.get(INTERACTIVE) != null) {
                    this.displayAndSetTaskData((AppDeploymentTask)object, this.msgs);
                }
                ((DefaultBindingHelper)object2).completeTask(null, (AppDeploymentTask)object);
                Preferences preferences = DefaultBindingHelper.getPreferences((DefaultBinding)object);
                InstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6004I") + preferences);
                hashtable.put("usedefaultbindings", preferences);
            }
        }
        catch (AppDeploymentException appDeploymentException) {
            appDeploymentException.printStackTrace();
            InstallApp.dbg("Exception " + appDeploymentException + " in collecting preferences");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createPrefsForController " + hashtable));
        }
        return hashtable;
    }

    private void patchAppDeploymentController(Hashtable hashtable) {
        String string;
        String string2;
        String string3;
        Object v;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"patchAppDeploymentController");
        }
        if (this.appName != null && this.appName.trim().length() > 0) {
            hashtable.put("appname", this.appName);
        }
        hashtable.put("cell.name", this.argOptions.get("cell.name"));
        hashtable.put("node.name", this.argOptions.get("node.name"));
        hashtable.put("server.name", this.argOptions.get("server.name"));
        if (this.argOptions.containsKey("cluster.name")) {
            hashtable.put("cluster.name", this.argOptions.get("cluster.name"));
        }
        if (this.argOptions.containsKey("copy.sessionmgr.servername")) {
            hashtable.put("copy.sessionmgr.servername", this.argOptions.get("copy.sessionmgr.servername"));
        }
        if ((v = this.argOptions.get("installed.ear.destination")) != null) {
            hashtable.put("installed.ear.destination", v);
        }
        if ((string3 = (String)this.argOptions.get("useMetaDataFromBinary")) != null && string3.equalsIgnoreCase(CMDLINE_YES)) {
            hashtable.put("useMetaDataFromBinary", Boolean.TRUE);
        }
        if ((string3 = (String)this.argOptions.get("distributeApp")) != null && string3.equalsIgnoreCase(CMDLINE_NO)) {
            hashtable.put("distributeApp", Boolean.FALSE);
        }
        if ((string2 = (String)this.argOptions.get("deployejb")) != null && string2.equalsIgnoreCase(CMDLINE_YES)) {
            hashtable.put("deployejb", Boolean.TRUE);
        } else if (string2 != null && string2.equalsIgnoreCase(CMDLINE_NO)) {
            hashtable.put("deployejb", Boolean.FALSE);
        }
        Hashtable hashtable2 = (Hashtable)hashtable.get("deployejb.options");
        String string4 = null;
        string4 = "deployejb.dbtype";
        if (this.argOptions.get(string4) != null) {
            hashtable2.put(string4, this.argOptions.get(string4));
        }
        if (this.argOptions.get(string4 = "deployejb.dbschema") != null) {
            hashtable2.put(string4, this.argOptions.get(string4));
        }
        if (this.argOptions.get(string4 = "deployejb.rmic") != null) {
            hashtable2.put(string4, this.argOptions.get(string4));
        }
        if (this.argOptions.get(string4 = "deployejb.classpath") != null) {
            hashtable2.put(string4, this.argOptions.get(string4));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Ejb deploy options created: " + hashtable2));
        }
        if ((string = (String)this.argOptions.get(MODULESERVER)) != null) {
            File file = new File(string);
            if (!file.exists()) {
                InstallApp.dbg("Warning: Properties " + string + " file for " + MODULESERVER + " does not exist.");
            } else {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    fileInputStream.close();
                    InstallApp.dbg("Read mod-server relations from " + string);
                    Hashtable<Object, String> hashtable3 = (Hashtable<Object, String>)hashtable.get("moduleToServer");
                    if (hashtable3 == null) {
                        hashtable3 = new Hashtable<Object, String>();
                    }
                    Enumeration<Object> enumeration = properties.keys();
                    while (enumeration.hasMoreElements()) {
                        Object object = enumeration.nextElement();
                        hashtable3.put(object, (String)properties.get(object));
                    }
                    hashtable.put("moduleToServer", hashtable3);
                }
                catch (Throwable throwable) {
                    InstallApp.dbg("Warning: Exception in reading " + string + " ex: " + throwable);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"patchAppDeploymentController");
        }
    }

    private void compareSecurityPolicy(AppDeploymentController appDeploymentController) throws Exception {
        Object object;
        Vector vector = null;
        String string = appDeploymentController.getSecurityPolicyData();
        String string2 = appDeploymentController.getSecurityPolicyWarning();
        if (string2 != null) {
            InstallApp.dbg(string2);
        }
        if (string == null || string.trim().length() == 0) {
            return;
        }
        InstallApp.dbg("");
        InstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6005I"));
        if (this.argOptions.get(USEJMX) == null) {
            object = AppManagementFactory.createLocalAppManagementImpl();
            vector = object.compareSecurityPolicy(string, new Hashtable(), null);
        } else {
            object = this.getAdminClient();
            ObjectName objectName = this.getObjectName((AdminClient)object);
            if (objectName == null) {
                InstallApp.errorAndExit("Could not find AppManagement MBean.");
            }
            vector = (Vector)object.invoke(objectName, "compareSecurityPolicy", new Object[]{string, new Hashtable(), null}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String"});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("retVal: " + vector));
        }
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            InstallApp.dbg(vector.elementAt(i));
        }
    }

    private void getTasks(AppDeploymentController appDeploymentController) throws AppDeploymentException {
        AppDeploymentTask appDeploymentTask = appDeploymentController.getFirstTask();
        int n = 1;
        while (appDeploymentTask != null) {
            String[][] stringArray;
            Object object;
            if (this.argOptions.get(INTERACTIVE) != null) {
                InstallApp.dbg("");
                object = appDeploymentController.getTaskInfo((String)appDeploymentTask.getName()).appMessages;
                stringArray = object.getGoalTitle(appDeploymentTask.getName());
                InstallApp.dbg("Task[" + n++ + "]: " + (String)stringArray);
                InstallApp.dbg(object.getGoalMessage(appDeploymentTask.getName()));
                InstallApp.dbg("");
                if (appDeploymentTask.isTaskEmpty()) {
                    InstallApp.dbg(object.getEmptyTaskMessage(appDeploymentTask.getName()));
                } else if (appDeploymentTask.isTaskDisabled()) {
                    InstallApp.dbg("...." + object.getDisableTaskMessage(appDeploymentTask.getName()));
                } else {
                    if (appDeploymentTask.getName().equals("EnsureMethodProtectionFor20EJB")) {
                        InstallApp.dbg("**** Possible value entered is uncheck, exclude, or security role names separated by comma");
                        InstallApp.dbg("");
                    } else if (appDeploymentTask.getName().equals("DataSourceFor20CMPBeans") || appDeploymentTask.getName().equals("DataSourceFor20EJBModules")) {
                        InstallApp.dbg("**** Possible value for resource authorization is container or per connection factory");
                        InstallApp.dbg("");
                    } else if (appDeploymentTask.getName().equals("EnsureMethodProtectionFor10EJB")) {
                        InstallApp.dbg("**** Possible value is yes, no, or null");
                        InstallApp.dbg("");
                    }
                    this.displayAndSetTaskData(appDeploymentTask, (AppDeploymentMessages)object);
                }
                InstallApp.dbg("=========== End (" + (String)stringArray + ")============");
            } else if (appDeploymentTask.getName().equals(BACKENDID_OPTION) && !appDeploymentTask.isTaskEmpty()) {
                object = (String)this.argOptions.get(BACKENDID_OPTION);
                stringArray = appDeploymentTask.getTaskData();
                for (int i = 1; i < stringArray.length; ++i) {
                    stringArray[i][stringArray[i].length - 1] = object;
                }
                appDeploymentTask.setTaskData(stringArray);
            }
            appDeploymentTask = appDeploymentController.getNextTask();
        }
    }

    private void displayAndSetTaskData(AppDeploymentTask appDeploymentTask, AppDeploymentMessages appDeploymentMessages) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("displayAndSetTaskData  " + appDeploymentTask.getName()));
        }
        String[][] stringArray = appDeploymentTask.getTaskData();
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                for (int j = 0; j < stringArray[i].length; ++j) {
                    String string = appDeploymentMessages.getColumnName(stringArray[0][j], appDeploymentTask.getName()) + ":  ";
                    if (appDeploymentTask.getMutableColumns(j)) {
                        string = string + "[";
                    }
                    string = stringArray[i][j] != null && (stringArray[i][j].equals("AppDeploymentOption.Yes") || stringArray[i][j].equals("AppDeploymentOption.No") || stringArray[i][j].equals("cmpBinding.container") || stringArray[i][j].equals("cmpBinding.perConnectionFactory")) ? string + appDeploymentMessages.getMessage(stringArray[i][j]) : string + stringArray[i][j];
                    if (appDeploymentTask.getMutableColumns(j)) {
                        string = string + "]: ";
                    }
                    if (appDeploymentTask.getMutableColumns(j)) {
                        String string2 = this.promptInput(appDeploymentMessages, appDeploymentTask.getName(), appDeploymentTask.getRequiredColumns(j), stringArray[i][j], string, stringArray[0][j]);
                        if (string2 == null) continue;
                        InstallApp.dbg(".... Setting " + appDeploymentMessages.getColumnName(stringArray[0][j], appDeploymentTask.getName()) + " to " + string2);
                        stringArray[i][j] = string2;
                        continue;
                    }
                    InstallApp.dbg(string);
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                InstallApp.dbg("Index out of bound");
                arrayIndexOutOfBoundsException.printStackTrace();
            }
        }
        appDeploymentTask.setTaskData(stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("displayAndSetTaskData " + appDeploymentTask.getName()));
        }
    }

    private String promptInput(AppDeploymentMessages appDeploymentMessages, String string, boolean bl, String string2, String string3, String string4) {
        String string5 = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        block2: while (true) {
            try {
                while (true) {
                    System.out.print(string3);
                    string5 = bufferedReader.readLine();
                    if (bl && (string5 == null || string5 != null && string5.trim().length() == 0) && (string2 == null || string2 != null && string2.length() == 0)) {
                        InstallApp.dbg("You have not entered a value for this  required field. Please try again.");
                        continue;
                    }
                    if (string5 != null && (bl && string5.trim().length() == 0 || !bl && string5.length() == 0)) {
                        string5 = null;
                    }
                    if (string5 == null) break block2;
                    if (string2 != null && (string2.equals("AppDeploymentOption.Yes") || string2.equals("AppDeploymentOption.No"))) {
                        if (string5.toLowerCase().equals(CMDLINE_NO)) {
                            string5 = "AppDeploymentOption.No";
                            break block2;
                        }
                        if (string5.toLowerCase().equals(CMDLINE_YES)) {
                            string5 = "AppDeploymentOption.Yes";
                            break block2;
                        }
                        InstallApp.dbg("This field requires Yes or no as the value. Please try again.");
                        continue;
                    }
                    if (!string4.equals("resAuth")) break;
                    if (string5.trim().toLowerCase().equals("container")) {
                        string5 = "cmpBinding.container";
                        break block2;
                    }
                    if (string5.trim().toLowerCase().equals("per connection factory")) {
                        string5 = "cmpBinding.perConnectionFactory";
                        break block2;
                    }
                    if (string5.trim().equals("")) break block2;
                    InstallApp.dbg("This field requires Container or Per connection factory as the value. Please try again.");
                }
                if (!string4.equals("method.protectionType")) break;
                if (string5.trim().toLowerCase().equals("exclude")) {
                    string5 = "methodProtection.exclude";
                    break;
                }
                if (!string5.trim().toLowerCase().equals("uncheck")) break;
                string5 = "methodProtection.uncheck";
            }
            catch (IOException iOException) {
                InstallApp.dbg("Error reading your input. Please try again");
                continue;
            }
            break;
        }
        return string5;
    }

    private Hashtable saveAndClose(AppDeploymentController appDeploymentController) throws AppDeploymentException {
        InstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6006I"));
        if (this.argOptions.get(API) == null) {
            appDeploymentController.saveAndClose();
        } else {
            appDeploymentController.close(false, true, true);
        }
        Hashtable hashtable = appDeploymentController.getAppDeploymentSavedResults();
        return hashtable;
    }

    private Vector getOldAppTasks() throws Exception {
        if (this.argOptions.get(USEJMX) == null) {
            InstallApp.dbg("Getting tasks for: " + this.appName);
            AppManagement appManagement = AppManagementFactory.createLocalAppManagementImpl();
            return appManagement.getApplicationInfo(this.appName, new Hashtable(), null);
        }
        AdminClient adminClient = this.getAdminClient();
        ObjectName objectName = this.getObjectName(adminClient);
        if (objectName == null) {
            InstallApp.errorAndExit("Can not find AppManagement MBean.");
        }
        Vector vector = (Vector)adminClient.invoke(objectName, "getApplicationInfo", new Object[]{this.appName, new Hashtable(), null}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String"});
        return vector;
    }

    private void performInstall(String string, Hashtable hashtable) throws Exception {
        if (this.argOptions.get(PREPAREONLY) != null) {
            this.printOptions(hashtable);
            return;
        }
        String string2 = (String)this.argOptions.get("zeroBinaryCopy");
        if (string2 != null && string2.equalsIgnoreCase(CMDLINE_YES)) {
            hashtable.put("zeroBinaryCopy", Boolean.TRUE);
        }
        if (this.argOptions.get(USEJMX) == null) {
            InstallApp.dbg("");
            InstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6007I"));
            this.printOptions(hashtable);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Creating local AppManagementImpl");
            }
            AppManagement appManagement = AppManagementFactory.createLocalAppManagementImpl();
            if (this.argOptions.get("redeploy") == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Before installApplication");
                }
                appManagement.installApplicationLocal(string, this.appName, hashtable, this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"After installApplication");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Before redeployApplicationLocal");
                }
                appManagement.redeployApplicationLocal(string, this.appName, hashtable, this, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"After redeployApplicationLocal");
                }
            }
        } else {
            Object object;
            this.printOptions(hashtable);
            AdminClient adminClient = this.getAdminClient();
            ObjectName objectName = this.getObjectName(adminClient);
            if (objectName == null) {
                InstallApp.errorAndExit("Can not find AppManagement MBean.");
            }
            boolean bl = false;
            try {
                object = new NotificationFilterSupport();
                ((NotificationFilterSupport)object).enableType("websphere.admin.appmgmt");
                adminClient.addNotificationListener(objectName, this, (NotificationFilter)object, "Install:" + this.appName);
                bl = true;
            }
            catch (Throwable throwable) {
                InstallApp.dbg("Error: Could not add listener to JMX MBean: " + throwable);
            }
            object = "installApplication";
            if (this.argOptions.get("redeploy") != null) {
                object = "redeployApplication";
            }
            adminClient.invoke(objectName, (String)object, new Object[]{string, this.appName, hashtable, null}, new String[]{"java.lang.String", "java.lang.String", "java.util.Hashtable", "java.lang.String"});
            InstallApp.dbg("after invoking installapplication.");
            boolean bl2 = this.waitForTimeout((String)this.argOptions.get(TIMEOUT));
            if (bl2) {
                InstallApp.dbg("Operation timed out.");
                if (bl) {
                    adminClient.removeNotificationListener(objectName, this);
                }
            }
        }
    }

    private AdminClient getAdminClient() throws Exception {
        if (this._soapClient != null) {
            return this._soapClient;
        }
        Properties properties = new Properties();
        properties.put(HOST, (String)this.argOptions.get(HOST));
        properties.put(PORT, (String)this.argOptions.get(PORT));
        properties.put("type", (String)this.argOptions.get(TYPE));
        this._soapClient = AdminClientFactory.createAdminClient(properties);
        return this._soapClient;
    }

    private ObjectName getObjectName(AdminClient adminClient) throws Exception {
        ObjectName objectName;
        int n;
        if (this._on != null) {
            return this._on;
        }
        ObjectName objectName2 = new ObjectName("WebSphere:type=AppManagement,*");
        Iterator iterator = adminClient.queryNames(objectName2, null).iterator();
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            this._on = (ObjectName)vector.elementAt(0);
            InstallApp.dbg("App Management object name = " + this._on);
            return this._on;
        }
        for (n = 0; n < vector.size(); ++n) {
            objectName = (ObjectName)vector.elementAt(n);
            if (!objectName.getKeyProperty("process").equals("dmgr")) continue;
            this._on = objectName;
            InstallApp.dbg("App Management object name = " + this._on);
            return this._on;
        }
        for (n = 0; n < vector.size(); ++n) {
            objectName = (ObjectName)vector.elementAt(n);
            if (!objectName.getKeyProperty("process").equals(objectName.getKeyProperty("node"))) continue;
            this._on = objectName;
            InstallApp.dbg("App Management object name = " + this._on);
            return this._on;
        }
        this._on = (ObjectName)vector.elementAt(0);
        InstallApp.dbg("App Management object name = " + this._on);
        return this._on;
    }

    private boolean waitForTimeout(String string) {
        try {
            int n = 300;
            if (string != null) {
                n = new Integer(string);
            }
            if (n == -1) {
                return false;
            }
            int n2 = 5;
            while (n > 0) {
                Thread.sleep(n2 * 1000);
                n -= n2;
                InstallApp.dbg("..");
            }
            return true;
        }
        catch (Throwable throwable) {
            InstallApp.dbg("Error in waiting for JMX events.." + throwable);
            throwable.printStackTrace();
            return true;
        }
    }

    public void appEventReceived(AppNotification appNotification) {
        InstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6008I") + appNotification);
        if (appNotification.taskName.equals("InstallApplication") && (appNotification.taskStatus.equals("Completed") || appNotification.taskStatus.equals("Failed"))) {
            try {
                if (this._soapClient != null) {
                    this._soapClient.removeNotificationListener(this.getObjectName(this._soapClient), this);
                }
            }
            catch (Throwable throwable) {
                InstallApp.dbg("Error removing listener: " + throwable);
            }
            InstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6009I"));
            if (this._soapClient != null) {
                System.exit(0);
            }
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (notification == null) {
            InstallApp.dbg("!! JMX event Recd: (handback obj= " + object + "): " + "Notification object is null");
            return;
        }
        Object object2 = notification.getUserData();
        InstallApp.dbg("!! JMX event Recd: (handback obj= " + object + "): " + object2);
        if (object2 instanceof AppNotification) {
            this.appEventReceived((AppNotification)object2);
        }
    }

    private void printOptions(Hashtable hashtable) {
        InstallApp.dbg("*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            InstallApp.dbg("");
            InstallApp.dbg(k + " ----> " + hashtable.get(k));
        }
        InstallApp.dbg("*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        tc = Tr.register((Class)(class$com$ibm$ws$management$application$client$driver$InstallApp == null ? (class$com$ibm$ws$management$application$client$driver$InstallApp = InstallApp.class$("com.ibm.ws.management.application.client.driver.InstallApp")) : class$com$ibm$ws$management$application$client$driver$InstallApp), (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    }
}

