/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.archive.exception.SaveFailureException;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.init.ArchiveInit;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.dfltbndngs.BindEarCmd;
import com.ibm.ws.management.application.dfltbndngs.BindingError;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import com.ibm.ws.management.application.dfltbndngs.utils.CommandLineUtils;
import com.ibm.ws.management.application.dfltbndngs.utils.ShowBindingsCmd;
import com.ibm.ws.management.application.dfltbndngs.utils.WrapModuleInEARCmd;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class BindEar {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$application$dfltbndngs$BindEar == null ? (class$com$ibm$ws$management$application$dfltbndngs$BindEar = BindEar.class$("com.ibm.ws.management.application.dfltbndngs.BindEar")) : class$com$ibm$ws$management$application$dfltbndngs$BindEar), (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private EARFile inputEar = null;
    private Archive originalArchive = null;
    private String originalEarName = null;
    private boolean debugMode = false;
    private ResourceBundle nlsBundle;
    private boolean ready = false;
    private String earFileName = null;
    private String outputEarFileName = null;
    private Preferences preferences = new Preferences();
    private boolean verbose = true;
    static /* synthetic */ Class class$com$ibm$ws$management$application$dfltbndngs$BindEar;

    public static void main(String[] stringArray) {
        BindEar bindEar = new BindEar();
        bindEar.processArgs(stringArray);
        try {
            bindEar.bind();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.application.dfltbndngs.BindEar.main", (String)"118");
            exception.printStackTrace();
        }
    }

    public BindEar() {
        try {
            this.nlsBundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.BindEarNLS");
            this.copyright();
            this.initializeMOF();
            this.ready = true;
        }
        catch (MissingResourceException missingResourceException) {
            FFDCFilter.processException((Throwable)missingResourceException, (String)"com.ibm.ws.management.application.dfltbndngs.BindEar.BindEar", (String)"136", (Object)this);
            System.err.println("Unable to Find NLS Resources: " + missingResourceException.getMessage());
            this.ready = false;
        }
    }

    void initializeMOF() {
    }

    void copyright() {
        System.out.println(this.nlsBundle.getString("product.header"));
        System.out.println(this.nlsBundle.getString("tool.header"));
        System.out.println(this.nlsBundle.getString("ibm.copyright"));
        System.out.println("");
    }

    void usage() {
        System.err.println("");
        System.err.println(this.nlsBundle.getString("usage.main"));
        System.err.println(this.nlsBundle.getString("usage.dbUser"));
        System.err.println(this.nlsBundle.getString("usage.dbPassword"));
        System.err.println(this.nlsBundle.getString("usage.defaultConnFact"));
        System.err.println(this.nlsBundle.getString("usage.defaultDataSource"));
        System.err.println(this.nlsBundle.getString("usage.ejbJndiPrefix"));
        System.err.println(this.nlsBundle.getString("usage.forceBindings"));
        System.err.println(this.nlsBundle.getString("usage.resAuth"));
        for (int i = 0; i < Preferences.RES_AUTH.length; ++i) {
            System.err.println("\t  " + Preferences.RES_AUTH[i]);
        }
        System.err.println(this.nlsBundle.getString("usage.strategy"));
        System.err.println(this.nlsBundle.getString("usage.validate"));
        System.err.println(this.nlsBundle.getString("usage.virtualHost"));
    }

    void processArgs(String[] stringArray) {
        String string;
        String string2;
        if (System.getProperty("DEBUG_MODE") != null && System.getProperty("DEBUG_MODE").equalsIgnoreCase(this.nlsBundle.getString("answer.true"))) {
            this.debugMode = true;
        }
        Vector<String> vector = new Vector<String>(1);
        String[] stringArray2 = new String[]{"dbpassword", "dbuser", "defaultdatasource", "defaultconnectionfactory", "defaultresauth", "ear", "ejbJndiPrefix", "forcebindings", "output", "resauth", "strategy", "validate", "virtualhost"};
        for (int i = 0; i < stringArray2.length; ++i) {
            vector.addElement(stringArray2[i]);
        }
        Hashtable hashtable = CommandLineUtils.parseCommandLineArgs(stringArray, true);
        if (hashtable == null) {
            System.err.println(this.nlsBundle.getString("invalid.num.arguments"));
            this.usage();
            this.ready = false;
            return;
        }
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string = (String)hashtable.get(string2);
            if (!string.equals("NO SUB-ARG")) continue;
            System.err.println(MessageFormat.format(this.nlsBundle.getString("no.sub.arg.error"), string2));
            System.err.println("");
            this.usage();
            this.ready = false;
            return;
        }
        try {
            CommandLineUtils.checkArguments(vector, hashtable, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.management.application.dfltbndngs.BindEar.processArgs", (String)"256", (Object)this);
            if (this.debugMode) {
                illegalArgumentException.printStackTrace();
            }
            System.err.println(MessageFormat.format(this.nlsBundle.getString("illegal.argument"), illegalArgumentException.getMessage()));
            this.usage();
            this.ready = false;
            return;
        }
        if (!hashtable.containsKey("ear") || !hashtable.containsKey("output")) {
            System.err.println(this.nlsBundle.getString("required.command.missing"));
            this.usage();
            this.ready = false;
            return;
        }
        this.setEarFileName((String)hashtable.get("ear"));
        this.setOutputFile((String)hashtable.get("output"));
        this.getPreferences().setDefaultDataSourceJndiName((String)hashtable.get("defaultdatasource"));
        this.getPreferences().setDefaultDataSourceUser((String)hashtable.get("dbuser"));
        this.getPreferences().setDefaultDataSourcePassword((String)hashtable.get("dbpassword"));
        this.getPreferences().setStrategyFile((String)hashtable.get("strategy"));
        this.getPreferences().setDefaultConnectionFactoryJndiName((String)hashtable.get("defaultconnectionfactory"));
        this.getPreferences().setDefaultConnectionFactoryResAuth((String)hashtable.get("resauth"));
        string2 = (String)hashtable.get("ejbjndiprefix");
        if (string2 != null) {
            this.getPreferences().setEjbJndiPrefix(string2);
        }
        if ((string = (String)hashtable.get("virtualhost")) != null) {
            this.getPreferences().setVirtualHost(string);
        }
        File file = null;
        if (this.getEarFileName() != null) {
            file = new File(this.getEarFileName());
            try {
                this.setEarFileName(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.application.dfltbndngs.BindEar.processArgs", (String)"313", (Object)this);
                this.setEarFileName(file.getAbsolutePath());
            }
        }
        if (this.getOutputFile() != null) {
            file = new File(this.getOutputFile());
            try {
                this.setOutputFile(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.application.dfltbndngs.BindEar.processArgs", (String)"324", (Object)this);
                this.setOutputFile(file.getAbsolutePath());
            }
        }
        this.getPreferences().setForceBindings(this.processBoolean(hashtable, "forcebindings", false, "invalid.forcebindings"));
    }

    boolean processBoolean(Hashtable hashtable, String string, boolean bl, String string2) {
        boolean bl2 = bl;
        try {
            bl2 = this.calcBoolean((String)hashtable.get(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.management.application.dfltbndngs.BindEar.processBoolean", (String)"342", (Object)this);
            System.err.println(MessageFormat.format(this.nlsBundle.getString(string2), illegalArgumentException.getMessage()));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            FFDCFilter.processException((Throwable)noSuchFieldException, (String)"com.ibm.ws.management.application.dfltbndngs.BindEar.processBoolean", (String)"346", (Object)this);
        }
        return bl2;
    }

    void log(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }

    boolean calcBoolean(String string) throws IllegalArgumentException, NoSuchFieldException {
        if (string != null) {
            if (string.equalsIgnoreCase(this.nlsBundle.getString("answer.true")) || string.equalsIgnoreCase(this.nlsBundle.getString("answer.t")) || string.equalsIgnoreCase(this.nlsBundle.getString("answer.yes")) || string.equalsIgnoreCase(this.nlsBundle.getString("answer.y"))) {
                return true;
            }
            if (string.equalsIgnoreCase(this.nlsBundle.getString("answer.false")) || string.equalsIgnoreCase(this.nlsBundle.getString("answer.f")) || string.equalsIgnoreCase(this.nlsBundle.getString("answer.no")) || string.equalsIgnoreCase(this.nlsBundle.getString("answer.n"))) {
                return false;
            }
            throw new IllegalArgumentException(string);
        }
        throw new NoSuchFieldException();
    }

    public void bind() throws Exception {
        if (this.ready) {
            System.out.println(this.getPreferences().toString());
            this.loadEarFile();
            this.bindEarFile();
            this.saveEarFile();
        }
    }

    void loadEarFile() throws Exception {
        try {
            this.log(MessageFormat.format(this.nlsBundle.getString("loading"), this.getEarFileName()));
            ArchiveInit.init();
            CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            this.originalArchive = commonarchiveFactory.openArchive(this.getEarFileName());
            if (this.originalArchive.isEARFile()) {
                this.inputEar = (EARFile)this.originalArchive;
                this.inputEar.rollUpRoles();
            } else if (this.originalArchive.isWARFile()) {
                this.wrapWarFile((WARFile)this.originalArchive);
            } else if (this.originalArchive.isEJBJarFile()) {
                this.wrapEjbJarFile((EJBJarFile)this.originalArchive);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.application.dfltbndngs.BindEar.loadEarFile", (String)"402", (Object)this);
            this.log(MessageFormat.format(this.nlsBundle.getString("load.exception"), exception.toString()));
            throw exception;
        }
    }

    EJBJarFile getEjbJar(EARFile eARFile) {
        List list = eARFile.getEJBJarFiles();
        return (EJBJarFile)list.get(0);
    }

    void wrapWarFile(WARFile wARFile) throws Exception {
        File file = new File(this.getEarFileName());
        String string = wARFile.getName();
        String string2 = "/";
        WrapModuleInEARCmd wrapModuleInEARCmd = new WrapModuleInEARCmd((ModuleFile)wARFile, this.getEarFileName(), file.getParent(), null, string2, false, string);
        wrapModuleInEARCmd.execute();
        Collection collection = wrapModuleInEARCmd.getResult();
        this.inputEar = (EARFile)collection.iterator().next();
        this.log(MessageFormat.format(this.nlsBundle.getString("created.war.wrapper"), this.inputEar.getAbsolutePath(), this.getEarFileName()));
        this.setEarFileName(this.inputEar.getName());
    }

    void wrapEjbJarFile(EJBJarFile eJBJarFile) throws Exception {
        File file = new File(this.getEarFileName());
        String string = eJBJarFile.getName();
        WrapModuleInEARCmd wrapModuleInEARCmd = new WrapModuleInEARCmd((ModuleFile)eJBJarFile, this.getEarFileName(), file.getParent(), null, false);
        wrapModuleInEARCmd.execute();
        Collection collection = wrapModuleInEARCmd.getResult();
        this.inputEar = (EARFile)collection.iterator().next();
        this.log(MessageFormat.format(this.nlsBundle.getString("created.ejbjar.wrapper"), this.inputEar.getName(), this.getEarFileName()));
        this.setEarFileName(this.inputEar.getName());
    }

    void saveEarFile() throws Exception {
        try {
            this.log(this.nlsBundle.getString("saved.ear.to.directory"));
            File file = new File(this.getEarFileName());
            File file2 = new File(this.outputEarFileName);
            if (file.equals(file2)) {
                if (this.outputEarFileName.endsWith(".jar") || this.outputEarFileName.endsWith(".war")) {
                    this.getEjbJar(this.inputEar).save();
                } else {
                    this.inputEar.save();
                }
            } else if (this.outputEarFileName.endsWith(".jar") || this.outputEarFileName.endsWith(".war")) {
                this.getEjbJar(this.inputEar).saveAs(this.outputEarFileName);
            } else {
                this.inputEar.saveAs(this.outputEarFileName);
            }
            this.inputEar.close();
            this.log(this.nlsBundle.getString("saved.ear.to.directory.success"));
        }
        catch (SaveFailureException saveFailureException) {
            FFDCFilter.processException((Throwable)saveFailureException, (String)"com.ibm.ws.management.application.dfltbndngs.BindEar.saveEarFile", (String)"481", (Object)this);
            System.err.println(MessageFormat.format(this.nlsBundle.getString("saved.ear.to.directory.failed"), saveFailureException.getNestedException().getMessage()));
            if (this.debugMode) {
                saveFailureException.printStackTrace();
            }
            throw saveFailureException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.application.dfltbndngs.BindEar.saveEarFile", (String)"488", (Object)this);
            System.err.println(MessageFormat.format(this.nlsBundle.getString("saved.ear.to.directory.failed"), exception.getMessage()));
            if (this.debugMode) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    void bindEarFile() throws Exception {
        try {
            BindEarCmd bindEarCmd = null;
            bindEarCmd = new BindEarCmd(this.inputEar, this.getPreferences());
            if (!bindEarCmd.bind()) {
                Iterator iterator = bindEarCmd.getWarnings().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    System.out.println("WARNING: " + string);
                }
            }
            this.showBindings(this.inputEar);
        }
        catch (BindingError bindingError) {
            FFDCFilter.processException((Throwable)bindingError, (String)"com.ibm.ws.management.application.dfltbndngs.BindEar.bindEarFile", (String)"514", (Object)this);
            System.err.println("FATAL ERROR: couldnt bind:");
            bindingError.printStackTrace();
            throw bindingError;
        }
    }

    void showBindings(EARFile eARFile) {
        ShowBindingsCmd showBindingsCmd = new ShowBindingsCmd(eARFile, System.out);
        showBindingsCmd.execute();
    }

    public String getEarFileName() {
        return this.earFileName;
    }

    public void setEarFileName(String string) {
        this.earFileName = string;
    }

    public String getOutputFile() {
        return this.outputEarFileName;
    }

    public void setOutputFile(String string) {
        this.outputEarFileName = string;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

