/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.application.dfltbndngs.BindingStrategy;
import com.ibm.ws.management.application.dfltbndngs.ConnectionFactoryBinding;
import com.ibm.ws.management.application.dfltbndngs.DOMParser;
import com.ibm.ws.management.application.dfltbndngs.DataSourceBinding;
import com.ibm.ws.management.application.dfltbndngs.DefaultStrategy;
import com.ibm.ws.management.application.dfltbndngs.EjbId;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CustomizeableStrategy
extends DefaultStrategy {
    static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$application$dfltbndngs$CustomizeableStrategy == null ? (class$com$ibm$ws$management$application$dfltbndngs$CustomizeableStrategy = CustomizeableStrategy.class$("com.ibm.ws.management.application.dfltbndngs.CustomizeableStrategy")) : class$com$ibm$ws$management$application$dfltbndngs$CustomizeableStrategy), null, (String)"com.ibm.ws.management.resources.BindEarCmd");
    public static final String CONNFACT = "connection-factory";
    public static final String DATASOURCE = "data-source";
    public static final String EJB_BINDING = "ejb-binding";
    public static final String EJB_BINDINGS = "ejb-bindings";
    public static final String EJB_JAR_BINDING = "ejb-jar-binding";
    public static final String JAR_NAME = "jar-name";
    public static final String EJB_NAME = "ejb-name";
    public static final String GLOBAL_BINDINGS = "global-bindings";
    public static final String JAVA_BINDING = "java-binding";
    public static final String JNDI_NAME = "jndi-name";
    public static final String LISTERNER_PORT = "listener-port";
    public static final String MODULE_BINDINGS = "module-bindings";
    public static final String PASSWORD = "password";
    public static final String RESAUTH = "res-auth";
    public static final String RESOURCE_ENV_REF = "resource-env-ref-binding";
    public static final String RESOURCE_ENV_REFS = "resource-env-ref-bindings";
    public static final String RESOURCE_ENV_REF_NAME = "resource-env-ref-name";
    public static final String RESOURCE_REF = "resource-ref-binding";
    public static final String RESOURCE_REFS = "resource-ref-bindings";
    public static final String RESOURCE_REF_NAME = "resource-ref-name";
    public static final String USER = "user";
    public static final String VIRTUAL_HOST = "virtual-host";
    public static final String WAR_BINDING = "war-binding";
    private String _dataSourceJndiName = null;
    private String _ejbJarName = null;
    private String _ejbName = null;
    private String _jndiName = null;
    private String _password = null;
    private String _resourceRefName = null;
    private String _user = null;
    private boolean _verbose = true;
    private boolean _debugMode = false;
    private Hashtable _datasourceMap = new Hashtable();
    private Hashtable _connectionFactoryMap = new Hashtable();
    private Hashtable _resourceRefMap = new Hashtable();
    private Hashtable _resourceEnvRefMap = new Hashtable();
    private Hashtable _ejbBindingMap = new Hashtable();
    private Hashtable _virtualHostMap = new Hashtable();
    private DataSourceBinding _globalDataSourceBinding = null;
    private ConnectionFactoryBinding _globalConnectionFactoryBinding = null;
    private String _globalVirtualHost = null;
    static /* synthetic */ Class class$com$ibm$ws$management$application$dfltbndngs$CustomizeableStrategy;

    public CustomizeableStrategy() {
    }

    public CustomizeableStrategy(Preferences preferences) {
        super(preferences);
    }

    public String toString() {
        return "CustomizeableStrategy{ prefs=" + this.preferences + ", ... }";
    }

    public void parse(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parse", (Object)new Object[]{"docuri=" + string});
        }
        DOMParser dOMParser = new DOMParser();
        FileInputStream fileInputStream = new FileInputStream(string);
        InputSource inputSource = new InputSource(fileInputStream);
        Document document = dOMParser.parse(inputSource);
        Node node = null;
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            node = nodeList.item(i);
            break;
        }
        this.parseGlobalBindings(dOMParser, node);
        Node node2 = dOMParser.findChild(node, MODULE_BINDINGS);
        this.parseEjbJarBindings(dOMParser, node2);
        this.parseWarBindings(dOMParser, node2);
        this.parseAppClientBindings(dOMParser, node2);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parse -  global DS info: " + this._globalDataSourceBinding));
            Tr.debug((TraceComponent)tc, (String)("parse - data source map: " + this._datasourceMap.toString()));
            Tr.debug((TraceComponent)tc, (String)("parse - resrce ref map : " + this._resourceRefMap.toString()));
            Tr.debug((TraceComponent)tc, (String)("parse - EJB bndngs map : " + this._ejbBindingMap.toString()));
        }
    }

    void parseGlobalBindings(DOMParser dOMParser, Node node) {
        String string;
        String string2;
        Object object;
        Node node2 = dOMParser.findChild(node, GLOBAL_BINDINGS);
        Node node3 = dOMParser.findChild(node2, DATASOURCE);
        if (node3 != null) {
            object = dOMParser.findValue(JNDI_NAME, node3, false);
            string2 = dOMParser.findValue(USER, node3, false);
            string = dOMParser.findValue(PASSWORD, node3, false);
            this.setDataSourceBinding(null, null, (String)object, string2, string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"parse - found global datasource", (Object)new Object[]{"jndi=" + (String)object, "user=" + string2, "pwd=" + string});
            }
        }
        if ((object = dOMParser.findChild(node2, CONNFACT)) != null) {
            string2 = dOMParser.findValue(JNDI_NAME, (Node)object, false);
            string = dOMParser.findValue(RESAUTH, (Node)object, false);
            this.setConnectionFactoryBinding(null, null, string2, string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"parse - found global connection factory", (Object)new Object[]{this._globalConnectionFactoryBinding});
            }
        }
        if ((string2 = dOMParser.findValue(VIRTUAL_HOST, node2, false)) != null) {
            this.setVirtualHost(null, string2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"parse - found global virtual host", (Object)new Object[]{this._globalVirtualHost});
            }
        }
    }

    void parseEjbJarBindings(DOMParser dOMParser, Node node) {
        Iterator iterator = dOMParser.findChildren(node, EJB_JAR_BINDING).iterator();
        while (iterator.hasNext()) {
            String string;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Iterator iterator2;
            Object object6;
            Object object7;
            Node node2;
            Node node3 = (Node)iterator.next();
            String string2 = dOMParser.findValue(JAR_NAME, node3, false);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"parse - found EJB jar binding", (Object)new Object[]{"ejbJarName=" + string2});
            }
            if ((node2 = dOMParser.findChild(node3, DATASOURCE)) != null) {
                object7 = dOMParser.findValue(JNDI_NAME, node2, false);
                object6 = dOMParser.findValue(USER, node2, false);
                iterator2 = dOMParser.findValue(PASSWORD, node2, false);
                this.setDataSourceBinding(string2, null, (String)object7, (String)object6, (String)((Object)iterator2));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"parse - found jar level data source", (Object)new Object[]{"jndi=" + (String)object7, "user=" + (String)object6, "password=" + iterator2});
                }
            }
            if ((object7 = dOMParser.findChild(node3, CONNFACT)) != null) {
                object6 = dOMParser.findValue(JNDI_NAME, (Node)object7, false);
                iterator2 = dOMParser.findValue(RESAUTH, (Node)object7, false);
                object5 = new ConnectionFactoryBinding((String)object6, (String)((Object)iterator2));
                this.setConnectionFactoryBinding(string2, null, (String)object6, (String)((Object)iterator2));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"parser - found jar level connection factory", (Object)new Object[]{object5});
                }
            }
            if ((object6 = dOMParser.findChild(node3, EJB_BINDINGS)) != null) {
                iterator2 = dOMParser.findChildren((Node)object6, EJB_BINDING).iterator();
                while (iterator2.hasNext()) {
                    Object object8;
                    Object object9;
                    Object object10;
                    Object object11;
                    Object object12;
                    object5 = (Node)iterator2.next();
                    object4 = dOMParser.findValue(EJB_NAME, (Node)object5, false);
                    object3 = dOMParser.findValue(JNDI_NAME, (Node)object5, false);
                    object2 = dOMParser.findChild((Node)object5, DATASOURCE);
                    object = dOMParser.findChild((Node)object5, CONNFACT);
                    string = dOMParser.findValue(LISTERNER_PORT, (Node)object5, false);
                    if (object3 != null) {
                        this.setEjbJndiName(string2, (String)object4, (String)object3);
                    }
                    if (string != null) {
                        this.setListenerPort(string2, (String)object4, string);
                    }
                    if (object2 != null) {
                        object12 = dOMParser.findValue(JNDI_NAME, (Node)object2, false);
                        object11 = dOMParser.findValue(USER, (Node)object2, false);
                        object10 = dOMParser.findValue(PASSWORD, (Node)object2, false);
                        this.setDataSourceBinding(string2, (String)object4, (String)object12, (String)object11, (String)object10);
                    }
                    if (object != null) {
                        object12 = dOMParser.findValue(JNDI_NAME, (Node)object, false);
                        object11 = dOMParser.findValue(RESAUTH, (Node)object, false);
                        this.setConnectionFactoryBinding(string2, (String)object4, (String)object12, (String)object11);
                    }
                    object12 = dOMParser.findChild((Node)object5, RESOURCE_REFS);
                    object11 = dOMParser.findChildren((Node)object12, RESOURCE_REF).iterator();
                    while (object11.hasNext()) {
                        object10 = (Node)object11.next();
                        object9 = dOMParser.findValue(RESOURCE_REF_NAME, (Node)object10, false);
                        object8 = dOMParser.findValue(JNDI_NAME, (Node)object10, false);
                        this.setResourceRefBinding(string2, (String)object4, (String)object9, (String)object8);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("parse - EJB jar resource ref: " + this.getResourceRefMapElement(string2, (String)object4, (String)object9, false).toString()));
                    }
                    object10 = dOMParser.findChild((Node)object5, RESOURCE_ENV_REFS);
                    object9 = dOMParser.findChildren((Node)object10, RESOURCE_ENV_REF).iterator();
                    while (object9.hasNext()) {
                        object8 = (Node)object9.next();
                        String string3 = dOMParser.findValue(RESOURCE_ENV_REF_NAME, (Node)object8, false);
                        String string4 = dOMParser.findValue(JNDI_NAME, (Node)object8, false);
                        this.setResourceEnvRefBinding(string2, (String)object4, string3, string4);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("parse - EJB jar resource env ref: " + this.getResourceEnvRefMapElement(string2, (String)object4, string3, false).toString()));
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"parse - EJB binding info: ", (Object)new Object[]{this.getEjbMapElement(string2, (String)object4, false).toString()});
                }
            }
            iterator2 = dOMParser.findChild(node3, RESOURCE_REFS);
            object5 = dOMParser.findChildren((Node)((Object)iterator2), RESOURCE_REF).iterator();
            while (object5.hasNext()) {
                object4 = (Node)object5.next();
                object3 = dOMParser.findValue(RESOURCE_REF_NAME, (Node)object4, false);
                object2 = dOMParser.findValue(JNDI_NAME, (Node)object4, false);
                this.setResourceRefBinding(string2, null, (String)object3, (String)object2);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("parse - EJB jar resource ref: " + this.getResourceRefMapElement(string2, null, (String)object3, false).toString()));
            }
            object4 = dOMParser.findChild(node3, RESOURCE_ENV_REFS);
            object3 = dOMParser.findChildren((Node)object4, RESOURCE_ENV_REF).iterator();
            while (object3.hasNext()) {
                object2 = (Node)object3.next();
                object = dOMParser.findValue(RESOURCE_ENV_REF_NAME, (Node)object2, false);
                string = dOMParser.findValue(JNDI_NAME, (Node)object2, false);
                this.setResourceEnvRefBinding(string2, null, (String)object, string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("parse - EJB jar resource env ref: " + this.getResourceEnvRefMapElement(string2, null, (String)object, false).toString()));
            }
        }
    }

    void parseWarBindings(DOMParser dOMParser, Node node) {
        Iterator iterator = dOMParser.findChildren(node, WAR_BINDING).iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            Node node2;
            String string3;
            Node node3 = (Node)iterator.next();
            String string4 = dOMParser.findValue(JAR_NAME, node3, false);
            Node node4 = dOMParser.findChild(node3, RESOURCE_REFS);
            Node node5 = dOMParser.findChild(node3, RESOURCE_ENV_REFS);
            Iterator iterator2 = dOMParser.findChildren(node4, RESOURCE_REF).iterator();
            Iterator iterator3 = dOMParser.findChildren(node5, RESOURCE_ENV_REF).iterator();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("parse - found .war bindings for " + string4));
            }
            if ((string3 = dOMParser.findValue(VIRTUAL_HOST, node3, false)) != null) {
                this.setVirtualHost(string4, string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"parse - war virtual host: ", (Object)string3);
                }
            }
            while (iterator2.hasNext()) {
                node2 = (Node)iterator2.next();
                string2 = dOMParser.findValue(RESOURCE_REF_NAME, node2, false);
                string = dOMParser.findValue(JNDI_NAME, node2, false);
                this.setResourceRefBinding(string4, null, string2, string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("parse - war resource ref info: " + this.getResourceRefMapElement(string4, null, string2, false).toString()));
            }
            while (iterator3.hasNext()) {
                node2 = (Node)iterator3.next();
                string2 = dOMParser.findValue(RESOURCE_ENV_REF_NAME, node2, false);
                string = dOMParser.findValue(JNDI_NAME, node2, false);
                this.setResourceEnvRefBinding(string4, null, string2, string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("parse - war resource env ref: " + this.getResourceEnvRefMapElement(string4, null, string2, false).toString()));
            }
        }
    }

    void parseAppClientBindings(DOMParser dOMParser, Node node) {
        Iterator iterator = dOMParser.findChildren(node, JAVA_BINDING).iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            Node node2;
            Node node3 = (Node)iterator.next();
            String string3 = dOMParser.findValue(JAR_NAME, node3, false);
            Node node4 = dOMParser.findChild(node3, RESOURCE_REFS);
            Iterator iterator2 = dOMParser.findChildren(node4, RESOURCE_REF).iterator();
            Node node5 = dOMParser.findChild(node3, RESOURCE_ENV_REFS);
            Iterator iterator3 = dOMParser.findChildren(node5, RESOURCE_ENV_REF).iterator();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("parse - found client bindings for " + string3));
            }
            while (iterator2.hasNext()) {
                node2 = (Node)iterator2.next();
                string2 = dOMParser.findValue(RESOURCE_REF_NAME, node2, false);
                string = dOMParser.findValue(JNDI_NAME, node2, false);
                this.setResourceRefBinding(string3, null, string2, string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("parse - client resource ref info: " + this.getResourceRefMapElement(string3, null, string2, false).toString()));
            }
            while (iterator3.hasNext()) {
                node2 = (Node)iterator3.next();
                string2 = dOMParser.findValue(RESOURCE_ENV_REF_NAME, node2, false);
                string = dOMParser.findValue(JNDI_NAME, node2, false);
                this.setResourceEnvRefBinding(string3, null, string2, string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("parse - client resource env ref: " + this.getResourceEnvRefMapElement(string3, null, string2, false).toString()));
            }
        }
    }

    public DataSourceBinding getDefaultDatasourceBindings(String string, DataSourceBinding dataSourceBinding, BindingStrategy.WarningCollaborator warningCollaborator) {
        DataSourceBinding dataSourceBinding2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultDatasourceBindings", (Object)new Object[]{"ejbJar=" + string, "defaults=" + dataSourceBinding});
        }
        if ((dataSourceBinding2 = (DataSourceBinding)this._datasourceMap.get(string)) == null) {
            dataSourceBinding2 = this._globalDataSourceBinding != null ? this._globalDataSourceBinding : super.getDefaultDatasourceBindings(string, dataSourceBinding, warningCollaborator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDefaultDatasourceBindings", (Object)new Object[]{"ejbJar=" + string, "defaults=" + dataSourceBinding, "result=" + dataSourceBinding2});
        }
        return dataSourceBinding2;
    }

    public ConnectionFactoryBinding getDefaultConnectionFactoryBindings(String string, ConnectionFactoryBinding connectionFactoryBinding, BindingStrategy.WarningCollaborator warningCollaborator) {
        ConnectionFactoryBinding connectionFactoryBinding2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultConnectionFactoryBindings", (Object)new Object[]{"ejbJar=" + string, "defaults=" + connectionFactoryBinding});
        }
        if ((connectionFactoryBinding2 = (ConnectionFactoryBinding)this._connectionFactoryMap.get(string)) == null) {
            connectionFactoryBinding2 = this._globalConnectionFactoryBinding != null ? this._globalConnectionFactoryBinding : super.getDefaultConnectionFactoryBindings(string, connectionFactoryBinding, warningCollaborator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDefaultConnectionFactoryBindings", (Object)new Object[]{"ejbJar=" + string, "defaults=" + connectionFactoryBinding, "result=" + connectionFactoryBinding2});
        }
        return connectionFactoryBinding2;
    }

    public String getEJBBinding(EjbId ejbId, String string, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEJBBinding", (Object)new Object[]{"ejbInfo=" + ejbId, "default=" + string});
        }
        String string2 = ejbId.getEjbName();
        String string3 = null;
        EjbBindingMapElement ejbBindingMapElement = (EjbBindingMapElement)this._ejbBindingMap.get(string2);
        if (ejbBindingMapElement != null && ejbBindingMapElement.jndiName != null) {
            this._ejbNameMap.setProperty(string2, ejbBindingMapElement.jndiName);
            if (ejbId.getHomeInterface() != null) {
                this._ejbHomeMap.setProperty(ejbId.getHomeInterface(), ejbBindingMapElement.jndiName);
            }
            if (ejbId.getLocalInterface() != null) {
                this._ejbHomeMap.setProperty(ejbId.getLocalInterface(), ejbBindingMapElement.jndiName);
            }
            string3 = ejbBindingMapElement.jndiName;
        } else {
            string3 = super.getEJBBinding(ejbId, string, warningCollaborator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEJBBinding", (Object)new Object[]{"ejbInfo=" + ejbId, "default=" + string, "result=" + string3});
        }
        return string3;
    }

    public ConnectionFactoryBinding getEJBConnectionFactoryBinding(EjbId ejbId, ConnectionFactoryBinding connectionFactoryBinding, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEJBConnectionFactoryBinding", (Object)new Object[]{"ejbInfo=" + ejbId, "defaults=" + connectionFactoryBinding});
        }
        ConnectionFactoryBinding connectionFactoryBinding2 = null;
        EjbBindingMapElement ejbBindingMapElement = (EjbBindingMapElement)this._ejbBindingMap.get(ejbId.getEjbName());
        connectionFactoryBinding2 = ejbBindingMapElement != null && ejbBindingMapElement.connFactInfo != null ? ejbBindingMapElement.connFactInfo : super.getEJBConnectionFactoryBinding(ejbId, connectionFactoryBinding, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEJBConnectionFactoryBinding", (Object)new Object[]{"ejbInfo=" + ejbId, "defaults=" + connectionFactoryBinding, "result=" + connectionFactoryBinding2});
        }
        return connectionFactoryBinding2;
    }

    public DataSourceBinding getEJBDatasourceBinding(EjbId ejbId, DataSourceBinding dataSourceBinding, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEJBDatasourceBinding", (Object)new Object[]{"ejbInfo=" + ejbId, "defaults=" + dataSourceBinding});
        }
        DataSourceBinding dataSourceBinding2 = null;
        EjbBindingMapElement ejbBindingMapElement = (EjbBindingMapElement)this._ejbBindingMap.get(ejbId.getEjbName());
        dataSourceBinding2 = ejbBindingMapElement != null && ejbBindingMapElement.dataSourceInfo != null ? new DataSourceBinding(ejbBindingMapElement.dataSourceInfo.jndiName, ejbBindingMapElement.dataSourceInfo.user, ejbBindingMapElement.dataSourceInfo.password) : super.getEJBDatasourceBinding(ejbId, dataSourceBinding, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEJBDatasourceBinding", (Object)new Object[]{"ejbInfo=" + ejbId, "defaults=" + dataSourceBinding, "result=" + dataSourceBinding2});
        }
        return dataSourceBinding2;
    }

    public String getMDBListenerPort(String string, String string2, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMDBListenerPort", (Object)new Object[]{"mdbName=" + string, "defaults=" + string2});
        }
        String string3 = null;
        EjbBindingMapElement ejbBindingMapElement = (EjbBindingMapElement)this._ejbBindingMap.get(string);
        string3 = ejbBindingMapElement != null && ejbBindingMapElement.listenerPort != null ? ejbBindingMapElement.listenerPort : super.getMDBListenerPort(string, string2, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMDBListenerPort", (Object)new Object[]{"mdbName=" + string, "defaults=" + string2, "result=" + string3});
        }
        return string3;
    }

    public String getVirtualHost(String string, String string2, BindingStrategy.WarningCollaborator warningCollaborator) {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getVirtualHost", (Object)new Object[]{"virtualHost=" + string});
        }
        if ((string3 = (String)this._virtualHostMap.get(string2)) == null) {
            String string4 = string3 = this._globalVirtualHost != null ? this._globalVirtualHost : super.getVirtualHost(string, string2, warningCollaborator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getVirtualHost", (Object)new Object[]{"virtualHost=" + string3});
        }
        return string3;
    }

    public String getResourceRefBinding(String string, String string2, String string3, String string4, String string5, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResourceRefBinding", (Object)new Object[]{"res-ref=" + string, "type=" + string2, "module=" + string3, "default=" + string5});
        }
        String string6 = null;
        ResourceRefMapElement resourceRefMapElement = this.getResourceRefMapElement(string3, string4, string, false);
        if (resourceRefMapElement == null && string4 != null) {
            resourceRefMapElement = this.getResourceRefMapElement(string3, null, string, false);
        }
        string6 = resourceRefMapElement != null ? resourceRefMapElement.jndiName : super.getResourceRefBinding(string, string2, string3, string4, string5, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResourceRefBinding", (Object)new Object[]{"res-ref=" + string, "type=" + string2, "module=" + string3, "default=" + string5, "result=" + string6});
        }
        return string6;
    }

    public String getResourceEnvRefBinding(String string, String string2, String string3, String string4, String string5, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResourceEnvRefBinding", (Object)new Object[]{"res-env-ref=" + string, "type=" + string2, "module=" + string3, "default=" + string5});
        }
        String string6 = null;
        ResourceRefMapElement resourceRefMapElement = this.getResourceEnvRefMapElement(string3, string4, string, false);
        if (resourceRefMapElement == null && string4 != null) {
            resourceRefMapElement = this.getResourceEnvRefMapElement(string3, null, string, false);
        }
        string6 = resourceRefMapElement != null ? resourceRefMapElement.jndiName : super.getResourceEnvRefBinding(string, string2, string3, string4, string5, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResourceEnvRefBinding", (Object)new Object[]{"res-env-ref=" + string, "type=" + string2, "module=" + string3, "default=" + string5, "result=" + string6});
        }
        return string6;
    }

    public void setDataSourceBinding(String string, String string2, String string3, String string4, String string5) {
        DataSourceBinding dataSourceBinding = new DataSourceBinding(string3, string4, string5);
        if (string != null) {
            if (string2 != null) {
                this.getEjbMapElement((String)string, (String)string2, (boolean)true).dataSourceInfo = new DataSourceMapElement(string3, string4, string5);
            } else {
                this._datasourceMap.put(string, dataSourceBinding);
            }
        } else {
            this._globalDataSourceBinding = dataSourceBinding;
        }
    }

    public void setConnectionFactoryBinding(String string, String string2, String string3, String string4) {
        ConnectionFactoryBinding connectionFactoryBinding = new ConnectionFactoryBinding(string3, string4);
        if (string != null) {
            if (string2 != null) {
                this.getEjbMapElement((String)string, (String)string2, (boolean)true).connFactInfo = new ConnectionFactoryBinding(string3, string4);
            } else {
                this._connectionFactoryMap.put(string, connectionFactoryBinding);
            }
        } else {
            this._globalConnectionFactoryBinding = connectionFactoryBinding;
        }
    }

    public void setVirtualHost(String string, String string2) {
        if (string != null) {
            this._virtualHostMap.put(string, string2);
        } else {
            this._globalVirtualHost = string2;
        }
    }

    public void setListenerPort(String string, String string2, String string3) {
        this.getEjbMapElement((String)string, (String)string2, (boolean)true).listenerPort = string3;
    }

    public void setEjbJndiName(String string, String string2, String string3) {
        this.getEjbMapElement((String)string, (String)string2, (boolean)true).jndiName = string3;
    }

    public void setEjbDatasource(String string, String string2, String string3, String string4, String string5) {
        this.getEjbMapElement((String)string, (String)string2, (boolean)true).dataSourceInfo = new DataSourceMapElement(string3, string4, string5);
    }

    public void setEjbConnectionFactory(String string, String string2, String string3, String string4) {
        this.getEjbMapElement((String)string, (String)string2, (boolean)true).connFactInfo = new ConnectionFactoryBinding(string3, string4);
    }

    public void setResourceRefBinding(String string, String string2, String string3, String string4) {
        this.getResourceRefMapElement((String)string, (String)string2, (String)string3, (boolean)true).jndiName = string4;
    }

    public void setResourceEnvRefBinding(String string, String string2, String string3, String string4) {
        this.getResourceEnvRefMapElement((String)string, (String)string2, (String)string3, (boolean)true).jndiName = string4;
    }

    EjbBindingMapElement getEjbMapElement(String string, String string2, boolean bl) {
        EjbBindingMapElement ejbBindingMapElement = (EjbBindingMapElement)this._ejbBindingMap.get(string2);
        if (ejbBindingMapElement == null && bl) {
            ejbBindingMapElement = new EjbBindingMapElement(null, null, null, null);
            this._ejbBindingMap.put(string2, ejbBindingMapElement);
        }
        return ejbBindingMapElement;
    }

    ResourceRefMapElement getResourceRefMapElement(String string, String string2, String string3, boolean bl) {
        String string4 = string + "-" + string2 + "-" + string3;
        ResourceRefMapElement resourceRefMapElement = (ResourceRefMapElement)this._resourceRefMap.get(string4);
        if (resourceRefMapElement == null && bl) {
            resourceRefMapElement = new ResourceRefMapElement(null);
            this._resourceRefMap.put(string4, resourceRefMapElement);
        }
        return resourceRefMapElement;
    }

    ResourceRefMapElement getResourceEnvRefMapElement(String string, String string2, String string3, boolean bl) {
        String string4 = string + "-" + string2 + "-" + string3;
        ResourceRefMapElement resourceRefMapElement = (ResourceRefMapElement)this._resourceEnvRefMap.get(string4);
        if (resourceRefMapElement == null && bl) {
            resourceRefMapElement = new ResourceRefMapElement(null);
            this._resourceEnvRefMap.put(string4, resourceRefMapElement);
        }
        return resourceRefMapElement;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class EjbBindingMapElement {
        public String jndiName = null;
        public DataSourceMapElement dataSourceInfo = null;
        public ConnectionFactoryBinding connFactInfo = null;
        public String listenerPort = null;

        public EjbBindingMapElement(String string, DataSourceMapElement dataSourceMapElement, ConnectionFactoryBinding connectionFactoryBinding, String string2) {
            this.jndiName = string;
            this.dataSourceInfo = dataSourceMapElement;
            this.connFactInfo = connectionFactoryBinding;
            this.listenerPort = string2;
        }

        public String toString() {
            return "{" + this.jndiName + "," + (this.dataSourceInfo != null ? this.dataSourceInfo.toString() : "{null}") + "," + this.connFactInfo + "," + this.listenerPort + "}";
        }
    }

    private class ResourceRefMapElement {
        public String jndiName = null;

        public ResourceRefMapElement(String string) {
            this.jndiName = string;
        }

        public String toString() {
            return "{" + this.jndiName + "}";
        }
    }

    private class DataSourceMapElement {
        public String jndiName = null;
        public String user = null;
        public String password = null;

        public DataSourceMapElement(String string, String string2, String string3) {
            this.jndiName = string;
            this.user = string2;
            this.password = string3;
        }

        public String toString() {
            return "{" + this.jndiName + "," + this.user + "," + this.password + "}";
        }
    }
}

