/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs.utils;

import com.ibm.etools.application.Application;
import com.ibm.etools.application.WebModule;
import com.ibm.etools.archive.exception.ArchiveRuntimeException;
import com.ibm.etools.archive.impl.ArchiveOptions;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.util.Collection;
import java.util.Vector;

public class WrapModuleInEARCmd {
    private EARFile _earFile;
    private ModuleFile _moduleFile;
    private String _earName;
    private String _directory;
    private String _contextRoot;
    private String _displayName;
    private boolean _isDirectory = false;
    private boolean _isEarFile = false;
    private boolean _closeFile = true;
    private String _alternateAppFileName;
    private String _jarName;
    private CommonarchiveFactory _factory = null;
    ArchiveOptions _archiveOptions = null;

    public WrapModuleInEARCmd(String string, String string2) throws Exception {
        this._jarName = string;
        this._directory = string2;
        this._closeFile = true;
        this.initializeFactories();
        File file = new File(string);
        this._isDirectory = file.isDirectory();
        try {
            Archive archive = this._factory.openArchive(this._archiveOptions, this._jarName);
            if (archive.isModuleFile()) {
                this._moduleFile = (ModuleFile)archive;
            } else {
                archive.close();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.application.dfltbndngs.utils.WrapModuleInEARCmd.WrapModuleInEARCmd", (String)"75", (Object)this);
            this.closeFiles();
            throw exception;
        }
    }

    public WrapModuleInEARCmd(ModuleFile moduleFile, String string, String string2) {
        this._jarName = string;
        this._directory = string2;
        this._closeFile = true;
        this._isDirectory = false;
        this._moduleFile = moduleFile;
        this.initializeFactories();
    }

    public void execute() throws Exception {
        try {
            if (this._moduleFile != null) {
                if (this._moduleFile.isEARFile()) {
                    this._earFile = (EARFile)this._moduleFile;
                    this._isEarFile = true;
                } else if (this._moduleFile.isModuleFile()) {
                    this.wrapModuleJar();
                } else {
                    this._earFile = null;
                }
            }
            this.closeFiles();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.application.dfltbndngs.utils.WrapModuleInEARCmd.execute", (String)"110", (Object)this);
            String string = "";
            if (exception != null) {
                string = this.PrintNestedArchiveExceptions(exception);
            }
            this.closeFiles();
            throw exception;
        }
    }

    public Collection getResult() {
        if (this._earFile == null) {
            return null;
        }
        Vector<EARFile> vector = new Vector<EARFile>(1);
        vector.addElement(this._earFile);
        return vector;
    }

    protected boolean prepare() {
        return true;
    }

    public WrapModuleInEARCmd(String string, String string2, String string3) throws Exception {
        this(string, string2);
        this._alternateAppFileName = string3;
    }

    public WrapModuleInEARCmd(String string, String string2, String string3, String string4) throws Exception {
        this(string, string2, string3);
        this._contextRoot = string4;
    }

    public WrapModuleInEARCmd(String string, String string2, String string3, String string4, String string5) throws Exception {
        this(string, string2, string3);
        this._contextRoot = string4;
        this._displayName = string5;
    }

    public WrapModuleInEARCmd(String string, String string2, String string3, boolean bl) throws Exception {
        this(string, string2);
        this._alternateAppFileName = string3;
        this._closeFile = bl;
    }

    public WrapModuleInEARCmd(String string, String string2, String string3, String string4, boolean bl) throws Exception {
        this(string, string2, string3);
        this._contextRoot = string4;
        this._closeFile = bl;
    }

    public WrapModuleInEARCmd(ModuleFile moduleFile, String string, String string2, String string3) {
        this(moduleFile, string, string2);
        this._alternateAppFileName = string3;
    }

    public WrapModuleInEARCmd(ModuleFile moduleFile, String string, String string2, String string3, String string4) {
        this(moduleFile, string, string2, string3);
        this._contextRoot = string4;
    }

    public WrapModuleInEARCmd(ModuleFile moduleFile, String string, String string2, String string3, boolean bl) {
        this(moduleFile, string, string2);
        this._alternateAppFileName = string3;
        this._closeFile = bl;
    }

    public WrapModuleInEARCmd(ModuleFile moduleFile, String string, String string2, String string3, boolean bl, String string4) {
        this(moduleFile, string, string2);
        this._alternateAppFileName = string3;
        this._closeFile = bl;
        this._displayName = string4;
    }

    public WrapModuleInEARCmd(ModuleFile moduleFile, String string, String string2, String string3, String string4, boolean bl) {
        this(moduleFile, string, string2, string3);
        this._contextRoot = string4;
        this._closeFile = bl;
    }

    public WrapModuleInEARCmd(ModuleFile moduleFile, String string, String string2, String string3, String string4, boolean bl, String string5) {
        this(moduleFile, string, string2, string3);
        this._contextRoot = string4;
        this._closeFile = bl;
        this._displayName = string5;
    }

    public String getEARFileName() {
        String string = null;
        if (this._isEarFile) {
            return this._jarName;
        }
        string = this._directory.endsWith("/") || this._directory.endsWith(File.separator) ? this._directory : this._directory + File.separator;
        if (this._alternateAppFileName != null && this._alternateAppFileName.length() > 0) {
            string = this._alternateAppFileName.endsWith(".ear") ? string + this._alternateAppFileName : string + this._alternateAppFileName + ".ear";
        } else {
            int n = this._jarName.lastIndexOf(".");
            int n2 = this._jarName.lastIndexOf(File.separator);
            String string2 = null;
            string2 = n > 0 ? (n2 < n - 1 ? this._jarName.substring(n2 + 1, n) : this._jarName.substring(0, n)) : this._jarName;
            string = string + string2;
            string = string + ".ear";
        }
        return string;
    }

    public String getDerivedApplicationName() {
        String string = null;
        if (this._alternateAppFileName != null && this._alternateAppFileName.length() > 0) {
            return this._alternateAppFileName;
        }
        int n = this._jarName.lastIndexOf(".");
        int n2 = this._jarName.lastIndexOf(File.separator);
        String string2 = null;
        string2 = n > 0 ? (n2 < n - 1 ? this._jarName.substring(n2 + 1, n) : this._jarName.substring(0, n)) : this._jarName;
        string = string2;
        return string;
    }

    private void initializeFactories() {
        this._factory = CommonarchiveFactoryImpl.getActiveFactory();
        this._archiveOptions = new ArchiveOptions();
    }

    protected void wrapModuleJar() throws Exception {
        try {
            File file;
            String string = this.getEARFileName();
            this._earFile = this._factory.createEARFileInitialized(string);
            Application application = this._earFile.getDeploymentDescriptor();
            if (this._displayName != null) {
                application.setDisplayName(this._displayName);
            } else {
                file = new File(this._jarName);
                application.setDisplayName(file.getName());
            }
            application.setDescription("Auto-Generated Wrapper EAR for Module " + this._jarName);
            file = this._earFile.addCopyRef(this._moduleFile);
            file.setURI(this._moduleFile.getName());
            if (file.isWeb()) {
                if (this._contextRoot != null && this._contextRoot.length() > 0) {
                    this._contextRoot = this._contextRoot.replace('\\', '/');
                    if (!this._contextRoot.startsWith("/")) {
                        this._contextRoot = "/" + this._contextRoot;
                    }
                } else {
                    this._contextRoot = "/" + this.getDerivedApplicationName();
                }
                WebModule webModule = (WebModule)file.getModule();
                webModule.setContextRoot(this._contextRoot);
            }
            this._earFile.rollUpRoles();
            this._earFile.save();
            this.closeFiles();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.application.dfltbndngs.utils.WrapModuleInEARCmd.wrapModuleJar", (String)"323", (Object)this);
            String string = "";
            if (exception != null) {
                string = this.PrintNestedArchiveExceptions(exception);
            }
            this.closeFiles();
            throw exception;
        }
    }

    protected String PrintNestedArchiveExceptions(Exception exception) {
        String string = "";
        Exception exception2 = exception;
        while (exception2 instanceof ArchiveRuntimeException) {
            string = string + "\n" + exception2.toString();
            if (((ArchiveRuntimeException)exception2).getNestedException() == null) continue;
            exception2 = ((ArchiveRuntimeException)exception2).getNestedException();
        }
        return string;
    }

    protected void closeFiles() {
        if (this._closeFile) {
            if (this._earFile != null) {
                this._earFile.close();
            }
            if (this._moduleFile != null) {
                this._moduleFile.close();
            }
        }
    }
}

