/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentPackage;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.sync.AppBinThread;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class AppBinaryProcessor
implements ConfigRepositoryListener,
NotificationListener {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$application$sync$AppBinaryProcessor == null ? (class$com$ibm$ws$management$application$sync$AppBinaryProcessor = AppBinaryProcessor.class$("com.ibm.ws.management.application.sync.AppBinaryProcessor")) : class$com$ibm$ws$management$application$sync$AppBinaryProcessor), (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CELLS_CONTEXT = "cells/";
    private static final String NODES_CONTEXT = "nodes/";
    private static final String DMGR = "dmgr";
    private static final long SYNC_ID = -1L;
    private static final Long BAD_ID = new Long(-2L);
    private ConfigRepository repository;
    private boolean isLocal;
    private ResourceBundle resBundle;
    private String cellName = null;
    private String nodeName = null;
    private boolean isInNodeSync = false;
    private Vector globalSyncQ = null;
    private Hashtable changeTable = null;
    static /* synthetic */ Class class$com$ibm$ws$management$application$sync$AppBinaryProcessor;

    public AppBinaryProcessor(Boolean bl, ConfigRepository configRepository) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("AppBinaryProcessor: " + bl));
        }
        this.isLocal = bl;
        this.repository = configRepository;
        this.resBundle = AppUtils.getBundle(null);
        this.changeTable = new Hashtable();
        NodeSync.addLocalSyncEventListener(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"AppBinaryProcessor");
        }
    }

    private void printTable(String string, long l, Hashtable hashtable) {
        if (tc.isDebugEnabled()) {
            if (hashtable == null) {
                Tr.debug((TraceComponent)tc, (String)("xxxxxxxxxxx " + string + ": " + l + " xxxxxxxxxx: NULL"));
                return;
            }
            Tr.debug((TraceComponent)tc, (String)("xxxxxxxxxxx " + string + ": " + l + " xxxxxxxxxx"));
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Tr.debug((TraceComponent)tc, (String)("---->" + k));
                Hashtable hashtable2 = (Hashtable)hashtable.get(k);
                Enumeration enumeration2 = hashtable2.keys();
                while (enumeration2.hasMoreElements()) {
                    Object k2 = enumeration2.nextElement();
                    Tr.debug((TraceComponent)tc, (String)("-------->" + k2));
                    Tr.debug((TraceComponent)tc, (String)("            " + hashtable2.get(k2)));
                }
                Tr.debug((TraceComponent)tc, (String)("---->End " + k));
            }
            Tr.debug((TraceComponent)tc, (String)("xxxxENDxxxx id: " + l + " xxxxENDxxxx"));
        }
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
        long l;
        long l2 = l = this.isInNodeSync ? -1L : configRepositoryEvent.getId();
        if (this.changeTable.get(new Long(l)) != null) {
            return;
        }
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            try {
                Hashtable hashtable = (Hashtable)this.changeTable.get(new Long(l));
                if (hashtable != null) {
                    return;
                }
                if (!this.shouldProcess(configChangeNotifierArray[i].getUri())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("process: " + configChangeNotifierArray[i].getUri() + " id=" + l));
                }
                this.createNodeInfo(configChangeNotifierArray[i].getUri());
                hashtable = new Hashtable();
                this.changeTable.put(new Long(l), hashtable);
                this.buildBin2AppRelation(hashtable, this.createVarMap());
                break;
            }
            catch (Throwable throwable) {
                Tr.warning((TraceComponent)tc, (String)"ADMA7000W", (Object)new Object[]{throwable});
            }
        }
        if (!this.isInNodeSync) {
            this.printTable("pre", l, (Hashtable)this.changeTable.get(new Long(l)));
        }
    }

    public void onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
        Vector<String> vector = null;
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            try {
                if (!this.shouldProcess(configChangeNotifierArray[i].getUri())) continue;
                if (this.isInNodeSync) {
                    if (this.globalSyncQ == null) {
                        this.globalSyncQ = new Vector();
                    }
                    vector = this.globalSyncQ;
                } else if (vector == null) {
                    vector = new Vector<String>();
                }
                vector.addElement(configChangeNotifierArray[i].getUri());
                vector.addElement((String)((Object)new Long(configChangeNotifierArray[i].getChangeType())));
                continue;
            }
            catch (Throwable throwable) {
                Tr.warning((TraceComponent)tc, (String)"ADMA7006E", (Object)new Object[]{throwable});
            }
        }
        if (!this.isInNodeSync) {
            this.postProcess(vector, configRepositoryEvent.getId(), true);
        }
    }

    public void onRepositoryEpochRefresh() {
    }

    public void handleNotification(Notification notification, Object object) {
        if (notification.getType().equals("websphere.nodesync.initiated")) {
            this.isInNodeSync = true;
        } else if (notification.getType().equals("websphere.nodesync.complete")) {
            Vector vector = this.globalSyncQ;
            this.isInNodeSync = false;
            this.globalSyncQ = null;
            this.printTable("pre", -1L, (Hashtable)this.changeTable.get(new Long(-1L)));
            if (notification.getUserData() != null && Boolean.TRUE.equals(notification.getUserData())) {
                this.postProcess(vector, -1L, this.isLocal);
            }
        }
    }

    private boolean shouldProcess(String string) throws Exception {
        try {
            String string2;
            String string3;
            int n;
            if (string.indexOf(CELLS_CONTEXT) == -1) {
                return false;
            }
            if (string.indexOf("applications") != -1 && (string.indexOf("deployments") != -1 ? string.endsWith("deployment.xml") : (n = (string3 = string.substring(string.indexOf("applications") + "applications".length() + 1)).indexOf("/")) != -1 && string3.startsWith(string2 = string3.substring(n + 1)))) {
                return true;
            }
            if (string.endsWith("variables.xml")) {
                return true;
            }
            if (this.isInNodeSync && !this.isLocal && string.endsWith(AdminServiceFactory.getAdminService().getNodeName() + "/serverindex.xml")) {
                return true;
            }
        }
        catch (Throwable throwable) {
            Tr.warning((TraceComponent)tc, (String)"ADMA7001W", (Object)new Object[]{string, throwable});
        }
        return false;
    }

    private void createNodeInfo(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createNodeInfo");
        }
        if (!this.isLocal) {
            this.cellName = AdminServiceFactory.getAdminService().getCellName();
            this.nodeName = AdminServiceFactory.getAdminService().getNodeName();
        } else if (this.isInNodeSync) {
            this.cellName = NodeSync.getNodeSync().getCellName();
            this.nodeName = NodeSync.getNodeSync().getNodeName();
        } else {
            this.cellName = string.substring(string.indexOf(CELLS_CONTEXT) + CELLS_CONTEXT.length());
            this.cellName = this.cellName.substring(0, this.cellName.indexOf(47));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cell: " + this.cellName));
            }
            Resource resource = this.getResource(CELLS_CONTEXT + this.cellName + "/" + "cell.xml", "cell.xml");
            Cell cell = (Cell)resource.getContents().get(0);
            WorkSpace workSpace = ConfigRepoHelper.getWorkSpace(null);
            RepositoryContext repositoryContext = AppUtils.findContext("cells", this.cellName, null, null, workSpace, true);
            if (cell.getCellType().getValue() == 1) {
                this.nodeName = this.getDmgrNodeName();
                if (this.nodeName == null) {
                    RepositoryContext repositoryContext2 = AppUtils.findContext("servers", DMGR, null, repositoryContext, workSpace, true);
                    if (repositoryContext2 == null) {
                        repositoryContext2 = AppUtils.findContext("servers", "netmgr", null, repositoryContext, workSpace, true);
                    }
                    if (repositoryContext2 == null) {
                        Object[] objectArray = AppUtils.getContextArray("servers", repositoryContext, workSpace);
                        repositoryContext2 = (RepositoryContext)objectArray[0];
                    }
                    this.nodeName = repositoryContext2.getParent().getName();
                }
            } else {
                Object[] objectArray = AppUtils.getContextArray("servers", repositoryContext, workSpace);
                this.nodeName = ((RepositoryContext)objectArray[0]).getParent().getName();
            }
            ConfigRepoHelper.removeWorkSpace(false, workSpace);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cell: " + this.cellName + ", node: " + this.nodeName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createNodeInfo");
        }
    }

    private VariableMap createVarMap() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createVarMap");
        }
        String string = (String)this.repository.getConfig().get("was.repository.root");
        VariableMap variableMap = AppUtils.createVarMap(string, this.cellName, this.nodeName, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createVarMap: " + variableMap));
        }
        return variableMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildBin2AppRelation(Hashtable hashtable, VariableMap variableMap) {
        Resource resource = this.getResource(CELLS_CONTEXT + this.cellName + "/" + NODES_CONTEXT + this.nodeName + "/serverindex.xml", "serverindex.xml");
        try {
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)eList.get(i);
                EList eList2 = serverEntry.getDeployedApplications();
                for (int j = 0; j < eList2.size(); ++j) {
                    this.buildCacheEntry(serverEntry.getServerName(), (String)eList2.get(j), hashtable, variableMap);
                }
            }
        }
        catch (Throwable throwable) {
            Tr.warning((TraceComponent)tc, (String)"ADMA7002E", (Object)new Object[]{throwable});
            hashtable.put(BAD_ID, new Hashtable());
        }
        finally {
            if (resource != null) {
                resource.unload();
            }
        }
    }

    private void buildCacheEntry(String string, String string2, Hashtable hashtable, VariableMap variableMap) throws Exception {
        Vector<String> vector;
        Hashtable<String, Vector<String>> hashtable2;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Building cache for: " + string2 + " for " + string));
        }
        int n = string2.indexOf(47);
        int n2 = string2.lastIndexOf(47);
        if (n2 <= n) {
            Tr.warning((TraceComponent)tc, (String)"ADMA7003E", (Object)new Object[]{string2});
            return;
        }
        String string3 = string2.substring(0, n);
        string3 = CELLS_CONTEXT + this.cellName + "/" + "applications" + "/" + string3 + "/" + string3;
        String string4 = string2.substring(n2 + 1);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Entry : binName: " + string3 + ", deplName: " + string4));
        }
        if ((hashtable2 = (Hashtable<String, Vector<String>>)hashtable.get(string3)) == null) {
            hashtable2 = new Hashtable<String, Vector<String>>();
            hashtable.put(string3, hashtable2);
        }
        if ((vector = (Vector<String>)hashtable2.get(string4)) == null) {
            Boolean bl;
            vector = new Vector<String>();
            String string5 = CELLS_CONTEXT + this.cellName + "/" + "applications" + "/" + string2 + "/deployment.xml";
            Resource resource = this.getResource(string5, "deployment.xml");
            if (resource == null) {
                System.out.println("AppBinaryProcessor: Config problem:  missing: " + string5 + "  for SI entry:   " + string2);
                Tr.warning((TraceComponent)tc, (String)("Config problem:  missing: " + string5 + "  for SI entry:   " + string2));
                if (hashtable2.size() == 0) {
                    System.out.println("AppBinaryProcessor: skipping: " + string3);
                    Tr.warning((TraceComponent)tc, (String)("Skipping: " + string3));
                    hashtable.remove(string3);
                }
                return;
            }
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(resource);
            String string6 = applicationDeployment.getBinariesURL();
            string6 = this.normalizePath(variableMap, string6);
            Boolean bl2 = applicationDeployment.eIsSet((EStructuralFeature)AppdeploymentPackage.eINSTANCE.getApplicationDeployment_EnableDistribution()) ? (applicationDeployment.isEnableDistribution() ? Boolean.TRUE : Boolean.FALSE) : (bl = Boolean.TRUE);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("binaryURL: " + string6 + ", isDistrib: " + bl));
            }
            resource.unload();
            vector.addElement(string6);
            vector.addElement((String)((Object)bl));
            hashtable2.put(string4, vector);
        }
        vector.addElement(string);
    }

    private Resource getResource(String string, String string2) {
        try {
            DocumentContentSource documentContentSource = this.repository.extract(string);
            WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
            URI uRI = URI.createURI((String)string2);
            Resource resource = wASResourceSetImpl.createResource(uRI);
            HashMap hashMap = new HashMap();
            resource.load(documentContentSource.getSource(), hashMap);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("res for: " + string + " is: " + resource));
            }
            return resource;
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)"ADMA7005E", (Object)new Object[]{string});
            return null;
        }
    }

    private String normalizePath(VariableMap variableMap, String string) {
        String string2 = variableMap.expand(string);
        string2 = string2.replace('/', File.separatorChar);
        string2 = string2.replace('\\', File.separatorChar);
        return string2;
    }

    public void postProcess(Vector vector, long l, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("postProcess: " + l + ", synchronous=: " + bl));
        }
        try {
            Hashtable hashtable = (Hashtable)this.changeTable.remove(new Long(l));
            if (vector == null || vector.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("postProcess NO: " + l));
                }
                return;
            }
            if (hashtable == null || hashtable.get(BAD_ID) != null) {
                if (tc.isEntryEnabled()) {
                    if (hashtable == null) {
                        Tr.debug((TraceComponent)tc, (String)"Error - oldTable is null. This means  changeStart events had no docs but changeComplete did.");
                    }
                    Tr.exit((TraceComponent)tc, (String)("postProcess  oldTable is null or BAD !!!! " + l));
                }
                return;
            }
            Hashtable hashtable2 = new Hashtable();
            this.buildBin2AppRelation(hashtable2, this.createVarMap());
            if (hashtable2.get(BAD_ID) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("postProcess  newTable is null or BAD !!!! " + l));
                }
                return;
            }
            this.printTable("post", l, hashtable2);
            if (hashtable2.size() == 0 && hashtable.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("postProcess  both old and new are of size 0. id=" + l));
                }
                return;
            }
            AppBinThread appBinThread = new AppBinThread(hashtable, hashtable2, vector, this.repository);
            appBinThread.setCellNode(this.cellName, this.nodeName);
            appBinThread.setLocal(this.isLocal);
            if (!bl) {
                Thread thread = new Thread(appBinThread);
                thread.start();
            } else {
                appBinThread.run();
            }
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)"ADMA7007E", (Object)new Object[]{throwable, new Long(l)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("postProcess: " + l));
        }
    }

    private String getDmgrNodeName() {
        block3: {
            String string = null;
            try {
                Vector vector = this.getNodes();
                for (int i = 0; i < vector.size(); ++i) {
                    Resource resource = this.getResource(CELLS_CONTEXT + this.cellName + "/" + NODES_CONTEXT + vector.elementAt(i) + "/serverindex.xml", "serverindex.xml");
                    if (resource == null) continue;
                    string = this.findDmgrName(resource);
                    resource.unload();
                    resource = null;
                    if (string == null) continue;
                    return (String)vector.elementAt(i);
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Problem getting the node name for the dmgr: " + throwable.getMessage()));
            }
        }
        return null;
    }

    private String findDmgrName(Resource resource) {
        EList eList = resource.getContents();
        ServerIndex serverIndex = null;
        for (int i = 0; i < eList.size(); ++i) {
            serverIndex = (ServerIndex)eList.get(i);
            EList eList2 = serverIndex.getServerEntries();
            for (int j = 0; j < eList2.size(); ++j) {
                ServerEntry serverEntry = (ServerEntry)eList2.get(j);
                String string = serverEntry.getServerType();
                if (!string.equals("DEPLOYMENT_MANAGER")) continue;
                return serverEntry.getServerName();
            }
        }
        return null;
    }

    private Vector getNodes() throws Exception {
        Vector<String> vector = new Vector<String>();
        String string = (String)this.repository.getConfig().get("was.repository.root");
        String string2 = string + "/cells/" + this.cellName + "/nodes";
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        String string3 = null;
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            string3 = fileArray[i].getName();
            vector.add(string3);
        }
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

