/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.Container;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appcfg.ModuleConfig;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ConfigRepoHelper {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$application$task$ConfigRepoHelper == null ? (class$com$ibm$ws$management$application$task$ConfigRepoHelper = ConfigRepoHelper.class$("com.ibm.ws.management.application.task.ConfigRepoHelper")) : class$com$ibm$ws$management$application$task$ConfigRepoHelper), (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String[] CONFIG_DIR = new String[]{"META-INF/"};
    private static final String[] WEBCONFIG_DIR = new String[]{"META-INF/", "WEB-INF/"};
    private static final String WSDL_EXT = ".wsdl";
    private static final String[] ALL_DIR = new String[]{"META-INF/wsdl/", "WEB-INF/wsdl/"};
    static /* synthetic */ Class class$com$ibm$ws$management$application$task$ConfigRepoHelper;

    public static boolean containsEList(EList eList, Object object) {
        if (object == null) {
            return false;
        }
        for (int i = 0; i < eList.size(); ++i) {
            if (!eList.get(i).equals(object)) continue;
            return true;
        }
        return false;
    }

    public static WorkSpace getWorkSpace(String string) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Init config and create workspace");
        }
        ConfigInit.init();
        RepositoryMetaDataFactory.initialize();
        AppdeploymentPackageImpl.init();
        String string2 = string;
        if (string2 == null) {
            string2 = "" + System.currentTimeMillis();
        }
        return WorkSpaceManagerFactory.getManager().getWorkSpace(string2);
    }

    public static void removeWorkSpace(boolean bl, WorkSpace workSpace) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeWorkSpace");
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sync workspace");
            }
            workSpace.synch(new HashMap());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"remove workspace");
        }
        String string = workSpace.getUserName();
        WorkSpaceManagerFactory.getManager().removeWorkSpace(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeWorkSpace");
        }
    }

    public static boolean checkIfZeroBinCopy(RepositoryContext repositoryContext) {
        return !repositoryContext.getParent().isAvailable(repositoryContext.getParent().getName());
    }

    public static EARFile getEarFileFromDeployment(WorkSpace workSpace, RepositoryContext repositoryContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEarFileFromWorkSpace");
        }
        if (ConfigRepoHelper.checkIfZeroBinCopy(repositoryContext)) {
            throw new AdminException("The application " + repositoryContext.getName() + " was installed using Zero Binary Copy option. Applications are installed" + " using this option in WSAD unit test environment or using AppManagement MBean API. " + " When an application is installed using this option it is not possible" + " to perform any operation on this application using wsadmin or admin console" + " that involves accessing the application metadata or EAR file.  Such operations" + " include view/edit application information, export, export DDL etc.  The only" + " possible operations using wsadmin or admin console are start, stop and uninstall. " + " If this application is installed using WSAD unit test environment then use WSAD to" + " view/edit application information.");
        }
        repositoryContext.extract(false);
        EARFile eARFile = AppInstallHelper.getEarFile(repositoryContext.getPath(), false, AppUtils.getBundle(null));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEarFileFromWorkSpace: " + eARFile));
        }
        if (eARFile == null) {
            throw new AdminException("Can not instantiate earfile for: " + repositoryContext.getName());
        }
        return eARFile;
    }

    public static void saveEarFileToDeployment(EARFile eARFile, RepositoryContext repositoryContext, String string) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"saveEarFileToDeployment");
        }
        ArrayList arrayList = new ArrayList();
        Collection collection = eARFile.getLoadedMofResources();
        ConfigRepoHelper.collectFiles(collection, arrayList, null);
        List list = eARFile.getModuleFiles();
        for (int i = 0; i < list.size(); ++i) {
            object = (Archive)list.get(i);
            ConfigRepoHelper.collectFiles(object.getLoadedMofResources(), arrayList, object.getURI());
        }
        Set set = repositoryContext.getFiles();
        object = string;
        if (!((String)object).endsWith(File.separator)) {
            object = (String)object + File.separator;
        }
        object = (String)object + "tmpsave." + System.currentTimeMillis();
        EarUtils.extractEar(eARFile, (String)object, false, 126);
        eARFile.close();
        File file = new File((String)object + File.separator + ".repositoryContext");
        if (file.exists()) {
            file.delete();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("deleted: " + file));
            }
        }
        if ((file = new File((String)object + File.separator + "deployment.xml")).exists()) {
            file.delete();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("deleted: " + file));
            }
        }
        EARFile eARFile2 = AppInstallHelper.getEarFile((String)object, false, AppUtils.getBundle(null));
        EarUtils.extractEar(eARFile2, repositoryContext.getPath(), false, 126);
        eARFile2.close();
        AppUtils.deleteDirTree((String)object);
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        object = repositoryContext.getPath() + File.separator;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!new File((String)object + e).exists()) continue;
            if (set.contains(e)) {
                arrayList3.add(e);
                continue;
            }
            arrayList2.add(e);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("xxx added files: " + arrayList2));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("xxx updated: " + arrayList3));
        }
        repositoryContext.notifyChanged(1, arrayList3);
        repositoryContext.notifyChanged(0, arrayList2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"saveEarFileToDeployment");
        }
    }

    private static void collectFiles(Collection collection, ArrayList arrayList, String string) throws Exception {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2 = (string == null ? "" : string + "/") + ((Resource)iterator.next()).getURI().toString();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Saving uri: " + string2));
            }
            arrayList.add(string2);
        }
    }

    public static EARFile getEarFileFromBinaries(RepositoryContext repositoryContext, WorkSpace workSpace, ResourceBundle resourceBundle, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEarFileFromBinaries: " + repositoryContext));
        }
        if (ConfigRepoHelper.checkIfZeroBinCopy(repositoryContext)) {
            throw new AdminException("The application " + repositoryContext.getName() + "was installed using zero binary copy option. Therefore it is not possible " + "to perform any operation on this application that involves accessing the " + "application metadata or EAR file.  The only possible operation is uninstall.");
        }
        EARFile eARFile = null;
        RepositoryContext repositoryContext2 = repositoryContext.getParent();
        try {
            repositoryContext.getParent().extract(repositoryContext2.getName(), false);
            eARFile = AppInstallHelper.getEarFile(repositoryContext2.getPath() + File.separator + repositoryContext2.getName(), false, resourceBundle);
        }
        catch (Throwable throwable) {
            if (eARFile == null && string == null) {
                throw new AdminException("Can not instantiate earfile for: " + repositoryContext2.getName());
            }
            AppUtils.dbg(tc, repositoryContext2.getName() + " file not found: " + throwable);
        }
        if (eARFile == null) {
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("appDepl: " + applicationDeployment));
            }
            String string2 = applicationDeployment.getBinariesURL();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("url: " + string2));
            }
            if (string2.indexOf("${") >= 0 || string2.indexOf("{(") >= 0) {
                VariableMap variableMap = AppUtils.createVarMap(repositoryContext, string);
                string2 = AppUtils.convert2AbsPath(string2, variableMap);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("abs-url: " + string2));
                }
            }
            try {
                eARFile = AppInstallHelper.getEarFile(string2, false, resourceBundle);
            }
            catch (Throwable throwable) {
                throw new AdminException(throwable, AppUtils.getMessage(resourceBundle, "ADMA5049E", new Object[]{repositoryContext.getName(), repositoryContext2.getName(), string2}));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEarFileFromBinaries: " + eARFile));
        }
        return eARFile;
    }

    public static List saveEarConfigDocs(String string, EARFile eARFile, ResourceBundle resourceBundle) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"saveEarConfigDocs");
        }
        LinkedList linkedList = new LinkedList();
        String string2 = string;
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        if (File.separatorChar != '/') {
            string2 = string2.replace('/', File.separatorChar);
        }
        ConfigRepoHelper.saveArchiveConfigDocs((Archive)eARFile, CONFIG_DIR, null, ALL_DIR, string2, null, linkedList, resourceBundle);
        EList eList = eARFile.getModuleRefs();
        for (int i = 0; i < eList.size(); ++i) {
            String[] stringArray;
            ModuleRef moduleRef = (ModuleRef)eList.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Saving docs for: " + moduleRef.getUri()));
            }
            ConfigRepoHelper.saveArchiveConfigDocs((Archive)moduleRef.getModuleFile(), moduleRef.isWeb() ? WEBCONFIG_DIR : CONFIG_DIR, WSDL_EXT, ALL_DIR, string2, moduleRef.getUri(), linkedList, resourceBundle);
            if (moduleRef.getAltDeploymentDescriptor() == null) continue;
            String string3 = moduleRef.getAltDeploymentDescriptor().eResource().getURI().toString();
            String string4 = string3.substring(0, string3.lastIndexOf(47) + 1);
            String string5 = moduleRef.getAltBindings().eResource().getURI().toString();
            String string6 = string5.substring(0, string5.lastIndexOf(47) + 1);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Saving alt docs from : " + string4 + " and binding: " + string6));
            }
            if (string6.trim().equals(string4)) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = string4;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = string4;
                stringArray = stringArray3;
                stringArray3[1] = string6;
            }
            ConfigRepoHelper.saveArchiveConfigDocs((Archive)eARFile, stringArray, null, null, string2, null, linkedList, resourceBundle);
        }
        return linkedList;
    }

    private static void saveArchiveConfigDocs(Archive archive, String[] stringArray, String string, String[] stringArray2, String string2, String string3, List list, ResourceBundle resourceBundle) throws Exception {
        String string4 = string2;
        if (string3 != null) {
            string4 = string4 + string3 + File.separator;
        }
        EList eList = archive.getFiles();
        for (int i = 0; i < eList.size(); ++i) {
            com.ibm.etools.commonarchive.File file = (com.ibm.etools.commonarchive.File)eList.get(i);
            if (file instanceof Container) continue;
            String string5 = file.getURI();
            if (!ConfigRepoHelper.fitsPattern(string5 = string5.replace('\\', '/'), stringArray, string, stringArray2)) continue;
            String string6 = (string3 == null ? "" : string3 + "/") + string5;
            if (list.contains(string6)) continue;
            InputStream inputStream = archive.getInputStream(string5);
            ConfigRepoHelper.save2File(inputStream, string4 + string5, resourceBundle);
            inputStream.close();
            AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6016I", new Object[]{string6}));
            list.add(string6);
        }
    }

    private static boolean fitsPattern(String string, String[] stringArray, String string2, String[] stringArray2) {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            if (!string.startsWith(stringArray[n]) || string.substring(stringArray[n].length()).indexOf(47) != -1) continue;
            return true;
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                if (!string.startsWith(stringArray2[n])) continue;
                return true;
            }
        }
        return string2 != null && string.endsWith(string2);
    }

    private static void save2File(InputStream inputStream, String string, ResourceBundle resourceBundle) throws Exception {
        byte[] byArray;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"save2File");
        }
        String string2 = string;
        if (File.separatorChar != '/') {
            string2 = string2.replace('/', File.separatorChar);
        }
        File file = new File(string2);
        file.getParentFile().mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        int n2 = inputStream.available();
        while (n2 > 0 && (n = inputStream.read(byArray = new byte[n2])) >= 1) {
            fileOutputStream.write(byArray, 0, n);
            n2 = inputStream.available();
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6017I", new Object[]{string2}));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"save2File");
        }
    }

    public static Resource getAppDeploymentResource(RepositoryContext repositoryContext) throws Exception {
        URI uRI = URI.createURI((String)"deployment.xml");
        Resource resource = repositoryContext.getResourceSet().createResource(uRI);
        HashMap hashMap = new HashMap();
        resource.load(hashMap);
        return resource;
    }

    public static ApplicationDeployment getAppDeploymentForApp(RepositoryContext repositoryContext) throws Exception {
        return ConfigRepoHelper.getAppDeploymentForApp(ConfigRepoHelper.getAppDeploymentResource(repositoryContext));
    }

    public static ApplicationDeployment getAppDeploymentForApp(Resource resource) throws Exception {
        Deployment deployment = (Deployment)resource.getContents().get(0);
        return (ApplicationDeployment)deployment.getDeployedObject();
    }

    public static Vector getServersForAppDeployment(ApplicationDeployment applicationDeployment, Vector vector, RepositoryContext repositoryContext, WorkSpace workSpace, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServersForAppDeployment");
        }
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < applicationDeployment.getModules().size(); ++i) {
            ModuleDeployment moduleDeployment = (ModuleDeployment)applicationDeployment.getModules().get(i);
            EList eList = moduleDeployment.getTargetMappings();
            for (int j = 0; j < eList.size(); ++j) {
                String string;
                DeploymentTarget deploymentTarget = ((DeploymentTargetMapping)eList.get(j)).getTarget();
                if (deploymentTarget == null) continue;
                if (deploymentTarget instanceof ClusteredTarget) {
                    string = AppUtils.findContext("clusters", deploymentTarget.getName(), null, repositoryContext, workSpace, true);
                    if (string == null) {
                        if (vector != null) {
                            if (vector.contains(deploymentTarget.getName())) continue;
                            vector.addElement(deploymentTarget.getName());
                            continue;
                        }
                        throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5027E", new Object[]{deploymentTarget.getName()}));
                    }
                    if (!vector2.contains(string)) {
                        vector2.addElement(string);
                    }
                }
                if (!(deploymentTarget instanceof ServerTarget)) continue;
                string = ((ServerTarget)deploymentTarget).getNodeName();
                RepositoryContext repositoryContext2 = AppUtils.findContext("servers", deploymentTarget.getName(), string, repositoryContext, workSpace, false);
                if (repositoryContext2 == null) {
                    if (vector != null) {
                        if (vector.contains(deploymentTarget.getName())) continue;
                        vector.addElement(deploymentTarget.getName());
                        continue;
                    }
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5028E", new Object[]{deploymentTarget.getName(), string}));
                }
                if (!bl && AppUtils.getClusterFromMember(AppUtils.findContext("servers", deploymentTarget.getName(), string, repositoryContext, workSpace, false), workSpace) != null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Ignoring  cluster member: " + deploymentTarget.getName()));
                    continue;
                }
                if (vector2.contains(repositoryContext2)) continue;
                vector2.addElement((String)repositoryContext2);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Server for appDepl: " + vector2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServersForAppDeployment");
        }
        return vector2;
    }

    public static Hashtable getNodeServerRelation(WorkSpace workSpace, Vector vector) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNodeServerRelation");
        }
        Hashtable hashtable = new Hashtable();
        Vector vector2 = ConfigRepoHelper.getAllServers(workSpace, vector);
        for (int i = 0; i < vector2.size(); ++i) {
            RepositoryContext repositoryContext = (RepositoryContext)vector2.elementAt(i);
            Vector<RepositoryContext> vector3 = (Vector<RepositoryContext>)hashtable.get(repositoryContext.getParent());
            if (vector3 == null) {
                vector3 = new Vector<RepositoryContext>();
                hashtable.put(repositoryContext.getParent(), vector3);
            }
            if (vector3.contains(repositoryContext)) continue;
            vector3.addElement(repositoryContext);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Node-server relation: " + hashtable));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getNodeServerRelation");
        }
        return hashtable;
    }

    public static Vector getAllServers(WorkSpace workSpace, Vector vector) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("orig svrs: " + vector));
        }
        if (vector.size() == 0) {
            return vector;
        }
        Vector<RepositoryContext> vector2 = new Vector<RepositoryContext>();
        for (int i = 0; i < vector.size(); ++i) {
            RepositoryContext repositoryContext = (RepositoryContext)vector.elementAt(i);
            if (AppUtils.isServer(repositoryContext) && !vector2.contains(repositoryContext)) {
                vector2.addElement(repositoryContext);
            }
            if (!AppUtils.isCluster(repositoryContext)) continue;
            URI uRI = URI.createURI((String)"cluster.xml");
            Resource resource = repositoryContext.getResourceSet().createResource(uRI);
            HashMap hashMap = new HashMap();
            resource.load(hashMap);
            ServerCluster serverCluster = (ServerCluster)resource.getContents().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Cluster obj: " + serverCluster));
            }
            EList eList = serverCluster.getMembers();
            for (int j = 0; j < eList.size(); ++j) {
                ClusterMember clusterMember = (ClusterMember)eList.get(j);
                RepositoryContext repositoryContext2 = AppUtils.findContext("servers", clusterMember.getMemberName(), clusterMember.getNodeName(), repositoryContext.getParent(), workSpace, false);
                if (repositoryContext2 == null) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5029E", new Object[]{clusterMember.getMemberName(), repositoryContext.getName()}));
                }
                if (vector2.contains(repositoryContext2)) continue;
                vector2.addElement(repositoryContext2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("ret svrs: " + vector2));
        }
        return vector2;
    }

    public static String getSIEntryText(RepositoryContext repositoryContext) {
        return repositoryContext.getParent().getName() + "/" + "deployments" + "/" + repositoryContext.getName();
    }

    public static RepositoryContext getAppContextFromSIEntry(String string, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getAppContextFromSIEntry:" + string));
        }
        int n = string.indexOf("/");
        int n2 = string.lastIndexOf("/");
        if (n == -1 || n2 == -1 || n == n2) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getAppContextFromSIEntry: Malformed si entry");
            }
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n2 + 1, string.length());
        RepositoryContext repositoryContext2 = AppUtils.findContext("deployments", string3, string2, repositoryContext, workSpace, false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getAppContextFromSIEntry:" + repositoryContext2));
        }
        return repositoryContext2;
    }

    public static String updateServerIndexDocs(RepositoryContext repositoryContext, WorkSpace workSpace, Vector vector, boolean bl, ResourceBundle resourceBundle) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("updateServerIndexDocs: " + vector));
        }
        Hashtable hashtable = ConfigRepoHelper.getNodeServerRelation(workSpace, vector);
        AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6018I", new Object[]{hashtable}));
        Hashtable hashtable2 = ConfigRepoHelper.getServerIndexDocs(workSpace, hashtable.keys());
        if (hashtable2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Server index docs not found!!");
            }
            return null;
        }
        Enumeration enumeration = hashtable.keys();
        boolean bl2 = true;
        String string = "";
        String string2 = ConfigRepoHelper.getSIEntryText(repositoryContext);
        try {
            while (enumeration.hasMoreElements()) {
                RepositoryContext repositoryContext2 = (RepositoryContext)enumeration.nextElement();
                Vector vector2 = (Vector)hashtable.get(repositoryContext2);
                Vector<String> vector3 = new Vector<String>();
                for (int i = 0; i < vector2.size(); ++i) {
                    vector3.addElement(((RepositoryContext)vector2.elementAt(i)).getName());
                }
                Resource resource = (Resource)hashtable2.get(repositoryContext2);
                ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                string = string + (bl2 ? "" : ", ") + repositoryContext2.getName();
                bl2 = false;
                EList eList = serverIndex.getServerEntries();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("servers for " + repositoryContext2.getName() + " are " + vector3));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("serversEntries for " + repositoryContext2.getName() + " are " + eList));
                }
                for (int i = 0; i < eList.size(); ++i) {
                    ServerEntry serverEntry = (ServerEntry)eList.get(i);
                    if (!vector3.contains(serverEntry.getServerName())) continue;
                    if (bl) {
                        EList eList2 = serverEntry.getDeployedApplications();
                        if (eList2.contains((Object)string2)) continue;
                        eList2.add((Object)string2);
                        AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6020I", new Object[]{repositoryContext, serverEntry.getServerName(), repositoryContext2.getName()}));
                        continue;
                    }
                    boolean bl3 = serverEntry.getDeployedApplications().remove((Object)string2);
                    AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6021I", new Object[]{string2, serverEntry.getServerName(), repositoryContext2.getName(), "" + bl3}));
                }
                HashMap hashMap = new HashMap();
                resource.save(hashMap);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("updateServerIndexDocs: " + string));
            }
            return string;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.task.ConfigRepoHelper.updateServerIndexDocs", (String)"124");
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, "Server Index update failed at  the last node of " + string);
        }
    }

    public static Hashtable getServerIndexDocs(WorkSpace workSpace, Enumeration enumeration) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerIndexDocs");
        }
        Hashtable<RepositoryContext, Resource> hashtable = new Hashtable<RepositoryContext, Resource>();
        while (enumeration.hasMoreElements()) {
            RepositoryContext repositoryContext = (RepositoryContext)enumeration.nextElement();
            URI uRI = URI.createURI((String)"serverindex.xml");
            Resource resource = repositoryContext.getResourceSet().createResource(uRI);
            HashMap hashMap = new HashMap();
            resource.load(hashMap);
            if (resource == null) {
                throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5031E", new Object[]{"serverindex.xml", repositoryContext}));
            }
            hashtable.put(repositoryContext, resource);
        }
        Tr.debug((TraceComponent)tc, (String)("retVal: " + hashtable));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerIndexDocs");
        }
        return hashtable;
    }

    public static String getDDUri(ModuleRef moduleRef) throws Exception {
        if (moduleRef.getAltDeploymentDescriptor() != null) {
            return moduleRef.getDeploymentDescriptor().eResource().getURI().toString();
        }
        if (moduleRef.isEJB()) {
            return "META-INF/ejb-jar.xml";
        }
        if (moduleRef.isWeb()) {
            return "WEB-INF/web.xml";
        }
        if (moduleRef.isConnector()) {
            return "META-INF/ra.xml";
        }
        return moduleRef.getDeploymentDescriptor().eResource().getURI().toString();
    }

    public static Hashtable getCNP(String string, ApplicationDeployment applicationDeployment, RepositoryContext repositoryContext, WorkSpace workSpace, EARFile eARFile) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCNP");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = false;
        Hashtable hashtable2 = ConfigRepoHelper.getModRef_vs_Deployment(string, applicationDeployment, workSpace, eARFile);
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            ModuleRef moduleRef = (ModuleRef)enumeration.nextElement();
            ModuleDeployment moduleDeployment = (ModuleDeployment)hashtable2.get(moduleRef);
            String string2 = ConfigRepoHelper.getCNP(workSpace, moduleDeployment, repositoryContext);
            hashtable.put(util.createUniqueModuleName(ConfigRepoHelper.getDDUri(moduleRef), moduleRef.getModule().getUri()), string2);
            bl = true;
        }
        if (!bl && string != null) {
            throw new AdminException("Unknown module: " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCNP: " + hashtable));
        }
        return hashtable;
    }

    public static Hashtable getModRef_vs_Deployment(String string, ApplicationDeployment applicationDeployment, WorkSpace workSpace, EARFile eARFile) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getModRefModDepl: " + string));
        }
        Hashtable<ModuleRef, ModuleDeployment> hashtable = new Hashtable<ModuleRef, ModuleDeployment>();
        String string2 = null;
        String string3 = null;
        if (string != null) {
            string2 = util.getModuleURIFromUniqueName(string);
            string3 = util.getDDURIFromUniqueName(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dURI: " + string3 + ", mURI: " + string2));
        }
        EList eList = eARFile.getModuleRefs();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleRef moduleRef = (ModuleRef)eList.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("modRef: " + moduleRef));
            }
            if (moduleRef.isClient()) continue;
            boolean bl = true;
            if (string != null && (bl = ConfigRepoHelper.matchModuleRef(string3, string2, moduleRef)) && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("found match: " + moduleRef));
            }
            if (!bl) continue;
            ModuleDeployment moduleDeployment = ConfigRepoHelper.getMDFromModuleRef(applicationDeployment, moduleRef);
            if (moduleDeployment == null) {
                throw new AdminException("Unknown module depl for: " + moduleRef);
            }
            hashtable.put(moduleRef, moduleDeployment);
            if (string != null) break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getModRefModDepl");
        }
        return hashtable;
    }

    public static boolean matchModuleRef(String string, String string2, ModuleRef moduleRef) throws Exception {
        if (!string2.equals(moduleRef.getUri())) {
            return false;
        }
        EObject eObject = moduleRef.getAltDeploymentDescriptor();
        if (eObject != null) {
            if (eObject.eResource().getURI().toString().equals(string)) {
                return true;
            }
        } else {
            if (AppUtils.isEmpty(string)) {
                return true;
            }
            if (ConfigRepoHelper.getDDUri(moduleRef).equals(string)) {
                return true;
            }
        }
        return false;
    }

    public static ModuleRef getModuleRef(EARFile eARFile, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getModuleRef: " + string + ", " + string2));
        }
        EList eList = eARFile.getModuleRefs();
        ModuleRef moduleRef = null;
        for (int i = 0; i < eList.size(); ++i) {
            ModuleRef moduleRef2 = (ModuleRef)eList.get(i);
            if (!ConfigRepoHelper.matchModuleRef(string2, string, moduleRef2)) continue;
            moduleRef = moduleRef2;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getModuleRef: " + moduleRef));
        }
        return moduleRef;
    }

    public static ModuleDeployment getMDFromModuleRef(ApplicationDeployment applicationDeployment, ModuleRef moduleRef) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getModuleDeplFromModuleRef" + moduleRef));
        }
        EList eList = applicationDeployment.getModules();
        for (int i = 0; i < eList.size(); ++i) {
            EObject eObject;
            ModuleDeployment moduleDeployment = (ModuleDeployment)eList.get(i);
            if (!moduleDeployment.getUri().equals(moduleRef.getUri()) || !(moduleDeployment.getAltDD() == null ? moduleRef.getAltDeploymentDescriptor() == null : (eObject = moduleRef.getAltDeploymentDescriptor()) != null && moduleDeployment.getAltDD().equals(eObject.eResource().getURI().toString()))) continue;
            return moduleDeployment;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getModuleDeplFromModuleRef: null");
        }
        return null;
    }

    public static String getCNP(WorkSpace workSpace, ModuleDeployment moduleDeployment, RepositoryContext repositoryContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCNP: " + moduleDeployment));
        }
        String string = "";
        EList eList = moduleDeployment.getTargetMappings();
        for (int i = 0; i < eList.size(); ++i) {
            DeploymentTargetMapping deploymentTargetMapping = (DeploymentTargetMapping)eList.get(i);
            RepositoryContext repositoryContext2 = null;
            if (deploymentTargetMapping.getTarget() instanceof ClusteredTarget) {
                repositoryContext2 = AppUtils.findContext("clusters", deploymentTargetMapping.getTarget().getName(), null, repositoryContext, workSpace, true);
            } else if (deploymentTargetMapping.getTarget() instanceof ServerTarget) {
                repositoryContext2 = AppUtils.findContext("servers", deploymentTargetMapping.getTarget().getName(), ((ServerTarget)deploymentTargetMapping.getTarget()).getNodeName(), repositoryContext, workSpace, false);
            }
            if (repositoryContext2 == null) continue;
            string = ConfigRepoHelper.getTargetString(repositoryContext2, string);
            if (deploymentTargetMapping.getConfig() == null) continue;
            string = string + ",config=" + ((ModuleConfig)deploymentTargetMapping.getConfig()).getName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCNP: " + string));
        }
        return string;
    }

    public static String getTargetString(RepositoryContext repositoryContext, String string) {
        String string2 = null;
        string2 = AppUtils.isCluster(repositoryContext) ? "WebSphere:cell=" + repositoryContext.getParent().getName() + ",cluster=" + repositoryContext.getName() : "WebSphere:cell=" + repositoryContext.getParent().getParent().getName() + ",node=" + repositoryContext.getParent().getName() + ",server=" + repositoryContext.getName();
        if (AppUtils.isEmpty(string)) {
            return string2;
        }
        return string + "+" + string2;
    }

    public static String getTargetString(ObjectName objectName, String string) {
        String string2 = "WebSphere:cell=" + objectName.getKeyProperty("cell") + ",node=" + objectName.getKeyProperty("node") + ",server=" + objectName.getKeyProperty("process");
        if (AppUtils.isEmpty(string)) {
            return string2;
        }
        return string + "+" + string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

