/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.ResourcesFactory;
import com.ibm.ejs.models.base.resources.ResourcesPackage;
import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.models.base.resources.j2c.J2cFactory;
import com.ibm.ejs.models.base.resources.j2c.J2cPackage;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.application.Module;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.init.ArchiveInit;
import com.ibm.etools.jca.ConfigProperty;
import com.ibm.etools.jca.Connector;
import com.ibm.etools.jca.ResourceAdapter;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appcfg.AppcfgFactory;
import com.ibm.websphere.models.config.appcfg.AppcfgPackage;
import com.ibm.websphere.models.config.appcfg.impl.AppcfgPackageImpl;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentFactory;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentPackage;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ConnectorModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.DeployedObject;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.EJBModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.WebModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebcontainerFactory;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebcontainerPackage;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppAssociation;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppDeploymentProfile;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public class ConfigureTask
extends AbstractTask {
    private static final int RAR_WEIGHT = 1000;
    private static final int JAR_WEIGHT = 5000;
    private static final int WAR_WEIGHT = 10000;
    protected AppdeploymentFactory appFactory;
    protected AppcfgFactory appCfgFactory;
    protected WebcontainerFactory webContainerFactory;
    protected J2cFactory j2cFactory;
    protected ResourcesFactory resourceFactory;
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$application$task$ConfigureTask == null ? (class$com$ibm$ws$management$application$task$ConfigureTask = ConfigureTask.class$("com.ibm.ws.management.application.task.ConfigureTask")) : class$com$ibm$ws$management$application$task$ConfigureTask), null, (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    static /* synthetic */ Class class$com$ibm$ws$management$application$task$ConfigureTask;

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performTask");
        }
        InstallScheduler installScheduler = (InstallScheduler)this.scheduler;
        try {
            this.createFactories();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Init all the factories");
            }
            Deployment deployment = this.createDeployment();
            RepositoryContext repositoryContext = installScheduler.getCellContext();
            RepositoryContext repositoryContext2 = AppUtils.findContext("applications", AppUtils.getAppBinDirName(installScheduler), repositoryContext.getName(), repositoryContext, installScheduler.getWorkSpace(), false);
            if (repositoryContext2 == null) {
                repositoryContext2 = repositoryContext.create(AppUtils.getContextType("applications"), AppUtils.getAppBinDirName(installScheduler));
            }
            RepositoryContext repositoryContext3 = repositoryContext2.create(AppUtils.getContextType("deployments"), installScheduler.getAppName());
            URI uRI = URI.createURI((String)"deployment.xml");
            Resource.Factory factory = installScheduler.getWorkSpace().getResourceFactoryRegistry().getFactory(uRI);
            Resource resource = factory.createResource(uRI);
            resource.getContents().add((Object)deployment);
            repositoryContext3.getResourceSet().getResources().add((Object)resource);
            HashMap hashMap = new HashMap();
            resource.save(hashMap);
            Vector vector = ConfigRepoHelper.getServersForAppDeployment((ApplicationDeployment)deployment.getDeployedObject(), null, installScheduler.getCellContext(), installScheduler.getWorkSpace(), false);
            ConfigRepoHelper.updateServerIndexDocs(repositoryContext3, installScheduler.getWorkSpace(), vector, true, this.getResourceBundle());
            if (!Boolean.TRUE.equals(installScheduler.getProperties().get("zeroBinaryCopy"))) {
                List list = ConfigRepoHelper.saveEarConfigDocs(repositoryContext3.getPath(), installScheduler.getEarFile(false, true), this.getResourceBundle());
                repositoryContext3.notifyChanged(0, list);
            }
            installScheduler.propagateTaskEvent(this.createNotification("Completed", "ADMA5005I", new String[]{installScheduler.getAppName()}));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"performTask");
            }
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.task.ConfigureTask.performTask", (String)"134", (Object)this);
            installScheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{installScheduler.getAppName(), throwable.toString()}));
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, AppUtils.getMessage(this.getResourceBundle(), "ADMA0066E"));
        }
    }

    private void createFactories() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createFactories");
        }
        ArchiveInit.init();
        CommonarchiveFactoryImpl.getActiveFactory();
        ConfigInit.init();
        AppdeploymentPackageImpl.init();
        AppcfgPackageImpl.init();
        AppdeploymentPackage appdeploymentPackage = (AppdeploymentPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appdeployment.xmi");
        this.appFactory = appdeploymentPackage.getAppdeploymentFactory();
        AppcfgPackage appcfgPackage = (AppcfgPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appcfg.xmi");
        this.appCfgFactory = appcfgPackage.getAppcfgFactory();
        WebcontainerPackage webcontainerPackage = (WebcontainerPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.webcontainer.xmi");
        this.webContainerFactory = webcontainerPackage.getWebcontainerFactory();
        J2cPackage j2cPackage = (J2cPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.j2c.xmi");
        this.j2cFactory = j2cPackage.getJ2cFactory();
        ResourcesPackage resourcesPackage = (ResourcesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.xmi");
        this.resourceFactory = resourcesPackage.getResourcesFactory();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createFactories");
        }
    }

    protected Deployment createDeployment() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createDeployments");
        }
        ApplicationDeployment applicationDeployment = this.appFactory.createApplicationDeployment();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("App Name: " + this.scheduler.getAppName()));
        }
        applicationDeployment.setDeploymentId("0");
        applicationDeployment.setStartingWeight(1);
        Deployment deployment = this.appFactory.createDeployment();
        deployment.setDeployedObject((DeployedObject)applicationDeployment);
        EList eList = ((InstallScheduler)this.scheduler).getEarFile(false, true).getModuleRefs();
        for (int i = 0; i < eList.size(); ++i) {
            this.createModuleDeployment((ModuleRef)eList.get(i), deployment);
        }
        AppDeploymentProfile.hash2Files(AppDeploymentProfile.OP_INSTALL, this.scheduler.getProperties(), applicationDeployment, this.scheduler);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createDeployments: " + deployment));
        }
        return deployment;
    }

    protected void createModuleDeployment(ModuleRef moduleRef, Deployment deployment) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createModuleDeployment " + moduleRef));
        }
        WebModuleDeployment webModuleDeployment = null;
        if (moduleRef.isWeb()) {
            webModuleDeployment = this.createWebModuleDeployment(moduleRef);
        }
        if (moduleRef.isEJB()) {
            webModuleDeployment = this.createEJBModuleDeployment(moduleRef);
        }
        if (moduleRef.isConnector()) {
            webModuleDeployment = this.createRARModuleDeployment(moduleRef);
        }
        if (webModuleDeployment != null) {
            ((ApplicationDeployment)deployment.getDeployedObject()).getModules().add((Object)webModuleDeployment);
            String string = util.createUniqueModuleName(ConfigRepoHelper.getDDUri(moduleRef), moduleRef.getModule().getUri());
            Hashtable hashtable = (Hashtable)this.scheduler.getProperties().get("moduleToServer");
            if (hashtable != null) {
                String string2 = this.getTargets(hashtable, string, moduleRef.getModule().getUri());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("key: " + string + " .. targets: " + string2));
                }
                AppAssociation.populateDeployTargets(deployment, (ModuleDeployment)webModuleDeployment, string2, string, this.scheduler.getCellContext(), this.scheduler.getWorkSpace(), this.appCfgFactory, this.appFactory);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Module-Server relation table passed to install API  is null - " + string));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Unknown module: " + moduleRef));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createDeploymentForModule " + webModuleDeployment));
        }
    }

    private String getTargets(Hashtable hashtable, String string, String string2) {
        String string3 = (String)hashtable.get(string);
        if (string3 != null) {
            return string3;
        }
        int n = string2.lastIndexOf(46);
        if (n != -1 && (string3 = (String)hashtable.get("*" + string2.substring(n))) != null) {
            return string3;
        }
        return (String)hashtable.get("*");
    }

    protected EJBModuleDeployment createEJBModuleDeployment(ModuleRef moduleRef) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createEJBModuleDeployment");
        }
        Module module = moduleRef.getModule();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("module: " + module));
        }
        EJBModuleDeployment eJBModuleDeployment = this.appFactory.createEJBModuleDeployment();
        eJBModuleDeployment.setUri(module.getUri());
        eJBModuleDeployment.setAltDD(module.getAltDD());
        eJBModuleDeployment.setDeploymentId("1");
        eJBModuleDeployment.setStartingWeight(5000);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createEJBModuleDeployment");
        }
        return eJBModuleDeployment;
    }

    protected ConnectorModuleDeployment createRARModuleDeployment(ModuleRef moduleRef) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createRARModuleDeployment");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("module: " + moduleRef));
        }
        ConnectorModuleDeployment connectorModuleDeployment = this.appFactory.createConnectorModuleDeployment();
        connectorModuleDeployment.setUri(moduleRef.getUri());
        connectorModuleDeployment.setAltDD(moduleRef.getModule().getAltDD());
        connectorModuleDeployment.setDeploymentId("1");
        connectorModuleDeployment.setStartingWeight(1000);
        Connector connector = (Connector)moduleRef.getDeploymentDescriptor();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("rar.name", this.scheduler.getAppName() + "." + connector.getDisplayName());
        String string = AppUtils.getAppInstallDir(this.scheduler) + File.separator + moduleRef.getUri();
        hashtable.put("rar.archivePath", string);
        J2CResourceAdapter j2CResourceAdapter = ConfigureTask.createJ2CResourceAdapter(this.j2cFactory, this.resourceFactory, connector, hashtable);
        connectorModuleDeployment.setResourceAdapter(j2CResourceAdapter);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createRARModuleDeployment");
        }
        return connectorModuleDeployment;
    }

    public static J2CResourceAdapter createJ2CResourceAdapter(J2cFactory j2cFactory, ResourcesFactory resourcesFactory, Connector connector, Hashtable hashtable) throws Exception {
        ResourceAdapter resourceAdapter;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createJ2CResourceAdapter");
        }
        J2CResourceAdapter j2CResourceAdapter = j2cFactory.createJ2CResourceAdapter();
        String string2 = (String)hashtable.get("rar.name");
        j2CResourceAdapter.setName(string2);
        String string3 = (String)hashtable.get("rar.archivePath");
        AppUtils.dbg(tc, "Archive path: " + string3);
        j2CResourceAdapter.setArchivePath(string3);
        String string4 = (String)hashtable.get("rar.desc");
        if (string4 != null) {
            j2CResourceAdapter.setDescription(string4);
        }
        String string5 = (String)hashtable.get("rar.classpath");
        j2CResourceAdapter.getClasspath().add((Object)string3);
        if (string5 != null) {
            ConfigureTask.addFromString(string5, j2CResourceAdapter.getClasspath());
        }
        if ((string = (String)hashtable.get("rar.nativePath")) != null) {
            ConfigureTask.addFromString(string, j2CResourceAdapter.getNativepath());
        }
        if ((resourceAdapter = connector.getResourceAdapter()).getConfigProperties() != null) {
            J2EEResourcePropertySet j2EEResourcePropertySet = resourcesFactory.createJ2EEResourcePropertySet();
            EList eList = resourceAdapter.getConfigProperties();
            for (int i = 0; i < eList.size(); ++i) {
                ConfigProperty configProperty = (ConfigProperty)eList.get(i);
                J2EEResourceProperty j2EEResourceProperty = resourcesFactory.createJ2EEResourceProperty();
                AppUtils.dbg("..... setting up resource property: " + configProperty.getName());
                j2EEResourceProperty.setName(configProperty.getName());
                j2EEResourceProperty.setType(configProperty.getType());
                j2EEResourceProperty.setValue(configProperty.getValue());
                j2EEResourceProperty.setDescription(configProperty.getDescription());
                j2EEResourcePropertySet.getResourceProperties().add((Object)j2EEResourceProperty);
            }
            j2CResourceAdapter.setPropertySet(j2EEResourcePropertySet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createJ2CResourceAdapter");
        }
        return j2CResourceAdapter;
    }

    private static void addFromString(String string, EList eList) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addFromString: " + string + " and " + eList));
        }
        if (string == null || eList == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (AppUtils.isEmpty(string2)) continue;
            eList.add((Object)string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addFromString: " + eList));
        }
    }

    protected WebModuleDeployment createWebModuleDeployment(ModuleRef moduleRef) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createWebModuleDeployment");
        }
        Module module = moduleRef.getModule();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("module: " + module));
        }
        WebModuleDeployment webModuleDeployment = this.appFactory.createWebModuleDeployment();
        webModuleDeployment.setUri(module.getUri());
        webModuleDeployment.setAltDD(module.getAltDD());
        webModuleDeployment.setDeploymentId("1");
        webModuleDeployment.setStartingWeight(10000);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createWebModuleDeployment");
        }
        return webModuleDeployment;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

