/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.deployment.deploywrapper.DeployOptions;
import com.ibm.ejs.util.deployment.deploywrapper.DeployUtil;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.etools.ejbdeploy.IStatusMonitor;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public class DeployEJBTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$application$task$DeployEJBTask == null ? (class$com$ibm$ws$management$application$task$DeployEJBTask = DeployEJBTask.class$("com.ibm.ws.management.application.task.DeployEJBTask")) : class$com$ibm$ws$management$application$task$DeployEJBTask), null, (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    static /* synthetic */ Class class$com$ibm$ws$management$application$task$DeployEJBTask;

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performTask");
        }
        InstallScheduler installScheduler = (InstallScheduler)this.scheduler;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Deploying EJBs .............");
        }
        StatusMonitorImpl statusMonitorImpl = new StatusMonitorImpl();
        String string = AppUtils.getAppTempDeployDir(installScheduler);
        String string2 = string + File.separator + AppUtils.getAppDeployFileName(installScheduler.getAppName());
        try {
            String string3;
            ModuleRef moduleRef;
            int n;
            Object object;
            Object object2;
            File file = new File(string);
            file.mkdirs();
            File file2 = new File(installScheduler.getEarPath());
            if (file2.isDirectory()) {
                object2 = string + File.separator + AppUtils.getPreAppDeployFileName(installScheduler.getAppName());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Copying source dir to an ear: " + (String)object2));
                }
                installScheduler.getEarFile(false, true).saveAs((String)object2);
                installScheduler.setEarPath((String)object2);
            }
            object2 = installScheduler.getProperties();
            if ((object2 = (Hashtable)((Hashtable)object2).get("deployejb.options")) == null) {
                throw new AdminException(AppUtils.getMessage(this.getResourceBundle(), "ADMA0062E"));
            }
            DeployOptions deployOptions = new DeployOptions();
            deployOptions.setInputModuleName(installScheduler.getEarPath());
            deployOptions.setDeployedModuleName(string2);
            deployOptions.setWorkingDirectory(string);
            Object object3 = (String)((Hashtable)object2).get("deployejb.rmic");
            if (!this.isEmpty((String)object3)) {
                deployOptions.setRMICOptions((String)object3);
            }
            if (!this.isEmpty((String)(object3 = (String)((Hashtable)object2).get("deployejb.classpath")))) {
                object3 = ((String)object3).replace('/', File.separatorChar);
                object3 = ((String)object3).replace('\\', File.separatorChar);
                deployOptions.setClasspath((String)object3);
            }
            if ((object3 = (Boolean)((Hashtable)object2).get("deployejb.codegen")) != null) {
                deployOptions.setCodegenOnly(((Boolean)object3).booleanValue());
            }
            if (!this.isEmpty((String)(object3 = (String)((Hashtable)object2).get("deployejb.dbtype")))) {
                deployOptions.setDatabaseType((String)object3);
            }
            if (!this.isEmpty((String)(object3 = (String)((Hashtable)object2).get("deployejb.dbschema")))) {
                deployOptions.setSchemaName((String)object3);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Options are: " + deployOptions));
            }
            object3 = (Hashtable)installScheduler.getProperties().get("moduleToServer");
            Hashtable<String, String> hashtable = null;
            if (object3 != null) {
                object = installScheduler.getEarFile().getModuleRefs();
                for (n = 0; n < object.size(); ++n) {
                    moduleRef = (ModuleRef)object.get(n);
                    if (!moduleRef.isEJB() || moduleRef.getAltDeploymentDescriptor() == null) continue;
                    if (hashtable == null) {
                        hashtable = new Hashtable<String, String>();
                    }
                    string3 = util.createUniqueModuleName(ConfigRepoHelper.getDDUri(moduleRef), moduleRef.getModule().getUri());
                    hashtable.put(moduleRef.getModule().getUri(), string3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("altDDMods: " + hashtable));
                }
            }
            installScheduler.propagateTaskEvent(this.createNotification("InProgress", "ADMA5018I", new String[]{installScheduler.getEarPath()}));
            DeployUtil.deploy((Archive)installScheduler.getEarFile(false, true), (DeployOptions)deployOptions, (IStatusMonitor)statusMonitorImpl);
            installScheduler.setEarPath(string2);
            installScheduler.propagateTaskEvent(this.createNotification("Completed", "ADMA5007I", new String[]{string2}));
            if (statusMonitorImpl.getErrors().size() != 0) {
                object = statusMonitorImpl.getErrors();
                throw new AdminException(AppUtils.getMessage(this.getResourceBundle(), "ADMA0063E", new Object[]{object}));
            }
            if (hashtable != null) {
                object = installScheduler.getEarFile().getModuleRefs();
                for (n = 0; n < object.size(); ++n) {
                    String string4;
                    moduleRef = (ModuleRef)object.get(n);
                    if (!moduleRef.isEJB() || (string4 = (String)((Hashtable)object3).get(string3 = (String)hashtable.get(moduleRef.getModule().getUri()))) == null) continue;
                    String string5 = util.createUniqueModuleName(ConfigRepoHelper.getDDUri(moduleRef), moduleRef.getModule().getUri());
                    ((Hashtable)object3).remove(string3);
                    ((Hashtable)object3).put(string5, string4);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Removed: " + string3 + " .. added: " + string5 + " = " + string4));
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"performTask");
            }
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.task.DeployEJBTask.performTask", (String)"160", (Object)this);
            installScheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5008E", new String[]{string2, throwable.toString()}));
            AppUtils.dbg(tc, "Exception in EJBDeploy : " + throwable);
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            Vector vector = statusMonitorImpl.getErrors();
            throw new AdminException(throwable, AppUtils.getMessage(this.getResourceBundle(), "ADMA0063E", new Object[]{vector}));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class StatusMonitorImpl
    implements IStatusMonitor {
        Vector errors = new Vector();

        StatusMonitorImpl() {
        }

        public void errorMessage(String string, int n) {
            switch (n) {
                case 2: {
                    this.errors.addElement(string);
                    AppUtils.dbg(tc, "\t[EJBDeploy] " + string + " [Severity " + n + "]");
                    Tr.error((TraceComponent)tc, (String)"ADMA0086E", (Object)new Object[]{string, new Integer(n)});
                    DeployEJBTask.this.scheduler.propagateTaskEvent(DeployEJBTask.this.createTranslatedNotification("InProgress", string, null));
                }
                case 1: {
                    AppUtils.dbg(tc, "\t[EJBDeploy] " + string + " [Severity " + n + "]");
                    Tr.warning((TraceComponent)tc, (String)"ADMA0087W", (Object)new Object[]{string, new Integer(n)});
                }
            }
            AppUtils.dbg(tc, "\t[EJBDeploy] " + string + " [Severity " + n + "]");
            Tr.warning((TraceComponent)tc, (String)"ADMA0087W", (Object)new Object[]{string, new Integer(n)});
        }

        public Vector getErrors() {
            return this.errors;
        }

        public boolean isCanceled() {
            return false;
        }

        public void subtaskMessage(String string) {
            AppUtils.dbg(tc, "\t[EJBDeploy] " + string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("\t[EJBDeploy] " + string));
            }
        }

        public void taskMessage(String string) {
            AppUtils.dbg(tc, "\t[EJBDeploy] " + string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("\t[EJBDeploy] " + string));
            }
            DeployEJBTask.this.scheduler.propagateTaskEvent(DeployEJBTask.this.createTranslatedNotification("InProgress", string, null));
        }
    }
}

