/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.jca;

import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.apache.wsif.WSIFCorrelationId;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFResponseHandler;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.providers.jca.WSIFMessage_JCA;
import org.apache.wsif.providers.jca.WSIFMessage_JCAStreamable;
import org.apache.wsif.providers.jca.WSIFPort_JCA;
import org.apache.wsif.providers.jca.WSIFProviderJCAExtensions;
import org.apache.wsif.providers.jca.WSIFProviderJCAExtensions2;
import org.apache.wsif.providers.jca.WSIFResource_JCA;

public class WSIFOperation_JCA
implements WSIFOperation {
    private static final long serialVersionUID = 1L;
    protected Connection fieldConnection;
    protected InteractionSpec fieldInteractionSpec;
    protected Definition fieldDefinition;
    protected Binding fieldBinding;
    protected String fieldOperationName;
    protected String fieldInputName;
    protected String fieldOutputName;
    protected Operation fieldOperation;
    protected WSIFProviderJCAExtensions fieldFactory = null;
    private static final String crlf = System.getProperty("line.separator");
    private WSIFDynamicTypeMap fieldTypeMap;
    private Port fieldPort;
    private Service fieldService;
    private WSIFPort_JCA fieldJcaPort;

    public WSIFOperation_JCA(Definition definition, Service service, Port port, String string, String string2, String string3, WSIFDynamicTypeMap wSIFDynamicTypeMap, WSIFPort_JCA wSIFPort_JCA, WSIFProviderJCAExtensions wSIFProviderJCAExtensions, Connection connection, InteractionSpec interactionSpec) {
        this.fieldDefinition = definition;
        this.fieldInteractionSpec = interactionSpec;
        this.fieldConnection = connection;
        this.fieldFactory = wSIFProviderJCAExtensions;
        this.fieldBinding = port.getBinding();
        this.fieldOperationName = string;
        this.fieldInputName = string2;
        this.fieldOutputName = string3;
        this.fieldTypeMap = wSIFDynamicTypeMap;
        this.fieldPort = port;
        this.fieldService = service;
        this.fieldJcaPort = wSIFPort_JCA;
    }

    public boolean executeRequestResponseOperation(WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2, WSIFMessage wSIFMessage3) throws WSIFException {
        Trc.entry((Object)this, (Object)wSIFMessage, (Object)wSIFMessage2, (Object)wSIFMessage3);
        if (wSIFMessage.getParts() == null || !wSIFMessage.getParts().hasNext()) {
            wSIFMessage = null;
        }
        try {
            this.fieldFactory.updateInteractionSpec(wSIFMessage, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName, this.fieldInteractionSpec);
            if (this.fieldConnection == null) {
                this.fieldConnection = this.fieldFactory instanceof WSIFProviderJCAExtensions2 ? ((WSIFProviderJCAExtensions2)this.fieldFactory).createConnection(this.fieldJcaPort, wSIFMessage, this.fieldDefinition, this.fieldService, this.fieldPort, this.fieldTypeMap, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName) : this.fieldFactory.createConnection(wSIFMessage, this.fieldDefinition, this.fieldService, this.fieldPort, this.fieldTypeMap, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName);
                this.fieldJcaPort.setConnection(this.fieldConnection);
            }
            Interaction interaction = this.fieldConnection.createInteraction();
            interaction.execute(this.fieldInteractionSpec, (Record)wSIFMessage, (Record)wSIFMessage2);
            interaction.close();
            if (wSIFMessage2 instanceof WSIFMessage_JCA) {
                ((WSIFMessage_JCA)wSIFMessage2).setInteractionSpec(this.fieldInteractionSpec);
            }
            this.fieldFactory.updateOutputMessage(wSIFMessage2, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName, this.fieldInteractionSpec);
        }
        catch (ResourceException resourceException) {
            WSIFException wSIFException = new WSIFException(WSIFResource_JCA.get("WSIF1000E"));
            wSIFException.setTargetException((Throwable)resourceException);
            Trc.exception((Throwable)resourceException);
            throw wSIFException;
        }
        catch (Throwable throwable) {
            WSIFException wSIFException = new WSIFException(WSIFResource_JCA.get("WSIF1008E", throwable.getLocalizedMessage()));
            wSIFException.setTargetException(throwable);
            Trc.exception((Throwable)wSIFException);
            throw wSIFException;
        }
        Trc.exit();
        return true;
    }

    public void executeInputOnlyOperation(WSIFMessage wSIFMessage) throws WSIFException {
        Trc.entry((Object)this, (Object)wSIFMessage);
        if (wSIFMessage.getParts() == null || !wSIFMessage.getParts().hasNext()) {
            wSIFMessage = null;
        }
        try {
            this.fieldFactory.updateInteractionSpec(wSIFMessage, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName, this.fieldInteractionSpec);
            if (this.fieldConnection == null) {
                this.fieldConnection = this.fieldFactory.createConnection(wSIFMessage, this.fieldDefinition, this.fieldService, this.fieldPort, this.fieldTypeMap, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName);
                this.fieldJcaPort.setConnection(this.fieldConnection);
            }
            Interaction interaction = this.fieldConnection.createInteraction();
            interaction.execute(this.fieldInteractionSpec, (Record)wSIFMessage);
            interaction.close();
        }
        catch (ResourceException resourceException) {
            WSIFException wSIFException = new WSIFException(WSIFResource_JCA.get("WSIF1000E"));
            Trc.exception((Throwable)resourceException);
            wSIFException.setTargetException((Throwable)resourceException);
            throw wSIFException;
        }
        catch (Throwable throwable) {
            WSIFException wSIFException = new WSIFException(WSIFResource_JCA.get("WSIF1008E", throwable.getLocalizedMessage()));
            wSIFException.setTargetException(throwable);
            Trc.exception((Throwable)wSIFException);
            throw wSIFException;
        }
        Trc.exit();
    }

    public WSIFMessage createFaultMessage() {
        Trc.entry((Object)this);
        WSIFMessage wSIFMessage = this.fieldFactory.createFaultMessage(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName);
        if (wSIFMessage != null) {
            return wSIFMessage;
        }
        return new WSIFMessage_JCAStreamable(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName, 3);
    }

    public WSIFMessage createFaultMessage(String string) {
        Trc.entry((Object)this, (Object)string);
        Object object = this.fieldFactory.createFaultMessage(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName);
        if (object != null) {
            object.setName(string);
            return object;
        }
        object = new WSIFMessage_JCAStreamable(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName, 3);
        object.setName(string);
        return object;
    }

    public WSIFMessage createInputMessage() {
        Trc.entry((Object)this);
        WSIFMessage wSIFMessage = this.fieldFactory.createInputMessage(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName);
        if (wSIFMessage != null) {
            return wSIFMessage;
        }
        return new WSIFMessage_JCAStreamable(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName, 1);
    }

    public WSIFMessage createInputMessage(String string) {
        Trc.entry((Object)this, (Object)string);
        Object object = this.fieldFactory.createInputMessage(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName);
        if (object != null) {
            object.setName(string);
            return object;
        }
        object = new WSIFMessage_JCAStreamable(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName, 1);
        object.setName(string);
        return object;
    }

    public WSIFMessage createOutputMessage() {
        Trc.entry((Object)this);
        WSIFMessage wSIFMessage = this.fieldFactory.createOutputMessage(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName);
        if (wSIFMessage != null) {
            return wSIFMessage;
        }
        return new WSIFMessage_JCAStreamable(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName, 2);
    }

    public WSIFMessage createOutputMessage(String string) {
        Trc.entry((Object)this, (Object)string);
        Object object = this.fieldFactory.createOutputMessage(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName);
        if (object != null) {
            object.setName(string);
            return object;
        }
        object = new WSIFMessage_JCAStreamable(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName, 2);
        object.setName(string);
        return object;
    }

    public InteractionSpec getInteractionSpec() {
        return this.fieldInteractionSpec;
    }

    public void setInteractionSpec(InteractionSpec interactionSpec) {
        this.fieldInteractionSpec = interactionSpec;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(crlf + "[JCAOperation" + crlf);
        try {
            if (this.fieldConnection != null) {
                stringBuffer.append("\tConnection: " + this.fieldConnection.toString() + crlf);
            } else {
                stringBuffer.append("\tConnection: null" + crlf);
            }
            if (this.fieldInteractionSpec != null) {
                stringBuffer.append("\tInteractionSpec:       " + this.fieldInteractionSpec.toString() + crlf);
            } else {
                stringBuffer.append("\tInteractionSpec:       null" + crlf);
            }
            if (this.fieldBinding != null) {
                stringBuffer.append("\tBinding:    " + this.fieldBinding.toString() + crlf);
            } else {
                stringBuffer.append("\tBinding:    null" + crlf);
            }
            if (this.fieldOperation != null) {
                stringBuffer.append("\tOperation:    " + this.fieldOperation.toString() + crlf);
            } else {
                stringBuffer.append("\tOperation:    null" + crlf);
            }
            if (this.fieldFactory != null) {
                stringBuffer.append("\tFactory:    " + this.fieldFactory.toString() + crlf);
            } else {
                stringBuffer.append("\tFactory:    null" + crlf);
            }
            if (this.fieldOperationName != null) {
                stringBuffer.append("\tOperationName:    " + this.fieldOperationName + crlf);
            } else {
                stringBuffer.append("\tOperationName:    null" + crlf);
            }
            if (this.fieldInputName != null) {
                stringBuffer.append("\tInputName:    " + this.fieldInputName + crlf);
            } else {
                stringBuffer.append("\tInputName:    null" + crlf);
            }
            if (this.fieldOutputName != null) {
                stringBuffer.append("\tOutputName:    " + this.fieldOutputName + crlf);
            } else {
                stringBuffer.append("\tOutputName:    null" + crlf);
            }
            stringBuffer.append("]" + crlf);
        }
        catch (Throwable throwable) {}
        return stringBuffer.toString();
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage wSIFMessage, WSIFResponseHandler wSIFResponseHandler) throws WSIFException {
        return null;
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage wSIFMessage) throws WSIFException {
        return null;
    }

    public void fireAsyncResponse(Object object) throws WSIFException {
    }

    public boolean processAsyncResponse(Object object, WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2) throws WSIFException {
        return false;
    }

    public void setContext(WSIFMessage wSIFMessage) {
    }

    public WSIFMessage getContext() {
        return null;
    }
}

