/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.cm.CMProperties;
import com.ibm.ejs.cm.DataSourceProperties;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.advanced.cm.factory.CMFactoryException;
import com.ibm.websphere.advanced.cm.factory.DataSourceFactory;
import com.ibm.websphere.advanced.cm.factory.MissingRequiredPropertyException;
import com.ibm.ws.naming.util.CacheableReference;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class CMPropertiesImpl
implements CMProperties,
Cloneable,
Serializable,
Referenceable {
    private String name;
    private int diagOptions = 0;
    public static final int DIAG_OPTION_OFF = 0;
    public static final int DIAG_OPTION_ORPHAN_NOTIFY = 1;
    public static final int DIAG_OPTION_ORPHAN_CODE_PATH = 2;
    public static final int DIAG_OPTION_CONN_WAIT_CODE_PATH = 4;
    private boolean transactionBranchesLooselyCoupled = false;
    private boolean validate = false;
    private String validateSQL;
    private String dataBaseVersion = "0";
    private boolean resetReadOnly = false;
    private boolean secureXACredential = false;
    private int min = 1;
    private int max = 10;
    private int connTimeout = 180;
    private int idleTimeout = 1800;
    private int orphanTimeout = 1800;
    private int agedTimeout = 0;
    private int statementCacheSize = 10;
    private int informixLockModeWait = 0;
    private boolean informixAllowNewLine = false;
    private int oracleStmtCacheSize = 0;
    private boolean disableCleanup = false;
    private Hashtable errorMap = DataSourceFactory.DEFAULT_ERROR_MAP;
    private boolean disable2Phase = false;
    private DataSourceProperties dataSourceProperties = new DataSourceProperties();
    private Properties xaRecoveryProps = null;
    private static Hashtable xaRecoveryCredentials = new Hashtable();
    private static final String MAP_ERROR_CODE = "EC";
    private static final String MAP_SQL_STATE = "SS";
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$cm$CMProperties == null ? (class$com$ibm$ejs$cm$CMProperties = CMPropertiesImpl.class$("com.ibm.ejs.cm.CMProperties")) : class$com$ibm$ejs$cm$CMProperties), null, (String)"com.ibm.ejs.resources.CONMMessages");
    private String mbeanFactoryId = "";
    private String mbeanProviderId = "";
    static /* synthetic */ Class class$com$ibm$ejs$cm$portability$PortableDataSource;
    static /* synthetic */ Class class$com$ibm$websphere$advanced$cm$factory$DataSourceFactory$ResourceReferenceObjectFactory;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$com$ibm$ejs$cm$CMProperties;

    public CMPropertiesImpl() {
    }

    public CMPropertiesImpl(String string, String string2) {
        this();
        this.setName(string);
        this.setDataSourceClassName(string2);
    }

    public CMPropertiesImpl(Properties properties) throws CMFactoryException {
        this();
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        String string = null;
        String string2 = null;
        try {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                string2 = properties.getProperty(string);
                if (string2 == null || string2.equals("")) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("ignoring null or empty property " + string));
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    if (string != null && string.equals("password")) {
                        Tr.debug((TraceComponent)tc, (String)"setting password=XXXXXXXX");
                    } else {
                        Tr.debug((TraceComponent)tc, (String)("setting " + string + "=" + string2));
                    }
                }
                if (string.equals("name")) {
                    this.setName(string2);
                    continue;
                }
                if (string.equals("dataSourceClassName")) {
                    this.setDataSourceClassName(string2);
                    continue;
                }
                if (string.equals("dataBaseVersion")) {
                    this.setDataBaseVersion(string2);
                    continue;
                }
                if (string.equals("minimumPoolSize")) {
                    this.setMinConnectionPoolSize(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("maximumPoolSize")) {
                    this.setMaxConnectionPoolSize(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("connectionTimeout")) {
                    this.setConnectionTimeout(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("idleTimeout")) {
                    this.setIdleTimeout(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("orphanTimeout")) {
                    this.setOrphanTimeout(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("agedTimeout")) {
                    this.setAgedTimeout(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("statementCacheSize")) {
                    this.setMaxStatementCacheSize(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("disableAutoConnectionCleanup")) {
                    this.setAutoConnCleanupDisabled(Boolean.valueOf(string2));
                    continue;
                }
                if (string.equals("errorMap")) {
                    this.setErrorMap(CMPropertiesImpl.stringToErrorMap(string2));
                    continue;
                }
                if (string.equals("oemId")) continue;
                if (string.equals("disable2Phase")) {
                    this.setDisable2Phase(Boolean.valueOf(string2));
                    continue;
                }
                if (string.equals("informixLockModeWait")) {
                    this.setInformixLockModeWait(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("informixAllowNewLine")) {
                    this.setInformixAllowNewLine(Boolean.valueOf(string2));
                    continue;
                }
                if (string.equals("oracleStmtCacheSize")) {
                    this.setOracleStmtCacheSize(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("connectionValidation")) {
                    this.setValidate(Boolean.valueOf(string2));
                    continue;
                }
                if (string.equals("validationSQL")) {
                    this.setValidateSQL(string2);
                    continue;
                }
                if (string.equals("logOrphan")) {
                    this.setLogOrphan(Boolean.valueOf(string2));
                    continue;
                }
                if (string.equals("diagOptions")) {
                    this.setDiagOptions(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("transactionBranchesLooselyCoupled")) {
                    this.setOraTransLoose(Boolean.valueOf(string2));
                    continue;
                }
                if (string.equals("j2ee.resource.factory.href")) {
                    this.setMBeanFactoryId(string2);
                    continue;
                }
                if (string.equals("j2ee.resource.provider.href")) {
                    this.setMBeanProviderId(string2);
                    continue;
                }
                if (string.equals("resetReadOnly")) {
                    this.setResetReadOnly(Boolean.valueOf(string2));
                    continue;
                }
                if (string.equals("secureXACredential")) {
                    this.setSecureXACredential(Boolean.valueOf(string2));
                    continue;
                }
                this.setDataSourceProperty(string, string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Tr.error((TraceComponent)tc, (String)"MSG_CONM_1000E", (Object)new Object[]{string2, string, this.getName()});
            throw numberFormatException;
        }
        if (this.xaRecoveryProps != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("adding xaRecoveryProps to xaRecoveryCredentials list, id, user:" + this.getMBeanFactoryId() + " " + this.xaRecoveryProps.get("user")));
            }
            xaRecoveryCredentials.put(this.getMBeanFactoryId(), this.xaRecoveryProps);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = "CMProperties for DataSource \"" + this.name + "\"" + string + "  " + this.dataSourceProperties.toString() + string + "  Connection Pool Properties: " + string + "    dataBaseVersion              = " + this.getDataBaseVersion() + string + "    minConnectionPoolSize        = " + this.getMinConnectionPoolSize() + string + "    maxConnectionPoolSize        = " + this.getMaxConnectionPoolSize() + string + "    connTimeout                  = " + this.getConnectionTimeout() + string + "    idleTimeout                  = " + this.getIdleTimeout() + string + "    orphanTimeout                = " + this.getOrphanTimeout() + string + "    agedTimeout                      = " + this.getAgedTimeout() + string + "    maxStatementCacheSize        = " + this.getMaxStatementCacheSize() + string + "    autoConnectionCleanupDisabled= " + this.isAutoConnCleanupDisabled() + string + "    errorMap                     = " + this.getErrorMap() + string + "    informixLockModeWait         = " + this.getInformixLockModeWait() + string + "    informixAllowNewLine         = " + this.getInformixAllowNewLine() + string + "    oracleStmtCacheSize          = " + this.getOracleStmtCacheSize() + string + "    connectionValidation         = " + this.isValidateEnabled() + string + "    validationSQL                = " + this.getValidateSQL() + string + "    logOrphan                    = " + this.getLogOrphan() + string + "    diagOptions                  = " + this.getDiagOptions() + string + "    TransactionBranchesLooselyCoupled = " + this.getOraTransLoose() + string + "    secureXACredential           = " + this.getSecureXACredential() + string + "    resetReadOnly                = " + this.isResetReadOnlyEnabled();
        return string2;
    }

    public Reference getReference() throws NamingException {
        CacheableReference cacheableReference = new CacheableReference((class$com$ibm$ejs$cm$portability$PortableDataSource == null ? (class$com$ibm$ejs$cm$portability$PortableDataSource = CMPropertiesImpl.class$("com.ibm.ejs.cm.portability.PortableDataSource")) : class$com$ibm$ejs$cm$portability$PortableDataSource).getName(), (class$com$ibm$websphere$advanced$cm$factory$DataSourceFactory$ResourceReferenceObjectFactory == null ? (class$com$ibm$websphere$advanced$cm$factory$DataSourceFactory$ResourceReferenceObjectFactory = CMPropertiesImpl.class$("com.ibm.websphere.advanced.cm.factory.DataSourceFactory$ResourceReferenceObjectFactory")) : class$com$ibm$websphere$advanced$cm$factory$DataSourceFactory$ResourceReferenceObjectFactory).getName(), null);
        if (this.name != null) {
            cacheableReference.add(new StringRefAddr("name", this.name));
        }
        cacheableReference.add(new StringRefAddr("dataBaseVersion", this.dataBaseVersion));
        cacheableReference.add(new StringRefAddr("minimumPoolSize", Integer.toString(this.min)));
        cacheableReference.add(new StringRefAddr("maximumPoolSize", Integer.toString(this.max)));
        cacheableReference.add(new StringRefAddr("connectionTimeout", Integer.toString(this.connTimeout)));
        cacheableReference.add(new StringRefAddr("idleTimeout", Integer.toString(this.idleTimeout)));
        cacheableReference.add(new StringRefAddr("orphanTimeout", Integer.toString(this.orphanTimeout)));
        cacheableReference.add(new StringRefAddr("agedTimeout", Integer.toString(this.agedTimeout)));
        cacheableReference.add(new StringRefAddr("statementCacheSize", Integer.toString(this.statementCacheSize)));
        cacheableReference.add(new StringRefAddr("disableAutoConnectionCleanup", new Boolean(this.disableCleanup).toString()));
        if (this.errorMap != null) {
            cacheableReference.add(new StringRefAddr("errorMap", CMPropertiesImpl.errorMapToString(this.errorMap)));
        }
        cacheableReference.add(new StringRefAddr("informixLockModeWait", Integer.toString(this.informixLockModeWait)));
        cacheableReference.add(new StringRefAddr("informixAllowNewLine", new Boolean(this.informixAllowNewLine).toString()));
        cacheableReference.add(new StringRefAddr("oracleStmtCacheSize", Integer.toString(this.oracleStmtCacheSize)));
        cacheableReference.add(new StringRefAddr("disable2Phase", new Boolean(this.disable2Phase).toString()));
        cacheableReference.add(new StringRefAddr("connectionValidation", new Boolean(this.validate).toString()));
        cacheableReference.add(new StringRefAddr("logOrphan", new Boolean(this.getLogOrphan()).toString()));
        cacheableReference.add(new StringRefAddr("diagOptions", Integer.toString(this.diagOptions)));
        if (this.transactionBranchesLooselyCoupled) {
            cacheableReference.add(new StringRefAddr("transactionBranchesLooselyCoupled", new Boolean(this.transactionBranchesLooselyCoupled).toString()));
        }
        if (this.validateSQL != null) {
            cacheableReference.add(new StringRefAddr("validationSQL", this.validateSQL));
        }
        cacheableReference.add(new StringRefAddr("dataSourceClassName", this.dataSourceProperties.getDataSourceClassName()));
        cacheableReference.add(new StringRefAddr("j2ee.resource.factory.href", this.mbeanFactoryId));
        cacheableReference.add(new StringRefAddr("j2ee.resource.provider.href", this.mbeanProviderId));
        cacheableReference.add(new StringRefAddr("resetReadOnly", new Boolean(this.resetReadOnly).toString()));
        cacheableReference.add(new StringRefAddr("secureXACredential", new Boolean(this.secureXACredential).toString()));
        Enumeration enumeration = this.dataSourcePropertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.dataSourceProperties.getProperty(string);
            if (string.equals("password")) {
                string2 = PasswordUtil.passwordEncode((String)string2);
            }
            cacheableReference.add(new StringRefAddr(string, string2));
        }
        return cacheableReference;
    }

    public CMProperties loadFromReference(Reference reference) throws NumberFormatException, CMFactoryException {
        Properties properties = new Properties();
        Object object = reference.getAll();
        while (object.hasMoreElements()) {
            StringRefAddr stringRefAddr = (StringRefAddr)object.nextElement();
            properties.setProperty(stringRefAddr.getType(), (String)stringRefAddr.getContent());
        }
        object = properties.getProperty("password");
        if (object != null) {
            properties.setProperty("password", PasswordUtil.passwordDecode((String)object));
        }
        return new CMPropertiesImpl(properties);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Null or empty datasource name not allowed");
        }
        this.name = string;
    }

    public String getDataSourceClassName() {
        return this.dataSourceProperties.getDataSourceClassName();
    }

    public void setDataSourceClassName(String string) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Null or empty datasource class name not allowed");
        }
        this.dataSourceProperties.setDataSourceClassName(string);
    }

    public String getDataBaseVersion() {
        return this.dataBaseVersion;
    }

    public void setDataBaseVersion(String string) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Null or empty database version not allowed");
        }
        this.dataBaseVersion = string;
    }

    public int getMinConnectionPoolSize() {
        return this.min;
    }

    public void setMinConnectionPoolSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Pool size cannot be a negative number");
        }
        this.min = n;
    }

    public int getMaxConnectionPoolSize() {
        return this.max;
    }

    public void setMaxConnectionPoolSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Pool size must be greater than 0");
        }
        this.max = n;
    }

    public int getConnectionTimeout() {
        return this.connTimeout;
    }

    public int getConnectionTimeoutInMillis() {
        return this.connTimeout * 1000;
    }

    public void setConnectionTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Timeout cannot be a negative number");
        }
        this.connTimeout = n;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public int getIdleTimeoutInMillis() {
        return this.idleTimeout * 1000;
    }

    public void setIdleTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Timeout cannot be a negative number");
        }
        this.idleTimeout = n;
    }

    public int getOrphanTimeout() {
        return this.orphanTimeout;
    }

    public long getOrphanTimeoutInMillis() {
        return this.orphanTimeout * 1000;
    }

    public void setOrphanTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Timeout cannot be a negative number");
        }
        this.orphanTimeout = n;
    }

    public int getAgedTimeout() {
        return this.agedTimeout;
    }

    public long getAgedTimeoutInMillis() {
        return this.agedTimeout * 1000;
    }

    public void setAgedTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("agedTimeout cannot be a negative number");
        }
        this.agedTimeout = n;
    }

    public int getMaxStatementCacheSize() {
        return this.statementCacheSize;
    }

    public void setMaxStatementCacheSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Cache size cannot be a negative number");
        }
        this.statementCacheSize = n;
    }

    public String getUser() {
        return this.dataSourceProperties.getProperty("user");
    }

    public int getInformixLockModeWait() {
        return this.informixLockModeWait;
    }

    public boolean getInformixAllowNewLine() {
        return this.informixAllowNewLine;
    }

    public int getOracleStmtCacheSize() {
        return this.oracleStmtCacheSize;
    }

    public void setUser(String string) {
        if (string == null || string.equals("")) {
            this.dataSourceProperties.remove("user");
        } else {
            this.dataSourceProperties.setProperty("user", string);
        }
    }

    public String getTmpUser() {
        return this.dataSourceProperties.getProperty("tmpUser");
    }

    public void setTmpUser(String string) {
        if (string == null || string.equals("")) {
            this.dataSourceProperties.remove("tmpUser");
        } else {
            this.dataSourceProperties.setProperty("tmpUser", string);
        }
    }

    String getTmpPassword() {
        return this.dataSourceProperties.getProperty("tmpPassword");
    }

    public void setTmpPassword(String string) {
        if (string == null || string.equals("")) {
            this.dataSourceProperties.remove("tmpPassword");
        } else {
            this.dataSourceProperties.setProperty("tmpPassword", string);
        }
    }

    public void setInformixLockModeWait(int n) {
        this.informixLockModeWait = n;
    }

    public void setInformixAllowNewLine(boolean bl) {
        this.informixAllowNewLine = bl;
    }

    public void setOracleStmtCacheSize(int n) {
        this.oracleStmtCacheSize = n;
    }

    String getPassword() {
        return this.dataSourceProperties.getProperty("password");
    }

    public void setPassword(String string) {
        if (string == null || string.equals("")) {
            this.dataSourceProperties.remove("password");
        } else {
            this.dataSourceProperties.setProperty("password", string);
        }
    }

    public boolean isAutoConnCleanupDisabled() {
        return this.disableCleanup;
    }

    public void setAutoConnCleanupDisabled(boolean bl) {
        this.disableCleanup = bl;
    }

    public Hashtable getErrorMap() {
        return this.errorMap;
    }

    public void setErrorMap(Hashtable hashtable) {
        this.errorMap = hashtable;
    }

    public boolean isDisable2Phase() {
        return this.disable2Phase;
    }

    public void setDisable2Phase(boolean bl) {
        this.disable2Phase = bl;
    }

    public void setDataSourceProperty(String string, String string2) {
        if (this.getSecureXACredential() && (string.equals("user") || string.equals("password"))) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("secureXACredential set, not setting DataSourceProperty " + string));
            }
            if (this.xaRecoveryProps == null) {
                this.xaRecoveryProps = new Properties();
            }
            this.xaRecoveryProps.put(string, string2);
        } else {
            this.dataSourceProperties.setProperty(string, string2);
        }
    }

    public String getDataSourceProperty(String string) {
        return this.dataSourceProperties.getProperty(string);
    }

    public Enumeration dataSourcePropertyNames() {
        return this.dataSourceProperties.propertyNames();
    }

    public DataSourceProperties getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public void validate() throws CMFactoryException {
        if (this.getName() == null) {
            Tr.error((TraceComponent)tc, (String)"MSG_CONM_1001E", (Object)new Object[]{"DataSourceFactory.NAME", ""});
            throw new MissingRequiredPropertyException("Required property DataSourceFactory.NAME is missing");
        }
        if (this.getDataSourceClassName() == null) {
            Tr.error((TraceComponent)tc, (String)"MSG_CONM_1001E", (Object)new Object[]{"DataSourceFactory.DATASOURCE_CLASS_NAME", this.getName()});
            throw new MissingRequiredPropertyException("Required property DataSourceFactory.DATASOURCE_CLASS_NAME for data source " + this.getName() + " is missing");
        }
        if (this.getUser() == null && this.getPassword() != null) {
            Tr.warning((TraceComponent)tc, (String)"MSG_CONM_1004W", (Object)this.getName());
            this.setUser(null);
        }
        if (this.getUser() != null && this.getPassword() == null) {
            Tr.warning((TraceComponent)tc, (String)"MSG_CONM_1005W", (Object)new Object[]{this.getUser(), this.getName()});
            this.setPassword(null);
        }
    }

    public void encodePassword() {
        if (this.getPassword() != null) {
            this.setPassword(PasswordUtil.passwordEncode((String)this.getPassword()));
        }
    }

    public void decodePassword() {
        if (this.getPassword() != null) {
            this.setPassword(PasswordUtil.passwordDecode((String)this.getPassword()));
        }
    }

    public Object clone() {
        CMPropertiesImpl cMPropertiesImpl = null;
        try {
            cMPropertiesImpl = (CMPropertiesImpl)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.errorMap != null) {
            cMPropertiesImpl.errorMap = (Hashtable)this.errorMap.clone();
        }
        cMPropertiesImpl.dataSourceProperties = (DataSourceProperties)this.dataSourceProperties.clone();
        return cMPropertiesImpl;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            CMPropertiesImpl cMPropertiesImpl = (CMPropertiesImpl)object;
            return (this.name == null && cMPropertiesImpl.name == null || this.name != null && this.name.equals(cMPropertiesImpl.name)) && this.min == cMPropertiesImpl.min && this.max == cMPropertiesImpl.max && this.connTimeout == cMPropertiesImpl.connTimeout && this.idleTimeout == cMPropertiesImpl.idleTimeout && this.orphanTimeout == cMPropertiesImpl.orphanTimeout && this.statementCacheSize == cMPropertiesImpl.statementCacheSize && this.disableCleanup == cMPropertiesImpl.disableCleanup && this.disable2Phase == cMPropertiesImpl.disable2Phase && this.informixLockModeWait == cMPropertiesImpl.informixLockModeWait && this.oracleStmtCacheSize == cMPropertiesImpl.oracleStmtCacheSize && this.dataSourceProperties.equals(cMPropertiesImpl.dataSourceProperties) && (this.errorMap == null && cMPropertiesImpl.errorMap == null || this.errorMap.equals(cMPropertiesImpl.errorMap));
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    private static Hashtable stringToErrorMap(String string) {
        Hashtable<Object, Class> hashtable = new Hashtable<Object, Class>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.lastIndexOf(61);
            String string3 = string2.substring(2, n);
            String string4 = string2.substring(n + 1, string2.length());
            try {
                Class clazz;
                Class clazz2 = string4.equals("") ? (class$java$lang$Void == null ? CMPropertiesImpl.class$("java.lang.Void") : class$java$lang$Void) : (clazz = classLoader.loadClass(string4));
                if (string2.startsWith(MAP_ERROR_CODE)) {
                    hashtable.put(new Integer(string3), clazz);
                    continue;
                }
                hashtable.put(string3, clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Unknown exception class: " + string4);
            }
        }
        return hashtable;
    }

    private static String errorMapToString(Hashtable hashtable) {
        if (hashtable == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = hashtable.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            stringBuffer.append(k instanceof Integer ? MAP_ERROR_CODE : MAP_SQL_STATE);
            stringBuffer.append(k);
            stringBuffer.append('=');
            if (entry.getValue() != null) {
                stringBuffer.append(((Class)entry.getValue()).getName());
            }
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    public boolean isValidateEnabled() {
        return this.validate;
    }

    public void setValidate(boolean bl) {
        this.validate = bl;
    }

    public String getValidateSQL() {
        return this.validateSQL;
    }

    public void setValidateSQL(String string) {
        this.validateSQL = string;
    }

    public boolean getLogOrphan() {
        return (this.diagOptions & 1) > 0;
    }

    public void setLogOrphan(boolean bl) {
        if (bl) {
            this.diagOptions |= 1;
        }
    }

    public boolean getOraTransLoose() {
        return this.transactionBranchesLooselyCoupled;
    }

    public void setOraTransLoose(boolean bl) {
        this.transactionBranchesLooselyCoupled = bl;
    }

    protected Properties getXaRecoveryCredentials() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getXaRecoveryCredentials");
        }
        if (this.xaRecoveryProps == null) {
            this.xaRecoveryProps = (Properties)xaRecoveryCredentials.get(this.getMBeanFactoryId());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getXaRecoveryCredentials", (Object)this.xaRecoveryProps);
        }
        return this.xaRecoveryProps;
    }

    public boolean isResetReadOnlyEnabled() {
        return this.resetReadOnly;
    }

    private void setResetReadOnly(boolean bl) {
        this.resetReadOnly = bl;
    }

    private boolean getSecureXACredential() {
        return this.secureXACredential;
    }

    private void setSecureXACredential(boolean bl) {
        this.secureXACredential = bl;
        if (this.secureXACredential) {
            String string;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Removing user and password from dataSourceProperties");
            }
            if ((string = (String)this.dataSourceProperties.remove("user")) != null) {
                if (this.xaRecoveryProps == null) {
                    this.xaRecoveryProps = new Properties();
                }
                this.xaRecoveryProps.put("user", string);
                string = null;
            }
            if ((string = (String)this.dataSourceProperties.remove("password")) != null) {
                if (this.xaRecoveryProps == null) {
                    this.xaRecoveryProps = new Properties();
                }
                this.xaRecoveryProps.put("password", string);
            }
        }
    }

    public String getMBeanFactoryId() {
        return this.mbeanFactoryId;
    }

    public String getMBeanProviderId() {
        return this.mbeanProviderId;
    }

    public void setMBeanFactoryId(String string) {
        this.mbeanFactoryId = string;
    }

    public void setMBeanProviderId(String string) {
        this.mbeanProviderId = string;
    }

    public void setDiagOptions(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The Connection Manager Diagnostic options must be zero (0) or greater");
        }
        this.diagOptions = this.diagOptions == 0 ? n : (this.diagOptions |= n);
    }

    public int getDiagOptions() {
        return this.diagOptions;
    }

    public boolean isDiagOptionEnabled(int n) {
        return (this.diagOptions & n) > 0;
    }

    public String getDiagOptionsString() {
        Class<?> clazz = this.getClass();
        Field[] fieldArray = clazz.getFields();
        String string = "[" + this.diagOptions + "]=";
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < fieldArray.length; ++i) {
            String string2 = fieldArray[i].getName();
            if (!string2.startsWith("DIAG_OPTION")) continue;
            try {
                if ((this.diagOptions & fieldArray[i].getInt(null)) <= 0) continue;
                stringBuffer.append(string2);
                stringBuffer.append(" ");
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getDiagOptionsString, Illegal Access Exception", (Object)illegalAccessException);
                }
                return "Error getting diagnostic options";
            }
        }
        if (stringBuffer.length() == string.length()) {
            stringBuffer.append("Invalid Connection Manager Diagnostic Options Set");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

