/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm;

import com.ibm.ejs.cm.PropertyEntry;
import com.ibm.ejs.cm.portability.MerantPortabilityLayer;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.advanced.cm.factory.DataSourceFactory;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileFilter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;

public abstract class ConnectionPoolHelper {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$cm$ConnectionPoolHelper == null ? (class$com$ibm$ejs$cm$ConnectionPoolHelper = ConnectionPoolHelper.class$("com.ibm.ejs.cm.ConnectionPoolHelper")) : class$com$ibm$ejs$cm$ConnectionPoolHelper), null, (String)"com.ibm.ejs.resources.CONMMessages");
    public static final String[] SUPPORTED_DATASOURCE_CLASS_NAMES = new String[]{"COM.ibm.db2.jdbc.DB2ConnectionPoolDataSource", "com.ibm.as400.access.AS400JDBCConnectionPoolDataSource", "com.ibm.db2.jdbc.app.DB2StdConnectionPoolDataSource", "com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource", "oracle.jdbc.pool.OracleConnectionPoolDataSource", "com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource", "com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource", "com.merant.datadirect.jdbcx.sqlserver.SQLServerDataSource", "com.ddtek.jdbcx.sqlserver.SQLServerDataSource", "com.microsoft.jdbcx.sqlserver.SQLServerDataSource", "com.merant.sequelink.jdbcx.datasource.SequeLinkDataSource", "com.ddtek.jdbcx.sequelink.SequeLinkDataSource", "com.ibm.ejs.cm.portability.IDBConnectionPoolDataSource", "com.ibm.db2.jcc.DB2ConnectionPoolDataSource"};
    public static final String[] SUPPORTED_XADATASOURCE_CLASS_NAMES = new String[]{"COM.ibm.db2.jdbc.DB2XADataSource", "com.ibm.as400.access.AS400JDBCXADataSource", "com.ibm.db2.jdbc.app.DB2StdXADataSource", "com.ibm.db2.jdbc.app.UDBXADataSource", "oracle.jdbc.xa.client.OracleXADataSource", "com.sybase.jdbc2.jdbc.SybXADataSource", "com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource", "com.merant.datadirect.jdbcx.sqlserver.SQLServerDataSource", "com.ddtek.jdbcx.sqlserver.SQLServerDataSource", "com.microsoft.jdbcx.sqlserver.SQLServerDataSource", "com.merant.sequelink.jdbcx.datasource.SequeLinkDataSource", "com.ddtek.jdbcx.sequelink.SequeLinkDataSource"};
    public static final String[] CM_PROPS = new String[]{"name", "dataSourceClassName", "description", "minimumPoolSize", "maximumPoolSize", "connectionTimeout", "idleTimeout", "orphanTimeout", "agedTimeout", "statementCacheSize", "user", "password", "disableAutoConnectionCleanup", "errorMap", "oemId", "informixLockModeWait", "informixAllowNewLine", "disable2Phase", "transactionBranchesLooselyCoupled"};
    private static final boolean HELPER_TEST_IF_DATASOURCE_LOADED = true;
    private static Hashtable loaders = new Hashtable();
    static /* synthetic */ Class class$com$ibm$ejs$cm$ConnectionPoolHelper;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;

    public static Vector getPropertiesForDataSource(String string, String string2) throws ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPropertiesForDataSource", (Object)new Object[]{string, string2});
        }
        Vector<PropertyEntry> vector = new Vector<PropertyEntry>();
        String[] stringArray = ConnectionPoolHelper.getRequiredPropertiesForDataSource(string);
        Vector vector2 = stringArray == null ? new Vector() : new Vector<String>(Arrays.asList(stringArray));
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            vector.add(new PropertyEntry((String)vector2.get(i), true));
        }
        TreeSet<PropertyEntry> treeSet = new TreeSet<PropertyEntry>();
        boolean bl = false;
        boolean bl2 = false;
        try {
            Class clazz = ConnectionPoolHelper.loadDataSourceClass(string, string2);
            PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                String string3 = propertyDescriptor.getName();
                if (vector2.contains(string3) || propertyDescriptor.getWriteMethod() == null) continue;
                if (string3.equals("user")) {
                    bl = true;
                    continue;
                }
                if (string3.equals("password")) {
                    bl2 = true;
                    continue;
                }
                treeSet.add(new PropertyEntry(string3, false));
            }
        }
        catch (IntrospectionException introspectionException) {
            Tr.warning((TraceComponent)tc, (String)"MSG_CONM_7001E", (Object)new Object[]{string, introspectionException});
        }
        if (bl) {
            vector.add(new PropertyEntry("user", false));
        }
        if (bl2) {
            vector.add(new PropertyEntry("password", false));
        }
        vector.addAll(treeSet);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPropertiesForDataSource");
        }
        return vector;
    }

    public static String[] getRequiredPropertiesForDataSource(String string) {
        if (string.equals("COM.ibm.db2.jdbc.DB2ConnectionPoolDataSource") || string.equals("COM.ibm.db2.jdbc.DB2XADataSource")) {
            return new String[]{"databaseName"};
        }
        if (string.equals("com.ibm.db2.jcc.DB2ConnectionPoolDataSource")) {
            return new String[]{"databaseName", "serverName", "portNumber", "driverType"};
        }
        if (string.equals("com.ibm.as400.access.AS400JDBCConnectionPoolDataSource") || string.equals("com.ibm.as400.access.AS400JDBCXADataSource")) {
            return new String[]{"serverName"};
        }
        if (string.equals("com.ibm.db2.jdbc.app.DB2StdConnectionPoolDataSource") || string.equals("com.ibm.db2.jdbc.app.DB2StdXADataSource") || string.equals("com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource") || string.equals("com.ibm.db2.jdbc.app.UDBXADataSource")) {
            return new String[0];
        }
        if (string.equals("oracle.jdbc.pool.OracleConnectionPoolDataSource") || string.equals("oracle.jdbc.xa.client.OracleXADataSource")) {
            return new String[]{"URL"};
        }
        if (string.equals("com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource") || string.equals("com.sybase.jdbc2.jdbc.SybXADataSource")) {
            return new String[]{"databaseName", "portNumber", "serverName"};
        }
        if (string.equals("com.merant.sequelink.jdbcx.datasource.SequeLinkDataSource") || string.equals("com.ddtek.jdbcx.sequelink.SequeLinkDataSource") || string.equals("com.merant.datadirect.jdbcx.sqlserver.SQLServerDataSource") || string.equals("com.ddtek.jdbcx.sqlserver.SQLServerDataSource") || string.equals("com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource") || string.equals("com.microsoft.jdbcx.sqlserver.SQLServerDataSource")) {
            return new String[]{"serverName"};
        }
        if (string.equals("com.ibm.ejs.cm.portability.IDBConnectionPoolDataSource")) {
            return new String[]{"url"};
        }
        if (string.equals("com.informix.jdbcx.IfxConnectionPoolDataSource") || string.equals("com.informix.jdbcx.IfxXADataSource")) {
            return new String[]{"databaseName", "ifxIFXHOST", "informixLockModeWait", "portNumber", "serverName"};
        }
        return null;
    }

    protected static String getSQLExceptionInfo(SQLException sQLException) {
        return "(SQL State: " + sQLException.getSQLState() + ", Error Code: " + sQLException.getErrorCode() + ") ";
    }

    protected static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    protected static Class loadDataSourceClass(String string, String string2) throws ClassNotFoundException {
        Class clazz;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadDataSourceClass", (Object)new Object[]{string, string2});
        }
        URLClassLoader uRLClassLoader = (URLClassLoader)loaders.get(string2);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("loadDataSourceClass:  ul = " + uRLClassLoader));
        }
        try {
            serializable = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            if (uRLClassLoader != null && serializable == null) {
                serializable = Class.forName(string, true, uRLClassLoader);
            }
            if (serializable != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"loadDataSourceClass: DataSource class already loaded, ", (Object)string);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"loadDataSourceClass");
                }
                return serializable;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        serializable = new Vector();
        String string3 = string2.indexOf(92) >= 0 || string2.indexOf(59) >= 0 ? ";" : File.pathSeparator;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(stringTokenizer.nextToken());
            if (file.isFile()) {
                ((Vector)serializable).add(file);
                continue;
            }
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.toString().endsWith(".jar") || file.toString().endsWith(".zip");
                }
            });
            if (fileArray == null) continue;
            ((Vector)serializable).addAll(Arrays.asList(fileArray));
        }
        int n = ((Vector)serializable).size();
        if (n < 1) {
            Tr.warning((TraceComponent)tc, (String)"MSG_CONM_7011W", (Object)new Object[]{string, string2});
            final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                Tr.error((TraceComponent)tc, (String)"MSG_CONM_7012E", (Object)new Object[]{string, string2});
                throw new ClassNotFoundException("No jar or zip files found in " + string2 + " and current class loader not found");
            }
            Class clazz2 = null;
            final String string4 = string;
            try {
                clazz2 = (Class)com.ibm.ws.security.util.AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return classLoader.loadClass(string4);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Tr.error((TraceComponent)tc, (String)"MSG_CONM_7012E", (Object)new Object[]{string, string2});
                throw new ClassNotFoundException("No jar or zip files found in " + string2 + " and not found in current class loader", privilegedActionException.getException());
            }
            if (clazz2 != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"loadDataSourceClass");
                }
                return clazz2;
            }
            Tr.error((TraceComponent)tc, (String)"MSG_CONM_7012E", (Object)new Object[]{string, string2});
            throw new ClassNotFoundException("No jar or zip files found in " + string2);
        }
        URL[] uRLArray = new URL[n];
        try {
            for (int i = 0; i < n; ++i) {
                uRLArray[i] = ((File)((Vector)serializable).get(i)).toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new ClassNotFoundException("Unable to find JDBC resource provider classes.", malformedURLException);
        }
        final URL[] uRLArray2 = uRLArray;
        final String string5 = string;
        final String string6 = string2;
        final URLClassLoader uRLClassLoader2 = uRLClassLoader;
        try {
            clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (uRLClassLoader2 == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"loadDataSourceClass:  creating new classloader!");
                        }
                        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray2, classLoader);
                        loaders.put(string6, uRLClassLoader);
                        return uRLClassLoader.loadClass(string5);
                    }
                    return uRLClassLoader2.loadClass(string5);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadDataSourceClass");
        }
        return clazz;
    }

    protected static void setProperty(Object object, PropertyDescriptor propertyDescriptor, String string) throws Exception {
        Constable constable = null;
        Method method = propertyDescriptor.getWriteMethod();
        if (method == null) {
            throw new NoSuchMethodException("No setter method for property: " + propertyDescriptor.getName());
        }
        Class<?> clazz = method.getParameterTypes()[0];
        if (!clazz.isPrimitive()) {
            constable = clazz.equals(class$java$lang$Character == null ? (class$java$lang$Character = ConnectionPoolHelper.class$("java.lang.Character")) : class$java$lang$Character) ? new Character(string.charAt(0)) : clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ConnectionPoolHelper.class$("java.lang.String")) : class$java$lang$String).newInstance(string);
        } else if (clazz.equals(Integer.TYPE)) {
            constable = new Integer(string);
        } else if (clazz.equals(Long.TYPE)) {
            constable = new Long(string);
        } else if (clazz.equals(Boolean.TYPE)) {
            constable = new Boolean(string);
        } else if (clazz.equals(Double.TYPE)) {
            constable = new Double(string);
        } else if (clazz.equals(Float.TYPE)) {
            constable = new Float(string);
        } else if (clazz.equals(Short.TYPE)) {
            constable = new Short(string);
        } else if (clazz.equals(Byte.TYPE)) {
            constable = new Byte(string);
        } else if (clazz.equals(Character.TYPE)) {
            constable = new Character(string.charAt(0));
        }
        method.invoke(object, constable);
    }

    public static Object[] testConnectionToDataSource(String string, Properties properties, String string2) throws ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"testConnectionToDataSource - dsClassName, dataSourceProps, providerLibPath", (Object)new Object[]{string, properties, string2});
        }
        int n = 0;
        Object[] objectArray = new Object[2];
        String string3 = "";
        String string4 = properties.getProperty("user");
        String string5 = properties.getProperty("password");
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        Vector<String> vector = new Vector<String>(Arrays.asList(DataSourceFactory.getCMProperties()));
        try {
            Object object;
            String string6;
            Object object2;
            String string7;
            String string8;
            Class clazz = ConnectionPoolHelper.loadDataSourceClass(string, string2);
            String string9 = null;
            final Class clazz2 = clazz;
            try {
                string9 = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return clazz2.newInstance();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
            PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                string8 = propertyDescriptor.getName();
                if (!properties2.containsKey(string8)) continue;
                try {
                    ConnectionPoolHelper.setProperty(string9, propertyDescriptor, (String)properties2.remove(string8));
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    ++n;
                    string7 = "Warning: property not found for " + string + ": " + string8;
                    Tr.warning((TraceComponent)tc, (String)"MSG_CONM_7003W", (Object)new Object[]{string8, string});
                    string3 = string3 + string7 + "\n";
                    continue;
                }
                catch (Exception exception) {
                    if (exception instanceof InvocationTargetException) {
                        object2 = (Exception)((InvocationTargetException)exception).getTargetException();
                    }
                    ++n;
                    string7 = object2.getClass().getName();
                    string6 = ((Throwable)object2).toString();
                    object = "Warning: error setting '" + string8 + "': " + (string6.indexOf(string7) < 0 ? string7 + ": " : "") + string6;
                    Tr.warning((TraceComponent)tc, (String)"MSG_CONM_7004W", (Object)new Object[]{string8, string7, object2});
                    string3 = string3 + (String)object + "\n";
                }
            }
            Object object3 = properties2.propertyNames();
            while (object3.hasMoreElements()) {
                string8 = (String)object3.nextElement();
                if (vector.contains(string8)) continue;
                ++n;
                object2 = "Warning: property not found for " + string + ": " + string8;
                Tr.warning((TraceComponent)tc, (String)"MSG_CONM_7003W", (Object)new Object[]{string8, string});
                string3 = string3 + (String)object2 + "\n";
            }
            object3 = null;
            object2 = string4;
            string7 = string5;
            string6 = string9;
            try {
                object3 = (PooledConnection)AccessController.doPrivileged(new PrivilegedExceptionAction((String)object2, string7, string6){
                    private final /* synthetic */ String val$userName;
                    private final /* synthetic */ String val$passWord;
                    private final /* synthetic */ Object val$fds;
                    {
                        this.val$userName = string;
                        this.val$passWord = string2;
                        this.val$fds = object;
                    }

                    public Object run() throws Exception {
                        if (this.val$userName != null && this.val$passWord != null) {
                            return this.val$fds instanceof XADataSource ? ((XADataSource)this.val$fds).getXAConnection(this.val$userName, this.val$passWord) : ((ConnectionPoolDataSource)this.val$fds).getPooledConnection(this.val$userName, this.val$passWord);
                        }
                        if (this.val$userName == null && this.val$passWord == null) {
                            return this.val$fds instanceof XADataSource ? ((XADataSource)this.val$fds).getXAConnection() : ((ConnectionPoolDataSource)this.val$fds).getPooledConnection();
                        }
                        Tr.warning((TraceComponent)tc, (String)"Both the username and the password must be set for Test Connection to work.");
                        throw new Exception("Both the username and the password must be set for Test Connection to work.");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
            object = object3.getConnection();
            if (string.startsWith("com.merant.sequelink.jdbcx.datasource.SequeLink") || string.startsWith("com.ddtek.jdbcx.sequelink.SequeLink") || string.startsWith("com.merant.datadirect.jdbcx.sqlserver.SQLServer") || string.startsWith("com.ddtek.jdbcx.sqlserver.SQLServer") || string.startsWith("com.ibm.websphere.jdbcx.sqlserver.SQLServer")) {
                MerantPortabilityLayer.unlockJDBCDriver((Connection)object, string);
            }
            object.close();
            object3.close();
            objectArray[0] = new Boolean(true);
            objectArray[1] = n > 0 ? string3 : null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new ClassNotFoundException(ConnectionPoolHelper.getStackTrace(noClassDefFoundError));
        }
        catch (Exception exception) {
            string3 = string3 + "Failed to connect to data source. Encountered " + exception.getClass().getName() + ": ";
            if (exception instanceof SQLException) {
                string3 = string3 + ConnectionPoolHelper.getSQLExceptionInfo((SQLException)exception);
            }
            string3 = string3 + exception.getMessage();
            objectArray[0] = new Boolean(false);
            objectArray[1] = string3;
            Tr.warning((TraceComponent)tc, (String)"MSG_CONM_7014W", (Object)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"testConnectionToDataSource - result", (Object)new Object[]{objectArray[0], objectArray[1]});
        }
        return objectArray;
    }

    public static boolean isPropertyRequired(String string, String string2) {
        String[] stringArray = ConnectionPoolHelper.getRequiredPropertiesForDataSource(string2);
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

